/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sparqlbuilder.graphpattern;

import java.util.Arrays;
import java.util.function.Consumer;
import org.eclipse.rdf4j.sparqlbuilder.constraint.Expression;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.AlternativeGraphPattern;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.FilterExistsGraphPattern;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.GraphName;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.GraphPattern;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.GroupGraphPattern;
import org.eclipse.rdf4j.sparqlbuilder.graphpattern.MinusGraphPattern;

public class GraphPatternNotTriple
implements GraphPattern {
    private GraphPattern pattern;

    GraphPatternNotTriple() {
        this(new GroupGraphPattern());
    }

    GraphPatternNotTriple(GraphPattern other) {
        this.pattern = this.extractPattern(other);
    }

    public GraphPatternNotTriple and(GraphPattern ... patterns) {
        if (patterns != null && patterns.length > 0) {
            GroupGraphPattern groupPattern = new GroupGraphPattern(this.pattern);
            this.extractAndAddPatterns(xva$0 -> groupPattern.and((GraphPattern)xva$0), patterns);
            this.pattern = groupPattern;
        }
        return this;
    }

    public GraphPatternNotTriple union(GraphPattern ... patterns) {
        AlternativeGraphPattern alternativePattern = new AlternativeGraphPattern(this.pattern);
        this.extractAndAddPatterns(xva$0 -> alternativePattern.union((GraphPattern)xva$0), patterns);
        this.pattern = alternativePattern;
        return this;
    }

    public GraphPatternNotTriple optional() {
        return this.optional(true);
    }

    public GraphPatternNotTriple optional(boolean isOptional) {
        this.pattern = new GroupGraphPattern(this.pattern).optional(isOptional);
        return this;
    }

    public GraphPatternNotTriple filter(Expression<?> constraint) {
        this.pattern = new GroupGraphPattern(this.pattern).filter(constraint);
        return this;
    }

    public GraphPatternNotTriple filterExists(GraphPattern ... patterns) {
        this.filterExists(true, patterns);
        return this;
    }

    public GraphPatternNotTriple filterNotExists(GraphPattern ... patterns) {
        this.filterExists(false, patterns);
        return this;
    }

    public GraphPatternNotTriple minus(GraphPattern ... patterns) {
        MinusGraphPattern minus = new MinusGraphPattern();
        this.extractAndAddPatterns(xva$0 -> minus.and((GraphPattern)xva$0), patterns);
        this.pattern = new GroupGraphPattern(this.pattern).and(minus);
        return this;
    }

    public GraphPatternNotTriple from(GraphName name) {
        this.pattern = new GroupGraphPattern(this.pattern).from(name);
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.pattern.isEmpty();
    }

    public boolean hasQualifier() {
        return this.pattern instanceof GroupGraphPattern && ((GroupGraphPattern)this.pattern).hasQualifier();
    }

    private void filterExists(boolean exists, GraphPattern ... patterns) {
        FilterExistsGraphPattern filterExists = new FilterExistsGraphPattern().exists(exists);
        this.extractAndAddPatterns(xva$0 -> filterExists.and((GraphPattern)xva$0), patterns);
        this.pattern = new GroupGraphPattern(this.pattern).and(filterExists);
    }

    private void extractAndAddPatterns(Consumer<? super GraphPattern> action, GraphPattern ... patterns) {
        Arrays.stream(patterns).map(this::extractPattern).forEach(action);
    }

    private GraphPattern extractPattern(GraphPattern pattern) {
        if (pattern instanceof GraphPatternNotTriple) {
            return ((GraphPatternNotTriple)pattern).pattern;
        }
        return pattern;
    }

    @Override
    public String getQueryString() {
        return this.pattern.getQueryString();
    }
}

