/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sparqlbuilder.core.query;

import java.util.Optional;
import org.eclipse.rdf4j.sparqlbuilder.core.Base;
import org.eclipse.rdf4j.sparqlbuilder.core.Dataset;
import org.eclipse.rdf4j.sparqlbuilder.core.From;
import org.eclipse.rdf4j.sparqlbuilder.core.Prefix;
import org.eclipse.rdf4j.sparqlbuilder.core.PrefixDeclarations;
import org.eclipse.rdf4j.sparqlbuilder.core.SparqlBuilder;
import org.eclipse.rdf4j.sparqlbuilder.core.query.Query;
import org.eclipse.rdf4j.sparqlbuilder.rdf.Iri;
import org.eclipse.rdf4j.sparqlbuilder.util.SparqlBuilderUtils;

public abstract class OuterQuery<T extends OuterQuery<T>>
extends Query<T> {
    protected Optional<Base> base = Optional.empty();
    protected Optional<PrefixDeclarations> prefixes = Optional.empty();
    protected Optional<Dataset> from = Optional.empty();

    public T base(Iri iri) {
        this.base = Optional.of(SparqlBuilder.base(iri));
        return (T)this;
    }

    public T base(Base base) {
        this.base = Optional.of(base);
        return (T)this;
    }

    public T prefix(Prefix ... prefixes) {
        this.prefixes = SparqlBuilderUtils.getOrCreateAndModifyOptional(this.prefixes, () -> SparqlBuilder.prefixes(new Prefix[0]), p -> p.addPrefix(prefixes));
        return (T)this;
    }

    public T prefix(PrefixDeclarations prefixes) {
        this.prefixes = Optional.of(prefixes);
        return (T)this;
    }

    public T from(From ... graphs) {
        this.from = SparqlBuilderUtils.getOrCreateAndModifyOptional(this.from, () -> SparqlBuilder.dataset(new From[0]), f -> f.from(graphs));
        return (T)this;
    }

    public T from(Dataset from) {
        this.from = Optional.of(from);
        return (T)this;
    }

    @Override
    public String getQueryString() {
        StringBuilder query = new StringBuilder();
        SparqlBuilderUtils.appendAndNewlineIfPresent(this.base, query);
        SparqlBuilderUtils.appendAndNewlineIfPresent(this.prefixes, query);
        SparqlBuilderUtils.appendAndNewlineIfPresent(this.from, query);
        query.append(super.getQueryString());
        return query.toString();
    }
}

