/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.testsuite.sparql.tests;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.QueryResult;
import org.eclipse.rdf4j.query.QueryResults;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.Update;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.testsuite.sparql.AbstractComplianceTest;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.function.ThrowingConsumer;

public class ValuesTest
extends AbstractComplianceTest {
    public ValuesTest(Supplier<Repository> repo) {
        super(repo);
    }

    private void testValuesInOptional(RepositoryConnection conn) throws Exception {
        this.loadTestData("/testdata-query/dataset-ses1692.trig", conn, new Resource[0]);
        String query = " PREFIX : <http://example.org/>\n SELECT DISTINCT ?a ?name ?isX WHERE { ?b :p1 ?a . ?a :name ?name. OPTIONAL { ?a a :X . VALUES(?isX) { (:X) } } } ";
        TupleQuery tq = conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            org.junit.jupiter.api.Assertions.assertNotNull((Object)result);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)result.hasNext());
            int count = 0;
            while (result.hasNext()) {
                ++count;
                BindingSet bs = (BindingSet)result.next();
                IRI a = (IRI)bs.getValue("a");
                org.junit.jupiter.api.Assertions.assertNotNull((Object)a);
                Value isX = bs.getValue("isX");
                Literal name = (Literal)bs.getValue("name");
                org.junit.jupiter.api.Assertions.assertNotNull((Object)name);
                if (a.stringValue().endsWith("a1")) {
                    org.junit.jupiter.api.Assertions.assertNotNull((Object)isX);
                    continue;
                }
                if (!a.stringValue().endsWith("a2")) continue;
                org.junit.jupiter.api.Assertions.assertNull((Object)isX);
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)count);
        }
    }

    private void testValuesClauseNamedGraph(RepositoryConnection conn) throws Exception {
        String ex = "http://example.org/";
        String data = "@prefix foaf: <http://xmlns.com/foaf/0.1/> .\n@prefix ex: <" + ex + "> .\nex:graph1 {\n\tex:Person1 rdf:type foaf:Person ;\n\t\tfoaf:name \"Person 1\" .\tex:Person2 rdf:type foaf:Person ;\n\t\tfoaf:name \"Person 2\" .\tex:Person3 rdf:type foaf:Person ;\n\t\tfoaf:name \"Person 3\" .\n}";
        conn.add((Reader)new StringReader(data), "", RDFFormat.TRIG, new Resource[0]);
        String query = "SELECT  ?person ?name ?__index \nWHERE {         VALUES (?person ?name  ?__index) { \n                  (<http://example.org/Person1> UNDEF \"0\") \n                  (<http://example.org/Person3> UNDEF \"2\")  } \n        GRAPH <http://example.org/graph1> { ?person <http://xmlns.com/foaf/0.1/name> ?name .   } }";
        TupleQuery q = conn.prepareTupleQuery(query);
        List result = QueryResults.asList((QueryResult)q.evaluate());
        Assertions.assertThat((List)result).hasSize(2);
    }

    private void testValuesCartesianProduct(RepositoryConnection conn) {
        String queryString = "select ?x ?y where {   values ?x { undef 67 }   values ?y { undef 42 } }";
        TupleQuery tupleQuery = conn.prepareTupleQuery("select ?x ?y where {   values ?x { undef 67 }   values ?y { undef 42 } }");
        List bindingSets = QueryResults.asList((QueryResult)tupleQuery.evaluate());
        Assertions.assertThat((List)bindingSets).hasSize(4);
    }

    private void testSES1081SameTermWithValues(RepositoryConnection conn) throws Exception {
        this.loadTestData("/testdata-query/dataset-ses1081.trig", conn, new Resource[0]);
        String query = "PREFIX ex: <http://example.org/>\n SELECT * \n WHERE { \n           ?s ex:p ?a . \n          FILTER sameTerm(?a, ?e) \n           VALUES ?e { ex:b } \n  } ";
        TupleQuery tq = conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            org.junit.jupiter.api.Assertions.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                BindingSet bs = (BindingSet)result.next();
                ++count;
                org.junit.jupiter.api.Assertions.assertNotNull((Object)bs);
                Value s = bs.getValue("s");
                Value a = bs.getValue("a");
                org.junit.jupiter.api.Assertions.assertNotNull((Object)s);
                org.junit.jupiter.api.Assertions.assertNotNull((Object)a);
                org.junit.jupiter.api.Assertions.assertEquals((Object)Values.iri((String)"http://example.org/a"), (Object)s);
                org.junit.jupiter.api.Assertions.assertEquals((Object)Values.iri((String)"http://example.org/b"), (Object)a);
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)count);
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            org.junit.jupiter.api.Assertions.fail((String)e.getMessage());
        }
    }

    private void testSES2136(RepositoryConnection conn) throws Exception {
        this.loadTestData("/testcases-sparql-1.1-w3c/bindings/data02.ttl", conn, new Resource[0]);
        String query = "PREFIX : <http://example.org/>\nSELECT ?s ?o { \n { SELECT * WHERE { ?s ?p ?o . } }\n\tVALUES (?o) { (:b) }\n}\n";
        ValueFactory vf = conn.getValueFactory();
        IRI a = vf.createIRI("http://example.org/a");
        IRI b = vf.createIRI("http://example.org/b");
        TupleQuery tq = conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            org.junit.jupiter.api.Assertions.assertNotNull((Object)result);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)result.hasNext());
            BindingSet bs = (BindingSet)result.next();
            org.junit.jupiter.api.Assertions.assertFalse((boolean)result.hasNext(), (String)"only one result expected");
            org.junit.jupiter.api.Assertions.assertEquals((Object)a, (Object)bs.getValue("s"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)b, (Object)bs.getValue("o"));
        }
    }

    private void testFilterExistsExternalValuesClause(RepositoryConnection conn) {
        String ub = "insert data {\n  <http://subj1> a <http://type> .\n  <http://subj2> a <http://type> .\n  <http://subj1> <http://predicate> <http://obj1> .\n  <http://subj2> <http://predicate> <http://obj2> .\n}";
        conn.prepareUpdate(QueryLanguage.SPARQL, ub).execute();
        String query = "select ?s  {\n    ?s a* <http://type> .\n    FILTER EXISTS {?s <http://predicate> ?o}\n} limit 100 values ?o {<http://obj1>}";
        TupleQuery tq = conn.prepareTupleQuery(query);
        List result = QueryResults.asList((QueryResult)tq.evaluate());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)result.size(), (String)"single result expected");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"http://subj1", (Object)((BindingSet)result.get(0)).getValue("s").stringValue());
    }

    public void testMultipleValuesClauses(RepositoryConnection conn) {
        Update update = conn.prepareUpdate("PREFIX ex: <http://example.org/>\n\nINSERT DATA { ex:sub ex:somePred \"value\" . };\n\nINSERT { ?s ?newPred ?newObj }\nWHERE {\n  # If one combines these into a single VALUES clause then it also works\n  VALUES ?newPred { ex:somePred2 }\n  VALUES ?newObj { \"value2\" }\n  ?s ex:somePred [] .\n}");
        update.execute();
    }

    public Stream<DynamicTest> tests() {
        return Stream.of(this.makeTest("ValuesInOptional", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testValuesInOptional)), this.makeTest("ValuesClauseNamedGraph", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testValuesClauseNamedGraph)), this.makeTest("ValuesCartesianProduct", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testValuesCartesianProduct)), this.makeTest("SES1081SameTermWithValues", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testSES1081SameTermWithValues)), this.makeTest("SES2136", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testSES2136)), this.makeTest("FilterExistsExternalValuesClause", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testFilterExistsExternalValuesClause)), this.makeTest("MultipleValuesClauses", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testMultipleValuesClauses)));
    }
}

