/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.testsuite.sparql.tests;

import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.util.ModelBuilder;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.QueryResult;
import org.eclipse.rdf4j.query.QueryResults;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.testsuite.sparql.AbstractComplianceTest;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.function.ThrowingConsumer;

public class BindTest
extends AbstractComplianceTest {
    public BindTest(Supplier<Repository> repo) {
        super(repo);
    }

    private void testBindError(RepositoryConnection conn) {
        conn.prepareUpdate(QueryLanguage.SPARQL, "insert data { <urn:test:subj> <urn:test:pred> _:blank }").execute();
        String qb = "SELECT * \nWHERE { \n  VALUES (?NAValue) { (<http://null>) } \n   BIND(IF(?NAValue != <http://null>, ?NAValue, ?notBoundVar) as ?ValidNAValue) \n   { ?disjClass (owl:disjointWith|^owl:disjointWith)? ?disjClass2 . }\n}\n";
        List result = QueryResults.asList((QueryResult)conn.prepareTupleQuery(qb).evaluate());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)result.size(), (String)"query should return 2 solutions");
    }

    private void testBindScope(RepositoryConnection conn) {
        String query = "SELECT * {\n  { BIND (\"a\" AS ?a) }\n  { BIND (?a AS ?b) } \n}";
        TupleQuery q = conn.prepareTupleQuery(query);
        List result = QueryResults.asList((QueryResult)q.evaluate());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)result.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)conn.getValueFactory().createLiteral("a"), (Object)((BindingSet)result.get(0)).getValue("a"));
        org.junit.jupiter.api.Assertions.assertNull((Object)((BindingSet)result.get(0)).getValue("b"));
    }

    private void testBindScopeUnion(RepositoryConnection conn) {
        ValueFactory f = conn.getValueFactory();
        String query = "prefix ex: <http://example.org/> \nselect * {\n  bind(ex:v1 as ?v)\n  bind(strafter(str(?v),str(ex:)) as ?b)\n  {\n    bind(?b as ?b1)\n  } union {\n    bind(?b as ?b2)\n  }\n}";
        TupleQuery q = conn.prepareTupleQuery(query);
        List result = QueryResults.asList((QueryResult)q.evaluate());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)result.size());
        IRI v1 = f.createIRI("http://example.org/v1");
        Literal b = f.createLiteral("v1");
        for (BindingSet bs : result) {
            Assertions.assertThat((Object)bs.getValue("v")).isEqualTo((Object)v1);
            Assertions.assertThat((Object)bs.getValue("b1")).isNull();
            Assertions.assertThat((Object)bs.getValue("b2")).isNull();
        }
    }

    private void testSES2250BindErrors(RepositoryConnection conn) {
        conn.prepareUpdate(QueryLanguage.SPARQL, "insert data { <urn:test:subj> <urn:test:pred> _:blank }").execute();
        String qb = "SELECT * {\n    ?s1 ?p1 ?blank .     FILTER(isBlank(?blank))    BIND (iri(?blank) as ?biri)    ?biri ?p2 ?o2 .}";
        TupleQuery tq = conn.prepareTupleQuery(QueryLanguage.SPARQL, qb);
        try (TupleQueryResult evaluate = tq.evaluate();){
            org.junit.jupiter.api.Assertions.assertFalse((boolean)evaluate.hasNext(), (String)("The query should not return a result: " + Arrays.toString(evaluate.stream().toArray())));
        }
    }

    private void testSES2250BindErrorsInPath(RepositoryConnection conn) {
        conn.prepareUpdate(QueryLanguage.SPARQL, "insert data { <urn:test:subj> <urn:test:pred> _:blank }").execute();
        String qb = "SELECT * {\n    ?s1 ?p1 ?blank .     FILTER(isBlank(?blank))    BIND (iri(?blank) as ?biri)    ?biri <urn:test:pred>* ?o2 .}";
        TupleQuery tq = conn.prepareTupleQuery(QueryLanguage.SPARQL, qb);
        try (TupleQueryResult evaluate = tq.evaluate();){
            org.junit.jupiter.api.Assertions.assertFalse((boolean)evaluate.hasNext(), (String)"The query should not return a result");
        }
    }

    public void testSelectBindOnly(RepositoryConnection conn) {
        String query = "select ?b1 ?b2 ?b3\nwhere {\n  bind(1 as ?b1)\n}";
        List result = QueryResults.asList((QueryResult)conn.prepareTupleQuery(query).evaluate());
        Assertions.assertThat((int)result.size()).isEqualTo(1);
        BindingSet solution = (BindingSet)result.get(0);
        Assertions.assertThat((Object)solution.getValue("b1")).isEqualTo((Object)Values.literal((String)"1", (CoreDatatype)CoreDatatype.XSD.INTEGER));
        Assertions.assertThat((Object)solution.getValue("b2")).isNull();
        Assertions.assertThat((Object)solution.getValue("b3")).isNull();
    }

    private void testGH3696Bind(RepositoryConnection conn) {
        Model testData = new ModelBuilder().setNamespace("ex", "http://example.org/").subject("ex:unit1").add(RDF.TYPE, (Object)"ex:Unit").add(RDFS.LABEL, (Object)"Unit1").add("ex:has", (Object)"Unit1").subject("ex:unit2").add(RDF.TYPE, (Object)"ex:Unit").add(RDFS.LABEL, (Object)"Unit2").build();
        conn.add((Iterable)testData, new Resource[0]);
        String query = "PREFIX ex: <http://example.org/>\nSELECT  * {\n  ?bind rdfs:label ?b1 ;\n        a ex:Unit .\n  FILTER (?b1 = 'Unit2') .\n  BIND(?bind AS ?n0)\n  ?n0 ex:has ?n1 \n }";
        List result = QueryResults.asList((QueryResult)conn.prepareTupleQuery(query).evaluate());
        Assertions.assertThat((List)result).isEmpty();
    }

    private void testGH4499BindFilterNotExist1(RepositoryConnection conn) {
        Model testData = new ModelBuilder().setNamespace("ex", "http://example.org/").subject("ex:a").add("ex:p", (Object)"ex:c1").add("ex:p", (Object)"ex:c2").add("ex:p", (Object)"ex:c3").subject("ex:c1").add(RDF.TYPE, (Object)"ex:T").add("ex:q", (Object)"something").subject("ex:c2").add(RDF.TYPE, (Object)"ex:T").build();
        conn.add((Iterable)testData, new Resource[0]);
        String query = "PREFIX ex: <http://example.org/>\nSELECT *\n    WHERE {\n            BIND ( ex:a AS ?a )\n            BIND ( ex:b AS ?b )\n            ?a ex:p* ?c .\n            FILTER EXISTS { ?c rdf:type ex:T }\n            FILTER NOT EXISTS { ?c ex:q ?d}\n}";
        List result = QueryResults.asList((QueryResult)conn.prepareTupleQuery(query).evaluate());
        Assertions.assertThat((List)result).hasSize(1);
        BindingSet bs = (BindingSet)result.get(0);
        Assertions.assertThat((String)bs.getValue("a").stringValue()).isEqualTo("http://example.org/a");
        Assertions.assertThat((String)bs.getValue("c").stringValue()).isEqualTo("http://example.org/c2");
        Assertions.assertThat((Object)bs.getValue("d")).isNull();
    }

    private void testGH4499BindFilterNotExist2(RepositoryConnection conn) {
        Model testData = new ModelBuilder().setNamespace("ex", "http://example.org/").subject("ex:a").add("ex:p", (Object)"ex:c1").add("ex:p", (Object)"ex:c2").add("ex:p", (Object)"ex:c3").subject("ex:c1").add(RDF.TYPE, (Object)"ex:T").add("ex:q", (Object)"something").subject("ex:c2").add(RDF.TYPE, (Object)"ex:T").build();
        conn.add((Iterable)testData, new Resource[0]);
        String query = "PREFIX ex: <http://example.org/>\nSELECT *\n    WHERE {\n            FILTER EXISTS { ?c rdf:type ex:T }\n            FILTER NOT EXISTS { ?c ex:q ?d }\n            BIND ( ex:a AS ?a )\n            BIND ( ex:b AS ?b )\n            ?a ex:p* ?c .\n}";
        List result = QueryResults.asList((QueryResult)conn.prepareTupleQuery(query).evaluate());
        Assertions.assertThat((List)result).hasSize(1);
        BindingSet bs = (BindingSet)result.get(0);
        Assertions.assertThat((String)bs.getValue("a").stringValue()).isEqualTo("http://example.org/a");
        Assertions.assertThat((String)bs.getValue("c").stringValue()).isEqualTo("http://example.org/c2");
        Assertions.assertThat((Object)bs.getValue("d")).isNull();
    }

    public Stream<DynamicTest> tests() {
        return Stream.of(this.makeTest("GH4499BindFilterNotExist2", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testGH4499BindFilterNotExist2)), this.makeTest("GH4499BindFilterNotExist1", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testGH4499BindFilterNotExist1)), this.makeTest("GH3696Bind", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testGH3696Bind)), this.makeTest("SelectBindOnly", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testSelectBindOnly)), this.makeTest("SES2250BindErrorsInPath", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testSES2250BindErrorsInPath)), this.makeTest("SES2250BindErrors", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testSES2250BindErrors)), this.makeTest("BindScopeUnion", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testBindScopeUnion)), this.makeTest("BindScope", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testBindScope)), this.makeTest("BindError", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testBindError)));
    }
}

