/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.testsuite.sparql.tests;

import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.testsuite.sparql.AbstractComplianceTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.function.ThrowingConsumer;

public class ExistsTest
extends AbstractComplianceTest {
    public ExistsTest(Supplier<Repository> repo) {
        super(repo);
    }

    private void testFilterNotExistsBindingToCurrentSolutionMapping(RepositoryConnection conn) {
        String ex = "http://example/";
        IRI a1 = Values.iri((String)ex, (String)"a1");
        IRI a2 = Values.iri((String)ex, (String)"a2");
        IRI both = Values.iri((String)ex, (String)"both");
        IRI predicate1 = Values.iri((String)ex, (String)"predicate1");
        IRI predicate2 = Values.iri((String)ex, (String)"predicate2");
        conn.add((Resource)a1, predicate1, (Value)both, new Resource[0]);
        conn.add((Resource)a1, predicate2, (Value)both, new Resource[0]);
        conn.add((Resource)a2, predicate1, (Value)both, new Resource[0]);
        conn.add((Resource)a2, predicate2, (Value)Values.bnode(), new Resource[0]);
        TupleQuery tupleQuery = conn.prepareTupleQuery("PREFIX : <http://example/>\nSELECT * WHERE {\n  ?a :predicate1 ?p1\n  FILTER NOT EXISTS {\n    ?a :predicate2 ?p2 .\n    FILTER(?p2 = ?p1)\n  }\n}\n");
        try (Stream stream = tupleQuery.evaluate().stream();){
            List collect = stream.collect(Collectors.toList());
            Assertions.assertEquals((int)1, (int)collect.size());
            Assertions.assertEquals((Object)a2, (Object)((BindingSet)collect.get(0)).getValue("a"));
        }
    }

    public Stream<DynamicTest> tests() {
        return Stream.of(this.makeTest("FilterNotExistsBindingToCurrentSolutionMapping", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testFilterNotExistsBindingToCurrentSolutionMapping)));
    }
}

