/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.testsuite.sparql.tests;

import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.testsuite.sparql.AbstractComplianceTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.function.ThrowingConsumer;

public class UnionTest
extends AbstractComplianceTest {
    public UnionTest(Supplier<Repository> repo) {
        super(repo);
    }

    private void testEmptyUnion(RepositoryConnection conn) {
        String query = "PREFIX : <http://example.org/> SELECT ?visibility WHERE {OPTIONAL { SELECT ?var WHERE { :s a :MyType . BIND (:s as ?var ) .} } .BIND (IF(BOUND(?var), 'VISIBLE', 'HIDDEN') as ?visibility)}";
        try (TupleQueryResult result = conn.prepareTupleQuery(QueryLanguage.SPARQL, query).evaluate();){
            Assertions.assertNotNull((Object)result);
            Assertions.assertFalse((boolean)result.hasNext());
        }
    }

    private void testSameTermRepeatInUnion(RepositoryConnection conn) throws Exception {
        this.loadTestData("/testdata-query/dataset-query.trig", conn, new Resource[0]);
        String query = "PREFIX foaf:<http://xmlns.com/foaf/0.1/>\nSELECT * {\n    {\n        ?sameTerm foaf:mbox ?mbox\n        FILTER sameTerm(?sameTerm,$william)\n    } UNION {\n        ?x foaf:knows ?sameTerm\n        FILTER sameTerm(?sameTerm,$william)\n    }\n}";
        TupleQuery tq = conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        tq.setBinding("william", (Value)conn.getValueFactory().createIRI("http://example.org/william"));
        try (TupleQueryResult result = tq.evaluate();){
            Assertions.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                BindingSet bs = (BindingSet)result.next();
                ++count;
                Assertions.assertNotNull((Object)bs);
                Value mbox = bs.getValue("mbox");
                Value x = bs.getValue("x");
                Assertions.assertTrue((mbox instanceof Literal || x instanceof IRI ? 1 : 0) != 0);
            }
            Assertions.assertEquals((int)3, (int)count);
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    private void testSameTermRepeatInUnionAndOptional(RepositoryConnection conn) throws Exception {
        this.loadTestData("/testdata-query/dataset-query.trig", conn, new Resource[0]);
        String query = this.getNamespaceDeclarations() + "SELECT * {\n    {\n        ex:a ?p ?prop1\n        FILTER (?p = ex:prop1)\n    } UNION {\n          ?s ex:p ex:A ;           {               {                  ?s ?p ?l .                 FILTER(?p = rdfs:label)               }               OPTIONAL {                  ?s ?p ?opt1 .                  FILTER (?p = ex:prop1)               }               OPTIONAL {                  ?s ?p ?opt2 .                  FILTER (?p = ex:prop2)               }           }    }\n}";
        TupleQuery tq = conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assertions.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                BindingSet bs = (BindingSet)result.next();
                ++count;
                Assertions.assertNotNull((Object)bs);
                Value prop1 = bs.getValue("prop1");
                Value l = bs.getValue("l");
                Assertions.assertTrue((prop1 instanceof Literal || l instanceof Literal ? 1 : 0) != 0);
                if (!(l instanceof Literal)) continue;
                Value opt1 = bs.getValue("opt1");
                Assertions.assertNull((Object)opt1);
                Value opt2 = bs.getValue("opt2");
                Assertions.assertNull((Object)opt2);
            }
            Assertions.assertEquals((int)2, (int)count);
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    public Stream<DynamicTest> tests() {
        return Stream.of(this.makeTest("EmptyUnion", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testEmptyUnion)), this.makeTest("SameTermRepeatInUnion", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testSameTermRepeatInUnion)), this.makeTest("SameTermRepeatInUnionAndOptional", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testSameTermRepeatInUnionAndOptional)));
    }
}

