/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.testsuite.sparql.tests;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.FOAF;
import org.eclipse.rdf4j.model.vocabulary.SKOS;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.QueryResult;
import org.eclipse.rdf4j.query.QueryResults;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.impl.MapBindingSet;
import org.eclipse.rdf4j.query.impl.SimpleBinding;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.testsuite.sparql.AbstractComplianceTest;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.function.ThrowingConsumer;

public class PropertyPathTest
extends AbstractComplianceTest {
    public PropertyPathTest(Supplier<Repository> repo) {
        super(repo);
    }

    private void testSES2147PropertyPathsWithIdenticalSubsPreds(RepositoryConnection conn) throws Exception {
        String data = "<urn:s1> <urn:p> <urn:s2> .\n<urn:s2> <urn:p> <urn:s3> .\n<urn:s3> <urn:q> <urn:s4> .\n<urn:s1> <urn:p> <urn:s5> .\n<urn:s5> <urn:q> <urn:s6> .\n";
        conn.begin();
        conn.add((Reader)new StringReader(data), "", RDFFormat.NTRIPLES, new Resource[0]);
        conn.commit();
        String query = this.getNamespaceDeclarations() + "SELECT ?x \nWHERE { ?x <urn:p>*/<urn:q> <urn:s4> . \n        ?x <urn:p>*/<urn:q> <urn:s6> . \n} \n";
        TupleQuery tq = conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            org.junit.jupiter.api.Assertions.assertNotNull((Object)result);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)result.hasNext());
            Value x = ((BindingSet)result.next()).getValue("x");
            org.junit.jupiter.api.Assertions.assertNotNull((Object)x);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)(x instanceof IRI));
            org.junit.jupiter.api.Assertions.assertEquals((Object)"urn:s1", (Object)x.stringValue());
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            org.junit.jupiter.api.Assertions.fail((String)e.getMessage());
        }
    }

    private void testSES2024PropertyPathAnonVarSharing(RepositoryConnection conn) throws Exception {
        this.loadTestData("/testdata-query/dataset-ses2024.trig", conn, new Resource[0]);
        String query = "PREFIX : <http://example.org/> SELECT * WHERE { ?x1 :p/:lit ?l1 . ?x1 :diff ?x2 . ?x2 :p/:lit ?l2 . }";
        TupleQuery tq = conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            org.junit.jupiter.api.Assertions.assertNotNull((Object)result);
            BindingSet bs = (BindingSet)result.next();
            Literal l1 = (Literal)bs.getValue("l1");
            Literal l2 = (Literal)bs.getValue("l2");
            org.junit.jupiter.api.Assertions.assertNotNull((Object)l1);
            org.junit.jupiter.api.Assertions.assertNotEquals((Object)l1, (Object)l2);
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            org.junit.jupiter.api.Assertions.fail((String)e.getMessage());
        }
    }

    private void testPropertyPathNegationInversion(RepositoryConnection conn) throws Exception {
        String data = "@prefix : <http://example.org/>.\n:Mary :parentOf :Jim.\n:Jim :knows :Jane.\n:Jane :worksFor :IBM.";
        conn.add((Reader)new StringReader(data), "", RDFFormat.TURTLE, new Resource[0]);
        String query1 = "prefix : <http://example.org/> ASK WHERE { :IBM ^(:|!:) :Jane } ";
        org.junit.jupiter.api.Assertions.assertTrue((boolean)conn.prepareBooleanQuery(query1).evaluate());
        String query2 = "prefix : <http://example.org/> ASK WHERE { :IBM ^(:|!:) ?a } ";
        org.junit.jupiter.api.Assertions.assertTrue((boolean)conn.prepareBooleanQuery(query2).evaluate());
        String query3 = "prefix : <http://example.org/> ASK WHERE { :IBM (^(:|!:))* :Mary } ";
        org.junit.jupiter.api.Assertions.assertTrue((boolean)conn.prepareBooleanQuery(query3).evaluate());
    }

    private void testSES2336NegatedPropertyPathMod(RepositoryConnection conn) throws Exception {
        this.loadTestData("/testdata-query/dataset-ses2336.trig", conn, new Resource[0]);
        String query = "prefix : <http://example.org/> select * where { ?s a :Test ; !:p? ?o . }";
        ValueFactory vf = conn.getValueFactory();
        TupleQuery tq = conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult evaluate = tq.evaluate();){
            List result = QueryResults.asList((QueryResult)evaluate);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)result);
            IRI a = vf.createIRI("http://example.org/", "a");
            IRI b = vf.createIRI("http://example.org/", "b");
            IRI c = vf.createIRI("http://example.org/", "c");
            IRI d = vf.createIRI("http://example.org/", "d");
            IRI e = vf.createIRI("http://example.org/", "e");
            IRI test = vf.createIRI("http://example.org/", "Test");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.containsSolution(result, new Binding[]{new SimpleBinding("s", (Value)a), new SimpleBinding("o", (Value)a)}));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.containsSolution(result, new Binding[]{new SimpleBinding("s", (Value)a), new SimpleBinding("o", (Value)test)}));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.containsSolution(result, new Binding[]{new SimpleBinding("s", (Value)a), new SimpleBinding("o", (Value)c)}));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.containsSolution(result, new Binding[]{new SimpleBinding("s", (Value)d), new SimpleBinding("o", (Value)d)}));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.containsSolution(result, new Binding[]{new SimpleBinding("s", (Value)d), new SimpleBinding("o", (Value)e)}));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.containsSolution(result, new Binding[]{new SimpleBinding("s", (Value)d), new SimpleBinding("o", (Value)test)}));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)this.containsSolution(result, new Binding[]{new SimpleBinding("s", (Value)a), new SimpleBinding("o", (Value)b)}));
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            org.junit.jupiter.api.Assertions.fail((String)e.getMessage());
        }
    }

    private void testSES1685propPathSameVar(RepositoryConnection conn) throws Exception {
        String queryStr = "PREFIX : <urn:> SELECT ?x WHERE {?x :p+ ?x}";
        conn.add((Reader)new StringReader("@prefix : <urn:> . :a :p :b . :b :p :a ."), "", RDFFormat.TURTLE, new Resource[0]);
        TupleQuery query = conn.prepareTupleQuery(QueryLanguage.SPARQL, "PREFIX : <urn:> SELECT ?x WHERE {?x :p+ ?x}");
        try (Stream result = query.evaluate().stream();){
            long count = result.count();
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)count);
        }
    }

    private void testSES1073InverseSymmetricPattern(RepositoryConnection conn) {
        IRI a = Values.iri((String)"http://example.org/a");
        IRI b1 = Values.iri((String)"http://example.org/b1");
        IRI b2 = Values.iri((String)"http://example.org/b2");
        IRI c1 = Values.iri((String)"http://example.org/c1");
        IRI c2 = Values.iri((String)"http://example.org/c2");
        IRI a2b = Values.iri((String)"http://example.org/a2b");
        IRI b2c = Values.iri((String)"http://example.org/b2c");
        conn.add((Resource)a, a2b, (Value)b1, new Resource[0]);
        conn.add((Resource)a, a2b, (Value)b2, new Resource[0]);
        conn.add((Resource)b1, b2c, (Value)c1, new Resource[0]);
        conn.add((Resource)b2, b2c, (Value)c2, new Resource[0]);
        Object query = "select * ";
        query = (String)query + "where{ ";
        query = (String)query + "?c1 ^<http://example.org/b2c>/^<http://example.org/a2b>/<http://example.org/a2b>/<http://example.org/b2c> ?c2 . ";
        query = (String)query + " } ";
        TupleQuery tq = conn.prepareTupleQuery(QueryLanguage.SPARQL, (String)query);
        try (Stream result = tq.evaluate().stream();){
            long count = result.count();
            org.junit.jupiter.api.Assertions.assertEquals((long)4L, (long)count);
        }
    }

    private void testNestedInversePropertyPathWithZeroLength(RepositoryConnection conn) {
        String insert = "insert data {\n    <urn:1> <urn:prop> <urn:object> .\n    <urn:2> <urn:prop> <urn:mid:1> .\n    <urn:mid:1> <urn:prop> <urn:object> .\n    <urn:3> <urn:prop> <urn:mid:2> .\n    <urn:mid:2> <urn:prop> <urn:mid:3> .\n    <urn:mid:3> <urn:prop> <urn:object> .\n}";
        String query = "select * where { \n    <urn:object> (^<urn:prop>)? ?o .\n}";
        conn.prepareUpdate(insert).execute();
        TupleQuery tq = conn.prepareTupleQuery(query);
        try (TupleQueryResult evaluate = tq.evaluate();){
            List result = QueryResults.asList((QueryResult)evaluate);
            Assertions.assertThat((List)result).hasSize(4);
        }
    }

    private void testComplexPath(RepositoryConnection conn) {
        conn.add((Resource)Values.bnode(), SKOS.BROADER, (Value)Values.bnode(), new Resource[0]);
        conn.add((Resource)Values.bnode(), SKOS.TOP_CONCEPT_OF, (Value)Values.bnode(), new Resource[0]);
        TupleQuery tupleQuery = conn.prepareTupleQuery("PREFIX skos:<http://www.w3.org/2004/02/skos/core#> \r\n SELECT *   WHERE {\r\n   ?s (skos:broader|^skos:narrower|skos:topConceptOf|^skos:hasTopConcept) ?o.\r\n }");
        try (TupleQueryResult evaluate = tupleQuery.evaluate();){
            List collect = evaluate.stream().collect(Collectors.toList());
            org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)collect.size());
        }
    }

    private void testInversePath(RepositoryConnection conn) {
        BNode bnode1 = Values.bnode((String)"bnode1");
        conn.add((Resource)Values.bnode(), FOAF.KNOWS, (Value)bnode1, new Resource[0]);
        conn.add((Resource)Values.bnode(), FOAF.KNOWS, (Value)bnode1, new Resource[0]);
        TupleQuery tupleQuery = conn.prepareTupleQuery("PREFIX foaf: <http://xmlns.com/foaf/0.1/>\nSELECT * WHERE {\n  ?x foaf:knows/^foaf:knows ?y . \n  FILTER(?x != ?y)\n}");
        try (TupleQueryResult evaluate = tupleQuery.evaluate();){
            List collect = evaluate.stream().collect(Collectors.toList());
            org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)collect.size());
        }
    }

    private boolean containsSolution(List<BindingSet> result, Binding ... solution) {
        MapBindingSet bs = new MapBindingSet();
        for (Binding b : solution) {
            bs.addBinding(b);
        }
        return result.contains(bs);
    }

    public Stream<DynamicTest> tests() {
        return Stream.of(this.makeTest("SES2147PropertyPathsWithIdenticalSubsPreds", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testSES2147PropertyPathsWithIdenticalSubsPreds)), this.makeTest("InversePath", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testInversePath)), this.makeTest("ComplexPath", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testComplexPath)), this.makeTest("NestedInversePropertyPathWithZeroLength", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testNestedInversePropertyPathWithZeroLength)), this.makeTest("SES1073InverseSymmetricPattern", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testSES1073InverseSymmetricPattern)), this.makeTest("SES1685propPathSameVar", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testSES1685propPathSameVar)), this.makeTest("SES2336NegatedPropertyPathMod", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testSES2336NegatedPropertyPathMod)), this.makeTest("PropertyPathNegationInversion", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testPropertyPathNegationInversion)), this.makeTest("SES2024PropertyPathAnonVarSharing", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testSES2024PropertyPathAnonVarSharing)));
    }
}

