/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.testsuite.sparql.tests;

import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.testsuite.sparql.AbstractComplianceTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.function.ThrowingConsumer;

public class InTest
extends AbstractComplianceTest {
    public InTest(Supplier<Repository> repo) {
        super(repo);
    }

    private void testInComparison1(RepositoryConnection conn) throws Exception {
        this.loadTestData("/testdata-query/dataset-ses1913.trig", conn, new Resource[0]);
        String query = " PREFIX : <http://example.org/>\n SELECT ?y WHERE { :a :p ?y. FILTER(?y in (:c, :d, 1/0 , 1)) } ";
        TupleQuery tq = conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assertions.assertNotNull((Object)result);
            Assertions.assertTrue((boolean)result.hasNext());
            BindingSet bs = (BindingSet)result.next();
            Value y = bs.getValue("y");
            Assertions.assertNotNull((Object)y);
            Assertions.assertTrue((boolean)(y instanceof Literal));
            Assertions.assertEquals((Object)Values.literal((String)"1", (CoreDatatype)CoreDatatype.XSD.INTEGER), (Object)y);
        }
    }

    private void testInComparison2(RepositoryConnection conn) throws Exception {
        this.loadTestData("/testdata-query/dataset-ses1913.trig", conn, new Resource[0]);
        String query = " PREFIX : <http://example.org/>\n SELECT ?y WHERE { :a :p ?y. FILTER(?y in (:c, :d, 1/0)) } ";
        TupleQuery tq = conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assertions.assertNotNull((Object)result);
            Assertions.assertFalse((boolean)result.hasNext());
        }
    }

    private void testInComparison3(RepositoryConnection conn) throws Exception {
        this.loadTestData("/testdata-query/dataset-ses1913.trig", conn, new Resource[0]);
        String query = " PREFIX : <http://example.org/>\n SELECT ?y WHERE { :a :p ?y. FILTER(?y in (:c, :d, 1, 1/0)) } ";
        TupleQuery tq = conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assertions.assertNotNull((Object)result);
            Assertions.assertTrue((boolean)result.hasNext());
            BindingSet bs = (BindingSet)result.next();
            Value y = bs.getValue("y");
            Assertions.assertNotNull((Object)y);
            Assertions.assertTrue((boolean)(y instanceof Literal));
            Assertions.assertEquals((Object)Values.literal((String)"1", (IRI)XSD.INTEGER), (Object)y);
        }
    }

    public Stream<DynamicTest> tests() {
        return Stream.of(this.makeTest("InComparison1", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testInComparison1)), this.makeTest("InComparison2", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testInComparison2)), this.makeTest("InComparison3", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testInComparison3)));
    }
}

