/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.testsuite.sparql.tests;

import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.FOAF;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.testsuite.sparql.AbstractComplianceTest;
import org.junit.Assert;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.function.ThrowingConsumer;

public class FilterScopeTest
extends AbstractComplianceTest {
    public FilterScopeTest(Supplier<Repository> repo) {
        super(repo);
    }

    public void testScope1(RepositoryConnection conn) {
        this.loadData(conn);
        String query = String.join((CharSequence)"\n", "", "PREFIX foaf: <http://xmlns.com/foaf/0.1/>", "SELECT * WHERE {", "  ?person a ?type ; ", "  foaf:age ?age ;", "  foaf:knows ?person2 .", "  FILTER(?person != <http://example.org/2> && ?type = foaf:Person)", "\t{", "      ?person foaf:age ?age .", "      FILTER(?type NOT IN (foaf:NotPerson)) #?type is not in scope, so should produce an error. ", "\t}", "} ");
        try (TupleQueryResult result = conn.prepareTupleQuery(query).evaluate();){
            List collect = result.stream().collect(Collectors.toList());
            Assert.assertEquals(List.of(), collect);
        }
    }

    public void testScope1WithoutScopingIssue(RepositoryConnection conn) {
        this.loadData(conn);
        String query = String.join((CharSequence)"\n", "", "PREFIX foaf: <http://xmlns.com/foaf/0.1/>", "SELECT * WHERE {", "  ?person a ?type ; ", "  foaf:age ?age ;", "  foaf:knows ?person2 .", "  FILTER(?person != <http://example.org/2> && ?type = foaf:Person)", "\t{", "      ?person foaf:age ?age .", "      # FILTER(?type NOT IN (foaf:NotPerson)) COMMENTED OUT ON PURPOSE TO SHOW THAT WE GET RESULTS WHEN THERE IS NO LONGER A SCOPE ISSUE  ", "\t}", "} ");
        try (TupleQueryResult result = conn.prepareTupleQuery(query).evaluate();){
            List collect = result.stream().collect(Collectors.toList());
            Assert.assertEquals((long)4L, (long)collect.size());
        }
    }

    public void testScope1WithCorrectScope(RepositoryConnection conn) {
        this.loadData(conn);
        String query = String.join((CharSequence)"\n", "", "PREFIX foaf: <http://xmlns.com/foaf/0.1/>", "SELECT * WHERE {", "  ?person a ?type ; ", "  foaf:age ?age ;", "  foaf:knows ?person2 .", "  FILTER(?person != <http://example.org/2> && ?type = foaf:Person)", "\t{", "      ?person foaf:age ?age .", "\t}", "   FILTER(?type NOT IN (foaf:NotPerson)) # ?type is now in scope", "} ");
        try (TupleQueryResult result = conn.prepareTupleQuery(query).evaluate();){
            List collect = result.stream().collect(Collectors.toList());
            Assert.assertEquals((long)4L, (long)collect.size());
        }
    }

    public void testScope2(RepositoryConnection conn) {
        this.loadData(conn);
        String query = String.join((CharSequence)"\n", "", "PREFIX foaf: <http://xmlns.com/foaf/0.1/>", "SELECT * WHERE {", "  ?person a ?type ; ", "  foaf:age ?age ;", "  foaf:knows ?person2 .", "\t{", "      ?person foaf:age ?age .", "      FILTER(?type NOT IN (foaf:NotPerson)) #?type is not in scope, so should produce an error. ", "\t}", "} ");
        try (TupleQueryResult result = conn.prepareTupleQuery(query).evaluate();){
            List collect = result.stream().collect(Collectors.toList());
            Assert.assertEquals(List.of(), collect);
        }
    }

    public void testScope3(RepositoryConnection conn) {
        this.loadData(conn);
        String query = String.join((CharSequence)"\n", "", "PREFIX foaf: <http://xmlns.com/foaf/0.1/>", "SELECT * WHERE {", "  ?person a ?type ; ", "  foaf:age ?age ;", "  foaf:knows ?person2 .", "\t{", "      ?person a ?type .", "      FILTER(?person2 NOT IN (<http://example.com/person1>)) #?person2 is not in scope, so should produce an error. ", "\t}", "  FILTER(?type IN (foaf:Person))", "} ");
        try (TupleQueryResult result = conn.prepareTupleQuery(query).evaluate();){
            List collect = result.stream().collect(Collectors.toList());
            Assert.assertEquals(List.of(), collect);
        }
    }

    public void testScope3WithoutScopingIssue(RepositoryConnection conn) {
        this.loadData(conn);
        String query = String.join((CharSequence)"\n", "", "PREFIX foaf: <http://xmlns.com/foaf/0.1/>", "SELECT * WHERE {", "  ?person a ?type ; ", "  foaf:age ?age ;", "  foaf:knows ?person2 .", "\t{", "      ?person a ?type .", "      # FILTER(?person2 NOT IN (<http://example.com/person1>)) COMMENTED OUT ON PURPOSE TO SHOW THAT WE GET RESULTS WHEN THERE IS NO LONGER A SCOPE ISSUE ", "\t}", "  FILTER(?type IN (foaf:Person))", "} ");
        try (TupleQueryResult result = conn.prepareTupleQuery(query).evaluate();){
            List collect = result.stream().collect(Collectors.toList());
            Assert.assertEquals((long)4L, (long)collect.size());
        }
    }

    public void testScope4(RepositoryConnection conn) {
        this.loadData(conn);
        String query = String.join((CharSequence)"\n", "", "PREFIX foaf: <http://xmlns.com/foaf/0.1/>", "SELECT * WHERE {", "  ?person a ?type ; ", "  foaf:age ?age ;", "  foaf:knows ?person2 .", "\t{", "      ?person a ?type .", "      FILTER(?person2 NOT IN (<http://example.com/person1>)) #?person2 is not in scope, so should produce an error. ", "\t}", "  FILTER(?type IN (foaf:Person, foaf:NotPerson))", "} ");
        try (TupleQueryResult result = conn.prepareTupleQuery(query).evaluate();){
            List collect = result.stream().collect(Collectors.toList());
            Assert.assertEquals(List.of(), collect);
        }
    }

    private void loadData(RepositoryConnection conn) {
        BNode bnode1 = Values.bnode((String)"1");
        BNode bnode2 = Values.bnode((String)"2");
        BNode bnode3 = Values.bnode((String)"3");
        BNode bnode4 = Values.bnode((String)"4");
        BNode bnode5 = Values.bnode((String)"5");
        conn.add((Resource)bnode1, RDF.TYPE, (Value)FOAF.PERSON, new Resource[0]);
        conn.add((Resource)bnode2, RDF.TYPE, (Value)FOAF.PERSON, new Resource[0]);
        conn.add((Resource)bnode3, RDF.TYPE, (Value)FOAF.PERSON, new Resource[0]);
        conn.add((Resource)bnode4, RDF.TYPE, (Value)FOAF.PERSON, new Resource[0]);
        conn.add((Resource)bnode5, RDF.TYPE, (Value)FOAF.PERSON, new Resource[0]);
        conn.add((Resource)bnode1, FOAF.AGE, (Value)Values.literal((int)1), new Resource[0]);
        conn.add((Resource)bnode2, FOAF.AGE, (Value)Values.literal((int)2), new Resource[0]);
        conn.add((Resource)bnode3, FOAF.AGE, (Value)Values.literal((int)3), new Resource[0]);
        conn.add((Resource)bnode4, FOAF.AGE, (Value)Values.literal((int)4), new Resource[0]);
        conn.add((Resource)bnode5, FOAF.AGE, (Value)Values.literal((int)5), new Resource[0]);
        conn.add((Resource)bnode5, FOAF.AGE, (Value)Values.literal((int)6), new Resource[0]);
        conn.add((Resource)bnode5, FOAF.AGE, (Value)Values.literal((int)7), new Resource[0]);
        conn.add((Resource)bnode5, FOAF.AGE, (Value)Values.literal((int)8), new Resource[0]);
        conn.add((Resource)bnode5, FOAF.AGE, (Value)Values.literal((int)9), new Resource[0]);
        conn.add((Resource)bnode1, FOAF.KNOWS, (Value)bnode2, new Resource[0]);
        conn.add((Resource)bnode2, FOAF.KNOWS, (Value)bnode3, new Resource[0]);
        conn.add((Resource)bnode3, FOAF.KNOWS, (Value)bnode4, new Resource[0]);
        conn.add((Resource)bnode4, FOAF.KNOWS, (Value)bnode5, new Resource[0]);
    }

    public Stream<DynamicTest> tests() {
        return Stream.of(this.makeTest("testScope1", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testScope1)), this.makeTest("testScope1WithoutScopingIssue", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testScope1WithoutScopingIssue)), this.makeTest("testScope1WithCorrectScope", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testScope1WithCorrectScope)), this.makeTest("testScope2", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testScope2)), this.makeTest("testScope3", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testScope3)), this.makeTest("testScope3WithoutScopingIssue", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testScope3WithoutScopingIssue)), this.makeTest("testScope4", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testScope4)));
    }
}

