/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.testsuite.sparql.tests;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Statements;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.DCAT;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.QueryResults;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.testsuite.sparql.AbstractComplianceTest;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.function.ThrowingConsumer;

public class ConstructTest
extends AbstractComplianceTest {
    public ConstructTest(Supplier<Repository> repo) {
        super(repo);
    }

    private void testConstructModifiers(RepositoryConnection conn) throws Exception {
        this.loadTestData("/testdata-query/dataset-construct-modifiers.ttl", conn, new Resource[0]);
        String qry = "PREFIX foaf: <http://xmlns.com/foaf/0.1/> \nPREFIX site: <http://example.org/stats#> \nCONSTRUCT { \n  ?iri foaf:name ?name . \n  ?iri foaf:nick ?nick . \n} \nWHERE { \n  ?iri foaf:name ?name ; \n    site:hits ?hits ; \n    foaf:nick ?nick . \n} \nORDER BY desc(?hits) \nLIMIT 3";
        Statement[] correctResult = new Statement[]{Statements.statement((Resource)Values.iri((String)"urn:1"), (IRI)Values.iri((String)"http://xmlns.com/foaf/0.1/name"), (Value)Values.literal((String)"Alice"), null), Statements.statement((Resource)Values.iri((String)"urn:1"), (IRI)Values.iri((String)"http://xmlns.com/foaf/0.1/nick"), (Value)Values.literal((String)"Al"), null), Statements.statement((Resource)Values.iri((String)"urn:3"), (IRI)Values.iri((String)"http://xmlns.com/foaf/0.1/name"), (Value)Values.literal((String)"Eve"), null), Statements.statement((Resource)Values.iri((String)"urn:3"), (IRI)Values.iri((String)"http://xmlns.com/foaf/0.1/nick"), (Value)Values.literal((String)"Ev"), null), Statements.statement((Resource)Values.iri((String)"urn:2"), (IRI)Values.iri((String)"http://xmlns.com/foaf/0.1/name"), (Value)Values.literal((String)"Bob"), null), Statements.statement((Resource)Values.iri((String)"urn:2"), (IRI)Values.iri((String)"http://xmlns.com/foaf/0.1/nick"), (Value)Values.literal((String)"Bo"), null)};
        GraphQuery gq = conn.prepareGraphQuery(qry);
        try (GraphQueryResult result = gq.evaluate();){
            org.junit.jupiter.api.Assertions.assertNotNull((Object)result);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)result.hasNext());
            int resultNo = 0;
            while (result.hasNext()) {
                Statement st = (Statement)result.next();
                Assertions.assertThat((int)resultNo).isLessThan(correctResult.length);
                org.junit.jupiter.api.Assertions.assertEquals((Object)correctResult[resultNo], (Object)st);
                ++resultNo;
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)correctResult.length, (int)resultNo);
        }
    }

    private void testConstruct_CyclicPathWithJoin(RepositoryConnection conn) {
        IRI test = Values.iri((String)"urn:test");
        IRI a = Values.iri((String)"urn:a");
        IRI b = Values.iri((String)"urn:b");
        IRI c = Values.iri((String)"urn:c");
        conn.add((Resource)test, RDF.TYPE, (Value)DCAT.CATALOG, new Resource[0]);
        String query = "PREFIX dcat: <http://www.w3.org/ns/dcat#>\n\nCONSTRUCT {\n<urn:a> <urn:b> ?x .\n  ?x <urn:c> ?x .\n}\nWHERE {\n  ?x a dcat:Catalog .\n}";
        Model result = QueryResults.asModel((CloseableIteration)conn.prepareGraphQuery(query).evaluate());
        Assertions.assertThat((boolean)result.contains((Resource)a, b, (Value)test, new Resource[0])).isTrue();
        Assertions.assertThat((boolean)result.contains((Resource)test, c, (Value)test, new Resource[0])).isTrue();
    }

    private void testSES2104ConstructBGPSameURI(RepositoryConnection conn) throws RDFParseException, RepositoryException, IOException {
        String queryStr = "PREFIX : <urn:> CONSTRUCT {:x :p :x } WHERE {} ";
        conn.add((Reader)new StringReader("@prefix : <urn:> . :a :p :b . "), "", RDFFormat.TURTLE, new Resource[0]);
        IRI x = conn.getValueFactory().createIRI("urn:x");
        IRI p = conn.getValueFactory().createIRI("urn:p");
        GraphQuery query = conn.prepareGraphQuery(QueryLanguage.SPARQL, "PREFIX : <urn:> CONSTRUCT {:x :p :x } WHERE {} ");
        try (GraphQueryResult evaluate = query.evaluate();){
            Model result = QueryResults.asModel((CloseableIteration)evaluate);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)result);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)result.isEmpty());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)result.contains((Resource)x, p, (Value)x, new Resource[0]));
        }
    }

    public Stream<DynamicTest> tests() {
        return Stream.of(this.makeTest("ConstructModifiers", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testConstructModifiers)), this.makeTest("SES2104ConstructBGPSameURI", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testSES2104ConstructBGPSameURI)), this.makeTest("Construct_CyclicPathWithJoin", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testConstruct_CyclicPathWithJoin)));
    }
}

