/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.testsuite.sparql.tests;

import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.OWL;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.impl.SimpleDataset;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.testsuite.sparql.AbstractComplianceTest;
import org.eclipse.rdf4j.testsuite.sparql.vocabulary.EX;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.function.ThrowingConsumer;

public class ArbitraryLengthPathTest
extends AbstractComplianceTest {
    public ArbitraryLengthPathTest(Supplier<Repository> repo) {
        super(repo);
    }

    public Stream<DynamicTest> tests() {
        return Stream.of(this.makeTest("PropertyPathInTree", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testPropertyPathInTree)), this.makeTest("ArbitraryLengthPathWithBinding1", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testArbitraryLengthPathWithBinding1)), this.makeTest("ArbitraryLengthPathWithFilter3", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testArbitraryLengthPathWithFilter3)), this.makeTest("ArbitraryLengthPathWithFilter2", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testArbitraryLengthPathWithFilter2)), this.makeTest("ArbitraryLengthPathWithFilter1", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testArbitraryLengthPathWithFilter1)), this.makeTest("ArbitraryLengthPathWithBinding8", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testArbitraryLengthPathWithBinding8)), this.makeTest("ArbitraryLengthPathWithBinding2", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testArbitraryLengthPathWithBinding2)), this.makeTest("ArbitraryLengthPathWithBinding3", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testArbitraryLengthPathWithBinding3)), this.makeTest("ArbitraryLengthPathWithBinding4", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testArbitraryLengthPathWithBinding4)), this.makeTest("ArbitraryLengthPathWithBinding5", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testArbitraryLengthPathWithBinding5)), this.makeTest("ArbitraryLengthPathWithBinding6", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testArbitraryLengthPathWithBinding6)), this.makeTest("ArbitraryLengthPathWithBinding7", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testArbitraryLengthPathWithBinding7)));
    }

    private void testArbitraryLengthPathWithBinding1(RepositoryConnection conn) throws Exception {
        this.loadTestData("/testdata-query/alp-testdata.ttl", conn, new Resource[0]);
        String query = this.getNamespaceDeclarations() + "SELECT ?parent ?child WHERE { ?child a owl:Class . ?child rdfs:subClassOf+ ?parent . }";
        TupleQuery tq = conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assertions.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                ++count;
                BindingSet bs = (BindingSet)result.next();
                Assertions.assertTrue((boolean)bs.hasBinding("child"));
                Assertions.assertTrue((boolean)bs.hasBinding("parent"));
            }
            Assertions.assertEquals((int)7, (int)count);
            tq.setBinding("parent", (Value)OWL.THING);
            try (TupleQueryResult result2 = tq.evaluate();){
                Assertions.assertNotNull((Object)result2);
                count = 0;
                while (result2.hasNext()) {
                    ++count;
                    BindingSet bs = (BindingSet)result2.next();
                    Assertions.assertTrue((boolean)bs.hasBinding("child"));
                    Assertions.assertTrue((boolean)bs.hasBinding("parent"));
                }
                Assertions.assertEquals((int)4, (int)count);
            }
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    private void testArbitraryLengthPathWithBinding2(RepositoryConnection conn) throws Exception {
        this.loadTestData("/testdata-query/alp-testdata.ttl", conn, new Resource[0]);
        String query = this.getNamespaceDeclarations() + "SELECT ?parent ?child WHERE { ?child rdfs:subClassOf+ ?parent . }";
        TupleQuery tq = conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assertions.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                ++count;
                BindingSet bs = (BindingSet)result.next();
                Assertions.assertTrue((boolean)bs.hasBinding("child"));
                Assertions.assertTrue((boolean)bs.hasBinding("parent"));
            }
            Assertions.assertEquals((int)7, (int)count);
            tq.setBinding("parent", (Value)OWL.THING);
            try (TupleQueryResult result2 = tq.evaluate();){
                Assertions.assertNotNull((Object)result2);
                count = 0;
                while (result2.hasNext()) {
                    ++count;
                    BindingSet bs = (BindingSet)result2.next();
                    Assertions.assertTrue((boolean)bs.hasBinding("child"));
                    Assertions.assertTrue((boolean)bs.hasBinding("parent"));
                }
                Assertions.assertEquals((int)4, (int)count);
            }
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    private void testArbitraryLengthPathWithBinding3(RepositoryConnection conn) throws Exception {
        this.loadTestData("/testdata-query/alp-testdata.ttl", conn, new Resource[0]);
        String query = this.getNamespaceDeclarations() + "SELECT ?parent ?child WHERE { ?child rdfs:subClassOf+ ?parent . }";
        TupleQuery tq = conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assertions.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                ++count;
                BindingSet bs = (BindingSet)result.next();
                Assertions.assertTrue((boolean)bs.hasBinding("child"));
                Assertions.assertTrue((boolean)bs.hasBinding("parent"));
            }
            Assertions.assertEquals((int)7, (int)count);
            tq.setBinding("child", (Value)EX.C);
            try (TupleQueryResult result2 = tq.evaluate();){
                Assertions.assertNotNull((Object)result2);
                count = 0;
                while (result2.hasNext()) {
                    ++count;
                    BindingSet bs = (BindingSet)result2.next();
                    Assertions.assertTrue((boolean)bs.hasBinding("child"));
                    Assertions.assertTrue((boolean)bs.hasBinding("parent"));
                }
                Assertions.assertEquals((int)2, (int)count);
            }
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    private void testArbitraryLengthPathWithBinding4(RepositoryConnection conn) throws Exception {
        this.loadTestData("/testdata-query/alp-testdata.ttl", conn, new Resource[]{EX.ALICE});
        String query = this.getNamespaceDeclarations() + "SELECT ?parent ?child WHERE { ?child rdfs:subClassOf+ ?parent . }";
        TupleQuery tq = conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assertions.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                ++count;
                BindingSet bs = (BindingSet)result.next();
                Assertions.assertTrue((boolean)bs.hasBinding("child"));
                Assertions.assertTrue((boolean)bs.hasBinding("parent"));
            }
            Assertions.assertEquals((int)7, (int)count);
            tq.setBinding("child", (Value)EX.C);
            try (TupleQueryResult result2 = tq.evaluate();){
                Assertions.assertNotNull((Object)result2);
                count = 0;
                while (result2.hasNext()) {
                    ++count;
                    BindingSet bs = (BindingSet)result2.next();
                    Assertions.assertTrue((boolean)bs.hasBinding("child"));
                    Assertions.assertTrue((boolean)bs.hasBinding("parent"));
                }
                Assertions.assertEquals((int)2, (int)count);
            }
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    private void testArbitraryLengthPathWithBinding5(RepositoryConnection conn) throws Exception {
        this.loadTestData("/testdata-query/alp-testdata.ttl", conn, new Resource[]{EX.ALICE, EX.BOB});
        String query = this.getNamespaceDeclarations() + "SELECT ?parent ?child WHERE { ?child rdfs:subClassOf+ ?parent . }";
        TupleQuery tq = conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assertions.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                ++count;
                BindingSet bs = (BindingSet)result.next();
                Assertions.assertTrue((boolean)bs.hasBinding("child"));
                Assertions.assertTrue((boolean)bs.hasBinding("parent"));
            }
            Assertions.assertEquals((int)7, (int)count);
            tq.setBinding("child", (Value)EX.C);
            try (TupleQueryResult result2 = tq.evaluate();){
                Assertions.assertNotNull((Object)result2);
                count = 0;
                while (result2.hasNext()) {
                    ++count;
                    BindingSet bs = (BindingSet)result2.next();
                    Assertions.assertTrue((boolean)bs.hasBinding("child"));
                    Assertions.assertTrue((boolean)bs.hasBinding("parent"));
                }
                Assertions.assertEquals((int)2, (int)count);
            }
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    private void testArbitraryLengthPathWithBinding6(RepositoryConnection conn) throws Exception {
        this.loadTestData("/testdata-query/alp-testdata.ttl", conn, new Resource[]{EX.ALICE, EX.BOB, EX.MARY});
        String query = this.getNamespaceDeclarations() + "SELECT ?parent ?child WHERE { ?child rdfs:subClassOf+ ?parent . }";
        TupleQuery tq = conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assertions.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                ++count;
                BindingSet bs = (BindingSet)result.next();
                Assertions.assertTrue((boolean)bs.hasBinding("child"));
                Assertions.assertTrue((boolean)bs.hasBinding("parent"));
            }
            Assertions.assertEquals((int)7, (int)count);
            tq.setBinding("child", (Value)EX.C);
            try (TupleQueryResult result2 = tq.evaluate();){
                Assertions.assertNotNull((Object)result2);
                count = 0;
                while (result2.hasNext()) {
                    ++count;
                    BindingSet bs = (BindingSet)result2.next();
                    Assertions.assertTrue((boolean)bs.hasBinding("child"));
                    Assertions.assertTrue((boolean)bs.hasBinding("parent"));
                }
                Assertions.assertEquals((int)2, (int)count);
            }
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    private void testArbitraryLengthPathWithBinding7(RepositoryConnection conn) throws Exception {
        this.loadTestData("/testdata-query/alp-testdata.ttl", conn, new Resource[]{EX.ALICE, EX.BOB, EX.MARY});
        String query = this.getNamespaceDeclarations() + "SELECT ?parent ?child WHERE { ?child rdfs:subClassOf+ ?parent . }";
        TupleQuery tq = conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        SimpleDataset dt = new SimpleDataset();
        dt.addDefaultGraph(EX.ALICE);
        tq.setDataset((Dataset)dt);
        try (TupleQueryResult result = tq.evaluate();){
            Assertions.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                ++count;
                BindingSet bs = (BindingSet)result.next();
                Assertions.assertTrue((boolean)bs.hasBinding("child"));
                Assertions.assertTrue((boolean)bs.hasBinding("parent"));
            }
            Assertions.assertEquals((int)7, (int)count);
            tq.setBinding("child", (Value)EX.C);
            try (TupleQueryResult result2 = tq.evaluate();){
                Assertions.assertNotNull((Object)result2);
                count = 0;
                while (result2.hasNext()) {
                    ++count;
                    BindingSet bs = (BindingSet)result2.next();
                    Assertions.assertTrue((boolean)bs.hasBinding("child"));
                    Assertions.assertTrue((boolean)bs.hasBinding("parent"));
                }
                Assertions.assertEquals((int)2, (int)count);
            }
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    private void testArbitraryLengthPathWithBinding8(RepositoryConnection conn) throws Exception {
        this.loadTestData("/testdata-query/alp-testdata.ttl", conn, new Resource[]{EX.ALICE, EX.BOB, EX.MARY});
        String query = this.getNamespaceDeclarations() + "SELECT ?parent ?child WHERE { ?child rdfs:subClassOf+ ?parent . }";
        TupleQuery tq = conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        SimpleDataset dt = new SimpleDataset();
        dt.addDefaultGraph(EX.ALICE);
        dt.addDefaultGraph(EX.BOB);
        tq.setDataset((Dataset)dt);
        try (TupleQueryResult result = tq.evaluate();){
            Assertions.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                ++count;
                BindingSet bs = (BindingSet)result.next();
                Assertions.assertTrue((boolean)bs.hasBinding("child"));
                Assertions.assertTrue((boolean)bs.hasBinding("parent"));
            }
            Assertions.assertEquals((int)7, (int)count);
            tq.setBinding("child", (Value)EX.C);
            try (TupleQueryResult result2 = tq.evaluate();){
                Assertions.assertNotNull((Object)result2);
                count = 0;
                while (result2.hasNext()) {
                    ++count;
                    BindingSet bs = (BindingSet)result2.next();
                    Assertions.assertTrue((boolean)bs.hasBinding("child"));
                    Assertions.assertTrue((boolean)bs.hasBinding("parent"));
                }
                Assertions.assertEquals((int)2, (int)count);
            }
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    private void testArbitraryLengthPathWithFilter1(RepositoryConnection conn) throws Exception {
        this.loadTestData("/testdata-query/alp-testdata.ttl", conn, new Resource[0]);
        String query = this.getNamespaceDeclarations() + "SELECT ?parent ?child WHERE { ?child a owl:Class . ?child rdfs:subClassOf+ ?parent . FILTER (?parent = owl:Thing) }";
        TupleQuery tq = conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assertions.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                ++count;
                BindingSet bs = (BindingSet)result.next();
                Assertions.assertTrue((boolean)bs.hasBinding("child"));
                Assertions.assertTrue((boolean)bs.hasBinding("parent"));
            }
            Assertions.assertEquals((int)4, (int)count);
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    private void testArbitraryLengthPathWithFilter2(RepositoryConnection conn) throws Exception {
        this.loadTestData("/testdata-query/alp-testdata.ttl", conn, new Resource[0]);
        String query = this.getNamespaceDeclarations() + "SELECT ?parent ?child WHERE { ?child rdfs:subClassOf+ ?parent . FILTER (?parent = owl:Thing) }";
        TupleQuery tq = conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assertions.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                ++count;
                BindingSet bs = (BindingSet)result.next();
                Assertions.assertTrue((boolean)bs.hasBinding("child"));
                Assertions.assertTrue((boolean)bs.hasBinding("parent"));
            }
            Assertions.assertEquals((int)4, (int)count);
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    private void testArbitraryLengthPathWithFilter3(RepositoryConnection conn) throws Exception {
        this.loadTestData("/testdata-query/alp-testdata.ttl", conn, new Resource[0]);
        String query = this.getNamespaceDeclarations() + "SELECT ?parent ?child WHERE { ?child rdfs:subClassOf+ ?parent . FILTER (?child = <http://example.org/C>) }";
        TupleQuery tq = conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assertions.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                ++count;
                BindingSet bs = (BindingSet)result.next();
                Assertions.assertTrue((boolean)bs.hasBinding("child"));
                Assertions.assertTrue((boolean)bs.hasBinding("parent"));
            }
            Assertions.assertEquals((int)2, (int)count);
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    private void testPropertyPathInTree(RepositoryConnection conn) throws Exception {
        this.loadTestData("/testdata-query/dataset-query.trig", conn, new Resource[0]);
        String query = this.getNamespaceDeclarations() + " SELECT ?node ?name  FROM ex:tree-graph  WHERE { ?node ex:hasParent+ ex:b . ?node ex:name ?name . }";
        TupleQuery tq = conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assertions.assertNotNull((Object)result);
            while (result.hasNext()) {
                BindingSet bs = (BindingSet)result.next();
                Assertions.assertNotNull((Object)bs);
            }
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }
}

