/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.testsuite.query.parser.sparql.manifest;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.rdf4j.common.io.IOUtil;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.algebra.DeleteData;
import org.eclipse.rdf4j.query.algebra.InsertData;
import org.eclipse.rdf4j.query.algebra.UpdateExpr;
import org.eclipse.rdf4j.query.parser.ParsedOperation;
import org.eclipse.rdf4j.query.parser.ParsedUpdate;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.repository.sail.helpers.SailUpdateExecutor;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.eclipse.rdf4j.testsuite.query.parser.sparql.manifest.SPARQLComplianceTest;
import org.junit.Assert;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.TestFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SPARQLSyntaxComplianceTest
extends SPARQLComplianceTest {
    private static final Logger logger = LoggerFactory.getLogger(SPARQLSyntaxComplianceTest.class);
    private static final List<String> excludedSubdirs = List.of();

    @TestFactory
    public Collection<DynamicTest> getTestData() {
        ArrayList<DynamicTest> tests = new ArrayList<DynamicTest>();
        ArrayDeque<String> manifests = new ArrayDeque<String>();
        manifests.add(SPARQLSyntaxComplianceTest.class.getClassLoader().getResource("testcases-sparql-1.1-w3c/manifest-all.ttl").toExternalForm());
        while (!manifests.isEmpty()) {
            String pop = (String)manifests.pop();
            SPARQLSyntaxManifest manifest = new SPARQLSyntaxManifest(pop);
            tests.addAll(manifest.tests);
            manifests.addAll(manifest.subManifests);
        }
        return tests;
    }

    protected abstract ParsedOperation parseOperation(String var1, String var2) throws MalformedQueryException;

    class SPARQLSyntaxManifest {
        List<DynamicTest> tests = new ArrayList<DynamicTest>();
        List<String> subManifests = new ArrayList<String>();

        public SPARQLSyntaxManifest(String filename) {
            SailRepositoryConnection connection;
            SailRepository sailRepository = new SailRepository((Sail)new MemoryStore());
            try {
                connection = sailRepository.getConnection();
                try {
                    connection.add(new URL(filename), filename, RDFFormat.TURTLE, new Resource[0]);
                }
                finally {
                    if (connection != null) {
                        connection.close();
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            connection = sailRepository.getConnection();
            try {
                String manifestQuery = " PREFIX qt: <http://www.w3.org/2001/sw/DataAccess/tests/test-query#> PREFIX mf: <http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#> SELECT DISTINCT ?manifestFile WHERE { [] mf:include [ rdf:rest*/rdf:first ?manifestFile ] . }   ";
                try (TupleQueryResult manifestResults = connection.prepareTupleQuery(QueryLanguage.SPARQL, manifestQuery, filename).evaluate();){
                    for (BindingSet bindingSet : manifestResults) {
                        String subManifestFile = bindingSet.getValue("manifestFile").stringValue();
                        if (!SPARQLComplianceTest.includeSubManifest(subManifestFile, excludedSubdirs)) continue;
                        this.subManifests.add(subManifestFile);
                    }
                }
                StringBuilder query = new StringBuilder(512);
                query.append("PREFIX mf: <http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#> ");
                query.append("PREFIX qt: <http://www.w3.org/2001/sw/DataAccess/tests/test-query#> ");
                query.append("PREFIX dawgt: <http://www.w3.org/2001/sw/DataAccess/tests/test-dawg#> ");
                query.append("SELECT ?TestURI ?Name ?Action ?Type ");
                query.append("WHERE { [] rdf:first ?TestURI. ");
                query.append("        ?TestURI a ?Type ; ");
                query.append("                 mf:name ?Name ;");
                query.append("                 mf:action ?Action ;");
                query.append("                 dawgt:approval dawgt:Approved . ");
                query.append("        FILTER(?Type IN (mf:PositiveSyntaxTest, mf:NegativeSyntaxTest, mf:PositiveSyntaxTest11, mf:NegativeSyntaxTest11, mf:PositiveUpdateSyntaxTest11, mf:NegativeUpdateSyntaxTest11)) ");
                query.append(" } ");
                try (TupleQueryResult result = connection.prepareTupleQuery(query.toString()).evaluate();){
                    for (BindingSet bs : result) {
                        String testName = bs.getValue("Name").stringValue();
                        String displayName = filename.substring(filename.lastIndexOf("testcases-sparql-1.1-w3c/") + "testcases-sparql-1.1-w3c/".length(), filename.lastIndexOf("/")) + ": " + testName;
                        IRI testURI = (IRI)bs.getValue("TestURI");
                        Value action = bs.getValue("Action");
                        String type = bs.getValue("Type").toString();
                        boolean positiveTest = type.equals("http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#PositiveSyntaxTest11") || type.equals("http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#PositiveUpdateSyntaxTest11");
                        DynamicSPARQLSyntaxComplianceTest ds11ut = new DynamicSPARQLSyntaxComplianceTest(displayName, testURI.stringValue(), testName, action.stringValue(), positiveTest);
                        if (SPARQLSyntaxComplianceTest.this.shouldIgnoredTest(testName)) continue;
                        this.tests.add(DynamicTest.dynamicTest((String)displayName, ds11ut::test));
                    }
                }
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
    }

    public class DynamicSPARQLSyntaxComplianceTest
    extends SPARQLComplianceTest.DynamicSparqlComplianceTest {
        private final String queryFileURL;
        private final boolean positiveTest;

        public DynamicSPARQLSyntaxComplianceTest(String displayName, String testURI, String name, String queryFileURL, boolean positiveTest) {
            super(displayName, testURI, name);
            this.queryFileURL = queryFileURL;
            this.positiveTest = positiveTest;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void runTest() throws Exception {
            block12: {
                InputStream stream = new URL(this.queryFileURL).openStream();
                String query = IOUtil.readString((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8));
                stream.close();
                try {
                    ParsedOperation operation = SPARQLSyntaxComplianceTest.this.parseOperation(query, this.queryFileURL);
                    Assertions.assertThatNoException().isThrownBy(() -> {
                        int hashCode = operation.hashCode();
                        if (hashCode == System.identityHashCode(operation)) {
                            throw new UnsupportedOperationException("hashCode() result is the same as  the identityHashCode in " + operation.getClass().getName());
                        }
                    });
                    if (!this.positiveTest) {
                        boolean dataBlockUpdate = false;
                        if (operation instanceof ParsedUpdate) {
                            for (UpdateExpr updateExpr : ((ParsedUpdate)operation).getUpdateExprs()) {
                                if (!(updateExpr instanceof InsertData) && !(updateExpr instanceof DeleteData)) continue;
                                dataBlockUpdate = true;
                                MemoryStore store = new MemoryStore();
                                store.init();
                                try (NotifyingSailConnection conn = store.getConnection();){
                                    conn.begin();
                                    SailUpdateExecutor exec = new SailUpdateExecutor((SailConnection)conn, store.getValueFactory(), null);
                                    exec.executeUpdate(updateExpr, null, null, true, -1);
                                    conn.rollback();
                                    Assert.fail((String)"Negative test case should have failed to parse");
                                }
                            }
                        }
                        if (!dataBlockUpdate) {
                            Assert.fail((String)"Negative test case should have failed to parse");
                        }
                    }
                }
                catch (MalformedQueryException e) {
                    if (!this.positiveTest) break block12;
                    e.printStackTrace();
                    Assert.fail((String)("Positive test case failed: " + e.getMessage()));
                }
            }
        }

        @Override
        protected Repository getDataRepository() {
            return null;
        }

        @Override
        public void tearDown() throws Exception {
        }

        @Override
        public void setUp() throws Exception {
        }
    }
}

