/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.testsuite.sparql.tests;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.QueryResult;
import org.eclipse.rdf4j.query.QueryResults;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.testsuite.sparql.AbstractComplianceTest;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.function.ThrowingConsumer;

public class OptionalTest
extends AbstractComplianceTest {
    public OptionalTest(Supplier<Repository> repo) {
        super(repo);
    }

    private void testSES1898LeftJoinSemantics1(RepositoryConnection conn) throws Exception {
        this.loadTestData("/testdata-query/dataset-ses1898.trig", conn, new Resource[0]);
        String query = "  PREFIX : <http://example.org/>   SELECT * WHERE {     ?s :p1 ?v1 .     OPTIONAL {?s :p2 ?v2 } .     ?s :p3 ?v2 .   } ";
        TupleQuery tq = conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (Stream result = tq.evaluate().stream();){
            long count = result.count();
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)count);
        }
    }

    private void testSES1121VarNamesInOptionals(RepositoryConnection conn) throws Exception {
        this.loadTestData("/testdata-query/dataset-ses1121.trig", conn, new Resource[0]);
        String query1 = this.getNamespaceDeclarations() + " SELECT DISTINCT *\n WHERE { GRAPH ?g { \n          OPTIONAL { ?var35 ex:p ?b . } \n           OPTIONAL { ?b ex:q ?c . } \n        } \n } \n";
        String query2 = this.getNamespaceDeclarations() + " SELECT DISTINCT *\n WHERE { GRAPH ?g { \n          OPTIONAL { ?var35 ex:p ?b . } \n           OPTIONAL { ?b ex:q ?var2 . } \n        } \n } \n";
        TupleQuery tq1 = conn.prepareTupleQuery(QueryLanguage.SPARQL, query1);
        TupleQuery tq2 = conn.prepareTupleQuery(QueryLanguage.SPARQL, query2);
        try (TupleQueryResult result1 = tq1.evaluate();
             TupleQueryResult result2 = tq2.evaluate();){
            org.junit.jupiter.api.Assertions.assertNotNull((Object)result1);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)result2);
            List qr1 = QueryResults.asList((QueryResult)result1);
            List qr2 = QueryResults.asList((QueryResult)result2);
            org.junit.jupiter.api.Assertions.assertEquals((int)qr1.size(), (int)qr2.size());
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            org.junit.jupiter.api.Assertions.fail((String)e.getMessage());
        }
    }

    private void testSameTermRepeatInOptional(RepositoryConnection conn) throws Exception {
        this.loadTestData("/testdata-query/dataset-query.trig", conn, new Resource[0]);
        String query = this.getNamespaceDeclarations() + " SELECT ?l ?opt1 ?opt2  FROM ex:optional-sameterm-graph  WHERE {           ?s ex:p ex:A ;           {               {                  ?s ?p ?l .                 FILTER(?p = rdfs:label)               }               OPTIONAL {                  ?s ?p ?opt1 .                  FILTER (?p = ex:prop1)               }               OPTIONAL {                  ?s ?p ?opt2 .                  FILTER (?p = ex:prop2)               }           } } ";
        TupleQuery tq = conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            org.junit.jupiter.api.Assertions.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                BindingSet bs = (BindingSet)result.next();
                ++count;
                org.junit.jupiter.api.Assertions.assertNotNull((Object)bs);
                Value l = bs.getValue("l");
                org.junit.jupiter.api.Assertions.assertTrue((boolean)(l instanceof Literal));
                org.junit.jupiter.api.Assertions.assertEquals((Object)"label", (Object)((Literal)l).getLabel());
                Value opt1 = bs.getValue("opt1");
                org.junit.jupiter.api.Assertions.assertNull((Object)opt1);
                Value opt2 = bs.getValue("opt2");
                org.junit.jupiter.api.Assertions.assertNull((Object)opt2);
            }
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)count);
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            org.junit.jupiter.api.Assertions.fail((String)e.getMessage());
        }
    }

    private void testValuesAfterOptional(RepositoryConnection conn) throws Exception {
        String data = "@prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> . \n@prefix :     <urn:ex:> . \n:r1 a rdfs:Resource . \n:r2 a rdfs:Resource ; rdfs:label \"a label\" . \n";
        String query = "prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> \nprefix :     <urn:ex:> \n\nselect ?resource ?label where { \n  ?resource a rdfs:Resource . \n  optional { ?resource rdfs:label ?label } \n  values ?label { undef } \n}";
        conn.add((Reader)new StringReader(data), RDFFormat.TURTLE, new Resource[0]);
        List result = QueryResults.asList((QueryResult)conn.prepareTupleQuery(query).evaluate());
        Assertions.assertThat((List)result).hasSize(2);
    }

    public Stream<DynamicTest> tests() {
        return Stream.of(this.makeTest("SameTermRepeatInOptional", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testSameTermRepeatInOptional)), this.makeTest("ValuesAfterOptional", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testValuesAfterOptional)), this.makeTest("SES1121VarNamesInOptionals", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testSES1121VarNamesInOptionals)), this.makeTest("SES1898LeftJoinSemantics1", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testSES1898LeftJoinSemantics1)));
    }
}

