/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.testsuite.sparql.tests;

import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.testsuite.sparql.AbstractComplianceTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.function.ThrowingConsumer;

public class BuiltinFunctionTest
extends AbstractComplianceTest {
    public BuiltinFunctionTest(Supplier<Repository> repo) {
        super(repo);
    }

    private void testSeconds(RepositoryConnection conn) {
        String qry = "PREFIX xsd: <http://www.w3.org/2001/XMLSchema#> SELECT (SECONDS(\"2011-01-10T14:45:13\"^^xsd:dateTime) AS ?sec) { }";
        try (TupleQueryResult result = conn.prepareTupleQuery(QueryLanguage.SPARQL, qry).evaluate();){
            Assertions.assertNotNull((Object)result);
            Assertions.assertTrue((boolean)result.hasNext());
            Assertions.assertEquals((Object)"13", (Object)((BindingSet)result.next()).getValue("sec").stringValue());
            Assertions.assertFalse((boolean)result.hasNext());
        }
    }

    private void testSecondsMilliseconds(RepositoryConnection conn) {
        String qry = "PREFIX xsd: <http://www.w3.org/2001/XMLSchema#> SELECT (SECONDS(\"2011-01-10T14:45:13.815-05:00\"^^xsd:dateTime) AS ?sec) { }";
        try (TupleQueryResult result = conn.prepareTupleQuery(QueryLanguage.SPARQL, qry).evaluate();){
            Assertions.assertNotNull((Object)result);
            Assertions.assertTrue((boolean)result.hasNext());
            Assertions.assertEquals((Object)"13.815", (Object)((BindingSet)result.next()).getValue("sec").stringValue());
            Assertions.assertFalse((boolean)result.hasNext());
        }
    }

    private void testSES1991NOWEvaluation(RepositoryConnection conn) throws Exception {
        this.loadTestData("/testdata-query/defaultgraph.ttl", conn, new Resource[0]);
        String query = "SELECT ?d WHERE {?s ?p ?o . BIND(NOW() as ?d) } LIMIT 2";
        TupleQuery tq = conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assertions.assertNotNull((Object)result);
            Assertions.assertTrue((boolean)result.hasNext());
            Literal d1 = (Literal)((BindingSet)result.next()).getValue("d");
            Assertions.assertTrue((boolean)result.hasNext());
            Literal d2 = (Literal)((BindingSet)result.next()).getValue("d");
            Assertions.assertFalse((boolean)result.hasNext());
            Assertions.assertNotNull((Object)d1);
            Assertions.assertEquals((Object)d1, (Object)d2);
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    private void testSES869ValueOfNow(RepositoryConnection conn) {
        TupleQuery tq = conn.prepareTupleQuery(QueryLanguage.SPARQL, "SELECT ?p ( NOW() as ?n ) { BIND (NOW() as ?p ) }");
        try (TupleQueryResult result = tq.evaluate();){
            Assertions.assertNotNull((Object)result);
            Assertions.assertTrue((boolean)result.hasNext());
            BindingSet bs = (BindingSet)result.next();
            Value p = bs.getValue("p");
            Value n = bs.getValue("n");
            Assertions.assertNotNull((Object)p);
            Assertions.assertNotNull((Object)n);
            Assertions.assertEquals((Object)p, (Object)n);
            Assertions.assertTrue((p == n ? 1 : 0) != 0);
        }
    }

    private void testSES1991UUIDEvaluation(RepositoryConnection conn) throws Exception {
        this.loadTestData("/testdata-query/defaultgraph.ttl", conn, new Resource[0]);
        String query = "SELECT ?uid WHERE {?s ?p ?o . BIND(UUID() as ?uid) } LIMIT 2";
        TupleQuery tq = conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assertions.assertNotNull((Object)result);
            IRI uuid1 = (IRI)((BindingSet)result.next()).getValue("uid");
            IRI uuid2 = (IRI)((BindingSet)result.next()).getValue("uid");
            Assertions.assertNotNull((Object)uuid1);
            Assertions.assertNotNull((Object)uuid2);
            Assertions.assertNotEquals((Object)uuid1, (Object)uuid2);
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    private void testSES1991STRUUIDEvaluation(RepositoryConnection conn) throws Exception {
        this.loadTestData("/testdata-query/defaultgraph.ttl", conn, new Resource[0]);
        String query = "SELECT ?uid WHERE {?s ?p ?o . BIND(STRUUID() as ?uid) } LIMIT 2";
        TupleQuery tq = conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assertions.assertNotNull((Object)result);
            Literal uid1 = (Literal)((BindingSet)result.next()).getValue("uid");
            Literal uid2 = (Literal)((BindingSet)result.next()).getValue("uid");
            Assertions.assertNotNull((Object)uid1);
            Assertions.assertNotEquals((Object)uid1, (Object)uid2);
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    private void testSES1991RANDEvaluation(RepositoryConnection conn) throws Exception {
        this.loadTestData("/testdata-query/defaultgraph.ttl", conn, new Resource[0]);
        String query = "SELECT ?r WHERE {?s ?p ?o . BIND(RAND() as ?r) } LIMIT 3";
        TupleQuery tq = conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assertions.assertNotNull((Object)result);
            Literal r1 = (Literal)((BindingSet)result.next()).getValue("r");
            Literal r2 = (Literal)((BindingSet)result.next()).getValue("r");
            Literal r3 = (Literal)((BindingSet)result.next()).getValue("r");
            Assertions.assertNotNull((Object)r1);
            Assertions.assertFalse((r1.equals((Object)r2) && r1.equals((Object)r3) ? 1 : 0) != 0);
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    private void testSES2121URIFunction(RepositoryConnection conn) {
        IRI uri;
        BindingSet bs;
        String query = "SELECT (URI(\"foo bar\") as ?uri) WHERE {}";
        TupleQuery tq = conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assertions.assertNotNull((Object)result);
            Assertions.assertTrue((boolean)result.hasNext());
            bs = (BindingSet)result.next();
            uri = (IRI)bs.getValue("uri");
            Assertions.assertNull((Object)uri, (String)"uri result for invalid URI should be unbound");
        }
        query = "BASE <http://example.org/> SELECT (URI(\"foo bar\") as ?uri) WHERE {}";
        tq = conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        result = tq.evaluate();
        try {
            Assertions.assertNotNull((Object)result);
            Assertions.assertTrue((boolean)result.hasNext());
            bs = (BindingSet)result.next();
            uri = (IRI)bs.getValue("uri");
            Assertions.assertNotNull((Object)uri, (String)"uri result for valid URI reference should be bound");
        }
        finally {
            if (result != null) {
                result.close();
            }
        }
    }

    private void test27NormalizeIRIFunction(RepositoryConnection conn) {
        String query = "SELECT (IRI(\"../bar\") as ?Iri) WHERE {}";
        TupleQuery tq = conn.prepareTupleQuery(QueryLanguage.SPARQL, query, "http://example.com/foo/");
        try (TupleQueryResult result = tq.evaluate();){
            Assertions.assertNotNull((Object)result);
            Assertions.assertTrue((boolean)result.hasNext());
            BindingSet bs = (BindingSet)result.next();
            IRI actual = (IRI)bs.getValue("Iri");
            IRI expected = Values.iri((String)"http://example.com/bar");
            Assertions.assertEquals((Object)expected, (Object)actual, (String)"IRI result for relative IRI should be normalized");
        }
    }

    private void testSES2052If1(RepositoryConnection conn) throws Exception {
        this.loadTestData("/testdata-query/dataset-query.trig", conn, new Resource[0]);
        String query = "SELECT ?p \nWHERE { \n         ?s ?p ?o . \n        FILTER(IF(BOUND(?p), ?p = <http://www.w3.org/1999/02/22-rdf-syntax-ns#type>, false)) \n}";
        TupleQuery tq = conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assertions.assertNotNull((Object)result);
            while (result.hasNext()) {
                BindingSet bs = (BindingSet)result.next();
                IRI p = (IRI)bs.getValue("p");
                Assertions.assertNotNull((Object)p);
                Assertions.assertEquals((Object)RDF.TYPE, (Object)p);
            }
        }
    }

    private void testSES2052If2(RepositoryConnection conn) throws Exception {
        this.loadTestData("/testdata-query/dataset-query.trig", conn, new Resource[0]);
        String query = "SELECT ?p \nWHERE { \n         ?s ?p ?o . \n        FILTER(IF(!BOUND(?p), false , ?p = <http://www.w3.org/1999/02/22-rdf-syntax-ns#type>)) \n}";
        TupleQuery tq = conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assertions.assertNotNull((Object)result);
            while (result.hasNext()) {
                BindingSet bs = (BindingSet)result.next();
                IRI p = (IRI)bs.getValue("p");
                Assertions.assertNotNull((Object)p);
                Assertions.assertEquals((Object)RDF.TYPE, (Object)p);
            }
        }
    }

    private void testRegexCaseNonAscii(RepositoryConnection conn) {
        String query = "ask {filter (regex(\"\u0412\u0430\u043b\u043e\u0432\u043e\u0439\", \"\u0432\u0430\u043b\u043e\u0432\u043e\u0439\", \"i\")) }";
        Assertions.assertTrue((boolean)conn.prepareBooleanQuery(query).evaluate(), (String)"case-insensitive match on Cyrillic should succeed");
        query = "ask {filter (regex(\"\u0412\u0430\u043b\u043e\u0432\u043e\u0439\", \"\u0432\u0430\u043b\u043e\u0432\u043e\u0439\")) }";
        Assertions.assertFalse((boolean)conn.prepareBooleanQuery(query).evaluate(), (String)"case-sensitive match on Cyrillic should fail");
    }

    private void testFilterRegexBoolean(RepositoryConnection conn) throws Exception {
        this.loadTestData("/testdata-query/dataset-query.trig", conn, new Resource[0]);
        String query = this.getNamespaceDeclarations() + " SELECT * WHERE {        ?x foaf:name ?name ;           foaf:mbox ?mbox .        FILTER(EXISTS {             FILTER(REGEX(?name, \"Bo\") && REGEX(?mbox, \"bob\"))             } ) } ";
        TupleQuery tq = conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (Stream result = tq.evaluate().stream();){
            long count = result.count();
            Assertions.assertEquals((long)1L, (long)count);
        }
    }

    private void testDateCastFunction_date(RepositoryConnection conn) {
        String qry = "PREFIX xsd: <http://www.w3.org/2001/XMLSchema#> SELECT (xsd:date(\"2022-09-09\") AS ?date) { }";
        try (TupleQueryResult result = conn.prepareTupleQuery(QueryLanguage.SPARQL, qry).evaluate();){
            Assertions.assertNotNull((Object)result);
            Assertions.assertTrue((boolean)result.hasNext());
            Assertions.assertEquals((Object)"2022-09-09", (Object)((BindingSet)result.next()).getValue("date").stringValue());
            Assertions.assertFalse((boolean)result.hasNext());
        }
    }

    private void testDateCastFunction_date_withTimeZone_utc(RepositoryConnection conn) {
        String qry = "PREFIX xsd: <http://www.w3.org/2001/XMLSchema#> SELECT (xsd:date(\"2022-09-09Z\") AS ?date) { }";
        try (TupleQueryResult result = conn.prepareTupleQuery(QueryLanguage.SPARQL, qry).evaluate();){
            Assertions.assertNotNull((Object)result);
            Assertions.assertTrue((boolean)result.hasNext());
            Assertions.assertEquals((Object)"2022-09-09Z", (Object)((BindingSet)result.next()).getValue("date").stringValue());
            Assertions.assertFalse((boolean)result.hasNext());
        }
    }

    private void testDateCastFunction_dateTime_withTimeZone_offset(RepositoryConnection conn) {
        String qry = "PREFIX xsd: <http://www.w3.org/2001/XMLSchema#> SELECT (xsd:date(\"2022-09-09T14:45:13+03:00\") AS ?date) { }";
        try (TupleQueryResult result = conn.prepareTupleQuery(QueryLanguage.SPARQL, qry).evaluate();){
            Assertions.assertNotNull((Object)result);
            Assertions.assertTrue((boolean)result.hasNext());
            Assertions.assertEquals((Object)"2022-09-09+03:00", (Object)((BindingSet)result.next()).getValue("date").stringValue());
            Assertions.assertFalse((boolean)result.hasNext());
        }
    }

    private void testDateCastFunction_invalidInput(RepositoryConnection conn) {
        String qry = "PREFIX xsd: <http://www.w3.org/2001/XMLSchema#> SELECT (xsd:date(\"2022-09-xx\") AS ?date) { }";
        try (TupleQueryResult result = conn.prepareTupleQuery(QueryLanguage.SPARQL, qry).evaluate();){
            Assertions.assertNotNull((Object)result);
            Assertions.assertTrue((boolean)result.hasNext());
            Assertions.assertFalse((boolean)((BindingSet)result.next()).hasBinding("date"), (String)"There should be no binding because the cast should have failed.");
            Assertions.assertFalse((boolean)result.hasNext());
        }
    }

    public Stream<DynamicTest> tests() {
        return Stream.of(this.makeTest("Seconds", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testSeconds)), this.makeTest("SecondsMilliseconds", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testSecondsMilliseconds)), this.makeTest("DateCastFunction_invalidInput", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testDateCastFunction_invalidInput)), this.makeTest("DateCastFunction_dateTime_withTimeZone_offset", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testDateCastFunction_dateTime_withTimeZone_offset)), this.makeTest("DateCastFunction_date_withTimeZone_utc", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testDateCastFunction_date_withTimeZone_utc)), this.makeTest("DateCastFunction_date", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testDateCastFunction_date)), this.makeTest("FilterRegexBoolean", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testFilterRegexBoolean)), this.makeTest("RegexCaseNonAscii", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testRegexCaseNonAscii)), this.makeTest("SES2052If2", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testSES2052If2)), this.makeTest("SES2052If1", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testSES2052If1)), this.makeTest("27NormalizeIRIFunction", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::test27NormalizeIRIFunction)), this.makeTest("SES2121URIFunction", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testSES2121URIFunction)), this.makeTest("SES1991RANDEvaluation", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testSES1991RANDEvaluation)), this.makeTest("SES1991STRUUIDEvaluation", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testSES1991STRUUIDEvaluation)), this.makeTest("SES1991UUIDEvaluation", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testSES1991UUIDEvaluation)), this.makeTest("SES869ValueOfNow", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testSES869ValueOfNow)), this.makeTest("SES1991NOWEvaluation", (ThrowingConsumer<RepositoryConnection>)((ThrowingConsumer)this::testSES1991NOWEvaluation)));
    }
}

