/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.testsuite.query.parser.sparql.manifest;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.rdf4j.common.io.IOUtil;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.common.text.StringUtil;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.Update;
import org.eclipse.rdf4j.query.impl.SimpleDataset;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.repository.util.Repositories;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.eclipse.rdf4j.testsuite.query.parser.sparql.manifest.SPARQL11ManifestTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(since="3.3.0")
public abstract class SPARQLUpdateConformanceTest
extends TestCase {
    static final Logger logger = LoggerFactory.getLogger(SPARQLUpdateConformanceTest.class);
    protected final String testURI;
    protected final String requestFileURL;
    protected Repository dataRep;
    protected Repository expectedResultRepo;
    private final IRI inputDefaultGraph;
    private final Map<String, IRI> inputNamedGraphs;
    private final IRI resultDefaultGraph;
    private final Map<String, IRI> resultNamedGraphs;
    protected final Dataset dataset;

    public SPARQLUpdateConformanceTest(String testURI, String name, String requestFile, IRI defaultGraphURI, Map<String, IRI> inputNamedGraphs, IRI resultDefaultGraphURI, Map<String, IRI> resultNamedGraphs) {
        super(name);
        this.testURI = testURI;
        this.requestFileURL = requestFile;
        this.inputDefaultGraph = defaultGraphURI;
        this.inputNamedGraphs = inputNamedGraphs;
        this.resultDefaultGraph = resultDefaultGraphURI;
        this.resultNamedGraphs = resultNamedGraphs;
        SimpleDataset ds = new SimpleDataset();
        ds.addDefaultGraph(null);
        ds.addDefaultRemoveGraph(null);
        ds.setDefaultInsertGraph(null);
        if (this.inputNamedGraphs.size() > 0) {
            for (String ng : inputNamedGraphs.keySet()) {
                IRI namedGraph = SimpleValueFactory.getInstance().createIRI(ng);
                ds.addNamedGraph(namedGraph);
            }
        }
        this.dataset = ds;
    }

    protected void setUp() throws Exception {
        URL graphURL;
        Object graphURL2;
        this.dataRep = this.createRepository();
        try (RepositoryConnection conn = this.dataRep.getConnection();){
            conn.clear(new Resource[0]);
            if (this.inputDefaultGraph != null) {
                graphURL2 = new URL(this.inputDefaultGraph.stringValue());
                conn.add((URL)graphURL2, null, (RDFFormat)Rio.getParserFormatForFileName((String)((URL)graphURL2).toString()).orElseThrow(Rio.unsupportedFormat((String)((URL)graphURL2).toString())), new Resource[0]);
            }
            for (String ng : this.inputNamedGraphs.keySet()) {
                graphURL = new URL(this.inputNamedGraphs.get(ng).stringValue());
                conn.add(graphURL, null, (RDFFormat)Rio.getParserFormatForFileName((String)graphURL.toString()).orElseThrow(Rio.unsupportedFormat((String)graphURL.toString())), new Resource[]{this.dataRep.getValueFactory().createIRI(ng)});
            }
        }
        this.expectedResultRepo = this.createRepository();
        conn = this.expectedResultRepo.getConnection();
        try {
            conn.clear(new Resource[0]);
            if (this.resultDefaultGraph != null) {
                graphURL2 = new URL(this.resultDefaultGraph.stringValue());
                conn.add((URL)graphURL2, null, (RDFFormat)Rio.getParserFormatForFileName((String)((URL)graphURL2).toString()).orElseThrow(Rio.unsupportedFormat((String)((URL)graphURL2).toString())), new Resource[0]);
            }
            for (String ng : this.resultNamedGraphs.keySet()) {
                graphURL = new URL(this.resultNamedGraphs.get(ng).stringValue());
                conn.add(graphURL, null, (RDFFormat)Rio.getParserFormatForFileName((String)graphURL.toString()).orElseThrow(Rio.unsupportedFormat((String)graphURL.toString())), new Resource[]{this.dataRep.getValueFactory().createIRI(ng)});
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    protected Repository createRepository() {
        Repository repo = this.newRepository();
        Repositories.consume((Repository)repo, con -> {
            con.clear(new Resource[0]);
            con.clearNamespaces();
        });
        return repo;
    }

    protected abstract Repository newRepository();

    protected void tearDown() {
        if (this.dataRep != null) {
            this.dataRep.shutDown();
            this.dataRep = null;
        }
    }

    protected void runTest() throws Exception {
        RepositoryConnection con = this.dataRep.getConnection();
        RepositoryConnection erCon = this.expectedResultRepo.getConnection();
        try {
            String updateString = this.readUpdateString();
            con.begin();
            Update update = con.prepareUpdate(QueryLanguage.SPARQL, updateString, this.requestFileURL);
            update.setDataset(this.dataset);
            update.execute();
            con.commit();
            logger.info("checking default graph");
            this.compareGraphs(Iterations.asList((CloseableIteration)con.getStatements(null, null, null, true, new Resource[]{null})), Iterations.asList((CloseableIteration)erCon.getStatements(null, null, null, true, new Resource[]{null})));
            for (String namedGraph : this.inputNamedGraphs.keySet()) {
                logger.info("checking named graph {}", (Object)namedGraph);
                IRI contextURI = con.getValueFactory().createIRI(namedGraph.replaceAll("\"", ""));
                this.compareGraphs(Iterations.asList((CloseableIteration)con.getStatements(null, null, null, true, new Resource[]{contextURI})), Iterations.asList((CloseableIteration)erCon.getStatements(null, null, null, true, new Resource[]{contextURI})));
            }
        }
        catch (Exception e) {
            if (con.isActive()) {
                con.rollback();
            }
            throw e;
        }
        finally {
            con.close();
            erCon.close();
        }
    }

    private void compareGraphs(Iterable<? extends Statement> actual, Iterable<? extends Statement> expected) {
        if (!Models.isomorphic(expected, actual)) {
            StringBuilder message = new StringBuilder(128);
            message.append("\n============ ");
            message.append(this.getName());
            message.append(" =======================\n");
            message.append("Expected result: \n");
            for (Statement statement : expected) {
                message.append(statement.toString());
                message.append("\n");
            }
            message.append("=============");
            StringUtil.appendN((char)'=', (int)this.getName().length(), (StringBuilder)message);
            message.append("========================\n");
            message.append("Actual result: \n");
            for (Statement statement : actual) {
                message.append(statement.toString());
                message.append("\n");
            }
            message.append("=============");
            StringUtil.appendN((char)'=', (int)this.getName().length(), (StringBuilder)message);
            message.append("========================\n");
            logger.error(message.toString());
            SPARQLUpdateConformanceTest.fail((String)message.toString());
        }
    }

    private String readUpdateString() throws IOException {
        try (InputStream stream = new URL(this.requestFileURL).openStream();){
            String string = IOUtil.readString((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8));
            return string;
        }
    }

    public static TestSuite suite(String manifestFileURL, Factory factory) throws Exception {
        return SPARQLUpdateConformanceTest.suite(manifestFileURL, factory, true);
    }

    public static TestSuite suite(String manifestFileURL, Factory factory, boolean approvedOnly) throws Exception {
        logger.info("Building test suite for {}", (Object)manifestFileURL);
        TestSuite suite = new TestSuite(factory.getClass().getName());
        SailRepository manifestRep = new SailRepository((Sail)new MemoryStore());
        try (RepositoryConnection con = manifestRep.getConnection();){
            SPARQL11ManifestTest.addTurtle(con, new URL(manifestFileURL), manifestFileURL, new Resource[0]);
            suite.setName(SPARQLUpdateConformanceTest.getManifestName((Repository)manifestRep, con, manifestFileURL));
            StringBuilder query = new StringBuilder(512);
            query.append("PREFIX mf: <http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#>\n ");
            query.append("PREFIX dawgt = <http://www.w3.org/2001/sw/DataAccess/tests/test-dawg#>\n");
            query.append("PREFIX qt: <http://www.w3.org/2001/sw/DataAccess/tests/test-query#>\n");
            query.append("PREFIX ut: <http://www.w3.org/2009/sparql/tests/test-update#>\n");
            query.append("PREFIX sd: <http://www.w3.org/ns/sparql-service-description#>\n");
            query.append("PREFIX ent: <http://www.w3.org/ns/entailment/> \n");
            query.append(" SELECT DISTINCT ?testURI ?testName ?result ?action ?requestFile ?defaultGraph ?resultDefaultGraph \n");
            query.append(" WHERE { [] rdf:first ?testURI. ?testURI a mf:UpdateEvaluationTest; ");
            if (approvedOnly) {
                query.append("                          dawgt:approval dawgt:Approved; ");
            }
            query.append("                             mf:name ?testName; ");
            query.append("                             mf:action ?action. ?action ut:request ?requestFile. ");
            query.append("  OPTIONAL {?action ut:data ?defaultGraph .} ");
            query.append("    ?testURI mf:result ?result . \n");
            query.append("  OPTIONAL { ?result ut:data ?resultDefaultGraph }} ");
            TupleQuery testCaseQuery = con.prepareTupleQuery(query.toString());
            query.setLength(0);
            query.append("PREFIX ut: <http://www.w3.org/2009/sparql/tests/test-update#> \n");
            query.append(" SELECT DISTINCT ?namedGraphData ?namedGraphLabel ");
            query.append(" WHERE { ?graphDef ut:graphData [ ut:graph ?namedGraphData ; ");
            query.append("                                  rdfs:label ?namedGraphLabel].} ");
            TupleQuery namedGraphsQuery = con.prepareTupleQuery(query.toString());
            logger.debug("evaluating query..");
            TupleQueryResult testCases = testCaseQuery.evaluate();
            while (testCases.hasNext()) {
                SPARQLUpdateConformanceTest test;
                BindingSet bindingSet = (BindingSet)testCases.next();
                IRI testURI = (IRI)bindingSet.getValue("testURI");
                String testName = bindingSet.getValue("testName").toString();
                Value result = bindingSet.getValue("result");
                Value action = bindingSet.getValue("action");
                IRI requestFile = (IRI)bindingSet.getValue("requestFile");
                IRI defaultGraphURI = (IRI)bindingSet.getValue("defaultGraph");
                IRI resultDefaultGraphURI = (IRI)bindingSet.getValue("resultDefaultGraph");
                logger.debug("found test case : {}", (Object)testName);
                namedGraphsQuery.setBinding("graphDef", action);
                TupleQueryResult inputNamedGraphsResult = namedGraphsQuery.evaluate();
                HashMap<String, IRI> inputNamedGraphs = new HashMap<String, IRI>();
                if (inputNamedGraphsResult.hasNext()) {
                    while (inputNamedGraphsResult.hasNext()) {
                        BindingSet graphBindings = (BindingSet)inputNamedGraphsResult.next();
                        IRI namedGraphData = (IRI)graphBindings.getValue("namedGraphData");
                        String namedGraphLabel = ((Literal)graphBindings.getValue("namedGraphLabel")).getLabel();
                        logger.debug(" adding named graph : {}", (Object)namedGraphLabel);
                        inputNamedGraphs.put(namedGraphLabel, namedGraphData);
                    }
                }
                namedGraphsQuery.setBinding("graphDef", result);
                TupleQueryResult resultNamedGraphsResult = namedGraphsQuery.evaluate();
                HashMap<String, IRI> resultNamedGraphs = new HashMap<String, IRI>();
                if (resultNamedGraphsResult.hasNext()) {
                    while (resultNamedGraphsResult.hasNext()) {
                        BindingSet graphBindings = (BindingSet)resultNamedGraphsResult.next();
                        IRI namedGraphData = (IRI)graphBindings.getValue("namedGraphData");
                        String namedGraphLabel = ((Literal)graphBindings.getValue("namedGraphLabel")).getLabel();
                        logger.debug(" adding named graph : {}", (Object)namedGraphLabel);
                        resultNamedGraphs.put(namedGraphLabel, namedGraphData);
                    }
                }
                if ((test = factory.createSPARQLUpdateConformanceTest(testURI.toString(), testName, requestFile.toString(), defaultGraphURI, inputNamedGraphs, resultDefaultGraphURI, resultNamedGraphs)) == null) continue;
                suite.addTest((Test)test);
            }
            testCases.close();
        }
        manifestRep.shutDown();
        logger.info("Created test suite with " + suite.countTestCases() + " test cases.");
        return suite;
    }

    protected static String getManifestName(Repository manifestRep, RepositoryConnection con, String manifestFileURL) throws QueryEvaluationException, RepositoryException, MalformedQueryException {
        TupleQuery manifestNameQuery = con.prepareTupleQuery("SELECT ?ManifestName WHERE { ?ManifestURL rdfs:label ?ManifestName .}");
        manifestNameQuery.setBinding("ManifestURL", (Value)manifestRep.getValueFactory().createIRI(manifestFileURL));
        try (TupleQueryResult manifestNames = manifestNameQuery.evaluate();){
            if (manifestNames.hasNext()) {
                String string = ((BindingSet)manifestNames.next()).getValue("ManifestName").stringValue();
                return string;
            }
        }
        int lastSlashIdx = manifestFileURL.lastIndexOf(47);
        int secLastSlashIdx = manifestFileURL.lastIndexOf(47, lastSlashIdx - 1);
        return manifestFileURL.substring(secLastSlashIdx + 1, lastSlashIdx);
    }

    public static interface Factory {
        public SPARQLUpdateConformanceTest createSPARQLUpdateConformanceTest(String var1, String var2, String var3, IRI var4, Map<String, IRI> var5, IRI var6, Map<String, IRI> var7);
    }
}

