/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.testsuite.sparql.tests;

import java.util.stream.Stream;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.testsuite.sparql.AbstractComplianceTest;
import org.junit.Assert;
import org.junit.Test;

public class BuiltinFunctionTest
extends AbstractComplianceTest {
    @Test
    public void testSeconds() {
        String qry = "PREFIX xsd: <http://www.w3.org/2001/XMLSchema#> SELECT (SECONDS(\"2011-01-10T14:45:13\"^^xsd:dateTime) AS ?sec) { }";
        try (TupleQueryResult result = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, qry).evaluate();){
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)result.hasNext());
            Assert.assertEquals((Object)"13", (Object)((BindingSet)result.next()).getValue("sec").stringValue());
            Assert.assertFalse((boolean)result.hasNext());
        }
    }

    @Test
    public void testSecondsMilliseconds() {
        String qry = "PREFIX xsd: <http://www.w3.org/2001/XMLSchema#> SELECT (SECONDS(\"2011-01-10T14:45:13.815-05:00\"^^xsd:dateTime) AS ?sec) { }";
        try (TupleQueryResult result = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, qry).evaluate();){
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)result.hasNext());
            Assert.assertEquals((Object)"13.815", (Object)((BindingSet)result.next()).getValue("sec").stringValue());
            Assert.assertFalse((boolean)result.hasNext());
        }
    }

    @Test
    public void testSES1991NOWEvaluation() throws Exception {
        this.loadTestData("/testdata-query/defaultgraph.ttl", new Resource[0]);
        String query = "SELECT ?d WHERE {?s ?p ?o . BIND(NOW() as ?d) } LIMIT 2";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)result.hasNext());
            Literal d1 = (Literal)((BindingSet)result.next()).getValue("d");
            Assert.assertTrue((boolean)result.hasNext());
            Literal d2 = (Literal)((BindingSet)result.next()).getValue("d");
            Assert.assertFalse((boolean)result.hasNext());
            Assert.assertNotNull((Object)d1);
            Assert.assertEquals((Object)d1, (Object)d2);
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSES869ValueOfNow() {
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, "SELECT ?p ( NOW() as ?n ) { BIND (NOW() as ?p ) }");
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)result.hasNext());
            BindingSet bs = (BindingSet)result.next();
            Value p = bs.getValue("p");
            Value n = bs.getValue("n");
            Assert.assertNotNull((Object)p);
            Assert.assertNotNull((Object)n);
            Assert.assertEquals((Object)p, (Object)n);
            Assert.assertTrue((p == n ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSES1991UUIDEvaluation() throws Exception {
        this.loadTestData("/testdata-query/defaultgraph.ttl", new Resource[0]);
        String query = "SELECT ?uid WHERE {?s ?p ?o . BIND(UUID() as ?uid) } LIMIT 2";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            IRI uuid1 = (IRI)((BindingSet)result.next()).getValue("uid");
            IRI uuid2 = (IRI)((BindingSet)result.next()).getValue("uid");
            Assert.assertNotNull((Object)uuid1);
            Assert.assertNotNull((Object)uuid2);
            Assert.assertNotEquals((Object)uuid1, (Object)uuid2);
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSES1991STRUUIDEvaluation() throws Exception {
        this.loadTestData("/testdata-query/defaultgraph.ttl", new Resource[0]);
        String query = "SELECT ?uid WHERE {?s ?p ?o . BIND(STRUUID() as ?uid) } LIMIT 2";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            Literal uid1 = (Literal)((BindingSet)result.next()).getValue("uid");
            Literal uid2 = (Literal)((BindingSet)result.next()).getValue("uid");
            Assert.assertNotNull((Object)uid1);
            Assert.assertNotEquals((Object)uid1, (Object)uid2);
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSES1991RANDEvaluation() throws Exception {
        this.loadTestData("/testdata-query/defaultgraph.ttl", new Resource[0]);
        String query = "SELECT ?r WHERE {?s ?p ?o . BIND(RAND() as ?r) } LIMIT 3";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            Literal r1 = (Literal)((BindingSet)result.next()).getValue("r");
            Literal r2 = (Literal)((BindingSet)result.next()).getValue("r");
            Literal r3 = (Literal)((BindingSet)result.next()).getValue("r");
            Assert.assertNotNull((Object)r1);
            Assert.assertFalse((r1.equals((Object)r2) && r1.equals((Object)r3) ? 1 : 0) != 0);
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSES2121URIFunction() {
        IRI uri;
        BindingSet bs;
        String query = "SELECT (URI(\"foo bar\") as ?uri) WHERE {}";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)result.hasNext());
            bs = (BindingSet)result.next();
            uri = (IRI)bs.getValue("uri");
            Assert.assertNull((String)"uri result for invalid URI should be unbound", (Object)uri);
        }
        query = "BASE <http://example.org/> SELECT (URI(\"foo bar\") as ?uri) WHERE {}";
        tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        result = tq.evaluate();
        try {
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)result.hasNext());
            bs = (BindingSet)result.next();
            uri = (IRI)bs.getValue("uri");
            Assert.assertNotNull((String)"uri result for valid URI reference should be bound", (Object)uri);
        }
        finally {
            if (result != null) {
                result.close();
            }
        }
    }

    @Test
    public void test27NormalizeIRIFunction() {
        String query = "SELECT (IRI(\"../bar\") as ?Iri) WHERE {}";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query, "http://example.com/foo/");
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)result.hasNext());
            BindingSet bs = (BindingSet)result.next();
            IRI actual = (IRI)bs.getValue("Iri");
            IRI expected = Values.iri((String)"http://example.com/bar");
            Assert.assertEquals((String)"IRI result for relative IRI should be normalized", (Object)expected, (Object)actual);
        }
    }

    @Test
    public void testSES2052If1() throws Exception {
        this.loadTestData("/testdata-query/dataset-query.trig", new Resource[0]);
        String query = "SELECT ?p \nWHERE { \n         ?s ?p ?o . \n        FILTER(IF(BOUND(?p), ?p = <http://www.w3.org/1999/02/22-rdf-syntax-ns#type>, false)) \n}";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            while (result.hasNext()) {
                BindingSet bs = (BindingSet)result.next();
                IRI p = (IRI)bs.getValue("p");
                Assert.assertNotNull((Object)p);
                Assert.assertEquals((Object)RDF.TYPE, (Object)p);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSES2052If2() throws Exception {
        this.loadTestData("/testdata-query/dataset-query.trig", new Resource[0]);
        String query = "SELECT ?p \nWHERE { \n         ?s ?p ?o . \n        FILTER(IF(!BOUND(?p), false , ?p = <http://www.w3.org/1999/02/22-rdf-syntax-ns#type>)) \n}";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            while (result.hasNext()) {
                BindingSet bs = (BindingSet)result.next();
                IRI p = (IRI)bs.getValue("p");
                Assert.assertNotNull((Object)p);
                Assert.assertEquals((Object)RDF.TYPE, (Object)p);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testRegexCaseNonAscii() {
        String query = "ask {filter (regex(\"\u0412\u0430\u043b\u043e\u0432\u043e\u0439\", \"\u0432\u0430\u043b\u043e\u0432\u043e\u0439\", \"i\")) }";
        Assert.assertTrue((String)"case-insensitive match on Cyrillic should succeed", (boolean)this.conn.prepareBooleanQuery(query).evaluate());
        query = "ask {filter (regex(\"\u0412\u0430\u043b\u043e\u0432\u043e\u0439\", \"\u0432\u0430\u043b\u043e\u0432\u043e\u0439\")) }";
        Assert.assertFalse((String)"case-sensitive match on Cyrillic should fail", (boolean)this.conn.prepareBooleanQuery(query).evaluate());
    }

    @Test
    public void testFilterRegexBoolean() throws Exception {
        this.loadTestData("/testdata-query/dataset-query.trig", new Resource[0]);
        String query = this.getNamespaceDeclarations() + " SELECT * WHERE {        ?x foaf:name ?name ;           foaf:mbox ?mbox .        FILTER(EXISTS {             FILTER(REGEX(?name, \"Bo\") && REGEX(?mbox, \"bob\"))             } ) } ";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (Stream result = tq.evaluate().stream();){
            long count = result.count();
            Assert.assertEquals((long)1L, (long)count);
        }
    }

    @Test
    public void testDateCastFunction_date() {
        String qry = "PREFIX xsd: <http://www.w3.org/2001/XMLSchema#> SELECT (xsd:date(\"2022-09-09\") AS ?date) { }";
        try (TupleQueryResult result = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, qry).evaluate();){
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)result.hasNext());
            Assert.assertEquals((Object)"2022-09-09", (Object)((BindingSet)result.next()).getValue("date").stringValue());
            Assert.assertFalse((boolean)result.hasNext());
        }
    }

    @Test
    public void testDateCastFunction_date_withTimeZone_utc() {
        String qry = "PREFIX xsd: <http://www.w3.org/2001/XMLSchema#> SELECT (xsd:date(\"2022-09-09Z\") AS ?date) { }";
        try (TupleQueryResult result = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, qry).evaluate();){
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)result.hasNext());
            Assert.assertEquals((Object)"2022-09-09Z", (Object)((BindingSet)result.next()).getValue("date").stringValue());
            Assert.assertFalse((boolean)result.hasNext());
        }
    }

    @Test
    public void testDateCastFunction_dateTime_withTimeZone_offset() {
        String qry = "PREFIX xsd: <http://www.w3.org/2001/XMLSchema#> SELECT (xsd:date(\"2022-09-09T14:45:13+03:00\") AS ?date) { }";
        try (TupleQueryResult result = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, qry).evaluate();){
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)result.hasNext());
            Assert.assertEquals((Object)"2022-09-09+03:00", (Object)((BindingSet)result.next()).getValue("date").stringValue());
            Assert.assertFalse((boolean)result.hasNext());
        }
    }

    @Test
    public void testDateCastFunction_invalidInput() {
        String qry = "PREFIX xsd: <http://www.w3.org/2001/XMLSchema#> SELECT (xsd:date(\"2022-09-xx\") AS ?date) { }";
        try (TupleQueryResult result = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, qry).evaluate();){
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)result.hasNext());
            Assert.assertFalse((String)"There should be no binding because the cast should have failed.", (boolean)((BindingSet)result.next()).hasBinding("date"));
            Assert.assertFalse((boolean)result.hasNext());
        }
    }
}

