/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.testsuite.sparql.tests;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.DC;
import org.eclipse.rdf4j.model.vocabulary.FOAF;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.query.AbstractTupleQueryResultHandler;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.eclipse.rdf4j.testsuite.sparql.AbstractComplianceTest;
import org.eclipse.rdf4j.testsuite.sparql.vocabulary.EX;
import org.junit.Assert;
import org.junit.Test;

public class BasicTest
extends AbstractComplianceTest {
    @Test
    public void testIdenticalVariablesInStatementPattern() {
        this.conn.add((Resource)EX.ALICE, DC.PUBLISHER, (Value)EX.BOB, new Resource[0]);
        String queryBuilder = "SELECT ?publisher { ?publisher <http://purl.org/dc/elements/1.1/publisher> ?publisher }";
        this.conn.prepareTupleQuery(QueryLanguage.SPARQL, queryBuilder).evaluate((TupleQueryResultHandler)new AbstractTupleQueryResultHandler(){

            public void handleSolution(BindingSet bindingSet) {
                Assert.fail((String)"nobody is self published");
            }
        });
    }

    @Test
    public void testIdenticalVariablesSubjectContextInStatementPattern() {
        this.conn.add((Resource)EX.ALICE, FOAF.KNOWS, (Value)EX.BOB, new Resource[]{EX.ALICE});
        this.conn.add((Resource)EX.ALICE, RDF.TYPE, (Value)FOAF.PERSON, new Resource[]{EX.ALICE});
        this.conn.add((Resource)EX.ALICE, FOAF.KNOWS, (Value)EX.A, new Resource[]{EX.BOB});
        this.conn.add((Resource)EX.ALICE, FOAF.KNOWS, (Value)EX.B, new Resource[]{EX.BOB});
        this.conn.add((Resource)EX.ALICE, FOAF.KNOWS, (Value)EX.C, new Resource[]{EX.BOB});
        this.conn.add((Resource)EX.ALICE, FOAF.KNOWS, (Value)EX.MARY, new Resource[]{EX.BOB});
        String queryBuilder = "SELECT ?knows { \tgraph ?alice {\t\t?alice a <" + FOAF.PERSON + ">; \t\t\t<" + FOAF.KNOWS + "> ?knows .\t\t}}";
        try (Stream stream = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, queryBuilder).evaluate().stream();){
            List knows = stream.map(b -> b.getValue("knows")).collect(Collectors.toList());
            Assert.assertEquals(List.of(EX.BOB), knows);
        }
    }
}

