/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.testsuite.sparql.tests;

import java.util.Set;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.QueryResults;
import org.eclipse.rdf4j.testsuite.sparql.AbstractComplianceTest;
import org.junit.Test;

public class DescribeTest
extends AbstractComplianceTest {
    @Test
    public void testDescribeA() throws Exception {
        this.loadTestData("/testdata-query/dataset-describe.trig", new Resource[0]);
        String query = this.getNamespaceDeclarations() + "DESCRIBE ex:a";
        GraphQuery gq = this.conn.prepareGraphQuery(QueryLanguage.SPARQL, query);
        ValueFactory f = this.conn.getValueFactory();
        IRI a = f.createIRI("http://example.org/a");
        IRI p = f.createIRI("http://example.org/p");
        try (GraphQueryResult evaluate = gq.evaluate();){
            Model result = QueryResults.asModel((CloseableIteration)evaluate);
            Set objects = result.filter((Resource)a, p, null, new Resource[0]).objects();
            Assertions.assertThat((Iterable)objects).isNotNull();
            for (Value object : objects) {
                if (!(object instanceof BNode)) continue;
                Assertions.assertThat((boolean)result.contains((Resource)object, null, null, new Resource[0])).isTrue();
                Assertions.assertThat((Iterable)result.filter((Resource)object, null, null, new Resource[0])).hasSize(2);
            }
        }
    }

    @Test
    public void testDescribeAWhere() throws Exception {
        this.loadTestData("/testdata-query/dataset-describe.trig", new Resource[0]);
        String query = this.getNamespaceDeclarations() + "DESCRIBE ?x WHERE {?x rdfs:label \"a\". } ";
        GraphQuery gq = this.conn.prepareGraphQuery(QueryLanguage.SPARQL, query);
        ValueFactory f = this.conn.getValueFactory();
        IRI a = f.createIRI("http://example.org/a");
        IRI p = f.createIRI("http://example.org/p");
        try (GraphQueryResult evaluate = gq.evaluate();){
            Model result = QueryResults.asModel((CloseableIteration)evaluate);
            Set objects = result.filter((Resource)a, p, null, new Resource[0]).objects();
            Assertions.assertThat((Iterable)objects).isNotNull();
            for (Value object : objects) {
                if (!(object instanceof BNode)) continue;
                Assertions.assertThat((boolean)result.contains((Resource)object, null, null, new Resource[0])).isTrue();
                Assertions.assertThat((Iterable)result.filter((Resource)object, null, null, new Resource[0])).hasSize(2);
            }
        }
    }

    @Test
    public void testDescribeWhere() throws Exception {
        this.loadTestData("/testdata-query/dataset-describe.trig", new Resource[0]);
        String query = this.getNamespaceDeclarations() + "DESCRIBE ?x WHERE {?x rdfs:label ?y . } ";
        GraphQuery gq = this.conn.prepareGraphQuery(QueryLanguage.SPARQL, query);
        ValueFactory vf = this.conn.getValueFactory();
        IRI a = vf.createIRI("http://example.org/a");
        IRI b = vf.createIRI("http://example.org/b");
        IRI c = vf.createIRI("http://example.org/c");
        IRI e = vf.createIRI("http://example.org/e");
        IRI f = vf.createIRI("http://example.org/f");
        IRI p = vf.createIRI("http://example.org/p");
        try (GraphQueryResult evaluate = gq.evaluate();){
            Model result = QueryResults.asModel((CloseableIteration)evaluate);
            Assertions.assertThat((boolean)result.contains((Resource)a, p, null, new Resource[0])).isTrue();
            Assertions.assertThat((boolean)result.contains((Resource)b, RDFS.LABEL, null, new Resource[0])).isTrue();
            Assertions.assertThat((boolean)result.contains((Resource)c, RDFS.LABEL, null, new Resource[0])).isTrue();
            Assertions.assertThat((boolean)result.contains(null, p, (Value)b, new Resource[0])).isTrue();
            Assertions.assertThat((boolean)result.contains((Resource)e, RDFS.LABEL, null, new Resource[0])).isTrue();
            Assertions.assertThat((boolean)result.contains(null, p, (Value)e, new Resource[0])).isTrue();
            Assertions.assertThat((boolean)result.contains((Resource)f, null, null, new Resource[0])).isFalse();
            Set objects = result.filter((Resource)a, p, null, new Resource[0]).objects();
            Assertions.assertThat((Iterable)objects).isNotNull();
            for (Value object : objects) {
                if (!(object instanceof BNode)) continue;
                Assertions.assertThat((boolean)result.contains((Resource)object, null, null, new Resource[0])).isTrue();
                Assertions.assertThat((Iterable)result.filter((Resource)object, null, null, new Resource[0])).hasSize(2);
            }
        }
    }

    @Test
    public void testDescribeB() throws Exception {
        this.loadTestData("/testdata-query/dataset-describe.trig", new Resource[0]);
        String query = this.getNamespaceDeclarations() + "DESCRIBE ex:b";
        GraphQuery gq = this.conn.prepareGraphQuery(QueryLanguage.SPARQL, query);
        ValueFactory f = this.conn.getValueFactory();
        IRI b = f.createIRI("http://example.org/b");
        IRI p = f.createIRI("http://example.org/p");
        try (GraphQueryResult evaluate = gq.evaluate();){
            Model result = QueryResults.asModel((CloseableIteration)evaluate);
            Set subjects = result.filter(null, p, (Value)b, new Resource[0]).subjects();
            Assertions.assertThat((Iterable)subjects).isNotNull();
            for (Value subject : subjects) {
                if (!(subject instanceof BNode)) continue;
                Assertions.assertThat((boolean)result.contains(null, null, subject, new Resource[0])).isTrue();
            }
        }
    }

    @Test
    public void testDescribeD() throws Exception {
        this.loadTestData("/testdata-query/dataset-describe.trig", new Resource[0]);
        String query = this.getNamespaceDeclarations() + "DESCRIBE ex:d";
        GraphQuery gq = this.conn.prepareGraphQuery(QueryLanguage.SPARQL, query);
        ValueFactory f = this.conn.getValueFactory();
        IRI d = f.createIRI("http://example.org/d");
        IRI p = f.createIRI("http://example.org/p");
        IRI e = f.createIRI("http://example.org/e");
        try (GraphQueryResult evaluate = gq.evaluate();){
            Model result = QueryResults.asModel((CloseableIteration)evaluate);
            Assertions.assertThat((boolean)result.contains(null, p, (Value)e, new Resource[0])).isTrue();
            Assertions.assertThat((boolean)result.contains((Resource)e, null, null, new Resource[0])).isFalse();
            Set objects = result.filter((Resource)d, p, null, new Resource[0]).objects();
            Assertions.assertThat((Iterable)objects).isNotNull();
            for (Value object : objects) {
                if (!(object instanceof BNode)) continue;
                Set childObjects = result.filter((Resource)((BNode)object), null, null, new Resource[0]).objects();
                Assertions.assertThat((Iterable)childObjects).isNotEmpty();
                for (Value childObject : childObjects) {
                    if (!(childObject instanceof BNode)) continue;
                    Assertions.assertThat((boolean)result.contains((Resource)((BNode)childObject), null, null, new Resource[0])).isTrue();
                }
            }
        }
    }

    @Test
    public void testDescribeF() throws Exception {
        this.loadTestData("/testdata-query/dataset-describe.trig", new Resource[0]);
        String query = this.getNamespaceDeclarations() + "DESCRIBE ex:f";
        GraphQuery gq = this.conn.prepareGraphQuery(QueryLanguage.SPARQL, query);
        ValueFactory vf = this.conn.getValueFactory();
        IRI f = vf.createIRI("http://example.org/f");
        IRI p = vf.createIRI("http://example.org/p");
        try (GraphQueryResult evaluate = gq.evaluate();){
            Model result = QueryResults.asModel((CloseableIteration)evaluate);
            ((IterableAssert)Assertions.assertThat((Iterable)result).isNotNull()).hasSize(4);
            Set objects = result.filter((Resource)f, p, null, new Resource[0]).objects();
            for (Value object : objects) {
                if (!(object instanceof BNode)) continue;
                Set childObjects = result.filter((Resource)((BNode)object), null, null, new Resource[0]).objects();
                Assertions.assertThat((Iterable)childObjects).isNotEmpty();
                for (Value childObject : childObjects) {
                    if (!(childObject instanceof BNode)) continue;
                    Assertions.assertThat((boolean)result.contains((Resource)((BNode)childObject), null, null, new Resource[0])).isTrue();
                }
            }
        }
    }

    @Test
    public void testDescribeMultipleA() {
        String update = "insert data { <urn:1> <urn:p1> <urn:v> . [] <urn:blank> <urn:1> . <urn:2> <urn:p2> <urn:3> . } ";
        this.conn.prepareUpdate(QueryLanguage.SPARQL, update).execute();
        String query = this.getNamespaceDeclarations() + "DESCRIBE <urn:1> <urn:2> ";
        GraphQuery gq = this.conn.prepareGraphQuery(QueryLanguage.SPARQL, query);
        ValueFactory vf = this.conn.getValueFactory();
        IRI urn1 = vf.createIRI("urn:1");
        IRI p1 = vf.createIRI("urn:p1");
        IRI p2 = vf.createIRI("urn:p2");
        IRI urn2 = vf.createIRI("urn:2");
        IRI blank = vf.createIRI("urn:blank");
        try (GraphQueryResult evaluate = gq.evaluate();){
            Model result = QueryResults.asModel((CloseableIteration)evaluate);
            Assertions.assertThat((boolean)result.contains((Resource)urn1, p1, null, new Resource[0])).isTrue();
            Assertions.assertThat((boolean)result.contains(null, blank, (Value)urn1, new Resource[0])).isTrue();
            Assertions.assertThat((boolean)result.contains((Resource)urn2, p2, null, new Resource[0])).isTrue();
        }
    }

    @Test
    public void testDescribeMultipleB() {
        String update = "insert data { <urn:1> <urn:p1> <urn:v> . <urn:1> <urn:blank> [] . <urn:2> <urn:p2> <urn:3> . } ";
        this.conn.prepareUpdate(QueryLanguage.SPARQL, update).execute();
        String query = this.getNamespaceDeclarations() + "DESCRIBE <urn:1> <urn:2> ";
        GraphQuery gq = this.conn.prepareGraphQuery(QueryLanguage.SPARQL, query);
        ValueFactory vf = this.conn.getValueFactory();
        IRI urn1 = vf.createIRI("urn:1");
        IRI p1 = vf.createIRI("urn:p1");
        IRI p2 = vf.createIRI("urn:p2");
        IRI urn2 = vf.createIRI("urn:2");
        IRI blank = vf.createIRI("urn:blank");
        try (GraphQueryResult evaluate = gq.evaluate();){
            Model result = QueryResults.asModel((CloseableIteration)evaluate);
            Assertions.assertThat((boolean)result.contains((Resource)urn1, p1, null, new Resource[0])).isTrue();
            Assertions.assertThat((boolean)result.contains((Resource)urn1, blank, null, new Resource[0])).isTrue();
            Assertions.assertThat((boolean)result.contains((Resource)urn2, p2, null, new Resource[0])).isTrue();
        }
    }

    @Test
    public void testDescribeMultipleC() {
        String update = "insert data { <urn:1> <urn:p1> <urn:v> . [] <urn:blank> <urn:1>. <urn:1> <urn:blank> [] . <urn:2> <urn:p2> <urn:3> . } ";
        this.conn.prepareUpdate(QueryLanguage.SPARQL, update).execute();
        String query = this.getNamespaceDeclarations() + "DESCRIBE <urn:1> <urn:2> ";
        GraphQuery gq = this.conn.prepareGraphQuery(QueryLanguage.SPARQL, query);
        ValueFactory vf = this.conn.getValueFactory();
        IRI urn1 = vf.createIRI("urn:1");
        IRI p1 = vf.createIRI("urn:p1");
        IRI p2 = vf.createIRI("urn:p2");
        IRI urn2 = vf.createIRI("urn:2");
        IRI blank = vf.createIRI("urn:blank");
        try (GraphQueryResult evaluate = gq.evaluate();){
            Model result = QueryResults.asModel((CloseableIteration)evaluate);
            Assertions.assertThat((boolean)result.contains((Resource)urn1, p1, null, new Resource[0])).isTrue();
            Assertions.assertThat((boolean)result.contains((Resource)urn1, blank, null, new Resource[0])).isTrue();
            Assertions.assertThat((boolean)result.contains(null, blank, (Value)urn1, new Resource[0])).isTrue();
            Assertions.assertThat((boolean)result.contains((Resource)urn2, p2, null, new Resource[0])).isTrue();
        }
    }

    @Test
    public void testDescribeMultipleD() {
        String update = "insert data { <urn:1> <urn:p1> <urn:v> . [] <urn:blank> <urn:1>. <urn:2> <urn:p2> <urn:3> . [] <urn:blank> <urn:2> . <urn:4> <urn:p2> <urn:3> . <urn:4> <urn:blank> [] .} ";
        this.conn.prepareUpdate(QueryLanguage.SPARQL, update).execute();
        String query = this.getNamespaceDeclarations() + "DESCRIBE <urn:1> <urn:2> <urn:4> ";
        GraphQuery gq = this.conn.prepareGraphQuery(QueryLanguage.SPARQL, query);
        ValueFactory vf = this.conn.getValueFactory();
        IRI urn1 = vf.createIRI("urn:1");
        IRI p1 = vf.createIRI("urn:p1");
        IRI p2 = vf.createIRI("urn:p2");
        IRI urn2 = vf.createIRI("urn:2");
        IRI urn4 = vf.createIRI("urn:4");
        IRI blank = vf.createIRI("urn:blank");
        try (GraphQueryResult evaluate = gq.evaluate();){
            Model result = QueryResults.asModel((CloseableIteration)evaluate);
            Assertions.assertThat((boolean)result.contains((Resource)urn1, p1, null, new Resource[0])).isTrue();
            Assertions.assertThat((boolean)result.contains(null, blank, (Value)urn1, new Resource[0])).isTrue();
            Assertions.assertThat((boolean)result.contains((Resource)urn2, p2, null, new Resource[0])).isTrue();
            Assertions.assertThat((boolean)result.contains((Resource)urn4, p2, null, new Resource[0])).isTrue();
            Assertions.assertThat((boolean)result.contains((Resource)urn4, blank, null, new Resource[0])).isTrue();
        }
    }
}

