/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.testsuite.query.parser.sparql.manifest;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.eclipse.rdf4j.common.io.IOUtil;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.Update;
import org.eclipse.rdf4j.query.impl.SimpleDataset;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.eclipse.rdf4j.testsuite.query.parser.sparql.manifest.SPARQLComplianceTest;
import org.junit.After;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public abstract class SPARQL11UpdateComplianceTest
extends SPARQLComplianceTest {
    private static final Logger logger = LoggerFactory.getLogger(SPARQL11UpdateComplianceTest.class);
    private static final String[] defaultIgnoredTests = new String[0];
    private static final List<String> excludedSubdirs = List.of("service");
    private String queryFileURL;
    private String resultFileURL;
    private final Dataset dataset;
    private boolean ordered;
    private Repository dataRep;
    protected Repository expectedResultRepo;
    private final String requestFile;
    private final IRI inputDefaultGraphURI;
    private final Map<String, IRI> inputNamedGraphs;
    private final IRI resultDefaultGraphURI;
    private final Map<String, IRI> resultNamedGraphs;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(SPARQL11UpdateComplianceTest.getTestData());
    }

    public SPARQL11UpdateComplianceTest(String displayName, String testURI, String name, String requestFile, IRI defaultGraphURI, Map<String, IRI> inputNamedGraphs, IRI resultDefaultGraphURI, Map<String, IRI> resultNamedGraphs) {
        super(displayName, testURI, name);
        this.requestFile = requestFile;
        this.inputDefaultGraphURI = defaultGraphURI;
        this.inputNamedGraphs = inputNamedGraphs;
        this.resultDefaultGraphURI = resultDefaultGraphURI;
        this.resultNamedGraphs = resultNamedGraphs;
        SimpleDataset ds = new SimpleDataset();
        ds.addDefaultGraph(null);
        ds.addDefaultRemoveGraph(null);
        ds.setDefaultInsertGraph(null);
        if (this.inputNamedGraphs.size() > 0) {
            for (String ng : inputNamedGraphs.keySet()) {
                IRI namedGraph = SimpleValueFactory.getInstance().createIRI(ng);
                ds.addNamedGraph(namedGraph);
            }
        }
        this.dataset = ds;
    }

    @Before
    public void setUp() throws Exception {
        URL graphURL;
        Object graphURL2;
        this.dataRep = this.createRepository();
        try (RepositoryConnection conn = this.dataRep.getConnection();){
            conn.clear(new Resource[0]);
            if (this.inputDefaultGraphURI != null) {
                graphURL2 = new URL(this.inputDefaultGraphURI.stringValue());
                conn.add((URL)graphURL2, null, (RDFFormat)Rio.getParserFormatForFileName((String)((URL)graphURL2).toString()).orElseThrow(Rio.unsupportedFormat((String)((URL)graphURL2).toString())), new Resource[0]);
            }
            for (String ng : this.inputNamedGraphs.keySet()) {
                graphURL = new URL(this.inputNamedGraphs.get(ng).stringValue());
                conn.add(graphURL, null, (RDFFormat)Rio.getParserFormatForFileName((String)graphURL.toString()).orElseThrow(Rio.unsupportedFormat((String)graphURL.toString())), new Resource[]{this.dataRep.getValueFactory().createIRI(ng)});
            }
        }
        this.expectedResultRepo = this.createRepository();
        conn = this.expectedResultRepo.getConnection();
        try {
            conn.clear(new Resource[0]);
            if (this.resultDefaultGraphURI != null) {
                graphURL2 = new URL(this.resultDefaultGraphURI.stringValue());
                conn.add((URL)graphURL2, null, (RDFFormat)Rio.getParserFormatForFileName((String)((URL)graphURL2).toString()).orElseThrow(Rio.unsupportedFormat((String)((URL)graphURL2).toString())), new Resource[0]);
            }
            for (String ng : this.resultNamedGraphs.keySet()) {
                graphURL = new URL(this.resultNamedGraphs.get(ng).stringValue());
                conn.add(graphURL, null, (RDFFormat)Rio.getParserFormatForFileName((String)graphURL.toString()).orElseThrow(Rio.unsupportedFormat((String)graphURL.toString())), new Resource[]{this.dataRep.getValueFactory().createIRI(ng)});
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    @After
    public void tearDown() throws Exception {
        if (this.dataRep != null) {
            this.dataRep.shutDown();
            this.dataRep = null;
        }
        if (this.expectedResultRepo != null) {
            this.expectedResultRepo.shutDown();
            this.expectedResultRepo = null;
        }
    }

    private Repository createRepository() throws Exception {
        Repository repo = this.newRepository();
        try (RepositoryConnection con = repo.getConnection();){
            con.clear(new Resource[0]);
            con.clearNamespaces();
        }
        return repo;
    }

    protected abstract Repository newRepository() throws Exception;

    @Override
    protected Repository getDataRepository() {
        return this.dataRep;
    }

    private static Object[][] getTestData() {
        ArrayList<Object[]> tests = new ArrayList<Object[]>();
        ArrayDeque<String> manifests = new ArrayDeque<String>();
        manifests.add(SPARQL11UpdateComplianceTest.class.getClassLoader().getResource("testcases-sparql-1.1-w3c/manifest-all.ttl").toExternalForm());
        while (!manifests.isEmpty()) {
            String pop = (String)manifests.pop();
            SPARQLUpdateTestManifest manifest = new SPARQLUpdateTestManifest(pop);
            tests.addAll(manifest.tests);
            manifests.addAll(manifest.subManifests);
        }
        Object[][] result = new Object[tests.size()][6];
        tests.toArray((T[])result);
        return result;
    }

    @Override
    protected void runTest() throws Exception {
        logger.debug("running {}", (Object)this.getName());
        RepositoryConnection con = this.dataRep.getConnection();
        RepositoryConnection erCon = this.expectedResultRepo.getConnection();
        try {
            String updateString = this.readUpdateString();
            con.begin();
            Update update = con.prepareUpdate(QueryLanguage.SPARQL, updateString, this.requestFile);
            Assertions.assertThatNoException().isThrownBy(() -> {
                int hashCode = update.hashCode();
                if (hashCode == System.identityHashCode(update)) {
                    throw new UnsupportedOperationException("hashCode() result is the same as  the identityHashCode in " + update.getClass().getName());
                }
            });
            update.setDataset(this.dataset);
            update.execute();
            con.commit();
            logger.info("checking default graph");
            this.compareGraphs(Iterations.asList((CloseableIteration)con.getStatements(null, null, null, true, new Resource[]{null})), Iterations.asList((CloseableIteration)erCon.getStatements(null, null, null, true, new Resource[]{null})));
            for (String namedGraph : this.inputNamedGraphs.keySet()) {
                logger.info("checking named graph {}", (Object)namedGraph);
                IRI contextURI = con.getValueFactory().createIRI(namedGraph.replaceAll("\"", ""));
                this.compareGraphs(Iterations.asList((CloseableIteration)con.getStatements(null, null, null, true, new Resource[]{contextURI})), Iterations.asList((CloseableIteration)erCon.getStatements(null, null, null, true, new Resource[]{contextURI})));
            }
        }
        catch (Exception e) {
            if (con.isActive()) {
                con.rollback();
            }
            throw e;
        }
        finally {
            con.close();
            erCon.close();
        }
    }

    private String readUpdateString() throws IOException {
        try (InputStream stream = new URL(this.requestFile).openStream();){
            String string = IOUtil.readString((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8));
            return string;
        }
    }

    static class SPARQLUpdateTestManifest {
        List<Object[]> tests = new ArrayList<Object[]>();
        List<String> subManifests = new ArrayList<String>();

        public SPARQLUpdateTestManifest(String filename) {
            SailRepositoryConnection connection;
            SailRepository sailRepository = new SailRepository((Sail)new MemoryStore());
            try {
                connection = sailRepository.getConnection();
                try {
                    connection.add(new URL(filename), filename, RDFFormat.TURTLE, new Resource[0]);
                }
                finally {
                    if (connection != null) {
                        connection.close();
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            connection = sailRepository.getConnection();
            try {
                String manifestQuery = " PREFIX qt: <http://www.w3.org/2001/sw/DataAccess/tests/test-query#> PREFIX mf: <http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#> SELECT DISTINCT ?manifestFile WHERE { [] mf:include [ rdf:rest*/rdf:first ?manifestFile ] . }   ";
                try (TupleQueryResult manifestResults = connection.prepareTupleQuery(QueryLanguage.SPARQL, manifestQuery, filename).evaluate();){
                    for (BindingSet bindingSet : manifestResults) {
                        String subManifestFile = bindingSet.getValue("manifestFile").stringValue();
                        if (!SPARQLComplianceTest.includeSubManifest(subManifestFile, excludedSubdirs)) continue;
                        this.subManifests.add(subManifestFile);
                    }
                }
                StringBuilder query = new StringBuilder(512);
                query.append("PREFIX mf: <http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#> \n ");
                query.append("PREFIX dawgt: <http://www.w3.org/2001/sw/DataAccess/tests/test-dawg#> \n");
                query.append("PREFIX qt:  <http://www.w3.org/2001/sw/DataAccess/tests/test-query#> \n");
                query.append("PREFIX ut: <http://www.w3.org/2009/sparql/tests/test-update#> \n");
                query.append("PREFIX sd: <http://www.w3.org/ns/sparql-service-description#>\n ");
                query.append("PREFIX ent: <http://www.w3.org/ns/entailment/> \n");
                query.append(" SELECT DISTINCT ?testURI ?testName ?result ?action ?requestFile ?defaultGraph ?resultDefaultGraph ");
                query.append(" wHERE { [] rdf:first ?testURI. ?testURI a mf:UpdateEvaluationTest .\n");
                query.append("         ?testURI  dawgt:approval dawgt:Approved; \n");
                query.append("                   mf:name ?testName; \n");
                query.append("                   mf:action ?action . \n");
                query.append("         ?action ut:request ?requestFile. \n");
                query.append("         OPTIONAL { ?action ut:data ?defaultGraph } \n");
                query.append("         ?testURI mf:result ?result. \n");
                query.append("         OPTIONAL { ?result ut:data ?resultDefaultGraph } \n");
                query.append("}");
                try (TupleQueryResult result = connection.prepareTupleQuery(query.toString()).evaluate();){
                    query.setLength(0);
                    query.append(" PREFIX ut: <http://www.w3.org/2009/sparql/tests/test-update#> \n");
                    query.append(" SELECT DISTINCT ?namedGraphData ?namedGraphLabel \n");
                    query.append(" WHERE { ?graphDef ut:graphData [ ut:graph ?namedGraphData ; \n ");
                    query.append("                                  rdfs:label ?namedGraphLabel ]. }\n ");
                    TupleQuery namedGraphsQuery = connection.prepareTupleQuery(query.toString());
                    for (BindingSet bs : result) {
                        String testName = bs.getValue("testName").stringValue();
                        String displayName = filename.substring(filename.lastIndexOf("testcases-sparql-1.1-w3c/") + "testcases-sparql-1.1-w3c/".length(), filename.lastIndexOf("/")) + ": " + testName;
                        IRI testURI = (IRI)bs.getValue("testURI");
                        Value testResult = bs.getValue("result");
                        Value action = bs.getValue("action");
                        IRI requestFile = (IRI)bs.getValue("requestFile");
                        IRI defaultGraphURI = (IRI)bs.getValue("defaultGraph");
                        IRI resultDefaultGraphURI = (IRI)bs.getValue("resultDefaultGraph");
                        Object dataset = null;
                        namedGraphsQuery.setBinding("graphDef", action);
                        TupleQueryResult inputNamedGraphsResult = namedGraphsQuery.evaluate();
                        HashMap<String, IRI> inputNamedGraphs = new HashMap<String, IRI>();
                        if (inputNamedGraphsResult.hasNext()) {
                            while (inputNamedGraphsResult.hasNext()) {
                                BindingSet graphBindings = (BindingSet)inputNamedGraphsResult.next();
                                IRI namedGraphData = (IRI)graphBindings.getValue("namedGraphData");
                                String namedGraphLabel = ((Literal)graphBindings.getValue("namedGraphLabel")).getLabel();
                                logger.debug(" adding named graph : {}", (Object)namedGraphLabel);
                                inputNamedGraphs.put(namedGraphLabel, namedGraphData);
                            }
                        }
                        namedGraphsQuery.setBinding("graphDef", testResult);
                        TupleQueryResult resultNamedGraphsResult = namedGraphsQuery.evaluate();
                        HashMap<String, IRI> resultNamedGraphs = new HashMap<String, IRI>();
                        if (resultNamedGraphsResult.hasNext()) {
                            while (resultNamedGraphsResult.hasNext()) {
                                BindingSet graphBindings = (BindingSet)resultNamedGraphsResult.next();
                                IRI namedGraphData = (IRI)graphBindings.getValue("namedGraphData");
                                String namedGraphLabel = ((Literal)graphBindings.getValue("namedGraphLabel")).getLabel();
                                logger.debug(" adding named graph : {}", (Object)namedGraphLabel);
                                resultNamedGraphs.put(namedGraphLabel, namedGraphData);
                            }
                        }
                        this.tests.add(new Object[]{displayName, testURI.stringValue(), testName, requestFile.stringValue(), defaultGraphURI, inputNamedGraphs, resultDefaultGraphURI, resultNamedGraphs});
                    }
                }
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
    }
}

