/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.testsuite.sparql.tests;

import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.OWL;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.impl.SimpleDataset;
import org.eclipse.rdf4j.testsuite.sparql.AbstractComplianceTest;
import org.eclipse.rdf4j.testsuite.sparql.vocabulary.EX;
import org.junit.Assert;
import org.junit.Test;

public class ArbitraryLengthPathTest
extends AbstractComplianceTest {
    @Test
    public void testArbitraryLengthPathWithBinding1() throws Exception {
        this.loadTestData("/testdata-query/alp-testdata.ttl", new Resource[0]);
        String query = this.getNamespaceDeclarations() + "SELECT ?parent ?child WHERE { ?child a owl:Class . ?child rdfs:subClassOf+ ?parent . }";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                ++count;
                BindingSet bs = (BindingSet)result.next();
                Assert.assertTrue((boolean)bs.hasBinding("child"));
                Assert.assertTrue((boolean)bs.hasBinding("parent"));
            }
            Assert.assertEquals((long)7L, (long)count);
            tq.setBinding("parent", (Value)OWL.THING);
            try (TupleQueryResult result2 = tq.evaluate();){
                Assert.assertNotNull((Object)result2);
                count = 0;
                while (result2.hasNext()) {
                    ++count;
                    BindingSet bs = (BindingSet)result2.next();
                    Assert.assertTrue((boolean)bs.hasBinding("child"));
                    Assert.assertTrue((boolean)bs.hasBinding("parent"));
                }
                Assert.assertEquals((long)4L, (long)count);
            }
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testArbitraryLengthPathWithBinding2() throws Exception {
        this.loadTestData("/testdata-query/alp-testdata.ttl", new Resource[0]);
        String query = this.getNamespaceDeclarations() + "SELECT ?parent ?child WHERE { ?child rdfs:subClassOf+ ?parent . }";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                ++count;
                BindingSet bs = (BindingSet)result.next();
                Assert.assertTrue((boolean)bs.hasBinding("child"));
                Assert.assertTrue((boolean)bs.hasBinding("parent"));
            }
            Assert.assertEquals((long)7L, (long)count);
            tq.setBinding("parent", (Value)OWL.THING);
            try (TupleQueryResult result2 = tq.evaluate();){
                Assert.assertNotNull((Object)result2);
                count = 0;
                while (result2.hasNext()) {
                    ++count;
                    BindingSet bs = (BindingSet)result2.next();
                    Assert.assertTrue((boolean)bs.hasBinding("child"));
                    Assert.assertTrue((boolean)bs.hasBinding("parent"));
                }
                Assert.assertEquals((long)4L, (long)count);
            }
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testArbitraryLengthPathWithBinding3() throws Exception {
        this.loadTestData("/testdata-query/alp-testdata.ttl", new Resource[0]);
        String query = this.getNamespaceDeclarations() + "SELECT ?parent ?child WHERE { ?child rdfs:subClassOf+ ?parent . }";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                ++count;
                BindingSet bs = (BindingSet)result.next();
                Assert.assertTrue((boolean)bs.hasBinding("child"));
                Assert.assertTrue((boolean)bs.hasBinding("parent"));
            }
            Assert.assertEquals((long)7L, (long)count);
            tq.setBinding("child", (Value)EX.C);
            try (TupleQueryResult result2 = tq.evaluate();){
                Assert.assertNotNull((Object)result2);
                count = 0;
                while (result2.hasNext()) {
                    ++count;
                    BindingSet bs = (BindingSet)result2.next();
                    Assert.assertTrue((boolean)bs.hasBinding("child"));
                    Assert.assertTrue((boolean)bs.hasBinding("parent"));
                }
                Assert.assertEquals((long)2L, (long)count);
            }
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testArbitraryLengthPathWithBinding4() throws Exception {
        this.loadTestData("/testdata-query/alp-testdata.ttl", new Resource[]{EX.ALICE});
        String query = this.getNamespaceDeclarations() + "SELECT ?parent ?child WHERE { ?child rdfs:subClassOf+ ?parent . }";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                ++count;
                BindingSet bs = (BindingSet)result.next();
                Assert.assertTrue((boolean)bs.hasBinding("child"));
                Assert.assertTrue((boolean)bs.hasBinding("parent"));
            }
            Assert.assertEquals((long)7L, (long)count);
            tq.setBinding("child", (Value)EX.C);
            try (TupleQueryResult result2 = tq.evaluate();){
                Assert.assertNotNull((Object)result2);
                count = 0;
                while (result2.hasNext()) {
                    ++count;
                    BindingSet bs = (BindingSet)result2.next();
                    Assert.assertTrue((boolean)bs.hasBinding("child"));
                    Assert.assertTrue((boolean)bs.hasBinding("parent"));
                }
                Assert.assertEquals((long)2L, (long)count);
            }
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testArbitraryLengthPathWithBinding5() throws Exception {
        this.loadTestData("/testdata-query/alp-testdata.ttl", new Resource[]{EX.ALICE, EX.BOB});
        String query = this.getNamespaceDeclarations() + "SELECT ?parent ?child WHERE { ?child rdfs:subClassOf+ ?parent . }";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                ++count;
                BindingSet bs = (BindingSet)result.next();
                Assert.assertTrue((boolean)bs.hasBinding("child"));
                Assert.assertTrue((boolean)bs.hasBinding("parent"));
            }
            Assert.assertEquals((long)7L, (long)count);
            tq.setBinding("child", (Value)EX.C);
            try (TupleQueryResult result2 = tq.evaluate();){
                Assert.assertNotNull((Object)result2);
                count = 0;
                while (result2.hasNext()) {
                    ++count;
                    BindingSet bs = (BindingSet)result2.next();
                    Assert.assertTrue((boolean)bs.hasBinding("child"));
                    Assert.assertTrue((boolean)bs.hasBinding("parent"));
                }
                Assert.assertEquals((long)2L, (long)count);
            }
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testArbitraryLengthPathWithBinding6() throws Exception {
        this.loadTestData("/testdata-query/alp-testdata.ttl", new Resource[]{EX.ALICE, EX.BOB, EX.MARY});
        String query = this.getNamespaceDeclarations() + "SELECT ?parent ?child WHERE { ?child rdfs:subClassOf+ ?parent . }";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                ++count;
                BindingSet bs = (BindingSet)result.next();
                Assert.assertTrue((boolean)bs.hasBinding("child"));
                Assert.assertTrue((boolean)bs.hasBinding("parent"));
            }
            Assert.assertEquals((long)7L, (long)count);
            tq.setBinding("child", (Value)EX.C);
            try (TupleQueryResult result2 = tq.evaluate();){
                Assert.assertNotNull((Object)result2);
                count = 0;
                while (result2.hasNext()) {
                    ++count;
                    BindingSet bs = (BindingSet)result2.next();
                    Assert.assertTrue((boolean)bs.hasBinding("child"));
                    Assert.assertTrue((boolean)bs.hasBinding("parent"));
                }
                Assert.assertEquals((long)2L, (long)count);
            }
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testArbitraryLengthPathWithBinding7() throws Exception {
        this.loadTestData("/testdata-query/alp-testdata.ttl", new Resource[]{EX.ALICE, EX.BOB, EX.MARY});
        String query = this.getNamespaceDeclarations() + "SELECT ?parent ?child WHERE { ?child rdfs:subClassOf+ ?parent . }";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        SimpleDataset dt = new SimpleDataset();
        dt.addDefaultGraph(EX.ALICE);
        tq.setDataset((Dataset)dt);
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                ++count;
                BindingSet bs = (BindingSet)result.next();
                Assert.assertTrue((boolean)bs.hasBinding("child"));
                Assert.assertTrue((boolean)bs.hasBinding("parent"));
            }
            Assert.assertEquals((long)7L, (long)count);
            tq.setBinding("child", (Value)EX.C);
            try (TupleQueryResult result2 = tq.evaluate();){
                Assert.assertNotNull((Object)result2);
                count = 0;
                while (result2.hasNext()) {
                    ++count;
                    BindingSet bs = (BindingSet)result2.next();
                    Assert.assertTrue((boolean)bs.hasBinding("child"));
                    Assert.assertTrue((boolean)bs.hasBinding("parent"));
                }
                Assert.assertEquals((long)2L, (long)count);
            }
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testArbitraryLengthPathWithBinding8() throws Exception {
        this.loadTestData("/testdata-query/alp-testdata.ttl", new Resource[]{EX.ALICE, EX.BOB, EX.MARY});
        String query = this.getNamespaceDeclarations() + "SELECT ?parent ?child WHERE { ?child rdfs:subClassOf+ ?parent . }";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        SimpleDataset dt = new SimpleDataset();
        dt.addDefaultGraph(EX.ALICE);
        dt.addDefaultGraph(EX.BOB);
        tq.setDataset((Dataset)dt);
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                ++count;
                BindingSet bs = (BindingSet)result.next();
                Assert.assertTrue((boolean)bs.hasBinding("child"));
                Assert.assertTrue((boolean)bs.hasBinding("parent"));
            }
            Assert.assertEquals((long)7L, (long)count);
            tq.setBinding("child", (Value)EX.C);
            try (TupleQueryResult result2 = tq.evaluate();){
                Assert.assertNotNull((Object)result2);
                count = 0;
                while (result2.hasNext()) {
                    ++count;
                    BindingSet bs = (BindingSet)result2.next();
                    Assert.assertTrue((boolean)bs.hasBinding("child"));
                    Assert.assertTrue((boolean)bs.hasBinding("parent"));
                }
                Assert.assertEquals((long)2L, (long)count);
            }
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testArbitraryLengthPathWithFilter1() throws Exception {
        this.loadTestData("/testdata-query/alp-testdata.ttl", new Resource[0]);
        String query = this.getNamespaceDeclarations() + "SELECT ?parent ?child WHERE { ?child a owl:Class . ?child rdfs:subClassOf+ ?parent . FILTER (?parent = owl:Thing) }";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                ++count;
                BindingSet bs = (BindingSet)result.next();
                Assert.assertTrue((boolean)bs.hasBinding("child"));
                Assert.assertTrue((boolean)bs.hasBinding("parent"));
            }
            Assert.assertEquals((long)4L, (long)count);
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testArbitraryLengthPathWithFilter2() throws Exception {
        this.loadTestData("/testdata-query/alp-testdata.ttl", new Resource[0]);
        String query = this.getNamespaceDeclarations() + "SELECT ?parent ?child WHERE { ?child rdfs:subClassOf+ ?parent . FILTER (?parent = owl:Thing) }";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                ++count;
                BindingSet bs = (BindingSet)result.next();
                Assert.assertTrue((boolean)bs.hasBinding("child"));
                Assert.assertTrue((boolean)bs.hasBinding("parent"));
            }
            Assert.assertEquals((long)4L, (long)count);
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testArbitraryLengthPathWithFilter3() throws Exception {
        this.loadTestData("/testdata-query/alp-testdata.ttl", new Resource[0]);
        String query = this.getNamespaceDeclarations() + "SELECT ?parent ?child WHERE { ?child rdfs:subClassOf+ ?parent . FILTER (?child = <http://example.org/C>) }";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                ++count;
                BindingSet bs = (BindingSet)result.next();
                Assert.assertTrue((boolean)bs.hasBinding("child"));
                Assert.assertTrue((boolean)bs.hasBinding("parent"));
            }
            Assert.assertEquals((long)2L, (long)count);
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testPropertyPathInTree() throws Exception {
        this.loadTestData("/testdata-query/dataset-query.trig", new Resource[0]);
        String query = this.getNamespaceDeclarations() + " SELECT ?node ?name  FROM ex:tree-graph  WHERE { ?node ex:hasParent+ ex:b . ?node ex:name ?name . }";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            while (result.hasNext()) {
                BindingSet bs = (BindingSet)result.next();
                Assert.assertNotNull((Object)bs);
            }
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

