/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.testsuite.sparql.tests;

import java.io.Reader;
import java.io.StringReader;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.testsuite.sparql.AbstractComplianceTest;
import org.junit.Assert;
import org.junit.Test;

public class OrderByTest
extends AbstractComplianceTest {
    @Test
    public void testDistinctOptionalOrderBy() throws Exception {
        this.conn.add((Reader)new StringReader("[] a <test:Class>.\n[] a <test:Class>; <test:nr> 123 ."), "", RDFFormat.TURTLE, new Resource[0]);
        String query = "select distinct ?o ?nr { ?o a <test:Class> optional { ?o <test:nr> ?nr } } order by ?nr";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (Stream result = tq.evaluate().stream();){
            long count = result.count();
            Assert.assertEquals((long)2L, (long)count);
        }
    }

    @Test
    public void testOrderByVariableNotInUse() throws Exception {
        this.conn.add((Reader)new StringReader("_:bob1 a <foaf:Person> ; rdfs:label \"Bob1\" .\n_:bob2 a <foaf:Person> ; rdfs:label \"Bob2\" ."), "", RDFFormat.TURTLE, new Resource[0]);
        String query = "SELECT * WHERE { ?person a <foaf:Person> } ORDER BY ?score\n";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (Stream result = tq.evaluate().stream();){
            long count = result.distinct().count();
            Assert.assertEquals((long)2L, (long)count);
        }
    }

    @Test
    public void testDistinctOptionalOrderByMath() throws Exception {
        this.conn.add((Reader)new StringReader("[] a <test:Class>.\n[] a <test:Class>; <test:nr> 123 ."), "", RDFFormat.TURTLE, new Resource[0]);
        String query = "select distinct ?o ?nr { ?o a <test:Class> optional { ?o <test:nr> ?nr } } order by (?nr + STRLEN(?o))";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (Stream result = tq.evaluate().stream();){
            long count = result.count();
            Assert.assertEquals((long)2L, (long)count);
        }
    }
}

