/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.testsuite.sparql.tests;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.testsuite.sparql.AbstractComplianceTest;
import org.junit.Assert;
import org.junit.Test;

public class MinusTest
extends AbstractComplianceTest {
    @Test
    public void testScopingOfFilterInMinus() {
        String ex = "http://example/";
        IRI a1 = Values.iri((String)ex, (String)"a1");
        IRI a2 = Values.iri((String)ex, (String)"a2");
        IRI both = Values.iri((String)ex, (String)"both");
        IRI predicate1 = Values.iri((String)ex, (String)"predicate1");
        IRI predicate2 = Values.iri((String)ex, (String)"predicate2");
        this.conn.add((Resource)a1, predicate1, (Value)both, new Resource[0]);
        this.conn.add((Resource)a1, predicate2, (Value)both, new Resource[0]);
        this.conn.add((Resource)a2, predicate1, (Value)both, new Resource[0]);
        this.conn.add((Resource)a2, predicate2, (Value)Values.bnode(), new Resource[0]);
        TupleQuery tupleQuery = this.conn.prepareTupleQuery("PREFIX : <http://example/>\nSELECT * WHERE {\n  ?a :predicate1 ?p1\n  MINUS {\n    ?a :predicate2 ?p2 .\n    FILTER(?p2 = ?p1)\n  }\n} ORDER BY ?a\n");
        try (Stream stream = tupleQuery.evaluate().stream();){
            List collect = stream.collect(Collectors.toList());
            Assert.assertEquals((long)2L, (long)collect.size());
            List<IRI> expectedValues = List.of(a1, a2);
            List actualValues = collect.stream().map(b -> b.getValue("a")).collect(Collectors.toList());
            Assert.assertEquals(expectedValues, actualValues);
        }
    }
}

