/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.testsuite.sparql.tests;

import java.math.BigDecimal;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.FOAF;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.QueryResult;
import org.eclipse.rdf4j.query.QueryResults;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.testsuite.sparql.AbstractComplianceTest;
import org.junit.Assert;
import org.junit.Test;

public class AggregateTest
extends AbstractComplianceTest {
    @Test
    public void testMaxAggregateWithGroupEmptyResult() {
        String query = "select ?s (max(?o) as ?omax) {\n   ?s ?p ?o .\n }\n group by ?s\n";
        try (TupleQueryResult result = this.conn.prepareTupleQuery(query).evaluate();){
            Assertions.assertThat((boolean)result.hasNext()).isFalse();
        }
    }

    @Test
    public void testMaxAggregateWithoutGroupEmptySolution() {
        String query = "select (max(?o) as ?omax) {\n   ?s ?p ?o .\n }\n";
        try (TupleQueryResult result = this.conn.prepareTupleQuery(query).evaluate();){
            Assertions.assertThat((Iterable)((Iterable)result.next())).isEmpty();
        }
    }

    @Test
    public void testMinAggregateWithGroupEmptyResult() {
        String query = "select ?s (min(?o) as ?omin) {\n   ?s ?p ?o .\n }\n group by ?s\n";
        try (TupleQueryResult result = this.conn.prepareTupleQuery(query).evaluate();){
            Assertions.assertThat((boolean)result.hasNext()).isFalse();
        }
    }

    @Test
    public void testMinAggregateWithoutGroupEmptySolution() {
        String query = "select (min(?o) as ?omin) {\n   ?s ?p ?o .\n }\n";
        try (TupleQueryResult result = this.conn.prepareTupleQuery(query).evaluate();){
            Assertions.assertThat((Iterable)((Iterable)result.next())).isEmpty();
        }
    }

    @Test
    public void testSampleAggregateWithGroupEmptyResult() {
        String query = "select ?s (sample(?o) as ?osample) {\n   ?s ?p ?o .\n }\n group by ?s\n";
        try (TupleQueryResult result = this.conn.prepareTupleQuery(query).evaluate();){
            Assertions.assertThat((boolean)result.hasNext()).isFalse();
        }
    }

    @Test
    public void testSampleAggregateWithoutGroupEmptySolution() {
        String query = "select (sample(?o) as ?osample) {\n   ?s ?p ?o .\n }\n";
        try (TupleQueryResult result = this.conn.prepareTupleQuery(query).evaluate();){
            Assertions.assertThat((Iterable)((Iterable)result.next())).isEmpty();
        }
    }

    @Test
    public void testSES2361UndefMin() {
        String query = "SELECT (MIN(?v) as ?min) WHERE { VALUES ?v { 1 2 undef 3 4 }}";
        try (TupleQueryResult result = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query).evaluate();){
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)result.hasNext());
            Assert.assertEquals((Object)"1", (Object)((BindingSet)result.next()).getValue("min").stringValue());
            Assert.assertFalse((boolean)result.hasNext());
        }
    }

    @Test
    public void testSES2361UndefMax() {
        String query = "SELECT (MAX(?v) as ?max) WHERE { VALUES ?v { 1 2 7 undef 3 4 }}";
        try (TupleQueryResult result = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query).evaluate();){
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)result.hasNext());
            Assert.assertEquals((Object)"7", (Object)((BindingSet)result.next()).getValue("max").stringValue());
            Assert.assertFalse((boolean)result.hasNext());
        }
    }

    @Test
    public void testSES2361UndefCount() {
        String query = "SELECT (COUNT(?v) as ?c) WHERE { VALUES ?v { 1 2 undef 3 4 }}";
        try (TupleQueryResult result = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query).evaluate();){
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)result.hasNext());
            Assert.assertEquals((Object)"4", (Object)((BindingSet)result.next()).getValue("c").stringValue());
            Assert.assertFalse((boolean)result.hasNext());
        }
    }

    @Test
    public void testSES2361UndefCountWildcard() {
        String query = "SELECT (COUNT(*) as ?c) WHERE { VALUES ?v { 1 2 undef 3 4 }}";
        try (TupleQueryResult result = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query).evaluate();){
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)result.hasNext());
            Assert.assertEquals((Object)"4", (Object)((BindingSet)result.next()).getValue("c").stringValue());
            Assert.assertFalse((boolean)result.hasNext());
        }
    }

    @Test
    public void testSES2361UndefSum() {
        String query = "SELECT (SUM(?v) as ?s) WHERE { VALUES ?v { 1 2 undef 3 4 }}";
        try (TupleQueryResult result = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query).evaluate();){
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)result.hasNext());
            Assert.assertEquals((Object)"10", (Object)((BindingSet)result.next()).getValue("s").stringValue());
            Assert.assertFalse((boolean)result.hasNext());
        }
    }

    @Test
    public void testSES1979MinMaxInf() throws Exception {
        this.loadTestData("/testdata-query/dataset-ses1979.trig", new Resource[0]);
        String query = "prefix : <http://example.org/> select (min(?o) as ?min) (max(?o) as ?max) where { ?s :float ?o }";
        ValueFactory vf = this.conn.getValueFactory();
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult evaluate = tq.evaluate();){
            List result = QueryResults.asList((QueryResult)evaluate);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertEquals((Object)vf.createLiteral(Float.NEGATIVE_INFINITY), (Object)((BindingSet)result.get(0)).getValue("min"));
            Assert.assertEquals((Object)vf.createLiteral(Float.POSITIVE_INFINITY), (Object)((BindingSet)result.get(0)).getValue("max"));
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGroupConcatDistinct() throws Exception {
        this.loadTestData("/testdata-query/dataset-query.trig", new Resource[0]);
        String query = this.getNamespaceDeclarations() + "SELECT (GROUP_CONCAT(DISTINCT ?l) AS ?concat)WHERE { ex:groupconcat-test ?p ?l . }";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            while (result.hasNext()) {
                BindingSet bs = (BindingSet)result.next();
                Assert.assertNotNull((Object)bs);
                Value concat = bs.getValue("concat");
                Assert.assertTrue((boolean)(concat instanceof Literal));
                String lexValue = ((Literal)concat).getLabel();
                int occ = this.countCharOccurrences(lexValue, 'a');
                Assert.assertEquals((long)1L, (long)occ);
                occ = this.countCharOccurrences(lexValue, 'b');
                Assert.assertEquals((long)1L, (long)occ);
                occ = this.countCharOccurrences(lexValue, 'c');
                Assert.assertEquals((long)1L, (long)occ);
                occ = this.countCharOccurrences(lexValue, 'd');
                Assert.assertEquals((long)1L, (long)occ);
            }
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGroupConcatNonDistinct() throws Exception {
        this.loadTestData("/testdata-query/dataset-query.trig", new Resource[0]);
        String query = this.getNamespaceDeclarations() + "SELECT (GROUP_CONCAT(?l) AS ?concat)WHERE { ex:groupconcat-test ?p ?l . }";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            while (result.hasNext()) {
                BindingSet bs = (BindingSet)result.next();
                Assert.assertNotNull((Object)bs);
                Value concat = bs.getValue("concat");
                Assert.assertTrue((boolean)(concat instanceof Literal));
                String lexValue = ((Literal)concat).getLabel();
                int occ = this.countCharOccurrences(lexValue, 'a');
                Assert.assertEquals((long)1L, (long)occ);
                occ = this.countCharOccurrences(lexValue, 'b');
                Assert.assertEquals((long)2L, (long)occ);
                occ = this.countCharOccurrences(lexValue, 'c');
                Assert.assertEquals((long)2L, (long)occ);
                occ = this.countCharOccurrences(lexValue, 'd');
                Assert.assertEquals((long)1L, (long)occ);
            }
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSES1970CountDistinctWildcard() throws Exception {
        this.loadTestData("/testdata-query/dataset-ses1970.trig", new Resource[0]);
        String query = "SELECT (COUNT(DISTINCT *) AS ?c) {?s ?p ?o }";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)result.hasNext());
            BindingSet s = (BindingSet)result.next();
            Literal count = (Literal)s.getValue("c");
            Assert.assertNotNull((Object)count);
            Assert.assertEquals((long)3L, (long)count.intValue());
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCountHaving() {
        BNode bnode1 = Values.bnode();
        BNode bnode2 = Values.bnode();
        BNode bnode3 = Values.bnode();
        this.conn.add((Resource)bnode3, FOAF.KNOWS, (Value)Values.bnode(), new Resource[0]);
        this.conn.add((Resource)bnode1, FOAF.KNOWS, (Value)Values.bnode(), new Resource[0]);
        this.conn.add((Resource)bnode1, FOAF.KNOWS, (Value)Values.bnode(), new Resource[0]);
        this.conn.add((Resource)bnode2, FOAF.KNOWS, (Value)Values.bnode(), new Resource[0]);
        this.conn.add((Resource)bnode3, FOAF.KNOWS, (Value)Values.bnode(), new Resource[0]);
        this.conn.add((Resource)bnode3, FOAF.KNOWS, (Value)Values.bnode(), new Resource[0]);
        this.conn.add((Resource)bnode1, FOAF.KNOWS, (Value)Values.bnode(), new Resource[0]);
        String query = "SELECT ?a WHERE { ?a ?b ?c } GROUP BY ?a HAVING( (COUNT(?c) > 1 ) && ( COUNT(?c)  != 0 ) ) ";
        try (TupleQueryResult result = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query).evaluate();){
            List collect = QueryResults.asList((QueryResult)result);
            Assert.assertEquals((long)2L, (long)collect.size());
        }
    }

    @Test
    public void testSum() {
        this.mixedDataForNumericAggregates();
        String query = "SELECT ?a (SUM(?c) as ?aggregate) WHERE { ?a ?b ?c } GROUP BY ?a ORDER BY ?aggregate ";
        try (TupleQueryResult result = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query).evaluate();){
            List collect = QueryResults.asList((QueryResult)result);
            int i = 0;
            Assert.assertNull((Object)((BindingSet)collect.get(i++)).getValue("aggregate"));
            Assert.assertNull((Object)((BindingSet)collect.get(i++)).getValue("aggregate"));
            Assert.assertNull((Object)((BindingSet)collect.get(i++)).getValue("aggregate"));
            Assert.assertEquals((Object)Values.literal((double)30.11), (Object)((BindingSet)collect.get(i++)).getValue("aggregate"));
            Assert.assertEquals((Object)Values.literal((BigDecimal)new BigDecimal("89.4786576482391284723864721567342354783275234")), (Object)((BindingSet)collect.get(i++)).getValue("aggregate"));
        }
    }

    @Test
    public void testDistinctSum() {
        this.mixedDataForNumericAggregates();
        String query = "SELECT ?a (SUM(DISTINCT ?c) as ?aggregate) WHERE { ?a ?b ?c } GROUP BY ?a ORDER BY ?aggregate ";
        try (TupleQueryResult result = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query).evaluate();){
            List collect = QueryResults.asList((QueryResult)result);
            int i = 0;
            Assert.assertNull((Object)((BindingSet)collect.get(i++)).getValue("aggregate"));
            Assert.assertNull((Object)((BindingSet)collect.get(i++)).getValue("aggregate"));
            Assert.assertNull((Object)((BindingSet)collect.get(i++)).getValue("aggregate"));
            Assert.assertEquals((Object)Values.literal((double)30.11), (Object)((BindingSet)collect.get(i++)).getValue("aggregate"));
            Assert.assertEquals((Object)Values.literal((BigDecimal)new BigDecimal("55.4786576482391284723864721567342354783275234")), (Object)((BindingSet)collect.get(i++)).getValue("aggregate"));
        }
    }

    @Test
    public void testAvg() {
        this.mixedDataForNumericAggregates();
        String query = "SELECT ?a (AVG(?c) as ?aggregate) WHERE { ?a ?b ?c } GROUP BY ?a ORDER BY ?aggregate ";
        try (TupleQueryResult result = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query).evaluate();){
            List collect = QueryResults.asList((QueryResult)result);
            int i = 0;
            Assert.assertNull((Object)((BindingSet)collect.get(i++)).getValue("aggregate"));
            Assert.assertNull((Object)((BindingSet)collect.get(i++)).getValue("aggregate"));
            Assert.assertNull((Object)((BindingSet)collect.get(i++)).getValue("aggregate"));
            Assert.assertEquals((Object)Values.literal((double)15.055), (Object)((BindingSet)collect.get(i++)).getValue("aggregate"));
            Assert.assertEquals((Object)Values.literal((BigDecimal)new BigDecimal("17.89573152964782569447729443134684709566550468")), (Object)((BindingSet)collect.get(i++)).getValue("aggregate"));
        }
    }

    @Test
    public void testDistinctAvg() {
        this.mixedDataForNumericAggregates();
        String query = "SELECT ?a (AVG(DISTINCT ?c) as ?aggregate) WHERE { ?a ?b ?c } GROUP BY ?a ORDER BY ?aggregate ";
        try (TupleQueryResult result = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query).evaluate();){
            List collect = QueryResults.asList((QueryResult)result);
            int i = 0;
            Assert.assertNull((Object)((BindingSet)collect.get(i++)).getValue("aggregate"));
            Assert.assertNull((Object)((BindingSet)collect.get(i++)).getValue("aggregate"));
            Assert.assertNull((Object)((BindingSet)collect.get(i++)).getValue("aggregate"));
            Assert.assertEquals((Object)Values.literal((double)15.055), (Object)((BindingSet)collect.get(i++)).getValue("aggregate"));
            Assert.assertEquals((Object)Values.literal((BigDecimal)new BigDecimal("18.492885882746376157462157")), (Object)((BindingSet)collect.get(i++)).getValue("aggregate"));
        }
    }

    @Test
    public void testMax() {
        this.mixedDataForNumericAggregates();
        String query = "SELECT ?a (MAX(?c) as ?aggregate) WHERE { ?a ?b ?c } GROUP BY ?a ORDER BY ?aggregate ";
        try (TupleQueryResult result = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query).evaluate();){
            List collect = QueryResults.asList((QueryResult)result);
            int i = 0;
            Assert.assertEquals((Object)Values.literal((BigDecimal)new BigDecimal("19.4786576482391284723864721567342354783275234")), (Object)((BindingSet)collect.get(i++)).getValue("aggregate"));
            Assert.assertEquals((Object)Values.literal((int)23), (Object)((BindingSet)collect.get(i++)).getValue("aggregate"));
            Assert.assertEquals((Object)Values.literal((int)23), (Object)((BindingSet)collect.get(i++)).getValue("aggregate"));
            Assert.assertEquals((Object)Values.literal((String)"2022-01-01T01:01:01.000000001Z", (CoreDatatype)CoreDatatype.XSD.DATETIME), (Object)((BindingSet)collect.get(i++)).getValue("aggregate"));
            Assert.assertEquals((Object)Values.literal((String)"3"), (Object)((BindingSet)collect.get(i++)).getValue("aggregate"));
        }
    }

    @Test
    public void testDistinctMax() {
        this.mixedDataForNumericAggregates();
        String query = "SELECT ?a (MAX(DISTINCT ?c) as ?aggregate) WHERE { ?a ?b ?c } GROUP BY ?a ORDER BY ?aggregate ";
        try (TupleQueryResult result = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query).evaluate();){
            List collect = QueryResults.asList((QueryResult)result);
            int i = 0;
            Assert.assertEquals((Object)Values.literal((BigDecimal)new BigDecimal("19.4786576482391284723864721567342354783275234")), (Object)((BindingSet)collect.get(i++)).getValue("aggregate"));
            Assert.assertEquals((Object)Values.literal((int)23), (Object)((BindingSet)collect.get(i++)).getValue("aggregate"));
            Assert.assertEquals((Object)Values.literal((int)23), (Object)((BindingSet)collect.get(i++)).getValue("aggregate"));
            Assert.assertEquals((Object)Values.literal((String)"2022-01-01T01:01:01.000000001Z", (CoreDatatype)CoreDatatype.XSD.DATETIME), (Object)((BindingSet)collect.get(i++)).getValue("aggregate"));
            Assert.assertEquals((Object)Values.literal((String)"3"), (Object)((BindingSet)collect.get(i++)).getValue("aggregate"));
        }
    }

    private void mixedDataForNumericAggregates() {
        IRI node1 = Values.iri((String)"http://example.com/1");
        IRI node2 = Values.iri((String)"http://example.com/2");
        IRI node3 = Values.iri((String)"http://example.com/3");
        IRI node4 = Values.iri((String)"http://example.com/4");
        IRI node5 = Values.iri((String)"http://example.com/5");
        this.conn.add((Resource)node3, FOAF.AGE, (Value)Values.bnode(), new Resource[0]);
        this.conn.add((Resource)node1, FOAF.AGE, (Value)Values.literal((String)"3"), new Resource[0]);
        this.conn.add((Resource)node1, FOAF.AGE, (Value)Values.literal((int)5), new Resource[0]);
        this.conn.add((Resource)node2, FOAF.AGE, (Value)Values.literal((double)7.11), new Resource[0]);
        this.conn.add((Resource)node3, FOAF.AGE, (Value)Values.literal((int)13), new Resource[0]);
        this.conn.add((Resource)node3, FOAF.AGE, (Value)Values.literal((int)17), new Resource[0]);
        this.conn.add((Resource)node1, FOAF.AGE, (Value)Values.literal((int)19), new Resource[0]);
        this.conn.add((Resource)node2, FOAF.AGE, (Value)Values.literal((int)23), new Resource[0]);
        this.conn.add((Resource)node4, FOAF.AGE, (Value)Values.literal((int)19), new Resource[0]);
        this.conn.add((Resource)node4, FOAF.AGE, (Value)Values.literal((TemporalAccessor)ZonedDateTime.of(2022, 1, 1, 1, 1, 1, 1, ZoneId.of("UTC"))), new Resource[0]);
        this.conn.add((Resource)node1, FOAF.AGE, (Value)Values.literal((int)23), new Resource[0]);
        this.conn.add((Resource)node2, FOAF.AGE, (Value)Values.literal((int)23), new Resource[0]);
        this.conn.add((Resource)node3, FOAF.AGE, (Value)Values.literal((int)23), new Resource[0]);
        this.conn.add((Resource)node4, FOAF.AGE, (Value)Values.literal((int)23), new Resource[0]);
        this.conn.add((Resource)node3, FOAF.KNOWS, (Value)node1, new Resource[0]);
        this.conn.add((Resource)node5, FOAF.AGE, (Value)Values.literal((int)17), new Resource[0]);
        this.conn.add((Resource)node5, FOAF.PHONE, (Value)Values.literal((int)17), new Resource[0]);
        this.conn.add((Resource)node5, FOAF.DNA_CHECKSUM, (Value)Values.literal((int)17), new Resource[0]);
        this.conn.add((Resource)node5, FOAF.DNA_CHECKSUM, (Value)Values.literal((int)19), new Resource[0]);
        this.conn.add((Resource)node5, FOAF.PHONE, (Value)Values.literal((BigDecimal)new BigDecimal("19.4786576482391284723864721567342354783275234")), new Resource[0]);
    }

    private int countCharOccurrences(String string, char ch) {
        int count = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != ch) continue;
            ++count;
        }
        return count;
    }
}

