/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.testsuite.sparql;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.common.exception.RDF4JException;
import org.eclipse.rdf4j.common.io.FileUtil;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.config.RepositoryFactory;
import org.eclipse.rdf4j.testsuite.sparql.tests.AggregateTest;
import org.eclipse.rdf4j.testsuite.sparql.tests.ArbitraryLengthPathTest;
import org.eclipse.rdf4j.testsuite.sparql.tests.BasicTest;
import org.eclipse.rdf4j.testsuite.sparql.tests.BindTest;
import org.eclipse.rdf4j.testsuite.sparql.tests.BuiltinFunctionTest;
import org.eclipse.rdf4j.testsuite.sparql.tests.ConstructTest;
import org.eclipse.rdf4j.testsuite.sparql.tests.DefaultGraphTest;
import org.eclipse.rdf4j.testsuite.sparql.tests.DescribeTest;
import org.eclipse.rdf4j.testsuite.sparql.tests.GroupByTest;
import org.eclipse.rdf4j.testsuite.sparql.tests.InTest;
import org.eclipse.rdf4j.testsuite.sparql.tests.OptionalTest;
import org.eclipse.rdf4j.testsuite.sparql.tests.OrderByTest;
import org.eclipse.rdf4j.testsuite.sparql.tests.PropertyPathTest;
import org.eclipse.rdf4j.testsuite.sparql.tests.SubselectTest;
import org.eclipse.rdf4j.testsuite.sparql.tests.UnionTest;
import org.eclipse.rdf4j.testsuite.sparql.tests.ValuesTest;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;

@RunWith(value=Suite.class)
@Suite.SuiteClasses(value={AggregateTest.class, ArbitraryLengthPathTest.class, BasicTest.class, BindTest.class, BuiltinFunctionTest.class, ConstructTest.class, DefaultGraphTest.class, DescribeTest.class, GroupByTest.class, InTest.class, OptionalTest.class, PropertyPathTest.class, SubselectTest.class, UnionTest.class, ValuesTest.class, OrderByTest.class})
@Experimental
public abstract class RepositorySPARQLComplianceTestSuite {
    private static RepositoryFactory factory;
    private static File dataDir;

    @BeforeClass
    public static void setUpClass() throws Exception {
        System.setProperty("org.eclipse.rdf4j.repository.debug", "true");
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        System.setProperty("org.eclipse.rdf4j.repository.debug", "false");
    }

    public static void setRepositoryFactory(RepositoryFactory factory) throws IOException {
        if (dataDir != null && dataDir.isDirectory()) {
            FileUtil.deleteDir((File)dataDir);
            dataDir = null;
        }
        RepositorySPARQLComplianceTestSuite.factory = factory;
    }

    public static Repository getEmptyInitializedRepository(Class<?> caller) throws RDF4JException, IOException {
        if (dataDir != null && dataDir.isDirectory()) {
            FileUtil.deleteDir((File)dataDir);
            dataDir = null;
        }
        dataDir = Files.createTempDirectory(caller.getSimpleName(), new FileAttribute[0]).toFile();
        Repository repository = factory.getRepository(factory.getConfig());
        repository.setDataDir(dataDir);
        try (RepositoryConnection con = repository.getConnection();){
            con.clear(new Resource[0]);
            con.clearNamespaces();
        }
        return repository;
    }
}

