/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.testsuite.query.parser.sparql;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.vocabulary.DC;
import org.eclipse.rdf4j.model.vocabulary.FOAF;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDF4J;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.Update;
import org.eclipse.rdf4j.query.UpdateExecutionException;
import org.eclipse.rdf4j.query.impl.SimpleDataset;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SPARQLUpdateTest {
    protected static final Logger logger = LoggerFactory.getLogger(SPARQLUpdateTest.class);
    private Repository rep;
    protected RepositoryConnection con;
    protected ValueFactory f;
    protected IRI bob;
    protected IRI alice;
    protected IRI graph1;
    protected IRI graph2;
    protected static final String EX_NS = "http://example.org/";

    @Before
    public void setUp() throws Exception {
        logger.debug("setting up test");
        this.rep = this.createRepository();
        this.con = this.rep.getConnection();
        this.f = this.rep.getValueFactory();
        this.loadDataset("/testdata-update/dataset-update.trig");
        this.bob = this.f.createIRI(EX_NS, "bob");
        this.alice = this.f.createIRI(EX_NS, "alice");
        this.graph1 = this.f.createIRI(EX_NS, "graph1");
        this.graph2 = this.f.createIRI(EX_NS, "graph2");
        logger.debug("setup complete.");
    }

    @After
    public void tearDown() throws Exception {
        logger.debug("tearing down...");
        this.con.close();
        this.con = null;
        this.rep.shutDown();
        this.rep = null;
        logger.debug("tearDown complete.");
    }

    @Test
    public void testDeleteFromDefaultGraph() throws Exception {
        this.con.add((Resource)RDF.FIRST, RDF.FIRST, (Value)RDF.FIRST, new Resource[0]);
        this.con.add((Resource)RDF.FIRST, RDF.FIRST, (Value)RDF.FIRST, new Resource[]{RDF.ALT});
        this.con.add((Resource)RDF.FIRST, RDF.FIRST, (Value)RDF.FIRST, new Resource[]{RDF.BAG});
        String update = this.getNamespaceDeclarations() + "DELETE { GRAPH sesame:nil { ?s ?p ?o } } WHERE { GRAPH rdf:Alt { ?s ?p ?o } }";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        operation.execute();
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)RDF.FIRST, RDF.FIRST, (Value)RDF.FIRST, true, new Resource[]{RDF.ALT}));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)RDF.FIRST, RDF.FIRST, (Value)RDF.FIRST, true, new Resource[]{RDF.BAG}));
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)RDF.FIRST, RDF.FIRST, (Value)RDF.FIRST, true, new Resource[]{RDF4J.NIL}));
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)RDF.FIRST, RDF.FIRST, (Value)RDF.FIRST, true, new Resource[]{null}));
    }

    @Test
    public void testDeleteFromDefaultGraphUsingWith() throws Exception {
        this.con.add((Resource)RDF.FIRST, RDF.FIRST, (Value)RDF.FIRST, new Resource[0]);
        this.con.add((Resource)RDF.FIRST, RDF.FIRST, (Value)RDF.FIRST, new Resource[]{RDF.ALT});
        this.con.add((Resource)RDF.FIRST, RDF.FIRST, (Value)RDF.FIRST, new Resource[]{RDF.BAG});
        String update = this.getNamespaceDeclarations() + "WITH sesame:nil DELETE { ?s ?p ?o  } WHERE { ?s ?p ?o }";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        operation.execute();
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)RDF.FIRST, RDF.FIRST, (Value)RDF.FIRST, true, new Resource[]{RDF.ALT}));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)RDF.FIRST, RDF.FIRST, (Value)RDF.FIRST, true, new Resource[]{RDF.BAG}));
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)RDF.FIRST, RDF.FIRST, (Value)RDF.FIRST, true, new Resource[]{RDF4J.NIL}));
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)RDF.FIRST, RDF.FIRST, (Value)RDF.FIRST, true, new Resource[]{null}));
    }

    @Test
    public void testInsertWhereInvalidTriple() throws Exception {
        String update = this.getNamespaceDeclarations() + "INSERT {?name a foaf:Person. ?x a <urn:TestSubject>. } WHERE { ?x foaf:name ?name }";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        try {
            operation.execute();
        }
        catch (ClassCastException e) {
            Assert.fail((String)"subject-literal triple pattern should be silently ignored");
        }
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)null, RDF.TYPE, (Value)this.con.getValueFactory().createIRI("urn:TestSubject"), true, new Resource[0]));
    }

    @Test
    public void testDeleteWhereInvalidTriple() throws Exception {
        String update = this.getNamespaceDeclarations() + "DELETE {?name a foaf:Person. ?x foaf:name ?name } WHERE { ?x foaf:name ?name }";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        try {
            operation.execute();
        }
        catch (ClassCastException e) {
            Assert.fail((String)"subject-literal triple pattern should be silently ignored");
        }
        Assert.assertFalse((boolean)this.con.hasStatement(null, FOAF.NAME, null, true, new Resource[0]));
    }

    @Test
    public void testDeleteInsertWhereInvalidTriple() throws Exception {
        String update = this.getNamespaceDeclarations() + "DELETE {?name a foaf:Person} INSERT {?name a foaf:Agent} WHERE { ?x foaf:name ?name }";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        try {
            operation.execute();
        }
        catch (ClassCastException e) {
            Assert.fail((String)"subject-literal triple pattern should be silently ignored");
        }
    }

    @Test
    public void testInsertWhere() throws Exception {
        logger.debug("executing test InsertWhere");
        String update = this.getNamespaceDeclarations() + "INSERT {?x rdfs:label ?y . } WHERE {?x foaf:name ?y }";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.alice, RDFS.LABEL, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
        operation.execute();
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.alice, RDFS.LABEL, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
    }

    @Test
    public void testInsertWhereWithBinding() throws Exception {
        logger.debug("executing test testInsertWhereWithBinding");
        String update = this.getNamespaceDeclarations() + "INSERT {?x rdfs:label ?y . } WHERE {?x foaf:name ?y }";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        operation.setBinding("x", (Value)this.bob);
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.alice, RDFS.LABEL, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
        operation.execute();
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.alice, RDFS.LABEL, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
    }

    @Test
    public void testInsertWhereWithBindings2() throws Exception {
        logger.debug("executing test testInsertWhereWithBindings2");
        String update = this.getNamespaceDeclarations() + "INSERT {?x rdfs:label ?z . } WHERE {?x foaf:name ?y }";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        operation.setBinding("z", (Value)this.f.createLiteral("Bobbie"));
        operation.setBinding("x", (Value)this.bob);
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bobbie"), true, new Resource[0]));
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.alice, RDFS.LABEL, null, true, new Resource[0]));
        operation.execute();
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bobbie"), true, new Resource[0]));
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.alice, RDFS.LABEL, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
    }

    @Test
    public void testInsertEmptyWhere() throws Exception {
        logger.debug("executing test testInsertEmptyWhere");
        String update = this.getNamespaceDeclarations() + "INSERT { <" + this.bob + "> rdfs:label \"Bob\" . } WHERE { }";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        operation.execute();
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
    }

    @Test
    public void testInsertEmptyWhereWithBinding() throws Exception {
        logger.debug("executing test testInsertEmptyWhereWithBinding");
        String update = this.getNamespaceDeclarations() + "INSERT {?x rdfs:label ?y . } WHERE { }";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        operation.setBinding("x", (Value)this.bob);
        operation.setBinding("y", (Value)this.f.createLiteral("Bob"));
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        operation.execute();
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
    }

    @Test
    public void testInsertNonMatchingWhere() throws Exception {
        logger.debug("executing test testInsertNonMatchingWhere");
        String update = this.getNamespaceDeclarations() + "INSERT { ?x rdfs:label ?y . } WHERE { ?x rdfs:comment ?y }";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, null, true, new Resource[0]));
        operation.execute();
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, null, true, new Resource[0]));
    }

    @Test
    public void testInsertNonMatchingWhereWithBindings() throws Exception {
        logger.debug("executing test testInsertNonMatchingWhereWithBindings");
        String update = this.getNamespaceDeclarations() + "INSERT { ?x rdfs:label ?y . } WHERE { ?x rdfs:comment ?y }";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        operation.setBinding("x", (Value)this.bob);
        operation.setBinding("y", (Value)this.f.createLiteral("Bob"));
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, null, true, new Resource[0]));
        operation.execute();
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, null, true, new Resource[0]));
    }

    @Test
    public void testInsertWhereWithBindings() throws Exception {
        logger.debug("executing test testInsertWhereWithBindings");
        String update = this.getNamespaceDeclarations() + "INSERT { ?x rdfs:comment ?z . } WHERE { ?x foaf:name ?y }";
        Literal comment = this.f.createLiteral("Bob has a comment");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        operation.setBinding("x", (Value)this.bob);
        operation.setBinding("z", (Value)comment);
        Assert.assertFalse((boolean)this.con.hasStatement(null, RDFS.COMMENT, (Value)comment, true, new Resource[0]));
        operation.execute();
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, RDFS.COMMENT, (Value)comment, true, new Resource[0]));
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.alice, RDFS.COMMENT, (Value)comment, true, new Resource[0]));
    }

    @Test
    public void testInsertWhereWithOptional() throws Exception {
        logger.debug("executing testInsertWhereWithOptional");
        String update = this.getNamespaceDeclarations() + " INSERT { ?s ex:age ?incAge }  WHERE { ?s foaf:name ?name .  OPTIONAL {?s ex:age ?age . BIND ((?age + 1) as ?incAge)  }  } ";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        IRI age = this.f.createIRI(EX_NS, "age");
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.alice, age, null, true, new Resource[0]));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, age, null, true, new Resource[0]));
        operation.execute();
        RepositoryResult result = this.con.getStatements((Resource)this.bob, age, null, true, new Resource[0]);
        while (result.hasNext()) {
            System.out.println(((Statement)result.next()).toString());
        }
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, age, (Value)this.f.createLiteral("43", XSD.INTEGER), true, new Resource[0]));
        result = this.con.getStatements((Resource)this.alice, age, null, true, new Resource[0]);
        while (result.hasNext()) {
            System.out.println(result.next());
        }
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.alice, age, null, true, new Resource[0]));
    }

    @Test
    public void testInsertWhereWithBlankNode() throws Exception {
        logger.debug("executing testInsertWhereWithBlankNode");
        String update = this.getNamespaceDeclarations() + " INSERT { ?s ex:complexAge [ rdf:value ?age; rdfs:label \"old\" ] . }  WHERE { ?s ex:age ?age .  } ";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        IRI age = this.f.createIRI(EX_NS, "age");
        IRI complexAge = this.f.createIRI(EX_NS, "complexAge");
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, age, null, true, new Resource[0]));
        operation.execute();
        RepositoryResult sts = this.con.getStatements((Resource)this.bob, complexAge, null, true, new Resource[0]);
        Assert.assertTrue((boolean)sts.hasNext());
        Value v1 = ((Statement)sts.next()).getObject();
        sts.close();
        sts = this.con.getStatements(null, RDF.VALUE, null, true, new Resource[0]);
        Assert.assertTrue((boolean)sts.hasNext());
        Resource v2 = ((Statement)sts.next()).getSubject();
        Assert.assertEquals((Object)v1, (Object)v2);
        sts.close();
        String query = this.getNamespaceDeclarations() + " SELECT ?bn ?age ?l WHERE { ex:bob ex:complexAge ?bn. ?bn rdf:value ?age. ?bn rdfs:label ?l .} ";
        TupleQueryResult result = this.con.prepareTupleQuery(QueryLanguage.SPARQL, query).evaluate();
        Assert.assertTrue((boolean)result.hasNext());
        BindingSet bs = (BindingSet)result.next();
        Assert.assertFalse((boolean)result.hasNext());
    }

    @Test
    public void testDeleteInsertWhere() throws Exception {
        logger.debug("executing test DeleteInsertWhere");
        String update = this.getNamespaceDeclarations() + "DELETE { ?x foaf:name ?y } INSERT {?x rdfs:label ?y . } WHERE {?x foaf:name ?y }";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.alice, RDFS.LABEL, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
        operation.execute();
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.alice, RDFS.LABEL, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.alice, FOAF.NAME, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
    }

    @Test
    public void testDeleteWhereOptional() throws Exception {
        logger.debug("executing test testDeleteWhereOptional");
        String update = this.getNamespaceDeclarations() + " DELETE { ?x foaf:name ?y; foaf:mbox ?mbox. }  WHERE {?x foaf:name ?y.  OPTIONAL { ?x foaf:mbox ?mbox. FILTER (str(?mbox) = \"bob@example.org\") } }";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        Literal mboxBob = this.f.createLiteral("bob@example.org");
        Literal mboxAlice = this.f.createLiteral("alice@example.org");
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, FOAF.MBOX, (Value)mboxBob, true, new Resource[0]));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.alice, FOAF.MBOX, (Value)mboxAlice, true, new Resource[0]));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.alice, FOAF.NAME, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
        operation.execute();
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.bob, FOAF.MBOX, (Value)mboxBob, true, new Resource[0]));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.alice, FOAF.MBOX, (Value)mboxAlice, true, new Resource[0]));
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.alice, FOAF.NAME, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
    }

    @Test
    public void testDeleteInsertWhereWithBindings() throws Exception {
        logger.debug("executing test testDeleteInsertWhereWithBindings");
        String update = this.getNamespaceDeclarations() + "DELETE { ?x foaf:name ?y } INSERT {?x rdfs:label ?y . } WHERE {?x foaf:name ?y }";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        operation.setBinding("x", (Value)this.bob);
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.alice, RDFS.LABEL, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
        operation.execute();
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.alice, RDFS.LABEL, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.alice, FOAF.NAME, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
    }

    @Test
    public void testDeleteInsertWhereWithBindings2() throws Exception {
        logger.debug("executing test testDeleteInsertWhereWithBindings2");
        String update = this.getNamespaceDeclarations() + "DELETE { ?x foaf:name ?y } INSERT {?x rdfs:label ?z . } WHERE {?x foaf:name ?y }";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        operation.setBinding("z", (Value)this.f.createLiteral("person"));
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.alice, RDFS.LABEL, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
        operation.execute();
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("person"), true, new Resource[0]));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.alice, RDFS.LABEL, (Value)this.f.createLiteral("person"), true, new Resource[0]));
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.alice, FOAF.NAME, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
    }

    @Test
    public void testDeleteInsertWhereLoopingBehavior() throws Exception {
        logger.debug("executing test testDeleteInsertWhereLoopingBehavior");
        String update = this.getNamespaceDeclarations() + " DELETE { ?x ex:age ?y } INSERT {?x ex:age ?z } WHERE {    ?x ex:age ?y .   BIND((?y + 1) as ?z)    FILTER( ?y < 46 )  } ";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        IRI age = this.f.createIRI(EX_NS, "age");
        Literal originalAgeValue = this.f.createLiteral("42", XSD.INTEGER);
        Literal correctAgeValue = this.f.createLiteral("43", (CoreDatatype)CoreDatatype.XSD.INTEGER);
        Literal inCorrectAgeValue = this.f.createLiteral("46", XSD.INTEGER);
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, age, (Value)originalAgeValue, true, new Resource[0]));
        operation.execute();
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.bob, age, (Value)originalAgeValue, true, new Resource[0]));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, age, (Value)correctAgeValue, true, new Resource[0]));
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.bob, age, (Value)inCorrectAgeValue, true, new Resource[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAutoCommitHandling() throws Exception {
        logger.debug("executing test testAutoCommitHandling");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        update.append("DELETE { ?x foaf:name ?y } INSERT {?x rdfs:label ?y . } WHERE {?x foaf:name ?y }");
        try {
            this.con.begin();
            Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
            Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
            Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.alice, RDFS.LABEL, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
            operation.execute();
            Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
            Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.alice, RDFS.LABEL, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
            Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
            Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.alice, FOAF.NAME, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
            try (RepositoryConnection con2 = this.rep.getConnection();){
                Assert.assertFalse((boolean)con2.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
                Assert.assertFalse((boolean)con2.hasStatement((Resource)this.alice, RDFS.LABEL, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
                Assert.assertTrue((boolean)con2.hasStatement((Resource)this.bob, FOAF.NAME, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
                Assert.assertTrue((boolean)con2.hasStatement((Resource)this.alice, FOAF.NAME, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
                this.con.commit();
                Assert.assertTrue((boolean)con2.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
                Assert.assertTrue((boolean)con2.hasStatement((Resource)this.alice, RDFS.LABEL, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
                Assert.assertFalse((boolean)con2.hasStatement((Resource)this.bob, FOAF.NAME, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
                Assert.assertFalse((boolean)con2.hasStatement((Resource)this.alice, FOAF.NAME, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
            }
        }
        catch (Exception e) {
            if (this.con.isActive()) {
                this.con.rollback();
            }
        }
        finally {
            this.con.close();
        }
    }

    @Test
    public void testConsecutiveUpdatesInSameTransaction() throws Exception {
        block2: {
            logger.debug("executing test testConsecutiveUpdatesInSameTransaction");
            StringBuilder update1 = new StringBuilder();
            update1.append(this.getNamespaceDeclarations());
            update1.append("DELETE { ?x foaf:name ?y } WHERE {?x foaf:name ?y }");
            try {
                this.con.begin();
                Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update1.toString());
                Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
                Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.alice, RDFS.LABEL, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
                operation.execute();
                Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
                Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.alice, FOAF.NAME, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
                String update2 = this.getNamespaceDeclarations() + "INSERT { ?x rdfs:label ?y } WHERE {?x foaf:name ?y }";
                operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update2);
                operation.execute();
                this.con.commit();
                Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
                Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.alice, RDFS.LABEL, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
            }
            catch (Exception e) {
                if (!this.con.isActive()) break block2;
                this.con.rollback();
            }
        }
    }

    @Test
    public void testInsertTransformedWhere() throws Exception {
        logger.debug("executing test InsertTransformedWhere");
        String update = this.getNamespaceDeclarations() + "INSERT {?x rdfs:label [] . } WHERE {?y ex:containsPerson ?x.  }";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, null, true, new Resource[0]));
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.alice, RDFS.LABEL, null, true, new Resource[0]));
        operation.execute();
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, null, true, new Resource[0]));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.alice, RDFS.LABEL, null, true, new Resource[0]));
    }

    @Test
    public void testInsertWhereGraph() throws Exception {
        logger.debug("executing testInsertWhereGraph");
        String update = this.getNamespaceDeclarations() + "INSERT {GRAPH ?g {?x rdfs:label ?y . }} WHERE {GRAPH ?g {?x foaf:name ?y }}";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        operation.execute();
        String message = "labels should have been inserted in corresponding named graphs only.";
        Assert.assertTrue((String)message, (boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[]{this.graph1}));
        Assert.assertFalse((String)message, (boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[]{this.graph2}));
        Assert.assertTrue((String)message, (boolean)this.con.hasStatement((Resource)this.alice, RDFS.LABEL, (Value)this.f.createLiteral("Alice"), true, new Resource[]{this.graph2}));
        Assert.assertFalse((String)message, (boolean)this.con.hasStatement((Resource)this.alice, RDFS.LABEL, (Value)this.f.createLiteral("Alice"), true, new Resource[]{this.graph1}));
    }

    @Test
    public void testInsertWhereUsing() throws Exception {
        logger.debug("executing testInsertWhereUsing");
        String update = this.getNamespaceDeclarations() + "INSERT {?x rdfs:label ?y . } USING ex:graph1 WHERE {?x foaf:name ?y }";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        operation.execute();
        String message = "label should have been inserted in default graph, for ex:bob only";
        Assert.assertTrue((String)message, (boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        Assert.assertFalse((String)message, (boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[]{this.graph1}));
        Assert.assertFalse((String)message, (boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[]{this.graph2}));
        Assert.assertFalse((String)message, (boolean)this.con.hasStatement((Resource)this.alice, RDFS.LABEL, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
    }

    @Test
    public void testInsertWhereUsingWith() throws Exception {
        logger.debug("executing testInsertWhereUsingWith");
        String update = this.getNamespaceDeclarations() + "WITH ex:graph2 INSERT {?x rdfs:label ?y . } USING ex:graph1 WHERE {?x foaf:name ?y }";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        operation.execute();
        String message = "label should have been inserted in graph2, for ex:bob only";
        Assert.assertTrue((String)message, (boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[]{this.graph2}));
        Assert.assertFalse((String)message, (boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[]{this.graph1}));
        Assert.assertFalse((String)message, (boolean)this.con.hasStatement((Resource)this.alice, RDFS.LABEL, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
    }

    @Test
    public void testInsertWhereWith() throws Exception {
        logger.debug("executing testInsertWhereWith");
        String update = this.getNamespaceDeclarations() + "WITH ex:graph1 INSERT {?x rdfs:label ?y . } WHERE {?x foaf:name ?y }";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        operation.execute();
        String message = "label should have been inserted in graph1 only, for ex:bob only";
        Assert.assertTrue((String)message, (boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[]{this.graph1}));
        Assert.assertFalse((String)message, (boolean)this.con.hasStatement((Resource)this.bob, RDFS.LABEL, (Value)this.f.createLiteral("Bob"), true, new Resource[]{this.graph2}));
        Assert.assertFalse((String)message, (boolean)this.con.hasStatement((Resource)this.alice, RDFS.LABEL, (Value)this.f.createLiteral("Alice"), true, new Resource[]{this.graph2}));
        Assert.assertFalse((String)message, (boolean)this.con.hasStatement((Resource)this.alice, RDFS.LABEL, (Value)this.f.createLiteral("Alice"), true, new Resource[]{this.graph1}));
    }

    @Test
    public void testDeleteWhereShortcut() throws Exception {
        logger.debug("executing testDeleteWhereShortcut");
        String update = this.getNamespaceDeclarations() + "DELETE WHERE {?x foaf:name ?y }";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.alice, FOAF.NAME, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
        operation.execute();
        String msg = "foaf:name properties should have been deleted";
        Assert.assertFalse((String)msg, (boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        Assert.assertFalse((String)msg, (boolean)this.con.hasStatement((Resource)this.alice, FOAF.NAME, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
        msg = "foaf:knows properties should not have been deleted";
        Assert.assertTrue((String)msg, (boolean)this.con.hasStatement((Resource)this.bob, FOAF.KNOWS, null, true, new Resource[0]));
        Assert.assertTrue((String)msg, (boolean)this.con.hasStatement((Resource)this.alice, FOAF.KNOWS, null, true, new Resource[0]));
    }

    @Test
    public void testDeleteWhere() throws Exception {
        logger.debug("executing testDeleteWhere");
        String update = this.getNamespaceDeclarations() + "DELETE {?x foaf:name ?y } WHERE {?x foaf:name ?y }";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.alice, FOAF.NAME, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
        operation.execute();
        String msg = "foaf:name properties should have been deleted";
        Assert.assertFalse((String)msg, (boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        Assert.assertFalse((String)msg, (boolean)this.con.hasStatement((Resource)this.alice, FOAF.NAME, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
    }

    @Test
    public void testDeleteTransformedWhere() throws Exception {
        logger.debug("executing testDeleteTransformedWhere");
        String update = this.getNamespaceDeclarations() + "DELETE {?y foaf:name ?n } WHERE {?x ex:containsPerson ?y . ?y foaf:name ?n . }";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.alice, FOAF.NAME, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
        operation.execute();
        String msg = "foaf:name properties should have been deleted";
        Assert.assertFalse((String)msg, (boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        Assert.assertFalse((String)msg, (boolean)this.con.hasStatement((Resource)this.alice, FOAF.NAME, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
        msg = "ex:containsPerson properties should not have been deleted";
        Assert.assertTrue((String)msg, (boolean)this.con.hasStatement((Resource)this.graph1, this.f.createIRI(EX_NS, "containsPerson"), (Value)this.bob, true, new Resource[0]));
        Assert.assertTrue((String)msg, (boolean)this.con.hasStatement((Resource)this.graph2, this.f.createIRI(EX_NS, "containsPerson"), (Value)this.alice, true, new Resource[0]));
    }

    @Test
    public void testInsertData() throws Exception {
        logger.debug("executing testInsertData");
        String update = this.getNamespaceDeclarations() + "INSERT DATA { ex:book1 dc:title \"book 1\" ; dc:creator \"Ringo\" . } ";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        IRI book1 = this.f.createIRI(EX_NS, "book1");
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)book1, DC.TITLE, (Value)this.f.createLiteral("book 1"), true, new Resource[0]));
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)book1, DC.CREATOR, (Value)this.f.createLiteral("Ringo"), true, new Resource[0]));
        operation.execute();
        String msg = "two new statements about ex:book1 should have been inserted";
        Assert.assertTrue((String)msg, (boolean)this.con.hasStatement((Resource)book1, DC.TITLE, (Value)this.f.createLiteral("book 1"), true, new Resource[0]));
        Assert.assertTrue((String)msg, (boolean)this.con.hasStatement((Resource)book1, DC.CREATOR, (Value)this.f.createLiteral("Ringo"), true, new Resource[0]));
    }

    @Test
    public void testInsertData2() throws Exception {
        logger.debug("executing testInsertData2");
        String update = this.getNamespaceDeclarations() + "INSERT DATA { ex:book1 dc:title \"the number four\"^^<http://www.w3.org/2001/XMLSchema#integer> . }; ";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        IRI book1 = this.f.createIRI(EX_NS, "book1");
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)book1, DC.TITLE, (Value)this.f.createLiteral("the number four", XSD.INTEGER), true, new Resource[0]));
        operation.execute();
        String msg = "new statement about ex:book1 should have been inserted";
        Assert.assertTrue((String)msg, (boolean)this.con.hasStatement((Resource)book1, DC.TITLE, (Value)this.f.createLiteral("the number four", (CoreDatatype)CoreDatatype.XSD.INTEGER), true, new Resource[0]));
    }

    @Test
    public void testInsertDataLangTaggedLiteral() throws Exception {
        logger.debug("executing testInsertDataLangTaggedLiteral");
        String update = this.getNamespaceDeclarations() + "INSERT DATA { ex:book1 dc:title \"book 1\"@en . } ";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        IRI book1 = this.f.createIRI(EX_NS, "book1");
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)book1, DC.TITLE, (Value)this.f.createLiteral("book 1", "en"), true, new Resource[0]));
        operation.execute();
        String msg = "new statement about ex:book1 should have been inserted";
        Assert.assertTrue((String)msg, (boolean)this.con.hasStatement((Resource)book1, DC.TITLE, (Value)this.f.createLiteral("book 1", "en"), true, new Resource[0]));
    }

    @Test
    public void testInsertDataGraph1() throws Exception {
        logger.debug("executing testInsertDataGraph1");
        String update = "INSERT DATA { \nGRAPH <urn:g1> { <urn:s1> <urn:p1> <urn:o1> . } \n<urn:s1> a <urn:C1> . \n}";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.f.createIRI("urn:s1"), RDF.TYPE, null, true, new Resource[]{null}));
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.f.createIRI("urn:s1"), this.f.createIRI("urn:p1"), (Value)this.f.createIRI("urn:o1"), true, new Resource[]{this.f.createIRI("urn:g1")}));
        operation.execute();
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.f.createIRI("urn:s1"), RDF.TYPE, null, true, new Resource[]{null}));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.f.createIRI("urn:s1"), this.f.createIRI("urn:p1"), (Value)this.f.createIRI("urn:o1"), true, new Resource[]{this.f.createIRI("urn:g1")}));
    }

    @Test
    public void testInsertDataGraph2() throws Exception {
        logger.debug("executing testInsertDataGraph2");
        String update = "INSERT DATA { \n<urn:s1> a <urn:C1> . \nGRAPH <urn:g1> { <urn:s1> <urn:p1> <urn:o1> . } \n}";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.f.createIRI("urn:s1"), RDF.TYPE, null, true, new Resource[]{null}));
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.f.createIRI("urn:s1"), this.f.createIRI("urn:p1"), (Value)this.f.createIRI("urn:o1"), true, new Resource[]{this.f.createIRI("urn:g1")}));
        operation.execute();
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.f.createIRI("urn:s1"), RDF.TYPE, null, true, new Resource[]{null}));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.f.createIRI("urn:s1"), this.f.createIRI("urn:p1"), (Value)this.f.createIRI("urn:o1"), true, new Resource[]{this.f.createIRI("urn:g1")}));
    }

    @Test
    public void testInsertDataGraph3() throws Exception {
        logger.debug("executing testInsertDataGraph3");
        String update = "INSERT DATA { \n<urn:s1> a <urn:C1> . \nGRAPH <urn:g1>{ <urn:s1> <urn:p1> <urn:o1> . <urn:s2> <urn:p2> <urn:o2> } \n<urn:s2> a <urn:C2> \n}";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.f.createIRI("urn:s1"), RDF.TYPE, null, true, new Resource[]{null}));
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.f.createIRI("urn:s1"), this.f.createIRI("urn:p1"), (Value)this.f.createIRI("urn:o1"), true, new Resource[]{this.f.createIRI("urn:g1")}));
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.f.createIRI("urn:s2"), this.f.createIRI("urn:p2"), (Value)this.f.createIRI("urn:o2"), true, new Resource[]{this.f.createIRI("urn:g1")}));
        operation.execute();
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.f.createIRI("urn:s1"), RDF.TYPE, null, true, new Resource[]{null}));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.f.createIRI("urn:s2"), RDF.TYPE, null, true, new Resource[]{null}));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.f.createIRI("urn:s1"), this.f.createIRI("urn:p1"), (Value)this.f.createIRI("urn:o1"), true, new Resource[]{this.f.createIRI("urn:g1")}));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.f.createIRI("urn:s2"), this.f.createIRI("urn:p2"), (Value)this.f.createIRI("urn:o2"), true, new Resource[]{this.f.createIRI("urn:g1")}));
    }

    @Test
    public void testInsertDataBlankNode() throws Exception {
        Resource subject;
        logger.debug("executing testInsertDataBlankNode");
        String update = this.getNamespaceDeclarations() + "INSERT DATA { _:foo dc:title \"book 1\" ; dc:creator \"Ringo\" . } ";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        Assert.assertFalse((boolean)this.con.hasStatement(null, DC.TITLE, (Value)this.f.createLiteral("book 1"), true, new Resource[0]));
        Assert.assertFalse((boolean)this.con.hasStatement(null, DC.CREATOR, (Value)this.f.createLiteral("Ringo"), true, new Resource[0]));
        operation.execute();
        RepositoryResult titleStatements = this.con.getStatements(null, DC.TITLE, (Value)this.f.createLiteral("book 1"), true, new Resource[0]);
        Assert.assertNotNull((Object)titleStatements);
        RepositoryResult creatorStatements = this.con.getStatements(null, DC.CREATOR, (Value)this.f.createLiteral("Ringo"), true, new Resource[0]);
        Assert.assertNotNull((Object)creatorStatements);
        BNode bookNode = null;
        if (titleStatements.hasNext()) {
            Statement ts = (Statement)titleStatements.next();
            Assert.assertFalse((boolean)titleStatements.hasNext());
            subject = ts.getSubject();
            Assert.assertTrue((boolean)(subject instanceof BNode));
            bookNode = (BNode)subject;
        }
        titleStatements.close();
        Assert.assertNotNull(bookNode);
        Assert.assertFalse((boolean)"_:foo".equals(bookNode.getID()));
        if (creatorStatements.hasNext()) {
            Statement cs = (Statement)creatorStatements.next();
            Assert.assertFalse((boolean)creatorStatements.hasNext());
            subject = cs.getSubject();
            Assert.assertTrue((boolean)(subject instanceof BNode));
            Assert.assertEquals((Object)bookNode, (Object)subject);
        } else {
            Assert.fail((String)"at least one creator statement expected");
        }
        creatorStatements.close();
    }

    @Test
    public void testInsertDataMultiplePatterns() throws Exception {
        logger.debug("executing testInsertData");
        String update = this.getNamespaceDeclarations() + "INSERT DATA { ex:book1 dc:title \"book 1\". ex:book1 dc:creator \"Ringo\" . ex:book2 dc:creator \"George\". } ";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        IRI book1 = this.f.createIRI(EX_NS, "book1");
        IRI book2 = this.f.createIRI(EX_NS, "book2");
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)book1, DC.TITLE, (Value)this.f.createLiteral("book 1"), true, new Resource[0]));
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)book1, DC.CREATOR, (Value)this.f.createLiteral("Ringo"), true, new Resource[0]));
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)book2, DC.CREATOR, (Value)this.f.createLiteral("George"), true, new Resource[0]));
        operation.execute();
        String msg = "newly inserted statement missing";
        Assert.assertTrue((String)msg, (boolean)this.con.hasStatement((Resource)book1, DC.TITLE, (Value)this.f.createLiteral("book 1"), true, new Resource[0]));
        Assert.assertTrue((String)msg, (boolean)this.con.hasStatement((Resource)book1, DC.CREATOR, (Value)this.f.createLiteral("Ringo"), true, new Resource[0]));
        Assert.assertTrue((String)msg, (boolean)this.con.hasStatement((Resource)book2, DC.CREATOR, (Value)this.f.createLiteral("George"), true, new Resource[0]));
    }

    @Test
    public void testInsertDataInGraph() throws Exception {
        logger.debug("executing testInsertDataInGraph");
        String update = this.getNamespaceDeclarations() + "INSERT DATA { GRAPH ex:graph1 { ex:book1 dc:title \"book 1\" ; dc:creator \"Ringo\" . } } ";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        IRI book1 = this.f.createIRI(EX_NS, "book1");
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)book1, DC.TITLE, (Value)this.f.createLiteral("book 1"), true, new Resource[]{this.graph1}));
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)book1, DC.CREATOR, (Value)this.f.createLiteral("Ringo"), true, new Resource[]{this.graph1}));
        operation.execute();
        String msg = "two new statements about ex:book1 should have been inserted in graph1";
        Assert.assertTrue((String)msg, (boolean)this.con.hasStatement((Resource)book1, DC.TITLE, (Value)this.f.createLiteral("book 1"), true, new Resource[]{this.graph1}));
        Assert.assertTrue((String)msg, (boolean)this.con.hasStatement((Resource)book1, DC.CREATOR, (Value)this.f.createLiteral("Ringo"), true, new Resource[]{this.graph1}));
    }

    @Test
    public void testInsertDataInGraph2() throws Exception {
        logger.debug("executing testInsertDataInGraph2");
        String update = this.getNamespaceDeclarations() + "INSERT DATA { GRAPH ex:graph1 { ex:Human rdfs:subClassOf ex:Mammal. ex:Mammal rdfs:subClassOf ex:Animal. ex:george a ex:Human. ex:ringo a ex:Human. } } ";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        IRI human = this.f.createIRI(EX_NS, "Human");
        IRI mammal = this.f.createIRI(EX_NS, "Mammal");
        IRI george = this.f.createIRI(EX_NS, "george");
        operation.execute();
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)human, RDFS.SUBCLASSOF, (Value)mammal, true, new Resource[]{this.graph1}));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)mammal, RDFS.SUBCLASSOF, null, true, new Resource[]{this.graph1}));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)george, RDF.TYPE, (Value)human, true, new Resource[]{this.graph1}));
    }

    @Test
    public void testDeleteData() throws Exception {
        logger.debug("executing testDeleteData");
        String update = this.getNamespaceDeclarations() + "DELETE DATA { ex:alice foaf:knows ex:bob. } ";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.alice, FOAF.KNOWS, (Value)this.bob, true, new Resource[0]));
        operation.execute();
        String msg = "statement should have been deleted.";
        Assert.assertFalse((String)msg, (boolean)this.con.hasStatement((Resource)this.alice, FOAF.KNOWS, (Value)this.bob, true, new Resource[0]));
    }

    @Test
    public void testDeleteDataUnicode() throws Exception {
        IRI i18n = this.con.getValueFactory().createIRI(EX_NS, "\u6771\u4eac");
        this.con.add((Resource)i18n, FOAF.KNOWS, (Value)this.bob, new Resource[0]);
        logger.debug("executing testDeleteData");
        String update = this.getNamespaceDeclarations() + "DELETE DATA { ex:\u6771\u4eac foaf:knows ex:bob. } ";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)i18n, FOAF.KNOWS, (Value)this.bob, true, new Resource[0]));
        operation.execute();
        String msg = "statement should have been deleted.";
        Assert.assertFalse((String)msg, (boolean)this.con.hasStatement((Resource)i18n, FOAF.KNOWS, (Value)this.bob, true, new Resource[0]));
    }

    @Test
    public void testDeleteDataMultiplePatterns() throws Exception {
        logger.debug("executing testDeleteData");
        String update = this.getNamespaceDeclarations() + "DELETE DATA { ex:alice foaf:knows ex:bob. ex:alice foaf:mbox \"alice@example.org\" .} ";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.alice, FOAF.KNOWS, (Value)this.bob, true, new Resource[0]));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.alice, FOAF.MBOX, (Value)this.f.createLiteral("alice@example.org"), true, new Resource[0]));
        operation.execute();
        String msg = "statement should have been deleted.";
        Assert.assertFalse((String)msg, (boolean)this.con.hasStatement((Resource)this.alice, FOAF.KNOWS, (Value)this.bob, true, new Resource[0]));
        Assert.assertFalse((String)msg, (boolean)this.con.hasStatement((Resource)this.alice, FOAF.MBOX, (Value)this.f.createLiteral("alice@example.org"), true, new Resource[0]));
    }

    @Test
    public void testDeleteDataFromGraph() throws Exception {
        logger.debug("executing testDeleteDataFromGraph");
        String update = this.getNamespaceDeclarations() + "DELETE DATA { GRAPH ex:graph1 {ex:alice foaf:knows ex:bob. } } ";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.alice, FOAF.KNOWS, (Value)this.bob, true, new Resource[]{this.graph1}));
        operation.execute();
        String msg = "statement should have been deleted from graph1";
        Assert.assertFalse((String)msg, (boolean)this.con.hasStatement((Resource)this.alice, FOAF.KNOWS, (Value)this.bob, true, new Resource[]{this.graph1}));
    }

    @Test
    public void testDeleteDataFromWrongGraph() throws Exception {
        logger.debug("executing testDeleteDataFromWrongGraph");
        String update = this.getNamespaceDeclarations() + "DELETE DATA { GRAPH ex:graph2 {ex:alice foaf:knows ex:bob. } } ";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.alice, FOAF.KNOWS, (Value)this.bob, true, new Resource[]{this.graph1}));
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.alice, FOAF.KNOWS, (Value)this.bob, true, new Resource[]{this.graph2}));
        operation.execute();
        String msg = "statement should have not have been deleted from graph1";
        Assert.assertTrue((String)msg, (boolean)this.con.hasStatement((Resource)this.alice, FOAF.KNOWS, (Value)this.bob, true, new Resource[]{this.graph1}));
    }

    @Test
    public void testCreateNewGraph() throws Exception {
        logger.debug("executing testCreateNewGraph");
        StringBuilder update = new StringBuilder();
        update.append(this.getNamespaceDeclarations());
        IRI newGraph = this.f.createIRI(EX_NS, "new-graph");
        update.append("CREATE GRAPH <" + newGraph + "> ");
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update.toString());
        operation.execute();
        Assert.assertTrue((boolean)this.con.hasStatement(null, null, null, false, new Resource[]{this.graph1}));
        Assert.assertTrue((boolean)this.con.hasStatement(null, null, null, false, new Resource[]{this.graph2}));
        Assert.assertFalse((boolean)this.con.hasStatement(null, null, null, false, new Resource[]{newGraph}));
        Assert.assertTrue((boolean)this.con.hasStatement(null, null, null, false, new Resource[0]));
    }

    @Test
    public void testCreateExistingGraph() throws Exception {
        block2: {
            logger.debug("executing testCreateExistingGraph");
            String update = this.getNamespaceDeclarations() + "CREATE GRAPH <" + this.graph1 + "> ";
            Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
            try {
                operation.execute();
                Assert.fail((String)"creation of existing graph should have resulted in error.");
            }
            catch (UpdateExecutionException e) {
                if (!this.con.isActive()) break block2;
                this.con.rollback();
            }
        }
    }

    @Test
    public void testCopyToDefault() throws Exception {
        logger.debug("executing testCopyToDefault");
        String update = this.getNamespaceDeclarations() + "COPY GRAPH <" + this.graph1.stringValue() + "> TO DEFAULT";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{null}));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{null}));
        operation.execute();
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{null}));
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{null}));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, null, false, new Resource[]{null}));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, null, false, new Resource[]{this.graph1}));
    }

    @Test
    public void testCopyToExistingNamed() throws Exception {
        logger.debug("executing testCopyToExistingNamed");
        String update = this.getNamespaceDeclarations() + "COPY GRAPH ex:graph1 TO ex:graph2";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.alice, FOAF.NAME, null, false, new Resource[]{this.graph2}));
        operation.execute();
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, null, false, new Resource[]{this.graph2}));
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.alice, FOAF.NAME, null, false, new Resource[]{this.graph2}));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, null, false, new Resource[]{this.graph1}));
    }

    @Test
    public void testCopyToNewNamed() throws Exception {
        logger.debug("executing testCopyToNewNamed");
        String update = this.getNamespaceDeclarations() + "COPY GRAPH ex:graph1 TO ex:graph3";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        operation.execute();
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, null, false, new Resource[]{this.f.createIRI(EX_NS, "graph3")}));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, null, false, new Resource[]{this.graph1}));
    }

    @Test
    public void testCopyFromDefault() throws Exception {
        logger.debug("executing testCopyFromDefault");
        String update = this.getNamespaceDeclarations() + "COPY DEFAULT TO ex:graph3";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{null}));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{null}));
        operation.execute();
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{null}));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{null}));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{this.f.createIRI(EX_NS, "graph3")}));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{this.f.createIRI(EX_NS, "graph3")}));
    }

    @Test
    public void testCopyFromDefaultToDefault() throws Exception {
        logger.debug("executing testCopyFromDefaultToDefault");
        String update = this.getNamespaceDeclarations() + "COPY DEFAULT TO DEFAULT";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{null}));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{null}));
        operation.execute();
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{null}));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{null}));
    }

    @Test
    public void testAddToDefault() throws Exception {
        logger.debug("executing testAddToDefault");
        String update = this.getNamespaceDeclarations() + "ADD GRAPH <" + this.graph1.stringValue() + "> TO DEFAULT";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{null}));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{null}));
        operation.execute();
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{null}));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{null}));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, null, false, new Resource[]{null}));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, null, false, new Resource[]{this.graph1}));
    }

    @Test
    public void testAddToExistingNamed() throws Exception {
        logger.debug("executing testAddToExistingNamed");
        String update = this.getNamespaceDeclarations() + "ADD GRAPH ex:graph1 TO ex:graph2";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        operation.execute();
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, null, false, new Resource[]{this.graph2}));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.alice, FOAF.NAME, null, false, new Resource[]{this.graph2}));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, null, false, new Resource[]{this.graph1}));
    }

    @Test
    public void testAddToNewNamed() throws Exception {
        logger.debug("executing testAddToNewNamed");
        String update = this.getNamespaceDeclarations() + "ADD GRAPH ex:graph1 TO ex:graph3";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        operation.execute();
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, null, false, new Resource[]{this.f.createIRI(EX_NS, "graph3")}));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, null, false, new Resource[]{this.graph1}));
    }

    @Test
    public void testAddFromDefault() throws Exception {
        logger.debug("executing testAddFromDefault");
        String update = this.getNamespaceDeclarations() + "ADD DEFAULT TO ex:graph3";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        IRI graph3 = this.f.createIRI(EX_NS, "graph3");
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{null}));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{null}));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.alice, FOAF.KNOWS, (Value)this.bob, false, new Resource[]{this.graph1}));
        operation.execute();
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{null}));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{null}));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{graph3}));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{graph3}));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.alice, FOAF.KNOWS, (Value)this.bob, false, new Resource[]{this.graph1}));
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.alice, FOAF.KNOWS, (Value)this.bob, false, new Resource[]{graph3}));
    }

    @Test
    public void testAddFromDefaultToDefault() throws Exception {
        logger.debug("executing testAddFromDefaultToDefault");
        String update = this.getNamespaceDeclarations() + "ADD DEFAULT TO DEFAULT";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{null}));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{null}));
        operation.execute();
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{null}));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{null}));
    }

    @Test
    public void testMoveToDefault() throws Exception {
        logger.debug("executing testMoveToDefault");
        String update = this.getNamespaceDeclarations() + "MOVE GRAPH <" + this.graph1.stringValue() + "> TO DEFAULT";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{null}));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{null}));
        operation.execute();
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{null}));
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{null}));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, null, false, new Resource[]{null}));
        Assert.assertFalse((boolean)this.con.hasStatement(null, null, null, false, new Resource[]{this.graph1}));
    }

    @Test
    public void testMoveToNewNamed() throws Exception {
        logger.debug("executing testMoveToNewNamed");
        String update = this.getNamespaceDeclarations() + "MOVE GRAPH ex:graph1 TO ex:graph3";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        operation.execute();
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, null, false, new Resource[]{this.f.createIRI(EX_NS, "graph3")}));
        Assert.assertFalse((boolean)this.con.hasStatement(null, null, null, false, new Resource[]{this.graph1}));
    }

    @Test
    public void testMoveFromDefault() throws Exception {
        logger.debug("executing testMoveFromDefault");
        String update = this.getNamespaceDeclarations() + "MOVE DEFAULT TO ex:graph3";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{null}));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{null}));
        operation.execute();
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{null}));
        Assert.assertFalse((boolean)this.con.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{null}));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{this.f.createIRI(EX_NS, "graph3")}));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{this.f.createIRI(EX_NS, "graph3")}));
    }

    @Test
    public void testMoveFromDefaultToDefault() throws Exception {
        logger.debug("executing testMoveFromDefaultToDefault");
        String update = this.getNamespaceDeclarations() + "MOVE DEFAULT TO DEFAULT";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{null}));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{null}));
        operation.execute();
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.graph1, DC.PUBLISHER, null, false, new Resource[]{null}));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.graph2, DC.PUBLISHER, null, false, new Resource[]{null}));
    }

    @Test
    public void testClearAll() throws Exception {
        logger.debug("executing testClearAll");
        String update = "CLEAR ALL";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        operation.execute();
        Assert.assertFalse((boolean)this.con.hasStatement(null, null, null, false, new Resource[0]));
    }

    @Test
    public void testClearDefault() throws Exception {
        logger.debug("executing testClearDefault");
        String update = "CLEAR DEFAULT";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        Assert.assertTrue((boolean)this.con.hasStatement(null, null, null, false, new Resource[]{this.graph1}));
        Assert.assertTrue((boolean)this.con.hasStatement(null, null, null, false, new Resource[]{this.graph2}));
        Assert.assertTrue((boolean)this.con.hasStatement(null, null, null, false, new Resource[]{null}));
        operation.execute();
        Assert.assertTrue((boolean)this.con.hasStatement(null, null, null, false, new Resource[]{this.graph1}));
        Assert.assertTrue((boolean)this.con.hasStatement(null, null, null, false, new Resource[]{this.graph2}));
        Assert.assertFalse((boolean)this.con.hasStatement(null, null, null, false, new Resource[]{null}));
    }

    @Test
    public void testClearGraph() throws Exception {
        logger.debug("executing testClearGraph");
        String update = this.getNamespaceDeclarations() + "CLEAR GRAPH <" + this.graph1.stringValue() + "> ";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        operation.execute();
        Assert.assertFalse((boolean)this.con.hasStatement(null, null, null, false, new Resource[]{this.graph1}));
        Assert.assertTrue((boolean)this.con.hasStatement(null, null, null, false, new Resource[]{this.graph2}));
        Assert.assertTrue((boolean)this.con.hasStatement(null, null, null, false, new Resource[0]));
    }

    @Test
    public void testClearNamed() throws Exception {
        logger.debug("executing testClearNamed");
        String update = "CLEAR NAMED";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        operation.execute();
        Assert.assertFalse((boolean)this.con.hasStatement(null, null, null, false, new Resource[]{this.graph1}));
        Assert.assertFalse((boolean)this.con.hasStatement(null, null, null, false, new Resource[]{this.graph2}));
        Assert.assertTrue((boolean)this.con.hasStatement(null, null, null, false, new Resource[0]));
    }

    @Test
    public void testDropAll() throws Exception {
        logger.debug("executing testDropAll");
        String update = "DROP ALL";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        operation.execute();
        Assert.assertFalse((boolean)this.con.hasStatement(null, null, null, false, new Resource[0]));
    }

    @Test
    public void testDropDefault() throws Exception {
        logger.debug("executing testDropDefault");
        String update = "DROP DEFAULT";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        Assert.assertTrue((boolean)this.con.hasStatement(null, null, null, false, new Resource[]{this.graph1}));
        Assert.assertTrue((boolean)this.con.hasStatement(null, null, null, false, new Resource[]{this.graph2}));
        Assert.assertTrue((boolean)this.con.hasStatement(null, null, null, false, new Resource[]{null}));
        operation.execute();
        Assert.assertTrue((boolean)this.con.hasStatement(null, null, null, false, new Resource[]{this.graph1}));
        Assert.assertTrue((boolean)this.con.hasStatement(null, null, null, false, new Resource[]{this.graph2}));
        Assert.assertFalse((boolean)this.con.hasStatement(null, null, null, false, new Resource[]{null}));
    }

    @Test
    public void testDropGraph() throws Exception {
        logger.debug("executing testDropGraph");
        String update = this.getNamespaceDeclarations() + "DROP GRAPH <" + this.graph1.stringValue() + "> ";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        operation.execute();
        Assert.assertFalse((boolean)this.con.hasStatement(null, null, null, false, new Resource[]{this.graph1}));
        Assert.assertTrue((boolean)this.con.hasStatement(null, null, null, false, new Resource[]{this.graph2}));
        Assert.assertTrue((boolean)this.con.hasStatement(null, null, null, false, new Resource[0]));
    }

    @Test
    public void testDropNamed() throws Exception {
        logger.debug("executing testDropNamed");
        String update = "DROP NAMED";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        operation.execute();
        Assert.assertFalse((boolean)this.con.hasStatement(null, null, null, false, new Resource[]{this.graph1}));
        Assert.assertFalse((boolean)this.con.hasStatement(null, null, null, false, new Resource[]{this.graph2}));
        Assert.assertTrue((boolean)this.con.hasStatement(null, null, null, false, new Resource[0]));
    }

    @Test
    public void testUpdateSequenceDeleteInsert() throws Exception {
        logger.debug("executing testUpdateSequenceDeleteInsert");
        String update = this.getNamespaceDeclarations() + "DELETE {?y foaf:name ?n } WHERE {?x ex:containsPerson ?y. ?y foaf:name ?n . }; " + this.getNamespaceDeclarations() + "INSERT {?x foaf:name \"foo\" } WHERE {?y ex:containsPerson ?x} ";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.alice, FOAF.NAME, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
        operation.execute();
        String msg = "foaf:name properties should have been deleted";
        Assert.assertFalse((String)msg, (boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        Assert.assertFalse((String)msg, (boolean)this.con.hasStatement((Resource)this.alice, FOAF.NAME, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
        msg = "foaf:name properties with value 'foo' should have been added";
        Assert.assertTrue((String)msg, (boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, (Value)this.f.createLiteral("foo"), true, new Resource[0]));
        Assert.assertTrue((String)msg, (boolean)this.con.hasStatement((Resource)this.alice, FOAF.NAME, (Value)this.f.createLiteral("foo"), true, new Resource[0]));
    }

    @Test
    public void testUpdateSequenceInsertDelete() throws Exception {
        logger.debug("executing testUpdateSequenceInsertDelete");
        String update = this.getNamespaceDeclarations() + "INSERT {?x foaf:name \"foo\" } WHERE {?y ex:containsPerson ?x}; " + this.getNamespaceDeclarations() + "DELETE {?y foaf:name ?n } WHERE {?x ex:containsPerson ?y. ?y foaf:name ?n . } ";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.alice, FOAF.NAME, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
        operation.execute();
        String msg = "foaf:name properties should have been deleted";
        Assert.assertFalse((String)msg, (boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, (Value)this.f.createLiteral("Bob"), true, new Resource[0]));
        Assert.assertFalse((String)msg, (boolean)this.con.hasStatement((Resource)this.alice, FOAF.NAME, (Value)this.f.createLiteral("Alice"), true, new Resource[0]));
        msg = "foaf:name properties with value 'foo' should not have been added";
        Assert.assertFalse((String)msg, (boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, (Value)this.f.createLiteral("foo"), true, new Resource[0]));
        Assert.assertFalse((String)msg, (boolean)this.con.hasStatement((Resource)this.alice, FOAF.NAME, (Value)this.f.createLiteral("foo"), true, new Resource[0]));
    }

    @Test
    public void testUpdateSequenceInsertDelete2() throws Exception {
        logger.debug("executing testUpdateSequenceInsertDelete2");
        String update = this.getNamespaceDeclarations() + "INSERT { GRAPH ex:graph2 { ?s ?p ?o } } WHERE { GRAPH ex:graph1 { ?s ?p ?o . FILTER (?s = ex:bob) } }; WITH ex:graph1 DELETE { ?s ?p ?o } WHERE {?s ?p ?o . FILTER (?s = ex:bob) } ";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, (Value)this.f.createLiteral("Bob"), true, new Resource[]{this.graph1}));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.alice, FOAF.NAME, (Value)this.f.createLiteral("Alice"), true, new Resource[]{this.graph2}));
        operation.execute();
        String msg = "statements about bob should have been removed from graph1";
        Assert.assertFalse((String)msg, (boolean)this.con.hasStatement((Resource)this.bob, null, null, true, new Resource[]{this.graph1}));
        msg = "statements about bob should have been added to graph2";
        Assert.assertTrue((String)msg, (boolean)this.con.hasStatement((Resource)this.bob, FOAF.NAME, (Value)this.f.createLiteral("Bob"), true, new Resource[]{this.graph2}));
        Assert.assertTrue((String)msg, (boolean)this.con.hasStatement((Resource)this.bob, FOAF.MBOX, null, true, new Resource[]{this.graph2}));
        Assert.assertTrue((String)msg, (boolean)this.con.hasStatement((Resource)this.bob, FOAF.KNOWS, (Value)this.alice, true, new Resource[]{this.graph2}));
    }

    @Test
    public void testUpdateSequenceInsertDeleteExample9() throws Exception {
        logger.debug("executing testUpdateSequenceInsertDeleteExample9");
        this.con.clear(new Resource[0]);
        this.loadDataset("/testdata-update/dataset-update-example9.trig");
        IRI book1 = this.f.createIRI("http://example/book1");
        IRI book3 = this.f.createIRI("http://example/book3");
        IRI bookStore = this.f.createIRI("http://example/bookStore");
        IRI bookStore2 = this.f.createIRI("http://example/bookStore2");
        String update = "prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#>  prefix xsd: <http://www.w3.org/2001/XMLSchema#>  prefix dc: <http://purl.org/dc/elements/1.1/>  prefix dcmitype: <http://purl.org/dc/dcmitype/>  INSERT  { GRAPH <http://example/bookStore2> { ?book ?p ?v } }  WHERE  { GRAPH  <http://example/bookStore>    { ?book dc:date ?date .        FILTER ( ?date < \"2000-01-01T00:00:00-02:00\"^^xsd:dateTime )        ?book ?p ?v       }  } ;WITH <http://example/bookStore>  DELETE { ?book ?p ?v }  WHERE  { ?book dc:date ?date ;          a dcmitype:PhysicalObject .    FILTER ( ?date < \"2000-01-01T00:00:00-02:00\"^^xsd:dateTime )    ?book ?p ?v } ";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        operation.execute();
        String msg = "statements about book1 should have been removed from bookStore";
        Assert.assertFalse((String)msg, (boolean)this.con.hasStatement((Resource)book1, null, null, true, new Resource[]{bookStore}));
        msg = "statements about book1 should have been added to bookStore2";
        Assert.assertTrue((String)msg, (boolean)this.con.hasStatement((Resource)book1, RDF.TYPE, null, true, new Resource[]{bookStore2}));
        Assert.assertTrue((String)msg, (boolean)this.con.hasStatement((Resource)book1, DC.DATE, null, true, new Resource[]{bookStore2}));
        Assert.assertTrue((String)msg, (boolean)this.con.hasStatement((Resource)book1, DC.TITLE, null, true, new Resource[]{bookStore2}));
    }

    @Test
    public void testUpdateSequenceWithRelativeIRI() throws Exception {
        logger.debug("executing testUpdateSequenceWithRelativeIRI");
        String update = "base <http://example.com/resource/>\nprefix em: <http://example.com/resource/ontology/>\ninsert {\n  graph <relations> { ?company em:parent ?other. ?other em:subsidiary ?company }\n} where {\n  values ?type {<relation/parent> <relation/acquisition>}\n  [em:type ?type; em:company ?company; em:investor ?other]\n};\ninsert {\n  graph <relations> { ?company em:hasCompetitor ?other. ?other em:hasCompetitor ?company. }\n} where {\n  [em:type <relation/competition>; em:company ?company; em:company ?other]\n  filter(str(?company)<str(?other)) \n};";
        Update operation = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        operation.execute();
    }

    @Test
    public void contextualInsertDeleteData() throws RepositoryException, MalformedQueryException, UpdateExecutionException {
        String insert = this.getNamespaceDeclarations() + "INSERT DATA { ex:alice foaf:knows ex:bob. ex:alice foaf:mbox \"alice@example.org\" .} ";
        SimpleDataset ds = new SimpleDataset();
        ds.setDefaultInsertGraph(this.graph2);
        ds.addDefaultRemoveGraph(this.graph2);
        Update updInsert = this.con.prepareUpdate(QueryLanguage.SPARQL, insert);
        updInsert.setDataset((Dataset)ds);
        updInsert.execute();
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.alice, FOAF.KNOWS, (Value)this.bob, true, new Resource[]{this.graph2}));
        Assert.assertTrue((boolean)this.con.hasStatement((Resource)this.alice, FOAF.MBOX, (Value)this.f.createLiteral("alice@example.org"), true, new Resource[]{this.graph2}));
        String update = this.getNamespaceDeclarations() + "DELETE DATA { ex:alice foaf:knows ex:bob. ex:alice foaf:mbox \"alice@example.org\" .} ";
        Update updDelete = this.con.prepareUpdate(QueryLanguage.SPARQL, update);
        updDelete.setDataset((Dataset)ds);
        updDelete.execute();
        String msg = "statement should have been deleted.";
        Assert.assertFalse((String)msg, (boolean)this.con.hasStatement((Resource)this.alice, FOAF.KNOWS, (Value)this.bob, true, new Resource[]{this.graph2}));
        Assert.assertFalse((String)msg, (boolean)this.con.hasStatement((Resource)this.alice, FOAF.MBOX, (Value)this.f.createLiteral("alice@example.org"), true, new Resource[]{this.graph2}));
    }

    @Test(expected=MalformedQueryException.class)
    public void testInvalidInsertUpdate() {
        RepositoryConnection connection = this.rep.getConnection();
        Update update = connection.prepareUpdate(QueryLanguage.SPARQL, "insert data { ?s ?p ?o }");
    }

    @Test(expected=MalformedQueryException.class)
    public void testInvalidDeleteUpdate() {
        RepositoryConnection connection = this.rep.getConnection();
        Update delete = connection.prepareUpdate(QueryLanguage.SPARQL, "delete data { ?s ?p ?o }");
    }

    protected void loadDataset(String datasetFile) throws RDFParseException, RepositoryException, IOException {
        logger.debug("loading dataset...");
        try (InputStream dataset = SPARQLUpdateTest.class.getResourceAsStream(datasetFile);){
            this.con.add(dataset, "", RDFFormat.TRIG, new Resource[0]);
        }
        logger.debug("dataset loaded.");
    }

    protected String getNamespaceDeclarations() {
        String declarations = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> \nPREFIX dc: <http://purl.org/dc/elements/1.1/> \nPREFIX foaf: <http://xmlns.com/foaf/0.1/> \nPREFIX ex: <http://example.org/> \nPREFIX xsd: <http://www.w3.org/2001/XMLSchema#> \n\n";
        return declarations;
    }

    protected Repository createRepository() throws Exception {
        Repository repository = this.newRepository();
        try (RepositoryConnection con = repository.getConnection();){
            con.clear(new Resource[0]);
            con.clearNamespaces();
        }
        return repository;
    }

    protected abstract Repository newRepository() throws Exception;
}

