/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.testsuite.sparql.tests;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.QueryResults;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.impl.MapBindingSet;
import org.eclipse.rdf4j.query.impl.SimpleBinding;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.testsuite.sparql.AbstractComplianceTest;
import org.junit.Assert;
import org.junit.Test;

public class PropertyPathTest
extends AbstractComplianceTest {
    @Test
    public void testSES2147PropertyPathsWithIdenticalSubsPreds() throws Exception {
        String data = "<urn:s1> <urn:p> <urn:s2> .\n<urn:s2> <urn:p> <urn:s3> .\n<urn:s3> <urn:q> <urn:s4> .\n<urn:s1> <urn:p> <urn:s5> .\n<urn:s5> <urn:q> <urn:s6> .\n";
        this.conn.begin();
        this.conn.add((Reader)new StringReader(data), "", RDFFormat.NTRIPLES, new Resource[0]);
        this.conn.commit();
        String query = this.getNamespaceDeclarations() + "SELECT ?x \nWHERE { ?x <urn:p>*/<urn:q> <urn:s4> . \n        ?x <urn:p>*/<urn:q> <urn:s6> . \n} \n";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)result.hasNext());
            Value x = ((BindingSet)result.next()).getValue("x");
            Assert.assertNotNull((Object)x);
            Assert.assertTrue((boolean)(x instanceof IRI));
            Assert.assertEquals((Object)"urn:s1", (Object)x.stringValue());
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSES2024PropertyPathAnonVarSharing() throws Exception {
        this.loadTestData("/testdata-query/dataset-ses2024.trig", new Resource[0]);
        String query = "PREFIX : <http://example.org/> SELECT * WHERE { ?x1 :p/:lit ?l1 . ?x1 :diff ?x2 . ?x2 :p/:lit ?l2 . }";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            BindingSet bs = (BindingSet)result.next();
            Literal l1 = (Literal)bs.getValue("l1");
            Literal l2 = (Literal)bs.getValue("l2");
            Assert.assertNotNull((Object)l1);
            Assert.assertNotEquals((Object)l1, (Object)l2);
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testPropertyPathNegationInversion() throws Exception {
        String data = "@prefix : <http://example.org/>.\n:Mary :parentOf :Jim.\n:Jim :knows :Jane.\n:Jane :worksFor :IBM.";
        this.conn.add((Reader)new StringReader(data), "", RDFFormat.TURTLE, new Resource[0]);
        String query1 = "prefix : <http://example.org/> ASK WHERE { :IBM ^(:|!:) :Jane } ";
        Assert.assertTrue((boolean)this.conn.prepareBooleanQuery(query1).evaluate());
        String query2 = "prefix : <http://example.org/> ASK WHERE { :IBM ^(:|!:) ?a } ";
        Assert.assertTrue((boolean)this.conn.prepareBooleanQuery(query2).evaluate());
        String query3 = "prefix : <http://example.org/> ASK WHERE { :IBM (^(:|!:))* :Mary } ";
        Assert.assertTrue((boolean)this.conn.prepareBooleanQuery(query3).evaluate());
    }

    @Test
    public void testSES2336NegatedPropertyPathMod() throws Exception {
        this.loadTestData("/testdata-query/dataset-ses2336.trig", new Resource[0]);
        String query = "prefix : <http://example.org/> select * where { ?s a :Test ; !:p? ?o . }";
        ValueFactory vf = this.conn.getValueFactory();
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult evaluate = tq.evaluate();){
            List result = QueryResults.asList((CloseableIteration)evaluate);
            Assert.assertNotNull((Object)result);
            IRI a = vf.createIRI("http://example.org/", "a");
            IRI b = vf.createIRI("http://example.org/", "b");
            IRI c = vf.createIRI("http://example.org/", "c");
            IRI d = vf.createIRI("http://example.org/", "d");
            IRI e = vf.createIRI("http://example.org/", "e");
            IRI test = vf.createIRI("http://example.org/", "Test");
            Assert.assertTrue((boolean)this.containsSolution(result, new Binding[]{new SimpleBinding("s", (Value)a), new SimpleBinding("o", (Value)a)}));
            Assert.assertTrue((boolean)this.containsSolution(result, new Binding[]{new SimpleBinding("s", (Value)a), new SimpleBinding("o", (Value)test)}));
            Assert.assertTrue((boolean)this.containsSolution(result, new Binding[]{new SimpleBinding("s", (Value)a), new SimpleBinding("o", (Value)c)}));
            Assert.assertTrue((boolean)this.containsSolution(result, new Binding[]{new SimpleBinding("s", (Value)d), new SimpleBinding("o", (Value)d)}));
            Assert.assertTrue((boolean)this.containsSolution(result, new Binding[]{new SimpleBinding("s", (Value)d), new SimpleBinding("o", (Value)e)}));
            Assert.assertTrue((boolean)this.containsSolution(result, new Binding[]{new SimpleBinding("s", (Value)d), new SimpleBinding("o", (Value)test)}));
            Assert.assertFalse((boolean)this.containsSolution(result, new Binding[]{new SimpleBinding("s", (Value)a), new SimpleBinding("o", (Value)b)}));
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSES1685propPathSameVar() throws Exception {
        String queryStr = "PREFIX : <urn:> SELECT ?x WHERE {?x :p+ ?x}";
        this.conn.add((Reader)new StringReader("@prefix : <urn:> . :a :p :b . :b :p :a ."), "", RDFFormat.TURTLE, new Resource[0]);
        TupleQuery query = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, "PREFIX : <urn:> SELECT ?x WHERE {?x :p+ ?x}");
        try (Stream result = query.evaluate().stream();){
            long count = result.count();
            Assert.assertEquals((long)2L, (long)count);
        }
    }

    @Test
    public void testSES1073InverseSymmetricPattern() {
        IRI a = Values.iri((String)"http://example.org/a");
        IRI b1 = Values.iri((String)"http://example.org/b1");
        IRI b2 = Values.iri((String)"http://example.org/b2");
        IRI c1 = Values.iri((String)"http://example.org/c1");
        IRI c2 = Values.iri((String)"http://example.org/c2");
        IRI a2b = Values.iri((String)"http://example.org/a2b");
        IRI b2c = Values.iri((String)"http://example.org/b2c");
        this.conn.add((Resource)a, a2b, (Value)b1, new Resource[0]);
        this.conn.add((Resource)a, a2b, (Value)b2, new Resource[0]);
        this.conn.add((Resource)b1, b2c, (Value)c1, new Resource[0]);
        this.conn.add((Resource)b2, b2c, (Value)c2, new Resource[0]);
        Object query = "select * ";
        query = (String)query + "where{ ";
        query = (String)query + "?c1 ^<http://example.org/b2c>/^<http://example.org/a2b>/<http://example.org/a2b>/<http://example.org/b2c> ?c2 . ";
        query = (String)query + " } ";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, (String)query);
        try (Stream result = tq.evaluate().stream();){
            long count = result.count();
            Assert.assertEquals((long)4L, (long)count);
        }
    }

    @Test
    public void testNestedInversePropertyPathWithZeroLength() {
        String insert = "insert data {\n    <urn:1> <urn:prop> <urn:object> .\n    <urn:2> <urn:prop> <urn:mid:1> .\n    <urn:mid:1> <urn:prop> <urn:object> .\n    <urn:3> <urn:prop> <urn:mid:2> .\n    <urn:mid:2> <urn:prop> <urn:mid:3> .\n    <urn:mid:3> <urn:prop> <urn:object> .\n}";
        String query = "select * where { \n    <urn:object> (^<urn:prop>)? ?o .\n}";
        this.conn.prepareUpdate(insert).execute();
        TupleQuery tq = this.conn.prepareTupleQuery(query);
        List result = QueryResults.asList((CloseableIteration)tq.evaluate());
        Assertions.assertThat((List)result).hasSize(4);
    }

    private boolean containsSolution(List<BindingSet> result, Binding ... solution) {
        MapBindingSet bs = new MapBindingSet();
        for (Binding b : solution) {
            bs.addBinding(b);
        }
        return result.contains(bs);
    }
}

