/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.testsuite.sparql.tests;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.QueryResults;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.testsuite.sparql.AbstractComplianceTest;
import org.junit.Assert;
import org.junit.Test;

public class BindTest
extends AbstractComplianceTest {
    @Test
    public void testBindError() {
        this.conn.prepareUpdate(QueryLanguage.SPARQL, "insert data { <urn:test:subj> <urn:test:pred> _:blank }").execute();
        String qb = "SELECT * \nWHERE { \n  VALUES (?NAValue) { (<http://null>) } \n   BIND(IF(?NAValue != <http://null>, ?NAValue, ?notBoundVar) as ?ValidNAValue) \n   { ?disjClass (owl:disjointWith|^owl:disjointWith)? ?disjClass2 . }\n}\n";
        List result = QueryResults.asList((CloseableIteration)this.conn.prepareTupleQuery(qb).evaluate());
        Assert.assertEquals((String)"query should return 2 solutions", (long)2L, (long)result.size());
    }

    @Test
    public void testBindScope() {
        String query = "SELECT * {\n  { BIND (\"a\" AS ?a) }\n  { BIND (?a AS ?b) } \n}";
        TupleQuery q = this.conn.prepareTupleQuery(query);
        List result = QueryResults.asList((CloseableIteration)q.evaluate());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)this.conn.getValueFactory().createLiteral("a"), (Object)((BindingSet)result.get(0)).getValue("a"));
        Assert.assertNull((Object)((BindingSet)result.get(0)).getValue("b"));
    }

    @Test
    public void testBindScopeUnion() {
        ValueFactory f = this.conn.getValueFactory();
        String query = "prefix ex: <http://example.org/> \nselect * {\n  bind(ex:v1 as ?v)\n  bind(strafter(str(?v),str(ex:)) as ?b)\n  {\n    bind(?b as ?b1)\n  } union {\n    bind(?b as ?b2)\n  }\n}";
        TupleQuery q = this.conn.prepareTupleQuery(query);
        List result = QueryResults.asList((CloseableIteration)q.evaluate());
        Assert.assertEquals((long)2L, (long)result.size());
        IRI v1 = f.createIRI("http://example.org/v1");
        Literal b = f.createLiteral("v1");
        for (BindingSet bs : result) {
            Assertions.assertThat((Object)bs.getValue("v")).isEqualTo((Object)v1);
            Assertions.assertThat((Object)bs.getValue("b1")).isNull();
            Assertions.assertThat((Object)bs.getValue("b2")).isNull();
        }
    }

    @Test
    public void testSES2250BindErrors() {
        this.conn.prepareUpdate(QueryLanguage.SPARQL, "insert data { <urn:test:subj> <urn:test:pred> _:blank }").execute();
        String qb = "SELECT * {\n    ?s1 ?p1 ?blank .     FILTER(isBlank(?blank))    BIND (iri(?blank) as ?biri)    ?biri ?p2 ?o2 .}";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, qb);
        try (TupleQueryResult evaluate = tq.evaluate();){
            Assert.assertFalse((String)"The query should not return a result", (boolean)evaluate.hasNext());
        }
    }

    @Test
    public void testSES2250BindErrorsInPath() {
        this.conn.prepareUpdate(QueryLanguage.SPARQL, "insert data { <urn:test:subj> <urn:test:pred> _:blank }").execute();
        String qb = "SELECT * {\n    ?s1 ?p1 ?blank .     FILTER(isBlank(?blank))    BIND (iri(?blank) as ?biri)    ?biri <urn:test:pred>* ?o2 .}";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, qb);
        try (TupleQueryResult evaluate = tq.evaluate();){
            Assert.assertFalse((String)"The query should not return a result", (boolean)evaluate.hasNext());
        }
    }

    @Test
    public void testSelectBindOnly() {
        String query = "select ?b1 ?b2 ?b3\nwhere {\n  bind(1 as ?b1)\n}";
        List result = QueryResults.asList((CloseableIteration)this.conn.prepareTupleQuery(query).evaluate());
        Assertions.assertThat((int)result.size()).isEqualTo(1);
        BindingSet solution = (BindingSet)result.get(0);
        Assertions.assertThat((Object)solution.getValue("b1")).isEqualTo((Object)Values.literal((String)"1", (CoreDatatype)CoreDatatype.XSD.INTEGER));
        Assertions.assertThat((Object)solution.getValue("b2")).isNull();
        Assertions.assertThat((Object)solution.getValue("b3")).isNull();
    }
}

