/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.testsuite.sparql.tests;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.QueryResults;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.testsuite.sparql.AbstractComplianceTest;
import org.junit.Assert;
import org.junit.Test;

public class ValuesTest
extends AbstractComplianceTest {
    @Test
    public void testValuesInOptional() throws Exception {
        this.loadTestData("/testdata-query/dataset-ses1692.trig", new Resource[0]);
        String query = " PREFIX : <http://example.org/>\n SELECT DISTINCT ?a ?name ?isX WHERE { ?b :p1 ?a . ?a :name ?name. OPTIONAL { ?a a :X . VALUES(?isX) { (:X) } } } ";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)result.hasNext());
            int count = 0;
            while (result.hasNext()) {
                ++count;
                BindingSet bs = (BindingSet)result.next();
                IRI a = (IRI)bs.getValue("a");
                Assert.assertNotNull((Object)a);
                Value isX = bs.getValue("isX");
                Literal name = (Literal)bs.getValue("name");
                Assert.assertNotNull((Object)name);
                if (a.stringValue().endsWith("a1")) {
                    Assert.assertNotNull((Object)isX);
                    continue;
                }
                if (!a.stringValue().endsWith("a2")) continue;
                Assert.assertNull((Object)isX);
            }
            Assert.assertEquals((long)2L, (long)count);
        }
    }

    @Test
    public void testValuesClauseNamedGraph() throws Exception {
        String ex = "http://example.org/";
        String data = "@prefix foaf: <http://xmlns.com/foaf/0.1/> .\n@prefix ex: <" + ex + "> .\nex:graph1 {\n\tex:Person1 rdf:type foaf:Person ;\n\t\tfoaf:name \"Person 1\" .\tex:Person2 rdf:type foaf:Person ;\n\t\tfoaf:name \"Person 2\" .\tex:Person3 rdf:type foaf:Person ;\n\t\tfoaf:name \"Person 3\" .\n}";
        this.conn.add((Reader)new StringReader(data), "", RDFFormat.TRIG, new Resource[0]);
        String query = "SELECT  ?person ?name ?__index \nWHERE {         VALUES (?person ?name  ?__index) { \n                  (<http://example.org/Person1> UNDEF \"0\") \n                  (<http://example.org/Person3> UNDEF \"2\")  } \n        GRAPH <http://example.org/graph1> { ?person <http://xmlns.com/foaf/0.1/name> ?name .   } }";
        TupleQuery q = this.conn.prepareTupleQuery(query);
        List result = QueryResults.asList((Iteration)q.evaluate());
        Assertions.assertThat((List)result).hasSize(2);
    }

    @Test
    public void testValuesCartesianProduct() {
        String queryString = "select ?x ?y where {   values ?x { undef 67 }   values ?y { undef 42 } }";
        TupleQuery tupleQuery = this.conn.prepareTupleQuery("select ?x ?y where {   values ?x { undef 67 }   values ?y { undef 42 } }");
        List bindingSets = QueryResults.asList((Iteration)tupleQuery.evaluate());
        Assertions.assertThat((List)bindingSets).hasSize(4);
    }

    @Test
    public void testSES1081SameTermWithValues() throws Exception {
        this.loadTestData("/testdata-query/dataset-ses1081.trig", new Resource[0]);
        String query = "PREFIX ex: <http://example.org/>\n SELECT * \n WHERE { \n           ?s ex:p ?a . \n          FILTER sameTerm(?a, ?e) \n           VALUES ?e { ex:b } \n  } ";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                BindingSet bs = (BindingSet)result.next();
                ++count;
                Assert.assertNotNull((Object)bs);
                Value s = bs.getValue("s");
                Value a = bs.getValue("a");
                Assert.assertNotNull((Object)s);
                Assert.assertNotNull((Object)a);
                Assert.assertEquals((Object)Values.iri((String)"http://example.org/a"), (Object)s);
                Assert.assertEquals((Object)Values.iri((String)"http://example.org/b"), (Object)a);
            }
            Assert.assertEquals((long)1L, (long)count);
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSES2136() throws Exception {
        this.loadTestData("/testcases-sparql-1.1-w3c/bindings/data02.ttl", new Resource[0]);
        String query = "PREFIX : <http://example.org/>\nSELECT ?s ?o { \n { SELECT * WHERE { ?s ?p ?o . } }\n\tVALUES (?o) { (:b) }\n}\n";
        ValueFactory vf = this.conn.getValueFactory();
        IRI a = vf.createIRI("http://example.org/a");
        IRI b = vf.createIRI("http://example.org/b");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)result.hasNext());
            BindingSet bs = (BindingSet)result.next();
            Assert.assertFalse((String)"only one result expected", (boolean)result.hasNext());
            Assert.assertEquals((Object)a, (Object)bs.getValue("s"));
            Assert.assertEquals((Object)b, (Object)bs.getValue("o"));
        }
    }

    @Test
    public void testFilterExistsExternalValuesClause() {
        String ub = "insert data {\n  <http://subj1> a <http://type> .\n  <http://subj2> a <http://type> .\n  <http://subj1> <http://predicate> <http://obj1> .\n  <http://subj2> <http://predicate> <http://obj2> .\n}";
        this.conn.prepareUpdate(QueryLanguage.SPARQL, ub).execute();
        String query = "select ?s  {\n    ?s a* <http://type> .\n    FILTER EXISTS {?s <http://predicate> ?o}\n} limit 100 values ?o {<http://obj1>}";
        TupleQuery tq = this.conn.prepareTupleQuery(query);
        List result = QueryResults.asList((Iteration)tq.evaluate());
        Assert.assertEquals((String)"single result expected", (long)1L, (long)result.size());
        Assert.assertEquals((Object)"http://subj1", (Object)((BindingSet)result.get(0)).getValue("s").stringValue());
    }
}

