/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.testsuite.sparql.tests;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.testsuite.sparql.AbstractComplianceTest;
import org.junit.Assert;
import org.junit.Test;

public class InTest
extends AbstractComplianceTest {
    @Test
    public void testInComparison1() throws Exception {
        this.loadTestData("/testdata-query/dataset-ses1913.trig", new Resource[0]);
        String query = " PREFIX : <http://example.org/>\n SELECT ?y WHERE { :a :p ?y. FILTER(?y in (:c, :d, 1/0 , 1)) } ";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)result.hasNext());
            BindingSet bs = (BindingSet)result.next();
            Value y = bs.getValue("y");
            Assert.assertNotNull((Object)y);
            Assert.assertTrue((boolean)(y instanceof Literal));
            Assert.assertEquals((Object)Values.literal((String)"1", (CoreDatatype)CoreDatatype.XSD.INTEGER), (Object)y);
        }
    }

    @Test
    public void testInComparison2() throws Exception {
        this.loadTestData("/testdata-query/dataset-ses1913.trig", new Resource[0]);
        String query = " PREFIX : <http://example.org/>\n SELECT ?y WHERE { :a :p ?y. FILTER(?y in (:c, :d, 1/0)) } ";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            Assert.assertFalse((boolean)result.hasNext());
        }
    }

    @Test
    public void testInComparison3() throws Exception {
        this.loadTestData("/testdata-query/dataset-ses1913.trig", new Resource[0]);
        String query = " PREFIX : <http://example.org/>\n SELECT ?y WHERE { :a :p ?y. FILTER(?y in (:c, :d, 1, 1/0)) } ";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)result.hasNext());
            BindingSet bs = (BindingSet)result.next();
            Value y = bs.getValue("y");
            Assert.assertNotNull((Object)y);
            Assert.assertTrue((boolean)(y instanceof Literal));
            Assert.assertEquals((Object)Values.literal((String)"1", (IRI)XSD.INTEGER), (Object)y);
        }
    }
}

