/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.testsuite.sparql.tests;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.QueryResults;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.testsuite.sparql.AbstractComplianceTest;
import org.eclipse.rdf4j.testsuite.sparql.vocabulary.EX;
import org.junit.Assert;
import org.junit.Test;

public class DefaultGraphTest
extends AbstractComplianceTest {
    @Test
    public void testNullContext1() throws Exception {
        this.loadTestData("/testdata-query/dataset-query.trig", new Resource[0]);
        String query = " SELECT *  FROM DEFAULT  WHERE { ?s ?p ?o } ";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            while (result.hasNext()) {
                BindingSet bs = (BindingSet)result.next();
                Assert.assertNotNull((Object)bs);
                Resource s = (Resource)bs.getValue("s");
                Assert.assertNotNull((Object)s);
                Assert.assertNotEquals((Object)EX.BOB, (Object)s);
                Assert.assertNotEquals((Object)EX.ALICE, (Object)s);
            }
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testNullContext2() throws Exception {
        this.loadTestData("/testdata-query/dataset-query.trig", new Resource[0]);
        String query = " SELECT *  FROM rdf4j:nil  WHERE { ?s ?p ?o } ";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            while (result.hasNext()) {
                BindingSet bs = (BindingSet)result.next();
                Assert.assertNotNull((Object)bs);
                Resource s = (Resource)bs.getValue("s");
                Assert.assertNotNull((Object)s);
                Assert.assertNotEquals((Object)EX.BOB, (Object)s);
                Assert.assertNotEquals((Object)EX.ALICE, (Object)s);
            }
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSesameNilAsGraph() throws Exception {
        this.loadTestData("/testdata-query/dataset-query.trig", new Resource[0]);
        String query = " SELECT *  WHERE { GRAPH rdf4j:nil { ?s ?p ?o } } ";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try {
            List result = QueryResults.asList((Iteration)tq.evaluate());
            Assertions.assertThat((int)result.size()).isGreaterThan(1);
            for (BindingSet bs : result) {
                Resource s = (Resource)bs.getValue("s");
                Assert.assertNotNull((Object)s);
                ((ObjectAssert)Assertions.assertThat((Object)s).withFailMessage("%s should not be present in nil graph", new Object[]{EX.BOB})).isNotEqualTo((Object)EX.BOB);
                ((ObjectAssert)Assertions.assertThat((Object)s).withFailMessage("%s should not be present in nil graph", new Object[]{EX.ALICE})).isNotEqualTo((Object)EX.ALICE);
            }
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

