/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.testsuite.sparql;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.testsuite.sparql.RepositorySPARQLComplianceTestSuite;
import org.junit.After;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractComplianceTest {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Repository repo;
    protected RepositoryConnection conn;

    @Before
    public void setUp() throws Exception {
        this.repo = RepositorySPARQLComplianceTestSuite.getEmptyInitializedRepository(this.getClass());
        this.conn = this.repo.getConnection();
    }

    @After
    public void tearDown() throws Exception {
        try {
            this.conn.close();
        }
        finally {
            this.repo.shutDown();
        }
    }

    protected void loadTestData(String dataFile, Resource ... contexts) throws RDFParseException, RepositoryException, IOException {
        this.logger.debug("loading dataset {}", (Object)dataFile);
        try (InputStream dataset = this.getClass().getResourceAsStream(dataFile);){
            this.conn.add(dataset, "", (RDFFormat)Rio.getParserFormatForFileName((String)dataFile).orElseThrow(Rio.unsupportedFormat((String)dataFile)), contexts);
        }
        this.logger.debug("dataset loaded.");
    }

    protected String getNamespaceDeclarations() {
        return "PREFIX dc: <http://purl.org/dc/terms/> \nPREFIX foaf: <http://xmlns.com/foaf/0.1/> \nPREFIX ex: <http://example.org/> \n\n";
    }
}

