/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.parser.sparql.manifest;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.eclipse.rdf4j.common.io.IOUtil;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.common.text.StringUtil;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.BooleanQuery;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.QueryResultHandler;
import org.eclipse.rdf4j.query.QueryResults;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.dawg.DAWGTestResultSetUtil;
import org.eclipse.rdf4j.query.impl.MutableTupleQueryResult;
import org.eclipse.rdf4j.query.impl.SimpleDataset;
import org.eclipse.rdf4j.query.impl.TupleQueryResultBuilder;
import org.eclipse.rdf4j.query.parser.sparql.manifest.SPARQLComplianceTest;
import org.eclipse.rdf4j.query.resultio.BooleanQueryResultParserRegistry;
import org.eclipse.rdf4j.query.resultio.QueryResultFormat;
import org.eclipse.rdf4j.query.resultio.QueryResultIO;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultParser;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.junit.After;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SPARQLQueryComplianceTest
extends SPARQLComplianceTest {
    private static final Logger logger = LoggerFactory.getLogger(SPARQLQueryComplianceTest.class);
    private final String queryFileURL;
    private final String resultFileURL;
    private final Dataset dataset;
    private final boolean ordered;
    private Repository dataRepository;

    public SPARQLQueryComplianceTest(String displayName, String testURI, String name, String queryFileURL, String resultFileURL, Dataset dataset, boolean ordered) {
        super(displayName, testURI, name);
        this.queryFileURL = queryFileURL;
        this.resultFileURL = resultFileURL;
        this.dataset = dataset;
        this.ordered = ordered;
    }

    @Before
    public void setUp() throws Exception {
        this.dataRepository = this.createRepository();
        if (this.dataset != null) {
            try {
                this.uploadDataset(this.dataset);
            }
            catch (Exception exc) {
                try {
                    this.dataRepository.shutDown();
                    this.dataRepository = null;
                }
                catch (Exception e2) {
                    logger.error(e2.toString(), (Throwable)e2);
                }
                throw exc;
            }
        }
    }

    @After
    public void tearDown() throws Exception {
        if (this.dataRepository != null) {
            this.dataRepository.shutDown();
            this.dataRepository = null;
        }
    }

    @Override
    protected void runTest() throws Exception {
        block10: {
            logger.debug("running {}", (Object)this.getName());
            try (RepositoryConnection conn = this.getDataRepository().getConnection();){
                conn.getParserConfig().set(BasicParserSettings.VERIFY_DATATYPE_VALUES, (Object)Boolean.FALSE);
                conn.getParserConfig().set(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES, (Object)Boolean.FALSE);
                String queryString = this.readQueryString();
                Query query = conn.prepareQuery(QueryLanguage.SPARQL, queryString, this.queryFileURL);
                if (this.dataset != null) {
                    query.setDataset(this.dataset);
                }
                if (query instanceof TupleQuery) {
                    TupleQueryResult actualResult = ((TupleQuery)query).evaluate();
                    TupleQueryResult expectedResult = this.readExpectedTupleQueryResult();
                    this.compareTupleQueryResults(actualResult, expectedResult);
                    break block10;
                }
                if (query instanceof GraphQuery) {
                    GraphQueryResult gqr = ((GraphQuery)query).evaluate();
                    Set actualResult = Iterations.asSet((Iteration)gqr);
                    Set<Statement> expectedResult = this.readExpectedGraphQueryResult();
                    this.compareGraphs(actualResult, expectedResult);
                    break block10;
                }
                if (query instanceof BooleanQuery) {
                    boolean actualResult = ((BooleanQuery)query).evaluate();
                    boolean expectedResult = this.readExpectedBooleanQueryResult();
                    Assertions.assertThat((boolean)actualResult).isEqualTo(expectedResult);
                    break block10;
                }
                throw new RuntimeException("Unexpected query type: " + query.getClass());
            }
        }
    }

    protected abstract Repository newRepository() throws Exception;

    private final Repository createRepository() throws Exception {
        Repository repo = this.newRepository();
        try (RepositoryConnection con = repo.getConnection();){
            con.clear(new Resource[0]);
            con.clearNamespaces();
        }
        return repo;
    }

    private final String readQueryString() throws IOException {
        try (InputStream stream = new URL(this.queryFileURL).openStream();){
            String string = IOUtil.readString((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8));
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final TupleQueryResult readExpectedTupleQueryResult() throws Exception {
        Optional tqrFormat = QueryResultIO.getParserFormatForFileName((String)this.resultFileURL);
        if (tqrFormat.isPresent()) {
            try (InputStream in = new URL(this.resultFileURL).openStream();){
                TupleQueryResultParser parser = QueryResultIO.createTupleParser((QueryResultFormat)((QueryResultFormat)tqrFormat.get()));
                parser.setValueFactory(this.getDataRepository().getValueFactory());
                TupleQueryResultBuilder qrBuilder = new TupleQueryResultBuilder();
                parser.setQueryResultHandler((QueryResultHandler)qrBuilder);
                parser.parseQueryResult(in);
                TupleQueryResult tupleQueryResult = qrBuilder.getQueryResult();
                return tupleQueryResult;
            }
        }
        Set<Statement> resultGraph = this.readExpectedGraphQueryResult();
        return DAWGTestResultSetUtil.toTupleQueryResult(resultGraph);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean readExpectedBooleanQueryResult() throws Exception {
        Optional bqrFormat = BooleanQueryResultParserRegistry.getInstance().getFileFormatForFileName(this.resultFileURL);
        if (bqrFormat.isPresent()) {
            try (InputStream in = new URL(this.resultFileURL).openStream();){
                boolean bl = QueryResultIO.parseBoolean((InputStream)in, (QueryResultFormat)((QueryResultFormat)bqrFormat.get()));
                return bl;
            }
        }
        Set<Statement> resultGraph = this.readExpectedGraphQueryResult();
        return DAWGTestResultSetUtil.toBooleanQueryResult(resultGraph);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Set<Statement> readExpectedGraphQueryResult() throws Exception {
        RDFFormat rdfFormat = (RDFFormat)Rio.getParserFormatForFileName((String)this.resultFileURL).orElseThrow(Rio.unsupportedFormat((String)this.resultFileURL));
        RDFParser parser = Rio.createParser((RDFFormat)rdfFormat);
        parser.setDatatypeHandling(RDFParser.DatatypeHandling.IGNORE);
        parser.setPreserveBNodeIDs(true);
        parser.setValueFactory(this.getDataRepository().getValueFactory());
        LinkedHashSet<Statement> result = new LinkedHashSet<Statement>();
        parser.setRDFHandler((RDFHandler)new StatementCollector(result));
        try (InputStream in = new URL(this.resultFileURL).openStream();){
            parser.parse(in, this.resultFileURL);
        }
        return result;
    }

    private final void compareTupleQueryResults(TupleQueryResult queryResult, TupleQueryResult expectedResult) throws Exception {
        boolean resultsEqual;
        MutableTupleQueryResult queryResultTable = new MutableTupleQueryResult(queryResult);
        MutableTupleQueryResult expectedResultTable = new MutableTupleQueryResult(expectedResult);
        boolean laxCardinality = false;
        if (laxCardinality) {
            resultsEqual = QueryResults.isSubset((TupleQueryResult)queryResultTable, (TupleQueryResult)expectedResultTable);
        } else {
            resultsEqual = QueryResults.equals((TupleQueryResult)queryResultTable, (TupleQueryResult)expectedResultTable);
            if (this.ordered) {
                queryResultTable.beforeFirst();
                expectedResultTable.beforeFirst();
                while (queryResultTable.hasNext()) {
                    BindingSet expectedBs;
                    BindingSet bs = queryResultTable.next();
                    if (bs.equals((Object)(expectedBs = expectedResultTable.next()))) continue;
                    resultsEqual = false;
                    break;
                }
            }
        }
        if (!resultsEqual) {
            queryResultTable.beforeFirst();
            expectedResultTable.beforeFirst();
            List queryBindings = Iterations.asList((Iteration)queryResultTable);
            List expectedBindings = Iterations.asList((Iteration)expectedResultTable);
            ArrayList missingBindings = new ArrayList(expectedBindings);
            missingBindings.removeAll(queryBindings);
            ArrayList unexpectedBindings = new ArrayList(queryBindings);
            unexpectedBindings.removeAll(expectedBindings);
            StringBuilder message = new StringBuilder(128);
            message.append("\n============ ");
            message.append(this.getName());
            message.append(" =======================\n");
            if (!missingBindings.isEmpty()) {
                message.append("Missing bindings: \n");
                for (BindingSet bs : missingBindings) {
                    SPARQLQueryComplianceTest.printBindingSet(bs, message);
                }
                message.append("=============");
                StringUtil.appendN((char)'=', (int)this.getName().length(), (StringBuilder)message);
                message.append("========================\n");
            }
            if (!unexpectedBindings.isEmpty()) {
                message.append("Unexpected bindings: \n");
                for (BindingSet bs : unexpectedBindings) {
                    SPARQLQueryComplianceTest.printBindingSet(bs, message);
                }
                message.append("=============");
                StringUtil.appendN((char)'=', (int)this.getName().length(), (StringBuilder)message);
                message.append("========================\n");
            }
            if (this.ordered && missingBindings.isEmpty() && unexpectedBindings.isEmpty()) {
                message.append("Results are not in expected order.\n");
                message.append(" =======================\n");
                message.append("query result: \n");
                for (BindingSet bs : queryBindings) {
                    SPARQLQueryComplianceTest.printBindingSet(bs, message);
                }
                message.append(" =======================\n");
                message.append("expected result: \n");
                for (BindingSet bs : expectedBindings) {
                    SPARQLQueryComplianceTest.printBindingSet(bs, message);
                }
                message.append(" =======================\n");
                System.out.print(message.toString());
            } else if (missingBindings.isEmpty() && unexpectedBindings.isEmpty()) {
                message.append("unexpected duplicate in result.\n");
                message.append(" =======================\n");
                message.append("query result: \n");
                for (BindingSet bs : queryBindings) {
                    SPARQLQueryComplianceTest.printBindingSet(bs, message);
                }
                message.append(" =======================\n");
                message.append("expected result: \n");
                for (BindingSet bs : expectedBindings) {
                    SPARQLQueryComplianceTest.printBindingSet(bs, message);
                }
                message.append(" =======================\n");
                System.out.print(message.toString());
            }
            logger.error(message.toString());
            Assertions.fail((String)message.toString());
        }
    }

    @Override
    protected Repository getDataRepository() {
        return this.dataRepository;
    }

    protected static class SPARQLQueryTestManifest {
        private final List<Object[]> tests = new ArrayList<Object[]>();
        private final List<String> subManifests = new ArrayList<String>();

        public SPARQLQueryTestManifest(String filename, List<String> excludedSubdirs) {
            this(filename, excludedSubdirs, true);
        }

        public SPARQLQueryTestManifest(String filename, List<String> excludedSubdirs, boolean approvedOnly) {
            SailRepositoryConnection connection;
            SailRepository sailRepository = new SailRepository((Sail)new MemoryStore());
            try {
                connection = sailRepository.getConnection();
                try {
                    connection.add(new URL(filename), filename, RDFFormat.TURTLE, new Resource[0]);
                }
                finally {
                    if (connection != null) {
                        connection.close();
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            connection = sailRepository.getConnection();
            try {
                String manifestQuery = " PREFIX qt: <http://www.w3.org/2001/sw/DataAccess/tests/test-query#> PREFIX mf: <http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#> SELECT DISTINCT ?manifestFile WHERE { [] mf:include [ rdf:rest*/rdf:first ?manifestFile ] . }   ";
                try (TupleQueryResult manifestResults = connection.prepareTupleQuery(QueryLanguage.SPARQL, manifestQuery, filename).evaluate();){
                    for (BindingSet bindingSet : manifestResults) {
                        String subManifestFile = bindingSet.getValue("manifestFile").stringValue();
                        if (!SPARQLQueryComplianceTest.includeSubManifest(subManifestFile, excludedSubdirs)) continue;
                        this.getSubManifests().add(subManifestFile);
                    }
                }
                StringBuilder query = new StringBuilder(512);
                query.append(" PREFIX mf: <http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#> \n");
                query.append(" PREFIX dawgt: <http://www.w3.org/2001/sw/DataAccess/tests/test-dawg#> \n");
                query.append(" PREFIX qt: <http://www.w3.org/2001/sw/DataAccess/tests/test-query#> \n");
                query.append(" PREFIX sd: <http://www.w3.org/ns/sparql-service-description#> \n");
                query.append(" PREFIX ent: <http://www.w3.org/ns/entailment/> \n");
                query.append(" SELECT DISTINCT ?testURI ?testName ?resultFile ?action ?queryFile ?defaultGraph ?ordered \n");
                query.append(" WHERE { [] rdf:first ?testURI . \n");
                if (approvedOnly) {
                    query.append(" ?testURI dawgt:approval dawgt:Approved . \n");
                }
                query.append(" ?testURI mf:name ?testName; \n");
                query.append("          mf:result ?resultFile . \n");
                query.append(" OPTIONAL { ?testURI mf:checkOrder ?ordered } \n");
                query.append(" OPTIONAL { ?testURI  mf:requires ?requirement } \n");
                query.append(" ?testURI mf:action ?action. \n");
                query.append(" ?action qt:query ?queryFile . \n");
                query.append(" OPTIONAL { ?action qt:data ?defaultGraph } \n");
                query.append(" OPTIONAL { ?action sd:entailmentRegime ?regime } \n");
                query.append(" FILTER(!STRENDS(STR(?resultFile), \"csv\")) \n");
                query.append(" FILTER(!BOUND(?regime)) \n");
                query.append(" FILTER (!BOUND(?requirement) || (?requirement != mf:BasicFederation)) \n");
                query.append(" }\n");
                try (TupleQueryResult result = connection.prepareTupleQuery(query.toString()).evaluate();){
                    query.setLength(0);
                    query.append(" PREFIX qt: <http://www.w3.org/2001/sw/DataAccess/tests/test-query#> \n");
                    query.append(" SELECT ?graph \n");
                    query.append(" WHERE { ?action qt:graphData ?graph } \n");
                    TupleQuery namedGraphsQuery = connection.prepareTupleQuery(query.toString());
                    for (BindingSet bs : result) {
                        String testName = bs.getValue("testName").stringValue();
                        Object displayName = filename.substring(0, filename.lastIndexOf(47));
                        displayName = ((String)displayName).substring(((String)displayName).lastIndexOf(47) + 1, ((String)displayName).length()) + ": " + testName;
                        IRI defaultGraphURI = (IRI)bs.getValue("defaultGraph");
                        Value action = bs.getValue("action");
                        Value ordered = bs.getValue("ordered");
                        SimpleDataset dataset = null;
                        namedGraphsQuery.setBinding("action", action);
                        try (TupleQueryResult namedGraphs = namedGraphsQuery.evaluate();){
                            if (defaultGraphURI != null || namedGraphs.hasNext()) {
                                dataset = new SimpleDataset();
                                if (defaultGraphURI != null) {
                                    dataset.addDefaultGraph(defaultGraphURI);
                                }
                                while (namedGraphs.hasNext()) {
                                    BindingSet graphBindings = (BindingSet)namedGraphs.next();
                                    IRI namedGraphURI = (IRI)graphBindings.getValue("graph");
                                    dataset.addNamedGraph(namedGraphURI);
                                }
                            }
                        }
                        this.getTests().add(new Object[]{displayName, bs.getValue("testURI").stringValue(), testName, bs.getValue("queryFile").stringValue(), bs.getValue("resultFile").stringValue(), dataset, Literals.getBooleanValue((Value)ordered, (boolean)false)});
                    }
                }
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }

        public List<Object[]> getTests() {
            return this.tests;
        }

        public List<String> getSubManifests() {
            return this.subManifests;
        }
    }
}

