/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.parser.sparql.manifest;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.eclipse.rdf4j.common.io.FileUtil;
import org.eclipse.rdf4j.common.io.IOUtil;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.algebra.DeleteData;
import org.eclipse.rdf4j.query.algebra.InsertData;
import org.eclipse.rdf4j.query.algebra.UpdateExpr;
import org.eclipse.rdf4j.query.parser.ParsedOperation;
import org.eclipse.rdf4j.query.parser.ParsedUpdate;
import org.eclipse.rdf4j.query.parser.sparql.manifest.SPARQL11ManifestTest;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.repository.sail.helpers.SailUpdateExecutor;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public abstract class SPARQL11SyntaxTest
extends TestCase {
    private static final Logger logger = LoggerFactory.getLogger(SPARQL11SyntaxTest.class);
    private static final String SUBMANIFEST_QUERY;
    private static final String TESTCASE_QUERY;
    protected final String testURI;
    protected final String queryFileURL;
    protected final boolean positiveTest;

    public SPARQL11SyntaxTest(String testURI, String name, String queryFileURL, boolean positiveTest) {
        super(name);
        this.testURI = testURI;
        this.queryFileURL = queryFileURL;
        this.positiveTest = positiveTest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runTest() throws Exception {
        block12: {
            InputStream stream = new URL(this.queryFileURL).openStream();
            String query = IOUtil.readString((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8));
            stream.close();
            try {
                ParsedOperation operation = this.parseOperation(query, this.queryFileURL);
                if (!this.positiveTest) {
                    boolean dataBlockUpdate = false;
                    if (operation instanceof ParsedUpdate) {
                        for (UpdateExpr updateExpr : ((ParsedUpdate)operation).getUpdateExprs()) {
                            if (!(updateExpr instanceof InsertData) && !(updateExpr instanceof DeleteData)) continue;
                            dataBlockUpdate = true;
                            MemoryStore store = new MemoryStore();
                            store.init();
                            try (NotifyingSailConnection conn = store.getConnection();){
                                conn.begin();
                                SailUpdateExecutor exec = new SailUpdateExecutor((SailConnection)conn, store.getValueFactory(), null);
                                exec.executeUpdate(updateExpr, null, null, true, -1);
                                conn.rollback();
                                SPARQL11SyntaxTest.fail((String)"Negative test case should have failed to parse");
                            }
                        }
                    }
                    if (!dataBlockUpdate) {
                        SPARQL11SyntaxTest.fail((String)"Negative test case should have failed to parse");
                    }
                }
            }
            catch (MalformedQueryException e) {
                if (!this.positiveTest) break block12;
                e.printStackTrace();
                SPARQL11SyntaxTest.fail((String)("Positive test case failed: " + e.getMessage()));
            }
        }
    }

    protected abstract ParsedOperation parseOperation(String var1, String var2) throws MalformedQueryException;

    public static Test suite() throws Exception {
        return new TestSuite();
    }

    public static Test suite(Factory factory, boolean useRemote) throws Exception {
        File tmpDir;
        String host;
        if (useRemote) {
            host = "http://www.w3.org/2009/sparql/docs/tests/data-sparql11/";
            tmpDir = null;
        } else {
            URL url = SPARQL11SyntaxTest.class.getResource("/testcases-sparql-1.1-w3c/");
            if ("jar".equals(url.getProtocol())) {
                try {
                    tmpDir = Files.createTempDirectory("sparql-syntax", new FileAttribute[0]).toFile();
                    JarURLConnection con = (JarURLConnection)url.openConnection();
                    JarFile jar = con.getJarFile();
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry file = entries.nextElement();
                        File f = new File(tmpDir + File.separator + file.getName());
                        if (file.isDirectory()) {
                            f.mkdir();
                            continue;
                        }
                        InputStream is = jar.getInputStream(file);
                        try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(f));){
                            while (is.available() > 0) {
                                ((OutputStream)fos).write(is.read());
                            }
                        }
                        is.close();
                    }
                    File localFile = new File(tmpDir, con.getEntryName());
                    host = localFile.toURI().toURL().toString();
                }
                catch (IOException e) {
                    throw new AssertionError((Object)e);
                }
            }
            host = url.toString();
            tmpDir = null;
        }
        String manifestFile = host + "manifest-all.ttl";
        TestSuite suite = new TestSuite(){

            public void run(TestResult result) {
                try {
                    super.run(result);
                }
                finally {
                    if (tmpDir != null) {
                        try {
                            FileUtil.deleteDir((File)tmpDir);
                        }
                        catch (IOException e) {
                            System.err.println("Unable to clean up temporary directory '" + tmpDir + "': " + e.getMessage());
                        }
                    }
                }
            }
        };
        SailRepository manifestRep = new SailRepository((Sail)new MemoryStore());
        try (RepositoryConnection con = manifestRep.getConnection();){
            logger.debug("Loading manifest data");
            URL manifest = new URL(manifestFile);
            SPARQL11ManifestTest.addTurtle(con, manifest, manifestFile, new Resource[0]);
            logger.info("Searching for sub-manifests");
            ArrayList<String> subManifestList = new ArrayList<String>();
            TupleQueryResult subManifests = con.prepareTupleQuery(QueryLanguage.SPARQL, SUBMANIFEST_QUERY).evaluate();
            while (subManifests.hasNext()) {
                BindingSet bindings = (BindingSet)subManifests.next();
                subManifestList.add(bindings.getValue("subManifest").toString());
            }
            subManifests.close();
            logger.info("Found {} sub-manifests", (Object)subManifestList.size());
            for (String subManifest : subManifestList) {
                logger.info("Loading sub manifest {}", (Object)subManifest);
                con.clear(new Resource[0]);
                URL subManifestURL = new URL(subManifest);
                SPARQL11ManifestTest.addTurtle(con, subManifestURL, subManifest, new Resource[0]);
                TestSuite subSuite = new TestSuite(subManifest.substring(host.length()));
                logger.info("Creating test cases for {}", (Object)subManifest);
                TupleQueryResult tests = con.prepareTupleQuery(QueryLanguage.SPARQL, TESTCASE_QUERY).evaluate();
                while (tests.hasNext()) {
                    BindingSet bindingSet = (BindingSet)tests.next();
                    String testURI = bindingSet.getValue("TestURI").toString();
                    String testName = bindingSet.getValue("Name").toString();
                    String testAction = bindingSet.getValue("Action").toString();
                    String type = bindingSet.getValue("Type").toString();
                    boolean positiveTest = type.equals("http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#PositiveSyntaxTest11") || type.equals("http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#PositiveUpdateSyntaxTest11");
                    subSuite.addTest((Test)factory.createSPARQLSyntaxTest(testURI, testName, testAction, positiveTest));
                }
                tests.close();
                suite.addTest((Test)subSuite);
            }
        }
        manifestRep.shutDown();
        logger.info("Added {} tests to suite ", (Object)suite.countTestCases());
        return suite;
    }

    static {
        StringBuilder sb = new StringBuilder(512);
        sb.append("PREFIX mf: <http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#> ");
        sb.append("PREFIX qt: <http://www.w3.org/2001/sw/DataAccess/tests/test-query#> ");
        sb.append("SELECT ?subManifest ");
        sb.append("WHERE { [] mf:include [ rdf:rest*/rdf:first ?subManifest ] . } ");
        SUBMANIFEST_QUERY = sb.toString();
        sb.setLength(0);
        sb.append("PREFIX mf: <http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#> ");
        sb.append("PREFIX qt: <http://www.w3.org/2001/sw/DataAccess/tests/test-query#> ");
        sb.append("PREFIX dawgt: <http://www.w3.org/2001/sw/DataAccess/tests/test-dawg#> ");
        sb.append("SELECT ?TestURI ?Name ?Action ?Type ");
        sb.append("WHERE { [] rdf:first ?TestURI. ");
        sb.append("        ?TestURI a ?Type ; ");
        sb.append("                 mf:name ?Name ;");
        sb.append("                 mf:action ?Action ;");
        sb.append("                 dawgt:approval dawgt:Approved . ");
        sb.append("        FILTER(?Type IN (mf:PositiveSyntaxTest11, mf:NegativeSyntaxTest11, mf:PositiveUpdateSyntaxTest11, mf:NegativeUpdateSyntaxTest11)) ");
        sb.append(" } ");
        TESTCASE_QUERY = sb.toString();
    }

    public static interface Factory {
        public SPARQL11SyntaxTest createSPARQLSyntaxTest(String var1, String var2, String var3, boolean var4);
    }
}

