/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.parser.sparql.manifest;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Objects;
import junit.framework.Test;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.eclipse.rdf4j.common.io.FileUtil;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.parser.sparql.manifest.SPARQLQueryTest;
import org.eclipse.rdf4j.query.parser.sparql.manifest.SPARQLUpdateConformanceTest;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.repository.util.RDFInserter;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.turtle.TurtleParser;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class SPARQL11ManifestTest {
    static final Logger logger = LoggerFactory.getLogger(SPARQL11ManifestTest.class);
    private static File tmpDir;

    public static TestSuite suite(SPARQLQueryTest.Factory factory, String manifestFile, boolean approvedTestsOnly, String ... excludedSubdirs) throws Exception {
        TestSuite suite = new TestSuite(factory.getClass().getName()){

            public void run(TestResult result) {
                try {
                    super.run(result);
                }
                finally {
                    if (tmpDir != null) {
                        try {
                            FileUtil.deleteDir((File)tmpDir);
                        }
                        catch (IOException e) {
                            System.err.println("Unable to clean up temporary directory '" + tmpDir + "': " + e.getMessage());
                        }
                    }
                }
            }
        };
        SailRepository manifestRep = new SailRepository((Sail)new MemoryStore());
        try (RepositoryConnection con = manifestRep.getConnection();){
            SPARQL11ManifestTest.addTurtle(con, new URL(manifestFile), manifestFile, new Resource[0]);
            String query = " PREFIX qt: <http://www.w3.org/2001/sw/DataAccess/tests/test-query#> PREFIX mf: <http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#> SELECT DISTINCT ?manifestFile WHERE { [] mf:include [ rdf:rest*/rdf:first ?manifestFile ] . }   ";
            TupleQueryResult manifestResults = con.prepareTupleQuery(QueryLanguage.SPARQL, query, manifestFile).evaluate();
            for (BindingSet bindingSet : manifestResults) {
                String subManifestFile = bindingSet.getValue("manifestFile").stringValue();
                if (!SPARQL11ManifestTest.includeSubManifest(subManifestFile, excludedSubdirs)) continue;
                suite.addTest((Test)SPARQLQueryTest.suite(subManifestFile, factory, approvedTestsOnly));
            }
        }
        manifestRep.shutDown();
        logger.info("Created aggregated test suite with " + suite.countTestCases() + " test cases.");
        return suite;
    }

    public static TestSuite suite(SPARQLUpdateConformanceTest.Factory factory, String manifestFile, boolean approvedTestsOnly, String ... excludedSubdirs) throws Exception {
        TestSuite suite = new TestSuite(factory.getClass().getName()){

            public void run(TestResult result) {
                try {
                    super.run(result);
                }
                finally {
                    if (tmpDir != null) {
                        try {
                            FileUtil.deleteDir((File)tmpDir);
                        }
                        catch (IOException e) {
                            System.err.println("Unable to clean up temporary directory '" + tmpDir + "': " + e.getMessage());
                        }
                    }
                }
            }
        };
        SailRepository manifestRep = new SailRepository((Sail)new MemoryStore());
        try (RepositoryConnection con = manifestRep.getConnection();){
            SPARQL11ManifestTest.addTurtle(con, new URL(manifestFile), manifestFile, new Resource[0]);
            String query = " PREFIX qt: <http://www.w3.org/2001/sw/DataAccess/tests/test-query#> PREFIX mf: <http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#> SELECT DISTINCT ?manifestFile WHERE { [] mf:include [ rdf:rest*/rdf:first ?manifestFile ] . }   ";
            TupleQueryResult manifestResults = con.prepareTupleQuery(QueryLanguage.SPARQL, query, manifestFile).evaluate();
            for (BindingSet bindingSet : manifestResults) {
                String subManifestFile = bindingSet.getValue("manifestFile").stringValue();
                if (!SPARQL11ManifestTest.includeSubManifest(subManifestFile, excludedSubdirs)) continue;
                suite.addTest((Test)SPARQLUpdateConformanceTest.suite(subManifestFile, factory, approvedTestsOnly));
            }
        }
        manifestRep.shutDown();
        logger.info("Created aggregated test suite with " + suite.countTestCases() + " test cases.");
        return suite;
    }

    private static boolean includeSubManifest(String subManifestFile, String[] excludedSubdirs) {
        boolean result = true;
        if (excludedSubdirs != null && excludedSubdirs.length > 0) {
            int index = subManifestFile.lastIndexOf(47);
            String path = subManifestFile.substring(0, index);
            String sd = path.substring(path.lastIndexOf(47) + 1);
            for (String subdir : excludedSubdirs) {
                if (!sd.equals(subdir)) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addTurtle(RepositoryConnection con, URL url, String baseURI, Resource ... contexts) throws IOException, RepositoryException, RDFParseException {
        if (baseURI == null) {
            baseURI = url.toExternalForm();
        }
        try (InputStream in = url.openStream();){
            Objects.requireNonNull(contexts, "contexts argument may not be null; either the value should be cast to Resource or an empty array should be supplied");
            ValueFactory vf = con.getRepository().getValueFactory();
            TurtleParser rdfParser = new TurtleParser();
            rdfParser.setValueFactory(vf);
            rdfParser.setVerifyData(false);
            rdfParser.setStopAtFirstError(true);
            rdfParser.setDatatypeHandling(RDFParser.DatatypeHandling.IGNORE);
            RDFInserter rdfInserter = new RDFInserter(con);
            rdfInserter.enforceContext(contexts);
            rdfParser.setRDFHandler((RDFHandler)rdfInserter);
            con.begin();
            try {
                rdfParser.parse(in, baseURI);
                con.commit();
            }
            catch (RDFHandlerException e) {
                con.rollback();
                throw (RepositoryException)e.getCause();
            }
            catch (RuntimeException e) {
                con.rollback();
            }
        }
    }
}

