/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.parser.sparql.manifest;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import junit.framework.Test;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.eclipse.rdf4j.common.io.FileUtil;
import org.eclipse.rdf4j.common.io.ZipUtil;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.parser.sparql.manifest.SPARQLQueryTest;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.repository.util.RDFInserter;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.turtle.TurtleParser;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class SPARQL10ManifestTest {
    static final Logger logger = LoggerFactory.getLogger(SPARQL10ManifestTest.class);
    private static final boolean REMOTE = false;

    public static TestSuite suite(SPARQLQueryTest.Factory factory) throws Exception {
        String manifestFile;
        File tmpDir;
        URL url = SPARQL10ManifestTest.class.getResource("/testcases-sparql-1.0-w3c/data-r2/manifest-evaluation.ttl");
        if ("jar".equals(url.getProtocol())) {
            try {
                tmpDir = Files.createTempDirectory("sparql-evaluation", new FileAttribute[0]).toFile();
                JarURLConnection con = (JarURLConnection)url.openConnection();
                JarFile jar = con.getJarFile();
                ZipUtil.extract((ZipFile)jar, (File)tmpDir);
                File localFile = new File(tmpDir, con.getEntryName());
                manifestFile = localFile.toURI().toURL().toString();
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        } else {
            manifestFile = url.toString();
            tmpDir = null;
        }
        TestSuite suite = new TestSuite(factory.getClass().getName()){

            public void run(TestResult result) {
                try {
                    super.run(result);
                }
                finally {
                    if (tmpDir != null) {
                        try {
                            FileUtil.deleteDir((File)tmpDir);
                        }
                        catch (IOException e) {
                            System.err.println("Unable to clean up temporary directory '" + tmpDir + "': " + e.getMessage());
                        }
                    }
                }
            }
        };
        SailRepository manifestRep = new SailRepository((Sail)new MemoryStore());
        try (RepositoryConnection con = manifestRep.getConnection();){
            SPARQL10ManifestTest.addTurtle(con, new URL(manifestFile), manifestFile, new Resource[0]);
            String query = "PREFIX mf: <http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#>\n PRFIX qt: <http://www.w3.org/2001/sw/DataAccess/tests/test-query#>SELECT DISTINCT ?manifestFile\nWHERE { ?x rdf:first ?manifestFile .} ";
            TupleQueryResult manifestResults = con.prepareTupleQuery(QueryLanguage.SPARQL, query, manifestFile).evaluate();
            while (manifestResults.hasNext()) {
                BindingSet bindingSet = (BindingSet)manifestResults.next();
                String subManifestFile = bindingSet.getValue("manifestFile").stringValue();
                suite.addTest((Test)SPARQLQueryTest.suite(subManifestFile, factory));
            }
            manifestResults.close();
        }
        manifestRep.shutDown();
        logger.info("Created aggregated test suite with " + suite.countTestCases() + " test cases.");
        return suite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addTurtle(RepositoryConnection con, URL url, String baseURI, Resource ... contexts) throws IOException, RepositoryException, RDFParseException, RDFHandlerException {
        Objects.requireNonNull(contexts, "contexts argument may not be null; either the value should be cast to Resource or an empty array should be supplied");
        if (baseURI == null) {
            baseURI = url.toExternalForm();
        }
        try (InputStream in = url.openStream();){
            ValueFactory vf = con.getRepository().getValueFactory();
            TurtleParser rdfParser = new TurtleParser();
            rdfParser.setValueFactory(vf);
            rdfParser.setVerifyData(false);
            rdfParser.setStopAtFirstError(true);
            rdfParser.setDatatypeHandling(RDFParser.DatatypeHandling.IGNORE);
            RDFInserter rdfInserter = new RDFInserter(con);
            rdfInserter.enforceContext(contexts);
            rdfParser.setRDFHandler((RDFHandler)rdfInserter);
            con.begin();
            try {
                rdfParser.parse(in, baseURI);
                con.commit();
            }
            catch (RDFHandlerException e) {
                if (con.isActive()) {
                    con.rollback();
                }
                if (e.getCause() != null && e.getCause() instanceof RepositoryException) {
                    throw (RepositoryException)e.getCause();
                }
                throw e;
            }
            catch (RuntimeException e) {
                if (con.isActive()) {
                    con.rollback();
                }
                throw e;
            }
        }
    }
}

