/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.parser.sparql;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.OWL;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.query.AbstractTupleQueryResultHandler;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.QueryResults;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.eclipse.rdf4j.query.impl.MapBindingSet;
import org.eclipse.rdf4j.query.impl.SimpleBinding;
import org.eclipse.rdf4j.query.impl.SimpleDataset;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.Rio;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ComplexSPARQLQueryTest {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Repository rep;
    protected RepositoryConnection conn;
    protected ValueFactory f;
    protected static final String EX_NS = "http://example.org/";
    private IRI bob;
    private IRI alice;
    private IRI mary;

    @BeforeClass
    public static void setUpClass() throws Exception {
        System.setProperty("org.eclipse.rdf4j.repository.debug", "true");
    }

    @Before
    public void setUp() throws Exception {
        this.logger.debug("setting up test");
        this.rep = this.newRepository();
        this.rep.initialize();
        this.f = this.rep.getValueFactory();
        this.conn = this.rep.getConnection();
        this.conn.clear(new Resource[0]);
        this.bob = this.f.createIRI(EX_NS, "bob");
        this.alice = this.f.createIRI(EX_NS, "alice");
        this.mary = this.f.createIRI(EX_NS, "mary");
        this.logger.debug("test setup complete.");
    }

    @After
    public void tearDown() throws Exception {
        try {
            if (this.conn != null) {
                this.conn.close();
            }
        }
        finally {
            if (this.rep != null) {
                this.rep.shutDown();
            }
        }
    }

    @Test
    public void testNullContext1() throws Exception {
        this.loadTestData("/testdata-query/dataset-query.trig", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append(" SELECT * ");
        query.append(" FROM DEFAULT ");
        query.append(" WHERE { ?s ?p ?o } ");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            while (result.hasNext()) {
                BindingSet bs = (BindingSet)result.next();
                Assert.assertNotNull((Object)bs);
                Resource s = (Resource)bs.getValue("s");
                Assert.assertNotNull((Object)s);
                Assert.assertFalse((boolean)this.bob.equals((Object)s));
                Assert.assertFalse((boolean)this.alice.equals((Object)s));
            }
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSES2373SubselectOptional() throws Exception {
        this.conn.prepareUpdate(QueryLanguage.SPARQL, "insert data {<u:1> <u:r> <u:subject> .<u:1> <u:v> 1 .<u:1> <u:x> <u:x1> .<u:2> <u:r> <u:subject> .<u:2> <u:v> 2 .<u:2> <u:x> <u:x2> .<u:3> <u:r> <u:subject> .<u:3> <u:v> 3 .<u:3> <u:x> <u:x3> .<u:4> <u:r> <u:subject> .<u:4> <u:v> 4 .<u:4> <u:x> <u:x4> .<u:5> <u:r> <u:subject> .<u:5> <u:v> 5 .<u:5> <u:x> <u:x5> .}").execute();
        StringBuilder qb = new StringBuilder();
        qb.append("select ?x { \n");
        qb.append(" { select ?v { ?v <u:r> <u:subject> filter (?v = <u:1>) } }.\n");
        qb.append("  optional {  select ?val { ?v <u:v> ?val .} }\n");
        qb.append("  ?v <u:x> ?x \n");
        qb.append("}\n");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, qb.toString());
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertTrue((String)"The query should return a result", (boolean)result.hasNext());
            BindingSet b = (BindingSet)result.next();
            Assert.assertTrue((String)"?x is from the mandatory part of the query and should be bound", (boolean)b.hasBinding("x"));
        }
    }

    @Test
    public void testSES2154SubselectOptional() throws Exception {
        StringBuilder ub = new StringBuilder();
        ub.append("insert data { \n");
        ub.append(" <urn:s1> a <urn:C> .  \n");
        ub.append(" <urn:s2> a <urn:C> .  \n");
        ub.append(" <urn:s3> a <urn:C> .  \n");
        ub.append(" <urn:s4> a <urn:C> .  \n");
        ub.append(" <urn:s5> a <urn:C> .  \n");
        ub.append(" <urn:s6> a <urn:C> .  \n");
        ub.append(" <urn:s7> a <urn:C> .  \n");
        ub.append(" <urn:s8> a <urn:C> .  \n");
        ub.append(" <urn:s9> a <urn:C> .  \n");
        ub.append(" <urn:s10> a <urn:C> .  \n");
        ub.append(" <urn:s11> a <urn:C> .  \n");
        ub.append(" <urn:s12> a <urn:C> .  \n");
        ub.append(" <urn:s1> <urn:p> \"01\" .  \n");
        ub.append(" <urn:s2> <urn:p> \"02\" .  \n");
        ub.append(" <urn:s3> <urn:p> \"03\" .  \n");
        ub.append(" <urn:s4> <urn:p> \"04\" .  \n");
        ub.append(" <urn:s5> <urn:p> \"05\" .  \n");
        ub.append(" <urn:s6> <urn:p> \"06\" .  \n");
        ub.append(" <urn:s7> <urn:p> \"07\" .  \n");
        ub.append(" <urn:s8> <urn:p> \"08\" .  \n");
        ub.append(" <urn:s9> <urn:p> \"09\" .  \n");
        ub.append(" <urn:s10> <urn:p> \"10\" .  \n");
        ub.append(" <urn:s11> <urn:p> \"11\" .  \n");
        ub.append(" <urn:s12> <urn:p> \"12\" .  \n");
        ub.append("} \n");
        this.conn.prepareUpdate(QueryLanguage.SPARQL, ub.toString()).execute();
        StringBuilder qb = new StringBuilder();
        qb.append("SELECT ?s ?label\n");
        qb.append("WHERE { \n");
        qb.append(" \t  ?s a <urn:C> \n .\n");
        qb.append(" \t  OPTIONAL  { {SELECT ?label  WHERE { \n");
        qb.append("                     ?s <urn:p> ?label . \n");
        qb.append("   \t      } ORDER BY ?label LIMIT 2 \n");
        qb.append("\t\t    }\n");
        qb.append("       }\n");
        qb.append("}\n");
        qb.append("ORDER BY ?s\n");
        qb.append("LIMIT 10 \n");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, qb.toString());
        try (TupleQueryResult evaluate = tq.evaluate();){
            Assert.assertTrue((String)"The query should return a result", (boolean)evaluate.hasNext());
            List result = QueryResults.asList((Iteration)evaluate);
            Assert.assertEquals((long)10L, (long)result.size());
            for (BindingSet bs : result) {
                Literal label = (Literal)bs.getValue("label");
                Assert.assertTrue((String)("wrong label value (expected '01' or '02', but got '" + label.stringValue() + "')"), (label.stringValue().equals("01") || label.stringValue().equals("02") ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testNullContext2() throws Exception {
        this.loadTestData("/testdata-query/dataset-query.trig", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append(this.getNamespaceDeclarations());
        query.append(" SELECT * ");
        query.append(" FROM rdf4j:nil ");
        query.append(" WHERE { ?s ?p ?o } ");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            while (result.hasNext()) {
                BindingSet bs = (BindingSet)result.next();
                Assert.assertNotNull((Object)bs);
                Resource s = (Resource)bs.getValue("s");
                Assert.assertNotNull((Object)s);
                Assert.assertFalse((boolean)this.bob.equals((Object)s));
                Assert.assertFalse((boolean)this.alice.equals((Object)s));
            }
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSesameNilAsGraph() throws Exception {
        this.loadTestData("/testdata-query/dataset-query.trig", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append(this.getNamespaceDeclarations());
        query.append(" SELECT * ");
        query.append(" WHERE { GRAPH rdf4j:nil { ?s ?p ?o } } ");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        try {
            List result = QueryResults.asList((Iteration)tq.evaluate());
            Assertions.assertThat((int)result.size()).isGreaterThan(1);
            for (BindingSet bs : result) {
                Resource s = (Resource)bs.getValue("s");
                Assert.assertNotNull((Object)s);
                ((ObjectAssert)Assertions.assertThat((Object)s).withFailMessage("%s should not be present in nil graph", new Object[]{this.bob})).isNotEqualTo((Object)this.bob);
                ((ObjectAssert)Assertions.assertThat((Object)s).withFailMessage("%s should not be present in nil graph", new Object[]{this.alice})).isNotEqualTo((Object)this.alice);
            }
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDescribeA() throws Exception {
        this.loadTestData("/testdata-query/dataset-describe.trig", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append(this.getNamespaceDeclarations());
        query.append("DESCRIBE ex:a");
        GraphQuery gq = this.conn.prepareGraphQuery(QueryLanguage.SPARQL, query.toString());
        ValueFactory f = this.conn.getValueFactory();
        IRI a = f.createIRI("http://example.org/a");
        IRI p = f.createIRI("http://example.org/p");
        try (GraphQueryResult evaluate = gq.evaluate();){
            Model result = QueryResults.asModel((CloseableIteration)evaluate);
            Set objects = result.filter((Resource)a, p, null, new Resource[0]).objects();
            Assert.assertNotNull((Object)objects);
            for (Value object : objects) {
                if (!(object instanceof BNode)) continue;
                Assert.assertTrue((boolean)result.contains((Resource)object, null, null, new Resource[0]));
                Assert.assertEquals((long)2L, (long)result.filter((Resource)object, null, null, new Resource[0]).size());
            }
        }
    }

    @Test
    public void testDescribeAWhere() throws Exception {
        this.loadTestData("/testdata-query/dataset-describe.trig", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append(this.getNamespaceDeclarations());
        query.append("DESCRIBE ?x WHERE {?x rdfs:label \"a\". } ");
        GraphQuery gq = this.conn.prepareGraphQuery(QueryLanguage.SPARQL, query.toString());
        ValueFactory f = this.conn.getValueFactory();
        IRI a = f.createIRI("http://example.org/a");
        IRI p = f.createIRI("http://example.org/p");
        try (GraphQueryResult evaluate = gq.evaluate();){
            Model result = QueryResults.asModel((CloseableIteration)evaluate);
            Set objects = result.filter((Resource)a, p, null, new Resource[0]).objects();
            Assert.assertNotNull((Object)objects);
            for (Value object : objects) {
                if (!(object instanceof BNode)) continue;
                Assert.assertTrue((boolean)result.contains((Resource)object, null, null, new Resource[0]));
                Assert.assertEquals((long)2L, (long)result.filter((Resource)object, null, null, new Resource[0]).size());
            }
        }
    }

    @Test
    public void testDescribeWhere() throws Exception {
        this.loadTestData("/testdata-query/dataset-describe.trig", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append(this.getNamespaceDeclarations());
        query.append("DESCRIBE ?x WHERE {?x rdfs:label ?y . } ");
        GraphQuery gq = this.conn.prepareGraphQuery(QueryLanguage.SPARQL, query.toString());
        ValueFactory vf = this.conn.getValueFactory();
        IRI a = vf.createIRI("http://example.org/a");
        IRI b = vf.createIRI("http://example.org/b");
        IRI c = vf.createIRI("http://example.org/c");
        IRI e = vf.createIRI("http://example.org/e");
        IRI f = vf.createIRI("http://example.org/f");
        IRI p = vf.createIRI("http://example.org/p");
        try (GraphQueryResult evaluate = gq.evaluate();){
            Model result = QueryResults.asModel((CloseableIteration)evaluate);
            Assert.assertTrue((boolean)result.contains((Resource)a, p, null, new Resource[0]));
            Assert.assertTrue((boolean)result.contains((Resource)b, RDFS.LABEL, null, new Resource[0]));
            Assert.assertTrue((boolean)result.contains((Resource)c, RDFS.LABEL, null, new Resource[0]));
            Assert.assertTrue((boolean)result.contains(null, p, (Value)b, new Resource[0]));
            Assert.assertTrue((boolean)result.contains((Resource)e, RDFS.LABEL, null, new Resource[0]));
            Assert.assertTrue((boolean)result.contains(null, p, (Value)e, new Resource[0]));
            Assert.assertFalse((boolean)result.contains((Resource)f, null, null, new Resource[0]));
            Set objects = result.filter((Resource)a, p, null, new Resource[0]).objects();
            Assert.assertNotNull((Object)objects);
            for (Value object : objects) {
                if (!(object instanceof BNode)) continue;
                Assert.assertTrue((boolean)result.contains((Resource)object, null, null, new Resource[0]));
                Assert.assertEquals((long)2L, (long)result.filter((Resource)object, null, null, new Resource[0]).size());
            }
        }
    }

    @Test
    public void testDescribeB() throws Exception {
        this.loadTestData("/testdata-query/dataset-describe.trig", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append(this.getNamespaceDeclarations());
        query.append("DESCRIBE ex:b");
        GraphQuery gq = this.conn.prepareGraphQuery(QueryLanguage.SPARQL, query.toString());
        ValueFactory f = this.conn.getValueFactory();
        IRI b = f.createIRI("http://example.org/b");
        IRI p = f.createIRI("http://example.org/p");
        try (GraphQueryResult evaluate = gq.evaluate();){
            Model result = QueryResults.asModel((CloseableIteration)evaluate);
            Set subjects = result.filter(null, p, (Value)b, new Resource[0]).subjects();
            Assert.assertNotNull((Object)subjects);
            for (Value subject : subjects) {
                if (!(subject instanceof BNode)) continue;
                Assert.assertTrue((boolean)result.contains(null, null, subject, new Resource[0]));
            }
        }
    }

    @Test
    public void testDescribeD() throws Exception {
        this.loadTestData("/testdata-query/dataset-describe.trig", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append(this.getNamespaceDeclarations());
        query.append("DESCRIBE ex:d");
        GraphQuery gq = this.conn.prepareGraphQuery(QueryLanguage.SPARQL, query.toString());
        ValueFactory f = this.conn.getValueFactory();
        IRI d = f.createIRI("http://example.org/d");
        IRI p = f.createIRI("http://example.org/p");
        IRI e = f.createIRI("http://example.org/e");
        try (GraphQueryResult evaluate = gq.evaluate();){
            Model result = QueryResults.asModel((CloseableIteration)evaluate);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)result.contains(null, p, (Value)e, new Resource[0]));
            Assert.assertFalse((boolean)result.contains((Resource)e, null, null, new Resource[0]));
            Set objects = result.filter((Resource)d, p, null, new Resource[0]).objects();
            Assert.assertNotNull((Object)objects);
            for (Value object : objects) {
                if (!(object instanceof BNode)) continue;
                Set childObjects = result.filter((Resource)((BNode)object), null, null, new Resource[0]).objects();
                Assert.assertNotNull((Object)childObjects);
                for (Value childObject : childObjects) {
                    if (!(childObject instanceof BNode)) continue;
                    Assert.assertTrue((boolean)result.contains((Resource)((BNode)childObject), null, null, new Resource[0]));
                }
            }
        }
    }

    @Test
    public void testDescribeF() throws Exception {
        this.loadTestData("/testdata-query/dataset-describe.trig", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append(this.getNamespaceDeclarations());
        query.append("DESCRIBE ex:f");
        GraphQuery gq = this.conn.prepareGraphQuery(QueryLanguage.SPARQL, query.toString());
        ValueFactory vf = this.conn.getValueFactory();
        IRI f = vf.createIRI("http://example.org/f");
        IRI p = vf.createIRI("http://example.org/p");
        try (GraphQueryResult evaluate = gq.evaluate();){
            Model result = QueryResults.asModel((CloseableIteration)evaluate);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((long)4L, (long)result.size());
            Set objects = result.filter((Resource)f, p, null, new Resource[0]).objects();
            Assert.assertNotNull((Object)objects);
            for (Value object : objects) {
                if (!(object instanceof BNode)) continue;
                Set childObjects = result.filter((Resource)((BNode)object), null, null, new Resource[0]).objects();
                Assert.assertNotNull((Object)childObjects);
                for (Value childObject : childObjects) {
                    if (!(childObject instanceof BNode)) continue;
                    Assert.assertTrue((boolean)result.contains((Resource)((BNode)childObject), null, null, new Resource[0]));
                }
            }
        }
    }

    @Test
    public void testDescribeMultipleA() throws Exception {
        String update = "insert data { <urn:1> <urn:p1> <urn:v> . [] <urn:blank> <urn:1> . <urn:2> <urn:p2> <urn:3> . } ";
        this.conn.prepareUpdate(QueryLanguage.SPARQL, update).execute();
        StringBuilder query = new StringBuilder();
        query.append(this.getNamespaceDeclarations());
        query.append("DESCRIBE <urn:1> <urn:2> ");
        GraphQuery gq = this.conn.prepareGraphQuery(QueryLanguage.SPARQL, query.toString());
        ValueFactory vf = this.conn.getValueFactory();
        IRI urn1 = vf.createIRI("urn:1");
        IRI p1 = vf.createIRI("urn:p1");
        IRI p2 = vf.createIRI("urn:p2");
        IRI urn2 = vf.createIRI("urn:2");
        IRI blank = vf.createIRI("urn:blank");
        try (GraphQueryResult evaluate = gq.evaluate();){
            Model result = QueryResults.asModel((CloseableIteration)evaluate);
            Assert.assertTrue((boolean)result.contains((Resource)urn1, p1, null, new Resource[0]));
            Assert.assertTrue((boolean)result.contains(null, blank, (Value)urn1, new Resource[0]));
            Assert.assertTrue((boolean)result.contains((Resource)urn2, p2, null, new Resource[0]));
        }
    }

    @Test
    public void testDescribeMultipleB() throws Exception {
        String update = "insert data { <urn:1> <urn:p1> <urn:v> . <urn:1> <urn:blank> [] . <urn:2> <urn:p2> <urn:3> . } ";
        this.conn.prepareUpdate(QueryLanguage.SPARQL, update).execute();
        StringBuilder query = new StringBuilder();
        query.append(this.getNamespaceDeclarations());
        query.append("DESCRIBE <urn:1> <urn:2> ");
        GraphQuery gq = this.conn.prepareGraphQuery(QueryLanguage.SPARQL, query.toString());
        ValueFactory vf = this.conn.getValueFactory();
        IRI urn1 = vf.createIRI("urn:1");
        IRI p1 = vf.createIRI("urn:p1");
        IRI p2 = vf.createIRI("urn:p2");
        IRI urn2 = vf.createIRI("urn:2");
        IRI blank = vf.createIRI("urn:blank");
        try (GraphQueryResult evaluate = gq.evaluate();){
            Model result = QueryResults.asModel((CloseableIteration)evaluate);
            Assert.assertTrue((boolean)result.contains((Resource)urn1, p1, null, new Resource[0]));
            Assert.assertTrue((boolean)result.contains((Resource)urn1, blank, null, new Resource[0]));
            Assert.assertTrue((boolean)result.contains((Resource)urn2, p2, null, new Resource[0]));
        }
    }

    @Test
    public void testDescribeMultipleC() throws Exception {
        String update = "insert data { <urn:1> <urn:p1> <urn:v> . [] <urn:blank> <urn:1>. <urn:1> <urn:blank> [] . <urn:2> <urn:p2> <urn:3> . } ";
        this.conn.prepareUpdate(QueryLanguage.SPARQL, update).execute();
        StringBuilder query = new StringBuilder();
        query.append(this.getNamespaceDeclarations());
        query.append("DESCRIBE <urn:1> <urn:2> ");
        GraphQuery gq = this.conn.prepareGraphQuery(QueryLanguage.SPARQL, query.toString());
        ValueFactory vf = this.conn.getValueFactory();
        IRI urn1 = vf.createIRI("urn:1");
        IRI p1 = vf.createIRI("urn:p1");
        IRI p2 = vf.createIRI("urn:p2");
        IRI urn2 = vf.createIRI("urn:2");
        IRI blank = vf.createIRI("urn:blank");
        try (GraphQueryResult evaluate = gq.evaluate();){
            Model result = QueryResults.asModel((CloseableIteration)evaluate);
            Assert.assertTrue((boolean)result.contains((Resource)urn1, p1, null, new Resource[0]));
            Assert.assertTrue((boolean)result.contains((Resource)urn1, blank, null, new Resource[0]));
            Assert.assertTrue((boolean)result.contains(null, blank, (Value)urn1, new Resource[0]));
            Assert.assertTrue((boolean)result.contains((Resource)urn2, p2, null, new Resource[0]));
        }
    }

    @Test
    public void testDescribeMultipleD() throws Exception {
        String update = "insert data { <urn:1> <urn:p1> <urn:v> . [] <urn:blank> <urn:1>. <urn:2> <urn:p2> <urn:3> . [] <urn:blank> <urn:2> . <urn:4> <urn:p2> <urn:3> . <urn:4> <urn:blank> [] .} ";
        this.conn.prepareUpdate(QueryLanguage.SPARQL, update).execute();
        StringBuilder query = new StringBuilder();
        query.append(this.getNamespaceDeclarations());
        query.append("DESCRIBE <urn:1> <urn:2> <urn:4> ");
        GraphQuery gq = this.conn.prepareGraphQuery(QueryLanguage.SPARQL, query.toString());
        ValueFactory vf = this.conn.getValueFactory();
        IRI urn1 = vf.createIRI("urn:1");
        IRI p1 = vf.createIRI("urn:p1");
        IRI p2 = vf.createIRI("urn:p2");
        IRI urn2 = vf.createIRI("urn:2");
        IRI urn4 = vf.createIRI("urn:4");
        IRI blank = vf.createIRI("urn:blank");
        try (GraphQueryResult evaluate = gq.evaluate();){
            Model result = QueryResults.asModel((CloseableIteration)evaluate);
            Assert.assertTrue((boolean)result.contains((Resource)urn1, p1, null, new Resource[0]));
            Assert.assertTrue((boolean)result.contains(null, blank, (Value)urn1, new Resource[0]));
            Assert.assertTrue((boolean)result.contains((Resource)urn2, p2, null, new Resource[0]));
            Assert.assertTrue((boolean)result.contains((Resource)urn4, p2, null, new Resource[0]));
            Assert.assertTrue((boolean)result.contains((Resource)urn4, blank, null, new Resource[0]));
        }
    }

    @Test
    public void testGroupByEmpty() throws Exception {
        String query = "select ?x where {?x ?p ?o} group by ?x";
        TupleQuery tq = this.conn.prepareTupleQuery(query);
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            Assert.assertFalse((boolean)result.hasNext());
        }
    }

    @Test
    public void testGroupConcatDistinct() throws Exception {
        this.loadTestData("/testdata-query/dataset-query.trig", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append(this.getNamespaceDeclarations());
        query.append("SELECT (GROUP_CONCAT(DISTINCT ?l) AS ?concat)");
        query.append("WHERE { ex:groupconcat-test ?p ?l . }");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            while (result.hasNext()) {
                BindingSet bs = (BindingSet)result.next();
                Assert.assertNotNull((Object)bs);
                Value concat = bs.getValue("concat");
                Assert.assertTrue((boolean)(concat instanceof Literal));
                String lexValue = ((Literal)concat).getLabel();
                int occ = this.countCharOccurrences(lexValue, 'a');
                Assert.assertEquals((long)1L, (long)occ);
                occ = this.countCharOccurrences(lexValue, 'b');
                Assert.assertEquals((long)1L, (long)occ);
                occ = this.countCharOccurrences(lexValue, 'c');
                Assert.assertEquals((long)1L, (long)occ);
                occ = this.countCharOccurrences(lexValue, 'd');
                Assert.assertEquals((long)1L, (long)occ);
            }
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSameTermRepeatInOptional() throws Exception {
        this.loadTestData("/testdata-query/dataset-query.trig", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append(this.getNamespaceDeclarations());
        query.append(" SELECT ?l ?opt1 ?opt2 ");
        query.append(" FROM ex:optional-sameterm-graph ");
        query.append(" WHERE { ");
        query.append("          ?s ex:p ex:A ; ");
        query.append("          { ");
        query.append("              { ");
        query.append("                 ?s ?p ?l .");
        query.append("                 FILTER(?p = rdfs:label) ");
        query.append("              } ");
        query.append("              OPTIONAL { ");
        query.append("                 ?s ?p ?opt1 . ");
        query.append("                 FILTER (?p = ex:prop1) ");
        query.append("              } ");
        query.append("              OPTIONAL { ");
        query.append("                 ?s ?p ?opt2 . ");
        query.append("                 FILTER (?p = ex:prop2) ");
        query.append("              } ");
        query.append("          }");
        query.append(" } ");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                BindingSet bs = (BindingSet)result.next();
                ++count;
                Assert.assertNotNull((Object)bs);
                Value l = bs.getValue("l");
                Assert.assertTrue((boolean)(l instanceof Literal));
                Assert.assertEquals((Object)"label", (Object)((Literal)l).getLabel());
                Value opt1 = bs.getValue("opt1");
                Assert.assertNull((Object)opt1);
                Value opt2 = bs.getValue("opt2");
                Assert.assertNull((Object)opt2);
            }
            Assert.assertEquals((long)1L, (long)count);
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSES1121VarNamesInOptionals() throws Exception {
        this.loadTestData("/testdata-query/dataset-ses1121.trig", new Resource[0]);
        StringBuilder query1 = new StringBuilder();
        query1.append(this.getNamespaceDeclarations());
        query1.append(" SELECT DISTINCT *\n");
        query1.append(" WHERE { GRAPH ?g { \n");
        query1.append("          OPTIONAL { ?var35 ex:p ?b . } \n ");
        query1.append("          OPTIONAL { ?b ex:q ?c . } \n ");
        query1.append("       } \n");
        query1.append(" } \n");
        StringBuilder query2 = new StringBuilder();
        query2.append(this.getNamespaceDeclarations());
        query2.append(" SELECT DISTINCT *\n");
        query2.append(" WHERE { GRAPH ?g { \n");
        query2.append("          OPTIONAL { ?var35 ex:p ?b . } \n ");
        query2.append("          OPTIONAL { ?b ex:q ?var2 . } \n ");
        query2.append("       } \n");
        query2.append(" } \n");
        TupleQuery tq1 = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query1.toString());
        TupleQuery tq2 = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query2.toString());
        try (TupleQueryResult result1 = tq1.evaluate();
             TupleQueryResult result2 = tq2.evaluate();){
            Assert.assertNotNull((Object)result1);
            Assert.assertNotNull((Object)result2);
            List qr1 = QueryResults.asList((Iteration)result1);
            List qr2 = QueryResults.asList((Iteration)result2);
            Assert.assertEquals((long)qr1.size(), (long)qr2.size());
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSES1081SameTermWithValues() throws Exception {
        this.loadTestData("/testdata-query/dataset-ses1081.trig", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append("PREFIX ex: <http://example.org/>\n");
        query.append(" SELECT * \n");
        query.append(" WHERE { \n ");
        query.append("          ?s ex:p ?a . \n");
        query.append("          FILTER sameTerm(?a, ?e) \n ");
        query.append("          VALUES ?e { ex:b } \n ");
        query.append(" } ");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                BindingSet bs = (BindingSet)result.next();
                ++count;
                Assert.assertNotNull((Object)bs);
                Value s = bs.getValue("s");
                Value a = bs.getValue("a");
                Assert.assertNotNull((Object)s);
                Assert.assertNotNull((Object)a);
                Assert.assertEquals((Object)this.f.createIRI("http://example.org/a"), (Object)s);
                Assert.assertEquals((Object)this.f.createIRI("http://example.org/b"), (Object)a);
            }
            Assert.assertEquals((long)1L, (long)count);
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSES1898LeftJoinSemantics1() throws Exception {
        this.loadTestData("/testdata-query/dataset-ses1898.trig", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append("  PREFIX : <http://example.org/> ");
        query.append("  SELECT * WHERE { ");
        query.append("    ?s :p1 ?v1 . ");
        query.append("    OPTIONAL {?s :p2 ?v2 } .");
        query.append("     ?s :p3 ?v2 . ");
        query.append("  } ");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                result.next();
                ++count;
            }
            Assert.assertEquals((long)0L, (long)count);
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSES1073InverseSymmetricPattern() throws Exception {
        IRI a = this.f.createIRI("http://example.org/a");
        IRI b1 = this.f.createIRI("http://example.org/b1");
        IRI b2 = this.f.createIRI("http://example.org/b2");
        IRI c1 = this.f.createIRI("http://example.org/c1");
        IRI c2 = this.f.createIRI("http://example.org/c2");
        IRI a2b = this.f.createIRI("http://example.org/a2b");
        IRI b2c = this.f.createIRI("http://example.org/b2c");
        this.conn.add((Resource)a, a2b, (Value)b1, new Resource[0]);
        this.conn.add((Resource)a, a2b, (Value)b2, new Resource[0]);
        this.conn.add((Resource)b1, b2c, (Value)c1, new Resource[0]);
        this.conn.add((Resource)b2, b2c, (Value)c2, new Resource[0]);
        String query = "select * ";
        query = query + "where{ ";
        query = query + "?c1 ^<http://example.org/b2c>/^<http://example.org/a2b>/<http://example.org/a2b>/<http://example.org/b2c> ?c2 . ";
        query = query + " } ";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertTrue((boolean)result.hasNext());
            int count = 0;
            while (result.hasNext()) {
                BindingSet r = (BindingSet)result.next();
                ++count;
            }
            Assert.assertEquals((long)4L, (long)count);
        }
    }

    @Test
    public void testSES1970CountDistinctWildcard() throws Exception {
        this.loadTestData("/testdata-query/dataset-ses1970.trig", new Resource[0]);
        String query = "SELECT (COUNT(DISTINCT *) AS ?c) {?s ?p ?o }";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)result.hasNext());
            BindingSet s = (BindingSet)result.next();
            Literal count = (Literal)s.getValue("c");
            Assert.assertNotNull((Object)count);
            Assert.assertEquals((long)3L, (long)count.intValue());
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSES1685propPathSameVar() throws Exception {
        String queryStr = "PREFIX : <urn:> SELECT ?x WHERE {?x :p+ ?x}";
        this.conn.add((Reader)new StringReader("@prefix : <urn:> . :a :p :b . :b :p :a ."), "", RDFFormat.TURTLE, new Resource[0]);
        TupleQuery query = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, "PREFIX : <urn:> SELECT ?x WHERE {?x :p+ ?x}");
        try (TupleQueryResult result = query.evaluate();){
            Assert.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                result.next();
                ++count;
            }
            Assert.assertEquals((long)2L, (long)count);
        }
    }

    @Test
    public void testSES2104ConstructBGPSameURI() throws Exception {
        String queryStr = "PREFIX : <urn:> CONSTRUCT {:x :p :x } WHERE {} ";
        this.conn.add((Reader)new StringReader("@prefix : <urn:> . :a :p :b . "), "", RDFFormat.TURTLE, new Resource[0]);
        IRI x = this.conn.getValueFactory().createIRI("urn:x");
        IRI p = this.conn.getValueFactory().createIRI("urn:p");
        GraphQuery query = this.conn.prepareGraphQuery(QueryLanguage.SPARQL, "PREFIX : <urn:> CONSTRUCT {:x :p :x } WHERE {} ");
        try (GraphQueryResult evaluate = query.evaluate();){
            Model result = QueryResults.asModel((CloseableIteration)evaluate);
            Assert.assertNotNull((Object)result);
            Assert.assertFalse((boolean)result.isEmpty());
            Assert.assertTrue((boolean)result.contains((Resource)x, p, (Value)x, new Resource[0]));
        }
    }

    @Test
    public void testSES1898LeftJoinSemantics2() throws Exception {
        this.loadTestData("/testdata-query/dataset-ses1898.trig", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append("  PREFIX : <http://example.org/> ");
        query.append("  SELECT * WHERE { ");
        query.append("    ?s :p1 ?v1 . ");
        query.append("    ?s :p3 ?v2 . ");
        query.append("    OPTIONAL {?s :p2 ?v2 } .");
        query.append("  } ");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                result.next();
                ++count;
            }
            Assert.assertEquals((long)1L, (long)count);
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testIdenticalVariablesInStatementPattern() throws Exception {
        this.conn.add((Resource)this.alice, this.f.createIRI("http://purl.org/dc/elements/1.1/publisher"), (Value)this.bob, new Resource[0]);
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append("SELECT ?publisher ");
        queryBuilder.append("{ ?publisher <http://purl.org/dc/elements/1.1/publisher> ?publisher }");
        this.conn.prepareTupleQuery(QueryLanguage.SPARQL, queryBuilder.toString()).evaluate((TupleQueryResultHandler)new AbstractTupleQueryResultHandler(){

            public void handleSolution(BindingSet bindingSet) {
                Assert.fail((String)"nobody is self published");
            }
        });
    }

    @Test
    public void testInComparison1() throws Exception {
        this.loadTestData("/testdata-query/dataset-ses1913.trig", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append(" PREFIX : <http://example.org/>\n");
        query.append(" SELECT ?y WHERE { :a :p ?y. FILTER(?y in (:c, :d, 1/0 , 1)) } ");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)result.hasNext());
            BindingSet bs = (BindingSet)result.next();
            Value y = bs.getValue("y");
            Assert.assertNotNull((Object)y);
            Assert.assertTrue((boolean)(y instanceof Literal));
            Assert.assertEquals((Object)this.f.createLiteral("1", XSD.INTEGER), (Object)y);
        }
    }

    @Test
    public void testInComparison2() throws Exception {
        this.loadTestData("/testdata-query/dataset-ses1913.trig", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append(" PREFIX : <http://example.org/>\n");
        query.append(" SELECT ?y WHERE { :a :p ?y. FILTER(?y in (:c, :d, 1/0)) } ");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            Assert.assertFalse((boolean)result.hasNext());
        }
    }

    @Test
    public void testInComparison3() throws Exception {
        this.loadTestData("/testdata-query/dataset-ses1913.trig", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append(" PREFIX : <http://example.org/>\n");
        query.append(" SELECT ?y WHERE { :a :p ?y. FILTER(?y in (:c, :d, 1, 1/0)) } ");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)result.hasNext());
            BindingSet bs = (BindingSet)result.next();
            Value y = bs.getValue("y");
            Assert.assertNotNull((Object)y);
            Assert.assertTrue((boolean)(y instanceof Literal));
            Assert.assertEquals((Object)this.f.createLiteral("1", XSD.INTEGER), (Object)y);
        }
    }

    @Test
    public void testSES2121URIFunction() throws Exception {
        IRI uri;
        BindingSet bs;
        String query = "SELECT (URI(\"foo bar\") as ?uri) WHERE {}";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)result.hasNext());
            bs = (BindingSet)result.next();
            uri = (IRI)bs.getValue("uri");
            Assert.assertTrue((String)"uri result for invalid URI should be unbound", (uri == null ? 1 : 0) != 0);
        }
        query = "BASE <http://example.org/> SELECT (URI(\"foo bar\") as ?uri) WHERE {}";
        tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        result = tq.evaluate();
        var4_4 = null;
        try {
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)result.hasNext());
            bs = (BindingSet)result.next();
            uri = (IRI)bs.getValue("uri");
            Assert.assertTrue((String)"uri result for valid URI reference should be bound", (uri != null ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (result != null) {
                if (var4_4 != null) {
                    try {
                        result.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    result.close();
                }
            }
        }
    }

    @Test
    public void test27NormalizeIRIFunction() throws Exception {
        String query = "SELECT (IRI(\"../bar\") as ?Iri) WHERE {}";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query, "http://example.com/foo/");
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)result.hasNext());
            BindingSet bs = (BindingSet)result.next();
            IRI actual = (IRI)bs.getValue("Iri");
            IRI expected = this.f.createIRI("http://example.com/bar");
            Assert.assertEquals((String)"IRI result for relative IRI should be normalized", (Object)expected, (Object)actual);
        }
    }

    @Test
    public void testSES869ValueOfNow() throws Exception {
        StringBuilder query = new StringBuilder();
        query.append("SELECT ?p ( NOW() as ?n ) { BIND (NOW() as ?p ) }");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)result.hasNext());
            BindingSet bs = (BindingSet)result.next();
            Value p = bs.getValue("p");
            Value n = bs.getValue("n");
            Assert.assertNotNull((Object)p);
            Assert.assertNotNull((Object)n);
            Assert.assertEquals((Object)p, (Object)n);
        }
    }

    @Test
    public void testSES2136() throws Exception {
        this.loadTestData("/testcases-sparql-1.1-w3c/bindings/data02.ttl", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append("PREFIX : <http://example.org/>\n");
        query.append("SELECT ?s ?o { \n");
        query.append(" { SELECT * WHERE { ?s ?p ?o . } }\n");
        query.append("\tVALUES (?o) { (:b) }\n");
        query.append("}\n");
        ValueFactory vf = this.conn.getValueFactory();
        IRI a = vf.createIRI("http://example.org/a");
        IRI b = vf.createIRI("http://example.org/b");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)result.hasNext());
            BindingSet bs = (BindingSet)result.next();
            Assert.assertFalse((String)"only one result expected", (boolean)result.hasNext());
            Assert.assertEquals((Object)a, (Object)bs.getValue("s"));
            Assert.assertEquals((Object)b, (Object)bs.getValue("o"));
        }
    }

    @Test
    public void testRegexCaseNonAscii() throws Exception {
        String query = "ask {filter (regex(\"\u0412\u0430\u043b\u043e\u0432\u043e\u0439\", \"\u0432\u0430\u043b\u043e\u0432\u043e\u0439\", \"i\")) }";
        Assert.assertTrue((String)"case-insensitive match on Cyrillic should succeed", (boolean)this.conn.prepareBooleanQuery(query).evaluate());
        query = "ask {filter (regex(\"\u0412\u0430\u043b\u043e\u0432\u043e\u0439\", \"\u0432\u0430\u043b\u043e\u0432\u043e\u0439\")) }";
        Assert.assertFalse((String)"case-sensitive match on Cyrillic should fail", (boolean)this.conn.prepareBooleanQuery(query).evaluate());
    }

    @Test
    public void testValuesInOptional() throws Exception {
        this.loadTestData("/testdata-query/dataset-ses1692.trig", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append(" PREFIX : <http://example.org/>\n");
        query.append(" SELECT DISTINCT ?a ?name ?isX WHERE { ?b :p1 ?a . ?a :name ?name. OPTIONAL { ?a a :X . VALUES(?isX) { (:X) } } } ");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)result.hasNext());
            int count = 0;
            while (result.hasNext()) {
                ++count;
                BindingSet bs = (BindingSet)result.next();
                IRI a = (IRI)bs.getValue("a");
                Assert.assertNotNull((Object)a);
                Value isX = bs.getValue("isX");
                Literal name = (Literal)bs.getValue("name");
                Assert.assertNotNull((Object)name);
                if (a.stringValue().endsWith("a1")) {
                    Assert.assertNotNull((Object)isX);
                    continue;
                }
                if (!a.stringValue().endsWith("a2")) continue;
                Assert.assertNull((Object)isX);
            }
            Assert.assertEquals((long)2L, (long)count);
        }
    }

    @Test
    public void testMaxAggregateWithGroupEmptyResult() throws Exception {
        String query = "select ?s (max(?o) as ?omax) {\n   ?s ?p ?o .\n }\n group by ?s\n";
        try (TupleQueryResult result = this.conn.prepareTupleQuery(query).evaluate();){
            Assertions.assertThat((boolean)result.hasNext()).isFalse();
        }
    }

    @Test
    public void testMaxAggregateWithoutGroupEmptySolution() throws Exception {
        String query = "select (max(?o) as ?omax) {\n   ?s ?p ?o .\n }\n";
        try (TupleQueryResult result = this.conn.prepareTupleQuery(query).evaluate();){
            Assertions.assertThat((Iterable)((Iterable)result.next())).isEmpty();
        }
    }

    @Test
    public void testMinAggregateWithGroupEmptyResult() throws Exception {
        String query = "select ?s (min(?o) as ?omin) {\n   ?s ?p ?o .\n }\n group by ?s\n";
        try (TupleQueryResult result = this.conn.prepareTupleQuery(query).evaluate();){
            Assertions.assertThat((boolean)result.hasNext()).isFalse();
        }
    }

    @Test
    public void testMinAggregateWithoutGroupEmptySolution() throws Exception {
        String query = "select (min(?o) as ?omin) {\n   ?s ?p ?o .\n }\n";
        try (TupleQueryResult result = this.conn.prepareTupleQuery(query).evaluate();){
            Assertions.assertThat((Iterable)((Iterable)result.next())).isEmpty();
        }
    }

    @Test
    public void testSampleAggregateWithGroupEmptyResult() throws Exception {
        String query = "select ?s (sample(?o) as ?osample) {\n   ?s ?p ?o .\n }\n group by ?s\n";
        try (TupleQueryResult result = this.conn.prepareTupleQuery(query).evaluate();){
            Assertions.assertThat((boolean)result.hasNext()).isFalse();
        }
    }

    @Test
    public void testSampleAggregateWithoutGroupEmptySolution() throws Exception {
        String query = "select (sample(?o) as ?osample) {\n   ?s ?p ?o .\n }\n";
        try (TupleQueryResult result = this.conn.prepareTupleQuery(query).evaluate();){
            Assertions.assertThat((Iterable)((Iterable)result.next())).isEmpty();
        }
    }

    @Test
    public void testSES2052If1() throws Exception {
        this.loadTestData("/testdata-query/dataset-query.trig", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append("SELECT ?p \n");
        query.append("WHERE { \n");
        query.append("         ?s ?p ?o . \n");
        query.append("        FILTER(IF(BOUND(?p), ?p = <http://www.w3.org/1999/02/22-rdf-syntax-ns#type>, false)) \n");
        query.append("}");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            while (result.hasNext()) {
                BindingSet bs = (BindingSet)result.next();
                IRI p = (IRI)bs.getValue("p");
                Assert.assertNotNull((Object)p);
                Assert.assertEquals((Object)RDF.TYPE, (Object)p);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSES2052If2() throws Exception {
        this.loadTestData("/testdata-query/dataset-query.trig", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append("SELECT ?p \n");
        query.append("WHERE { \n");
        query.append("         ?s ?p ?o . \n");
        query.append("        FILTER(IF(!BOUND(?p), false , ?p = <http://www.w3.org/1999/02/22-rdf-syntax-ns#type>)) \n");
        query.append("}");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            while (result.hasNext()) {
                BindingSet bs = (BindingSet)result.next();
                IRI p = (IRI)bs.getValue("p");
                Assert.assertNotNull((Object)p);
                Assert.assertEquals((Object)RDF.TYPE, (Object)p);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSameTermRepeatInUnion() throws Exception {
        this.loadTestData("/testdata-query/dataset-query.trig", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append("PREFIX foaf:<http://xmlns.com/foaf/0.1/>\n");
        query.append("SELECT * {\n");
        query.append("    {\n");
        query.append("        ?sameTerm foaf:mbox ?mbox\n");
        query.append("        FILTER sameTerm(?sameTerm,$william)\n");
        query.append("    } UNION {\n");
        query.append("        ?x foaf:knows ?sameTerm\n");
        query.append("        FILTER sameTerm(?sameTerm,$william)\n");
        query.append("    }\n");
        query.append("}");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        tq.setBinding("william", (Value)this.conn.getValueFactory().createIRI("http://example.org/william"));
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                BindingSet bs = (BindingSet)result.next();
                ++count;
                Assert.assertNotNull((Object)bs);
                Value mbox = bs.getValue("mbox");
                Value x = bs.getValue("x");
                Assert.assertTrue((mbox instanceof Literal || x instanceof IRI ? 1 : 0) != 0);
            }
            Assert.assertEquals((long)3L, (long)count);
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSameTermRepeatInUnionAndOptional() throws Exception {
        this.loadTestData("/testdata-query/dataset-query.trig", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append(this.getNamespaceDeclarations());
        query.append("SELECT * {\n");
        query.append("    {\n");
        query.append("        ex:a ?p ?prop1\n");
        query.append("        FILTER (?p = ex:prop1)\n");
        query.append("    } UNION {\n");
        query.append("          ?s ex:p ex:A ; ");
        query.append("          { ");
        query.append("              { ");
        query.append("                 ?s ?p ?l .");
        query.append("                 FILTER(?p = rdfs:label) ");
        query.append("              } ");
        query.append("              OPTIONAL { ");
        query.append("                 ?s ?p ?opt1 . ");
        query.append("                 FILTER (?p = ex:prop1) ");
        query.append("              } ");
        query.append("              OPTIONAL { ");
        query.append("                 ?s ?p ?opt2 . ");
        query.append("                 FILTER (?p = ex:prop2) ");
        query.append("              } ");
        query.append("          }");
        query.append("    }\n");
        query.append("}");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                BindingSet bs = (BindingSet)result.next();
                ++count;
                Assert.assertNotNull((Object)bs);
                Value prop1 = bs.getValue("prop1");
                Value l = bs.getValue("l");
                Assert.assertTrue((prop1 instanceof Literal || l instanceof Literal ? 1 : 0) != 0);
                if (!(l instanceof Literal)) continue;
                Value opt1 = bs.getValue("opt1");
                Assert.assertNull((Object)opt1);
                Value opt2 = bs.getValue("opt2");
                Assert.assertNull((Object)opt2);
            }
            Assert.assertEquals((long)2L, (long)count);
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testPropertyPathInTree() throws Exception {
        this.loadTestData("/testdata-query/dataset-query.trig", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append(this.getNamespaceDeclarations());
        query.append(" SELECT ?node ?name ");
        query.append(" FROM ex:tree-graph ");
        query.append(" WHERE { ?node ex:hasParent+ ex:b . ?node ex:name ?name . }");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            while (result.hasNext()) {
                BindingSet bs = (BindingSet)result.next();
                Assert.assertNotNull((Object)bs);
            }
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testFilterRegexBoolean() throws Exception {
        this.loadTestData("/testdata-query/dataset-query.trig", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append(this.getNamespaceDeclarations());
        query.append(" SELECT *");
        query.append(" WHERE { ");
        query.append("       ?x foaf:name ?name ; ");
        query.append("          foaf:mbox ?mbox . ");
        query.append("       FILTER(EXISTS { ");
        query.append("            FILTER(REGEX(?name, \"Bo\") && REGEX(?mbox, \"bob\")) ");
        query.append("            } )");
        query.append(" } ");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)result.hasNext());
            int count = 0;
            while (result.hasNext()) {
                BindingSet bs = (BindingSet)result.next();
                ++count;
            }
            Assert.assertEquals((long)1L, (long)count);
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGroupConcatNonDistinct() throws Exception {
        this.loadTestData("/testdata-query/dataset-query.trig", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append(this.getNamespaceDeclarations());
        query.append("SELECT (GROUP_CONCAT(?l) AS ?concat)");
        query.append("WHERE { ex:groupconcat-test ?p ?l . }");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            while (result.hasNext()) {
                BindingSet bs = (BindingSet)result.next();
                Assert.assertNotNull((Object)bs);
                Value concat = bs.getValue("concat");
                Assert.assertTrue((boolean)(concat instanceof Literal));
                String lexValue = ((Literal)concat).getLabel();
                int occ = this.countCharOccurrences(lexValue, 'a');
                Assert.assertEquals((long)1L, (long)occ);
                occ = this.countCharOccurrences(lexValue, 'b');
                Assert.assertEquals((long)2L, (long)occ);
                occ = this.countCharOccurrences(lexValue, 'c');
                Assert.assertEquals((long)2L, (long)occ);
                occ = this.countCharOccurrences(lexValue, 'd');
                Assert.assertEquals((long)1L, (long)occ);
            }
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testArbitraryLengthPathWithBinding1() throws Exception {
        this.loadTestData("/testdata-query/alp-testdata.ttl", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append(this.getNamespaceDeclarations());
        query.append("SELECT ?parent ?child ");
        query.append("WHERE { ?child a owl:Class . ?child rdfs:subClassOf+ ?parent . }");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                ++count;
                BindingSet bs = (BindingSet)result.next();
                Assert.assertTrue((boolean)bs.hasBinding("child"));
                Assert.assertTrue((boolean)bs.hasBinding("parent"));
            }
            Assert.assertEquals((long)7L, (long)count);
            tq.setBinding("parent", (Value)OWL.THING);
            try (TupleQueryResult result2 = tq.evaluate();){
                Assert.assertNotNull((Object)result2);
                count = 0;
                while (result2.hasNext()) {
                    ++count;
                    BindingSet bs = (BindingSet)result2.next();
                    Assert.assertTrue((boolean)bs.hasBinding("child"));
                    Assert.assertTrue((boolean)bs.hasBinding("parent"));
                }
                Assert.assertEquals((long)4L, (long)count);
            }
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testArbitraryLengthPathWithBinding2() throws Exception {
        this.loadTestData("/testdata-query/alp-testdata.ttl", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append(this.getNamespaceDeclarations());
        query.append("SELECT ?parent ?child ");
        query.append("WHERE { ?child rdfs:subClassOf+ ?parent . }");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                ++count;
                BindingSet bs = (BindingSet)result.next();
                Assert.assertTrue((boolean)bs.hasBinding("child"));
                Assert.assertTrue((boolean)bs.hasBinding("parent"));
            }
            Assert.assertEquals((long)7L, (long)count);
            tq.setBinding("parent", (Value)OWL.THING);
            try (TupleQueryResult result2 = tq.evaluate();){
                Assert.assertNotNull((Object)result2);
                count = 0;
                while (result2.hasNext()) {
                    ++count;
                    BindingSet bs = (BindingSet)result2.next();
                    Assert.assertTrue((boolean)bs.hasBinding("child"));
                    Assert.assertTrue((boolean)bs.hasBinding("parent"));
                }
                Assert.assertEquals((long)4L, (long)count);
            }
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testArbitraryLengthPathWithBinding3() throws Exception {
        this.loadTestData("/testdata-query/alp-testdata.ttl", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append(this.getNamespaceDeclarations());
        query.append("SELECT ?parent ?child ");
        query.append("WHERE { ?child rdfs:subClassOf+ ?parent . }");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                ++count;
                BindingSet bs = (BindingSet)result.next();
                Assert.assertTrue((boolean)bs.hasBinding("child"));
                Assert.assertTrue((boolean)bs.hasBinding("parent"));
            }
            Assert.assertEquals((long)7L, (long)count);
            tq.setBinding("child", (Value)this.f.createIRI(EX_NS, "C"));
            try (TupleQueryResult result2 = tq.evaluate();){
                Assert.assertNotNull((Object)result2);
                count = 0;
                while (result2.hasNext()) {
                    ++count;
                    BindingSet bs = (BindingSet)result2.next();
                    Assert.assertTrue((boolean)bs.hasBinding("child"));
                    Assert.assertTrue((boolean)bs.hasBinding("parent"));
                }
                Assert.assertEquals((long)2L, (long)count);
            }
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testArbitraryLengthPathWithBinding4() throws Exception {
        this.loadTestData("/testdata-query/alp-testdata.ttl", new Resource[]{this.alice});
        StringBuilder query = new StringBuilder();
        query.append(this.getNamespaceDeclarations());
        query.append("SELECT ?parent ?child ");
        query.append("WHERE { ?child rdfs:subClassOf+ ?parent . }");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                ++count;
                BindingSet bs = (BindingSet)result.next();
                Assert.assertTrue((boolean)bs.hasBinding("child"));
                Assert.assertTrue((boolean)bs.hasBinding("parent"));
            }
            Assert.assertEquals((long)7L, (long)count);
            tq.setBinding("child", (Value)this.f.createIRI(EX_NS, "C"));
            try (TupleQueryResult result2 = tq.evaluate();){
                Assert.assertNotNull((Object)result2);
                count = 0;
                while (result2.hasNext()) {
                    ++count;
                    BindingSet bs = (BindingSet)result2.next();
                    Assert.assertTrue((boolean)bs.hasBinding("child"));
                    Assert.assertTrue((boolean)bs.hasBinding("parent"));
                }
                Assert.assertEquals((long)2L, (long)count);
            }
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testArbitraryLengthPathWithBinding5() throws Exception {
        this.loadTestData("/testdata-query/alp-testdata.ttl", new Resource[]{this.alice, this.bob});
        StringBuilder query = new StringBuilder();
        query.append(this.getNamespaceDeclarations());
        query.append("SELECT ?parent ?child ");
        query.append("WHERE { ?child rdfs:subClassOf+ ?parent . }");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                ++count;
                BindingSet bs = (BindingSet)result.next();
                Assert.assertTrue((boolean)bs.hasBinding("child"));
                Assert.assertTrue((boolean)bs.hasBinding("parent"));
            }
            Assert.assertEquals((long)7L, (long)count);
            tq.setBinding("child", (Value)this.f.createIRI(EX_NS, "C"));
            try (TupleQueryResult result2 = tq.evaluate();){
                Assert.assertNotNull((Object)result2);
                count = 0;
                while (result2.hasNext()) {
                    ++count;
                    BindingSet bs = (BindingSet)result2.next();
                    Assert.assertTrue((boolean)bs.hasBinding("child"));
                    Assert.assertTrue((boolean)bs.hasBinding("parent"));
                }
                Assert.assertEquals((long)2L, (long)count);
            }
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testArbitraryLengthPathWithBinding6() throws Exception {
        this.loadTestData("/testdata-query/alp-testdata.ttl", new Resource[]{this.alice, this.bob, this.mary});
        StringBuilder query = new StringBuilder();
        query.append(this.getNamespaceDeclarations());
        query.append("SELECT ?parent ?child ");
        query.append("WHERE { ?child rdfs:subClassOf+ ?parent . }");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                ++count;
                BindingSet bs = (BindingSet)result.next();
                Assert.assertTrue((boolean)bs.hasBinding("child"));
                Assert.assertTrue((boolean)bs.hasBinding("parent"));
            }
            Assert.assertEquals((long)7L, (long)count);
            tq.setBinding("child", (Value)this.f.createIRI(EX_NS, "C"));
            try (TupleQueryResult result2 = tq.evaluate();){
                Assert.assertNotNull((Object)result2);
                count = 0;
                while (result2.hasNext()) {
                    ++count;
                    BindingSet bs = (BindingSet)result2.next();
                    Assert.assertTrue((boolean)bs.hasBinding("child"));
                    Assert.assertTrue((boolean)bs.hasBinding("parent"));
                }
                Assert.assertEquals((long)2L, (long)count);
            }
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testArbitraryLengthPathWithBinding7() throws Exception {
        this.loadTestData("/testdata-query/alp-testdata.ttl", new Resource[]{this.alice, this.bob, this.mary});
        StringBuilder query = new StringBuilder();
        query.append(this.getNamespaceDeclarations());
        query.append("SELECT ?parent ?child ");
        query.append("WHERE { ?child rdfs:subClassOf+ ?parent . }");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        SimpleDataset dt = new SimpleDataset();
        dt.addDefaultGraph(this.alice);
        tq.setDataset((Dataset)dt);
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                ++count;
                BindingSet bs = (BindingSet)result.next();
                Assert.assertTrue((boolean)bs.hasBinding("child"));
                Assert.assertTrue((boolean)bs.hasBinding("parent"));
            }
            Assert.assertEquals((long)7L, (long)count);
            tq.setBinding("child", (Value)this.f.createIRI(EX_NS, "C"));
            try (TupleQueryResult result2 = tq.evaluate();){
                Assert.assertNotNull((Object)result2);
                count = 0;
                while (result2.hasNext()) {
                    ++count;
                    BindingSet bs = (BindingSet)result2.next();
                    Assert.assertTrue((boolean)bs.hasBinding("child"));
                    Assert.assertTrue((boolean)bs.hasBinding("parent"));
                }
                Assert.assertEquals((long)2L, (long)count);
            }
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testArbitraryLengthPathWithBinding8() throws Exception {
        this.loadTestData("/testdata-query/alp-testdata.ttl", new Resource[]{this.alice, this.bob, this.mary});
        StringBuilder query = new StringBuilder();
        query.append(this.getNamespaceDeclarations());
        query.append("SELECT ?parent ?child ");
        query.append("WHERE { ?child rdfs:subClassOf+ ?parent . }");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        SimpleDataset dt = new SimpleDataset();
        dt.addDefaultGraph(this.alice);
        dt.addDefaultGraph(this.bob);
        tq.setDataset((Dataset)dt);
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                ++count;
                BindingSet bs = (BindingSet)result.next();
                Assert.assertTrue((boolean)bs.hasBinding("child"));
                Assert.assertTrue((boolean)bs.hasBinding("parent"));
            }
            Assert.assertEquals((long)7L, (long)count);
            tq.setBinding("child", (Value)this.f.createIRI(EX_NS, "C"));
            try (TupleQueryResult result2 = tq.evaluate();){
                Assert.assertNotNull((Object)result2);
                count = 0;
                while (result2.hasNext()) {
                    ++count;
                    BindingSet bs = (BindingSet)result2.next();
                    Assert.assertTrue((boolean)bs.hasBinding("child"));
                    Assert.assertTrue((boolean)bs.hasBinding("parent"));
                }
                Assert.assertEquals((long)2L, (long)count);
            }
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testArbitraryLengthPathWithFilter1() throws Exception {
        this.loadTestData("/testdata-query/alp-testdata.ttl", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append(this.getNamespaceDeclarations());
        query.append("SELECT ?parent ?child ");
        query.append("WHERE { ?child a owl:Class . ?child rdfs:subClassOf+ ?parent . FILTER (?parent = owl:Thing) }");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                ++count;
                BindingSet bs = (BindingSet)result.next();
                Assert.assertTrue((boolean)bs.hasBinding("child"));
                Assert.assertTrue((boolean)bs.hasBinding("parent"));
            }
            Assert.assertEquals((long)4L, (long)count);
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testArbitraryLengthPathWithFilter2() throws Exception {
        this.loadTestData("/testdata-query/alp-testdata.ttl", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append(this.getNamespaceDeclarations());
        query.append("SELECT ?parent ?child ");
        query.append("WHERE { ?child rdfs:subClassOf+ ?parent . FILTER (?parent = owl:Thing) }");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                ++count;
                BindingSet bs = (BindingSet)result.next();
                Assert.assertTrue((boolean)bs.hasBinding("child"));
                Assert.assertTrue((boolean)bs.hasBinding("parent"));
            }
            Assert.assertEquals((long)4L, (long)count);
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testArbitraryLengthPathWithFilter3() throws Exception {
        this.loadTestData("/testdata-query/alp-testdata.ttl", new Resource[0]);
        StringBuilder query = new StringBuilder();
        query.append(this.getNamespaceDeclarations());
        query.append("SELECT ?parent ?child ");
        query.append("WHERE { ?child rdfs:subClassOf+ ?parent . FILTER (?child = <http://example.org/C>) }");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            int count = 0;
            while (result.hasNext()) {
                ++count;
                BindingSet bs = (BindingSet)result.next();
                Assert.assertTrue((boolean)bs.hasBinding("child"));
                Assert.assertTrue((boolean)bs.hasBinding("parent"));
            }
            Assert.assertEquals((long)2L, (long)count);
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testNestedInversePropertyPathWithZeroLength() throws Exception {
        String insert = "insert data {\n    <urn:1> <urn:prop> <urn:object> .\n    <urn:2> <urn:prop> <urn:mid:1> .\n    <urn:mid:1> <urn:prop> <urn:object> .\n    <urn:3> <urn:prop> <urn:mid:2> .\n    <urn:mid:2> <urn:prop> <urn:mid:3> .\n    <urn:mid:3> <urn:prop> <urn:object> .\n}";
        String query = "select * where { \n    <urn:object> (^<urn:prop>)? ?o .\n}";
        this.conn.prepareUpdate(insert).execute();
        TupleQuery tq = this.conn.prepareTupleQuery(query);
        List result = QueryResults.asList((Iteration)tq.evaluate());
        Assertions.assertThat((List)result).hasSize(4);
    }

    @Test
    public void testSES2147PropertyPathsWithIdenticalSubsPreds() throws Exception {
        StringBuilder data = new StringBuilder();
        data.append("<urn:s1> <urn:p> <urn:s2> .\n");
        data.append("<urn:s2> <urn:p> <urn:s3> .\n");
        data.append("<urn:s3> <urn:q> <urn:s4> .\n");
        data.append("<urn:s1> <urn:p> <urn:s5> .\n");
        data.append("<urn:s5> <urn:q> <urn:s6> .\n");
        this.conn.begin();
        this.conn.add((Reader)new StringReader(data.toString()), "", RDFFormat.NTRIPLES, new Resource[0]);
        this.conn.commit();
        StringBuilder query = new StringBuilder();
        query.append(this.getNamespaceDeclarations());
        query.append("SELECT ?x \n");
        query.append("WHERE { ?x <urn:p>*/<urn:q> <urn:s4> . \n");
        query.append("        ?x <urn:p>*/<urn:q> <urn:s6> . \n");
        query.append("} \n");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query.toString());
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)result.hasNext());
            Value x = ((BindingSet)result.next()).getValue("x");
            Assert.assertNotNull((Object)x);
            Assert.assertTrue((boolean)(x instanceof IRI));
            Assert.assertEquals((Object)"urn:s1", (Object)x.stringValue());
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSES1991UUIDEvaluation() throws Exception {
        this.loadTestData("/testdata-query/defaultgraph.ttl", new Resource[0]);
        String query = "SELECT ?uid WHERE {?s ?p ?o . BIND(UUID() as ?uid) } LIMIT 2";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            IRI uuid1 = (IRI)((BindingSet)result.next()).getValue("uid");
            IRI uuid2 = (IRI)((BindingSet)result.next()).getValue("uid");
            Assert.assertNotNull((Object)uuid1);
            Assert.assertNotNull((Object)uuid2);
            Assert.assertFalse((boolean)uuid1.equals((Object)uuid2));
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSES1991STRUUIDEvaluation() throws Exception {
        this.loadTestData("/testdata-query/defaultgraph.ttl", new Resource[0]);
        String query = "SELECT ?uid WHERE {?s ?p ?o . BIND(STRUUID() as ?uid) } LIMIT 2";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            Literal uid1 = (Literal)((BindingSet)result.next()).getValue("uid");
            Literal uid2 = (Literal)((BindingSet)result.next()).getValue("uid");
            Assert.assertNotNull((Object)uid1);
            Assert.assertFalse((boolean)uid1.equals((Object)uid2));
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSES1991RANDEvaluation() throws Exception {
        this.loadTestData("/testdata-query/defaultgraph.ttl", new Resource[0]);
        String query = "SELECT ?r WHERE {?s ?p ?o . BIND(RAND() as ?r) } LIMIT 3";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            Literal r1 = (Literal)((BindingSet)result.next()).getValue("r");
            Literal r2 = (Literal)((BindingSet)result.next()).getValue("r");
            Literal r3 = (Literal)((BindingSet)result.next()).getValue("r");
            Assert.assertNotNull((Object)r1);
            Assert.assertFalse((r1.equals((Object)r2) && r1.equals((Object)r3) ? 1 : 0) != 0);
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSES1991NOWEvaluation() throws Exception {
        this.loadTestData("/testdata-query/defaultgraph.ttl", new Resource[0]);
        String query = "SELECT ?d WHERE {?s ?p ?o . BIND(NOW() as ?d) } LIMIT 2";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            Literal d1 = (Literal)((BindingSet)result.next()).getValue("d");
            Literal d2 = (Literal)((BindingSet)result.next()).getValue("d");
            Assert.assertNotNull((Object)d1);
            Assert.assertEquals((Object)d1, (Object)d2);
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSES2024PropertyPathAnonVarSharing() throws Exception {
        this.loadTestData("/testdata-query/dataset-ses2024.trig", new Resource[0]);
        String query = "PREFIX : <http://example.org/> SELECT * WHERE { ?x1 :p/:lit ?l1 . ?x1 :diff ?x2 . ?x2 :p/:lit ?l2 . }";
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult result = tq.evaluate();){
            Assert.assertNotNull((Object)result);
            BindingSet bs = (BindingSet)result.next();
            Literal l1 = (Literal)bs.getValue("l1");
            Literal l2 = (Literal)bs.getValue("l2");
            Assert.assertNotNull((Object)l1);
            Assert.assertFalse((boolean)l1.equals((Object)l2));
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testPropertyPathNegationInversion() throws Exception {
        String data = "@prefix : <http://example.org/>.\n:Mary :parentOf :Jim.\n:Jim :knows :Jane.\n:Jane :worksFor :IBM.";
        this.conn.add((Reader)new StringReader(data), "", RDFFormat.TURTLE, new Resource[0]);
        String query1 = "prefix : <http://example.org/> ASK WHERE { :IBM ^(:|!:) :Jane } ";
        Assert.assertTrue((boolean)this.conn.prepareBooleanQuery(query1).evaluate());
        String query2 = "prefix : <http://example.org/> ASK WHERE { :IBM ^(:|!:) ?a } ";
        Assert.assertTrue((boolean)this.conn.prepareBooleanQuery(query2).evaluate());
        String query3 = "prefix : <http://example.org/> ASK WHERE { :IBM (^(:|!:))* :Mary } ";
        Assert.assertTrue((boolean)this.conn.prepareBooleanQuery(query3).evaluate());
    }

    @Test
    public void testSES2361UndefMin() throws Exception {
        String query = "SELECT (MIN(?v) as ?min) WHERE { VALUES ?v { 1 2 undef 3 4 }}";
        try (TupleQueryResult result = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query).evaluate();){
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)result.hasNext());
            Assert.assertEquals((Object)"1", (Object)((BindingSet)result.next()).getValue("min").stringValue());
            Assert.assertFalse((boolean)result.hasNext());
        }
    }

    @Test
    public void testSES2361UndefMax() throws Exception {
        String query = "SELECT (MAX(?v) as ?max) WHERE { VALUES ?v { 1 2 7 undef 3 4 }}";
        try (TupleQueryResult result = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query).evaluate();){
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)result.hasNext());
            Assert.assertEquals((Object)"7", (Object)((BindingSet)result.next()).getValue("max").stringValue());
            Assert.assertFalse((boolean)result.hasNext());
        }
    }

    @Test
    public void testSES2361UndefCount() throws Exception {
        String query = "SELECT (COUNT(?v) as ?c) WHERE { VALUES ?v { 1 2 undef 3 4 }}";
        try (TupleQueryResult result = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query).evaluate();){
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)result.hasNext());
            Assert.assertEquals((Object)"4", (Object)((BindingSet)result.next()).getValue("c").stringValue());
            Assert.assertFalse((boolean)result.hasNext());
        }
    }

    @Test
    public void testSES2361UndefCountWildcard() throws Exception {
        String query = "SELECT (COUNT(*) as ?c) WHERE { VALUES ?v { 1 2 undef 3 4 }}";
        try (TupleQueryResult result = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query).evaluate();){
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)result.hasNext());
            Assert.assertEquals((Object)"4", (Object)((BindingSet)result.next()).getValue("c").stringValue());
            Assert.assertFalse((boolean)result.hasNext());
        }
    }

    @Test
    public void testSES2361UndefSum() throws Exception {
        String query = "SELECT (SUM(?v) as ?s) WHERE { VALUES ?v { 1 2 undef 3 4 }}";
        try (TupleQueryResult result = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query).evaluate();){
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)result.hasNext());
            Assert.assertEquals((Object)"10", (Object)((BindingSet)result.next()).getValue("s").stringValue());
            Assert.assertFalse((boolean)result.hasNext());
        }
    }

    @Test
    public void testSES2336NegatedPropertyPathMod() throws Exception {
        this.loadTestData("/testdata-query/dataset-ses2336.trig", new Resource[0]);
        String query = "prefix : <http://example.org/> select * where { ?s a :Test ; !:p? ?o . }";
        ValueFactory vf = this.conn.getValueFactory();
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult evaluate = tq.evaluate();){
            List result = QueryResults.asList((Iteration)evaluate);
            Assert.assertNotNull((Object)result);
            IRI a = vf.createIRI(EX_NS, "a");
            IRI b = vf.createIRI(EX_NS, "b");
            IRI c = vf.createIRI(EX_NS, "c");
            IRI d = vf.createIRI(EX_NS, "d");
            IRI e = vf.createIRI(EX_NS, "e");
            IRI test = vf.createIRI(EX_NS, "Test");
            Assert.assertTrue((boolean)this.containsSolution(result, new Binding[]{new SimpleBinding("s", (Value)a), new SimpleBinding("o", (Value)a)}));
            Assert.assertTrue((boolean)this.containsSolution(result, new Binding[]{new SimpleBinding("s", (Value)a), new SimpleBinding("o", (Value)test)}));
            Assert.assertTrue((boolean)this.containsSolution(result, new Binding[]{new SimpleBinding("s", (Value)a), new SimpleBinding("o", (Value)c)}));
            Assert.assertTrue((boolean)this.containsSolution(result, new Binding[]{new SimpleBinding("s", (Value)d), new SimpleBinding("o", (Value)d)}));
            Assert.assertTrue((boolean)this.containsSolution(result, new Binding[]{new SimpleBinding("s", (Value)d), new SimpleBinding("o", (Value)e)}));
            Assert.assertTrue((boolean)this.containsSolution(result, new Binding[]{new SimpleBinding("s", (Value)d), new SimpleBinding("o", (Value)test)}));
            Assert.assertFalse((boolean)this.containsSolution(result, new Binding[]{new SimpleBinding("s", (Value)a), new SimpleBinding("o", (Value)b)}));
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSES1979MinMaxInf() throws Exception {
        this.loadTestData("/testdata-query/dataset-ses1979.trig", new Resource[0]);
        String query = "prefix : <http://example.org/> select (min(?o) as ?min) (max(?o) as ?max) where { ?s :float ?o }";
        ValueFactory vf = this.conn.getValueFactory();
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query);
        try (TupleQueryResult evaluate = tq.evaluate();){
            List result = QueryResults.asList((Iteration)evaluate);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertEquals((Object)vf.createLiteral(Float.NEGATIVE_INFINITY), (Object)((BindingSet)result.get(0)).getValue("min"));
            Assert.assertEquals((Object)vf.createLiteral(Float.POSITIVE_INFINITY), (Object)((BindingSet)result.get(0)).getValue("max"));
        }
        catch (QueryEvaluationException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testBindError() throws Exception {
        StringBuilder ub = new StringBuilder();
        ub.append("insert data { <urn:test:subj> <urn:test:pred> _:blank }");
        this.conn.prepareUpdate(QueryLanguage.SPARQL, ub.toString()).execute();
        StringBuilder qb = new StringBuilder();
        qb.append("SELECT * \n");
        qb.append("WHERE { \n");
        qb.append("  VALUES (?NAValue) { (<http://null>) } \n ");
        qb.append("  BIND(IF(?NAValue != <http://null>, ?NAValue, ?notBoundVar) as ?ValidNAValue) \n ");
        qb.append("  { ?disjClass (owl:disjointWith|^owl:disjointWith)? ?disjClass2 . }\n");
        qb.append("}\n");
        List result = QueryResults.asList((Iteration)this.conn.prepareTupleQuery(qb.toString()).evaluate());
        Assert.assertEquals((String)"query should return 2 solutions", (long)2L, (long)result.size());
    }

    @Test
    public void testBindScope() throws Exception {
        String query = "SELECT * {\n  { BIND (\"a\" AS ?a) }\n  { BIND (?a AS ?b) } \n}";
        TupleQuery q = this.conn.prepareTupleQuery(query);
        List result = QueryResults.asList((Iteration)q.evaluate());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)this.conn.getValueFactory().createLiteral("a"), (Object)((BindingSet)result.get(0)).getValue("a"));
        Assert.assertNull((Object)((BindingSet)result.get(0)).getValue("b"));
    }

    @Test
    public void testBindScopeUnion() {
        ValueFactory f = this.conn.getValueFactory();
        String query = "prefix ex: <http://example.org/> \nselect * {\n  bind(ex:v1 as ?v)\n  bind(strafter(str(?v),str(ex:)) as ?b)\n  {\n    bind(?b as ?b1)\n  } union {\n    bind(?b as ?b2)\n  }\n}";
        TupleQuery q = this.conn.prepareTupleQuery(query);
        List result = QueryResults.asList((Iteration)q.evaluate());
        Assert.assertEquals((long)2L, (long)result.size());
        IRI v1 = f.createIRI("http://example.org/v1");
        Literal b = f.createLiteral("v1");
        for (BindingSet bs : result) {
            Assertions.assertThat((Object)bs.getValue("v")).isEqualTo((Object)v1);
            Assertions.assertThat((Object)bs.getValue("b1")).isNull();
            Assertions.assertThat((Object)bs.getValue("b2")).isNull();
        }
    }

    @Test
    public void testSES2250BindErrors() throws Exception {
        StringBuilder ub = new StringBuilder();
        ub.append("insert data { <urn:test:subj> <urn:test:pred> _:blank }");
        this.conn.prepareUpdate(QueryLanguage.SPARQL, ub.toString()).execute();
        StringBuilder qb = new StringBuilder();
        qb.append("SELECT * {\n    ?s1 ?p1 ?blank .     FILTER(isBlank(?blank))    BIND (iri(?blank) as ?biri)    ?biri ?p2 ?o2 .}");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, qb.toString());
        try (TupleQueryResult evaluate = tq.evaluate();){
            Assert.assertFalse((String)"The query should not return a result", (boolean)evaluate.hasNext());
        }
    }

    @Test
    public void testSES2250BindErrorsInPath() throws Exception {
        StringBuilder ub = new StringBuilder();
        ub.append("insert data { <urn:test:subj> <urn:test:pred> _:blank }");
        this.conn.prepareUpdate(QueryLanguage.SPARQL, ub.toString()).execute();
        StringBuilder qb = new StringBuilder();
        qb.append("SELECT * {\n    ?s1 ?p1 ?blank .     FILTER(isBlank(?blank))    BIND (iri(?blank) as ?biri)    ?biri <urn:test:pred>* ?o2 .}");
        TupleQuery tq = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, qb.toString());
        try (TupleQueryResult evaluate = tq.evaluate();){
            Assert.assertFalse((String)"The query should not return a result", (boolean)evaluate.hasNext());
        }
    }

    @Test
    public void testEmptyUnion() throws Exception {
        String query = "PREFIX : <http://example.org/> SELECT ?visibility WHERE {OPTIONAL { SELECT ?var WHERE { :s a :MyType . BIND (:s as ?var ) .} } .BIND (IF(BOUND(?var), 'VISIBLE', 'HIDDEN') as ?visibility)}";
        try (TupleQueryResult result = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, query).evaluate();){
            Assert.assertNotNull((Object)result);
            Assert.assertFalse((boolean)result.hasNext());
        }
    }

    @Test
    public void testFilterExistsExternalValuesClause() throws Exception {
        StringBuilder ub = new StringBuilder();
        ub.append("insert data {\n");
        ub.append("  <http://subj1> a <http://type> .\n");
        ub.append("  <http://subj2> a <http://type> .\n");
        ub.append("  <http://subj1> <http://predicate> <http://obj1> .\n");
        ub.append("  <http://subj2> <http://predicate> <http://obj2> .\n");
        ub.append("}");
        this.conn.prepareUpdate(QueryLanguage.SPARQL, ub.toString()).execute();
        String query = "select ?s  {\n    ?s a* <http://type> .\n    FILTER EXISTS {?s <http://predicate> ?o}\n} limit 100 values ?o {<http://obj1>}";
        TupleQuery tq = this.conn.prepareTupleQuery(query);
        List result = QueryResults.asList((Iteration)tq.evaluate());
        Assert.assertEquals((String)"single result expected", (long)1L, (long)result.size());
        Assert.assertEquals((Object)"http://subj1", (Object)((BindingSet)result.get(0)).getValue("s").stringValue());
    }

    @Test
    public void testValuesClauseNamedGraph() throws Exception {
        String ex = EX_NS;
        String data = "@prefix foaf: <http://xmlns.com/foaf/0.1/> .\n@prefix ex: <" + ex + "> .\nex:graph1 {\n\tex:Person1 rdf:type foaf:Person ;\n\t\tfoaf:name \"Person 1\" .\tex:Person2 rdf:type foaf:Person ;\n\t\tfoaf:name \"Person 2\" .\tex:Person3 rdf:type foaf:Person ;\n\t\tfoaf:name \"Person 3\" .\n}";
        this.conn.add((Reader)new StringReader(data), "", RDFFormat.TRIG, new Resource[0]);
        String query = "SELECT  ?person ?name ?__index \nWHERE {         VALUES (?person ?name  ?__index) { \n                  (<http://example.org/Person1> UNDEF \"0\") \n                  (<http://example.org/Person3> UNDEF \"2\")  } \n        GRAPH <http://example.org/graph1> { ?person <http://xmlns.com/foaf/0.1/name> ?name .   } }";
        TupleQuery q = this.conn.prepareTupleQuery(query);
        List result = QueryResults.asList((Iteration)q.evaluate());
        Assertions.assertThat((List)result).hasSize(2);
    }

    @Test
    public void testSeconds() throws Exception {
        String qry = "PREFIX xsd: <http://www.w3.org/2001/XMLSchema#> SELECT (SECONDS(\"2011-01-10T14:45:13\"^^xsd:dateTime) AS ?sec) { }";
        try (TupleQueryResult result = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, qry).evaluate();){
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)result.hasNext());
            Assert.assertEquals((Object)"13", (Object)((BindingSet)result.next()).getValue("sec").stringValue());
            Assert.assertFalse((boolean)result.hasNext());
        }
    }

    @Test
    public void testSecondsMilliseconds() throws Exception {
        String qry = "PREFIX xsd: <http://www.w3.org/2001/XMLSchema#> SELECT (SECONDS(\"2011-01-10T14:45:13.815-05:00\"^^xsd:dateTime) AS ?sec) { }";
        try (TupleQueryResult result = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, qry).evaluate();){
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)result.hasNext());
            Assert.assertEquals((Object)"13.815", (Object)((BindingSet)result.next()).getValue("sec").stringValue());
            Assert.assertFalse((boolean)result.hasNext());
        }
    }

    private boolean containsSolution(List<BindingSet> result, Binding ... solution) {
        MapBindingSet bs = new MapBindingSet();
        for (Binding b : solution) {
            bs.addBinding(b);
        }
        return result.contains(bs);
    }

    private int countCharOccurrences(String string, char ch) {
        int count = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != ch) continue;
            ++count;
        }
        return count;
    }

    protected String getNamespaceDeclarations() {
        StringBuilder declarations = new StringBuilder();
        declarations.append("PREFIX dc: <http://purl.org/dc/terms/> \n");
        declarations.append("PREFIX foaf: <http://xmlns.com/foaf/0.1/> \n");
        declarations.append("PREFIX sesame: <http://www.openrdf.org/schema/sesame#> \n");
        declarations.append("PREFIX ex: <http://example.org/> \n");
        declarations.append("\n");
        return declarations.toString();
    }

    protected abstract Repository newRepository() throws Exception;

    protected void loadTestData(String dataFile, Resource ... contexts) throws RDFParseException, RepositoryException, IOException {
        this.logger.debug("loading dataset {}", (Object)dataFile);
        try (InputStream dataset = ComplexSPARQLQueryTest.class.getResourceAsStream(dataFile);){
            this.conn.add(dataset, "", (RDFFormat)Rio.getParserFormatForFileName((String)dataFile).orElseThrow(Rio.unsupportedFormat((String)dataFile)), contexts);
        }
        this.logger.debug("dataset loaded.");
    }
}

