/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.parser.sparql.manifest;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.eclipse.rdf4j.common.io.IOUtil;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.common.text.StringUtil;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.BooleanQuery;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.QueryResultHandler;
import org.eclipse.rdf4j.query.QueryResults;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.dawg.DAWGTestResultSetUtil;
import org.eclipse.rdf4j.query.impl.MutableTupleQueryResult;
import org.eclipse.rdf4j.query.impl.SimpleDataset;
import org.eclipse.rdf4j.query.impl.TupleQueryResultBuilder;
import org.eclipse.rdf4j.query.resultio.BooleanQueryResultParserRegistry;
import org.eclipse.rdf4j.query.resultio.QueryResultFormat;
import org.eclipse.rdf4j.query.resultio.QueryResultIO;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultParser;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.repository.util.RDFInserter;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public abstract class SPARQL11QueryComplianceTest {
    private static final Logger logger = LoggerFactory.getLogger(SPARQL11QueryComplianceTest.class);
    private static final String[] defaultIgnoredTests = new String[]{"STRDT() TypeErrors", "STRLANG() TypeErrors", "sq03 - Subquery within graph pattern, graph variable is not bound"};
    private List<String> ignoredTests = new ArrayList<String>(Arrays.asList(defaultIgnoredTests));
    private static final String[] excludedSubdirs = new String[]{"service"};
    private String testURI;
    private String name;
    private String queryFileURL;
    private String resultFileURL;
    private Dataset dataset;
    private boolean ordered;
    private Repository dataRep;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(SPARQL11QueryComplianceTest.getTestData());
    }

    public SPARQL11QueryComplianceTest(String displayName, String testURI, String name, String queryFileURL, String resultFileURL, Dataset dataset, boolean ordered) {
        this.testURI = testURI;
        this.name = name;
        this.queryFileURL = queryFileURL;
        this.resultFileURL = resultFileURL;
        this.dataset = dataset;
        this.ordered = ordered;
    }

    @Before
    public void setUp() throws Exception {
        this.dataRep = this.createRepository();
        if (this.dataset != null) {
            try {
                this.uploadDataset(this.dataset);
            }
            catch (Exception exc) {
                try {
                    this.dataRep.shutDown();
                    this.dataRep = null;
                }
                catch (Exception e2) {
                    logger.error(e2.toString(), (Throwable)e2);
                }
                throw exc;
            }
        }
    }

    @After
    public void tearDown() throws Exception {
        if (this.dataRep != null) {
            this.dataRep.shutDown();
            this.dataRep = null;
        }
    }

    private final Repository createRepository() throws Exception {
        Repository repo = this.newRepository();
        try (RepositoryConnection con = repo.getConnection();){
            con.clear(new Resource[0]);
            con.clearNamespaces();
        }
        return repo;
    }

    protected abstract Repository newRepository() throws Exception;

    @Test
    public void test() throws Exception {
        this.runTest();
    }

    private static Object[][] getTestData() {
        ArrayList<Object[]> tests = new ArrayList<Object[]>();
        ArrayDeque<String> manifests = new ArrayDeque<String>();
        manifests.add(SPARQL11QueryComplianceTest.class.getClassLoader().getResource("testcases-sparql-1.1-w3c/manifest-all.ttl").toExternalForm());
        while (!manifests.isEmpty()) {
            String pop = (String)manifests.pop();
            Manifest manifest = new Manifest(pop);
            tests.addAll(manifest.tests);
            manifests.addAll(manifest.subManifests);
        }
        Object[][] result = new Object[tests.size()][6];
        tests.toArray((T[])result);
        return result;
    }

    private void runTest() throws Exception {
        block16: {
            ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)this.getIgnoredTests().contains(this.name)).withFailMessage("test case '%s' is ignored", new Object[]{this.name})).isFalse();
            logger.debug("running {}", (Object)this.name);
            try (RepositoryConnection conn = this.dataRep.getConnection();){
                conn.getParserConfig().set(BasicParserSettings.VERIFY_DATATYPE_VALUES, (Object)Boolean.FALSE);
                conn.getParserConfig().set(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES, (Object)Boolean.FALSE);
                String queryString = this.readQueryString();
                Query query = conn.prepareQuery(QueryLanguage.SPARQL, queryString, this.queryFileURL);
                if (this.dataset != null) {
                    query.setDataset(this.dataset);
                }
                if (query instanceof TupleQuery) {
                    TupleQueryResult actualResult = ((TupleQuery)query).evaluate();
                    TupleQueryResult expectedResult = this.readExpectedTupleQueryResult();
                    this.compareTupleQueryResults(actualResult, expectedResult);
                    break block16;
                }
                if (query instanceof GraphQuery) {
                    GraphQueryResult gqr = ((GraphQuery)query).evaluate();
                    Set actualResult = Iterations.asSet((Iteration)gqr);
                    Set<Statement> expectedResult = this.readExpectedGraphQueryResult();
                    this.compareGraphs(actualResult, expectedResult);
                    break block16;
                }
                if (query instanceof BooleanQuery) {
                    boolean actualResult = ((BooleanQuery)query).evaluate();
                    boolean expectedResult = this.readExpectedBooleanQueryResult();
                    Assertions.assertThat((boolean)actualResult).isEqualTo(expectedResult);
                    break block16;
                }
                throw new RuntimeException("Unexpected query type: " + query.getClass());
            }
        }
    }

    private final void uploadDataset(Dataset dataset) throws Exception {
        try (RepositoryConnection con = this.dataRep.getConnection();){
            HashSet graphURIs = new HashSet();
            graphURIs.addAll(dataset.getDefaultGraphs());
            graphURIs.addAll(dataset.getNamedGraphs());
            for (Resource graphURI : graphURIs) {
                this.upload((IRI)graphURI, graphURI);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upload(IRI graphURI, Resource context) throws Exception {
        try (RepositoryConnection con = this.dataRep.getConnection();){
            con.begin();
            RDFFormat rdfFormat = Rio.getParserFormatForFileName((String)graphURI.toString()).orElse(RDFFormat.TURTLE);
            RDFParser rdfParser = Rio.createParser((RDFFormat)rdfFormat, (ValueFactory)this.dataRep.getValueFactory());
            rdfParser.setVerifyData(false);
            rdfParser.setDatatypeHandling(RDFParser.DatatypeHandling.IGNORE);
            RDFInserter rdfInserter = new RDFInserter(con);
            rdfInserter.enforceContext(new Resource[]{context});
            rdfParser.setRDFHandler((RDFHandler)rdfInserter);
            URL graphURL = new URL(graphURI.toString());
            try (InputStream in = graphURL.openStream();){
                rdfParser.parse(in, graphURI.toString());
            }
            con.commit();
        }
    }

    private final String readQueryString() throws IOException {
        try (InputStream stream = new URL(this.queryFileURL).openStream();){
            String string = IOUtil.readString((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8));
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final TupleQueryResult readExpectedTupleQueryResult() throws Exception {
        Optional tqrFormat = QueryResultIO.getParserFormatForFileName((String)this.resultFileURL);
        if (tqrFormat.isPresent()) {
            try (InputStream in = new URL(this.resultFileURL).openStream();){
                TupleQueryResultParser parser = QueryResultIO.createTupleParser((QueryResultFormat)((QueryResultFormat)tqrFormat.get()));
                parser.setValueFactory(this.dataRep.getValueFactory());
                TupleQueryResultBuilder qrBuilder = new TupleQueryResultBuilder();
                parser.setQueryResultHandler((QueryResultHandler)qrBuilder);
                parser.parseQueryResult(in);
                TupleQueryResult tupleQueryResult = qrBuilder.getQueryResult();
                return tupleQueryResult;
            }
        }
        Set<Statement> resultGraph = this.readExpectedGraphQueryResult();
        return DAWGTestResultSetUtil.toTupleQueryResult(resultGraph);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean readExpectedBooleanQueryResult() throws Exception {
        Optional bqrFormat = BooleanQueryResultParserRegistry.getInstance().getFileFormatForFileName(this.resultFileURL);
        if (bqrFormat.isPresent()) {
            try (InputStream in = new URL(this.resultFileURL).openStream();){
                boolean bl = QueryResultIO.parseBoolean((InputStream)in, (QueryResultFormat)((QueryResultFormat)bqrFormat.get()));
                return bl;
            }
        }
        Set<Statement> resultGraph = this.readExpectedGraphQueryResult();
        return DAWGTestResultSetUtil.toBooleanQueryResult(resultGraph);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Set<Statement> readExpectedGraphQueryResult() throws Exception {
        RDFFormat rdfFormat = (RDFFormat)Rio.getParserFormatForFileName((String)this.resultFileURL).orElseThrow(Rio.unsupportedFormat((String)this.resultFileURL));
        RDFParser parser = Rio.createParser((RDFFormat)rdfFormat);
        parser.setDatatypeHandling(RDFParser.DatatypeHandling.IGNORE);
        parser.setPreserveBNodeIDs(true);
        parser.setValueFactory(this.dataRep.getValueFactory());
        LinkedHashSet<Statement> result = new LinkedHashSet<Statement>();
        parser.setRDFHandler((RDFHandler)new StatementCollector(result));
        try (InputStream in = new URL(this.resultFileURL).openStream();){
            parser.parse(in, this.resultFileURL);
        }
        return result;
    }

    private final void compareGraphs(Set<Statement> queryResult, Set<Statement> expectedResult) throws Exception {
        if (!Models.isomorphic(expectedResult, queryResult)) {
            StringBuilder message = new StringBuilder(128);
            message.append("\n============ ");
            message.append(this.name);
            message.append(" =======================\n");
            message.append("Expected result: \n");
            for (Statement st : expectedResult) {
                message.append(st.toString());
                message.append("\n");
            }
            message.append("=============");
            StringUtil.appendN((char)'=', (int)this.name.length(), (StringBuilder)message);
            message.append("========================\n");
            message.append("Query result: \n");
            for (Statement st : queryResult) {
                message.append(st.toString());
                message.append("\n");
            }
            message.append("=============");
            StringUtil.appendN((char)'=', (int)this.name.length(), (StringBuilder)message);
            message.append("========================\n");
            logger.error(message.toString());
            Assertions.fail((String)message.toString());
        }
    }

    private final void compareTupleQueryResults(TupleQueryResult queryResult, TupleQueryResult expectedResult) throws Exception {
        boolean resultsEqual;
        MutableTupleQueryResult queryResultTable = new MutableTupleQueryResult(queryResult);
        MutableTupleQueryResult expectedResultTable = new MutableTupleQueryResult(expectedResult);
        boolean laxCardinality = false;
        if (laxCardinality) {
            resultsEqual = QueryResults.isSubset((TupleQueryResult)queryResultTable, (TupleQueryResult)expectedResultTable);
        } else {
            resultsEqual = QueryResults.equals((TupleQueryResult)queryResultTable, (TupleQueryResult)expectedResultTable);
            if (this.ordered) {
                queryResultTable.beforeFirst();
                expectedResultTable.beforeFirst();
                while (queryResultTable.hasNext()) {
                    BindingSet expectedBs;
                    BindingSet bs = queryResultTable.next();
                    if (bs.equals((Object)(expectedBs = expectedResultTable.next()))) continue;
                    resultsEqual = false;
                    break;
                }
            }
        }
        if (!resultsEqual) {
            queryResultTable.beforeFirst();
            expectedResultTable.beforeFirst();
            List queryBindings = Iterations.asList((Iteration)queryResultTable);
            List expectedBindings = Iterations.asList((Iteration)expectedResultTable);
            ArrayList missingBindings = new ArrayList(expectedBindings);
            missingBindings.removeAll(queryBindings);
            ArrayList unexpectedBindings = new ArrayList(queryBindings);
            unexpectedBindings.removeAll(expectedBindings);
            StringBuilder message = new StringBuilder(128);
            message.append("\n============ ");
            message.append(this.name);
            message.append(" =======================\n");
            if (!missingBindings.isEmpty()) {
                message.append("Missing bindings: \n");
                for (BindingSet bs : missingBindings) {
                    this.printBindingSet(bs, message);
                }
                message.append("=============");
                StringUtil.appendN((char)'=', (int)this.name.length(), (StringBuilder)message);
                message.append("========================\n");
            }
            if (!unexpectedBindings.isEmpty()) {
                message.append("Unexpected bindings: \n");
                for (BindingSet bs : unexpectedBindings) {
                    this.printBindingSet(bs, message);
                }
                message.append("=============");
                StringUtil.appendN((char)'=', (int)this.name.length(), (StringBuilder)message);
                message.append("========================\n");
            }
            if (this.ordered && missingBindings.isEmpty() && unexpectedBindings.isEmpty()) {
                message.append("Results are not in expected order.\n");
                message.append(" =======================\n");
                message.append("query result: \n");
                for (BindingSet bs : queryBindings) {
                    this.printBindingSet(bs, message);
                }
                message.append(" =======================\n");
                message.append("expected result: \n");
                for (BindingSet bs : expectedBindings) {
                    this.printBindingSet(bs, message);
                }
                message.append(" =======================\n");
                System.out.print(message.toString());
            } else if (missingBindings.isEmpty() && unexpectedBindings.isEmpty()) {
                message.append("unexpected duplicate in result.\n");
                message.append(" =======================\n");
                message.append("query result: \n");
                for (BindingSet bs : queryBindings) {
                    this.printBindingSet(bs, message);
                }
                message.append(" =======================\n");
                message.append("expected result: \n");
                for (BindingSet bs : expectedBindings) {
                    this.printBindingSet(bs, message);
                }
                message.append(" =======================\n");
                System.out.print(message.toString());
            }
            logger.error(message.toString());
            Assertions.fail((String)message.toString());
        }
    }

    private final void printBindingSet(BindingSet bs, StringBuilder appendable) {
        ArrayList names = new ArrayList(bs.getBindingNames());
        Collections.sort(names);
        for (String name : names) {
            if (!bs.hasBinding(name)) continue;
            appendable.append(bs.getBinding(name));
            appendable.append(' ');
        }
        appendable.append("\n");
    }

    private static boolean includeSubManifest(String subManifestFile, String[] excludedSubdirs) {
        boolean result = true;
        if (excludedSubdirs != null && excludedSubdirs.length > 0) {
            int index = subManifestFile.lastIndexOf(47);
            String path = subManifestFile.substring(0, index);
            String sd = path.substring(path.lastIndexOf(47) + 1);
            for (String subdir : excludedSubdirs) {
                if (!sd.equals(subdir)) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    protected List<String> getIgnoredTests() {
        return this.ignoredTests;
    }

    protected void addIgnoredTest(String ignoredTest) {
        this.ignoredTests.add(ignoredTest);
    }

    protected void setIgnoredTests(List<String> ignoredTests) {
        this.ignoredTests = ignoredTests;
    }

    static class Manifest {
        List<Object[]> tests = new ArrayList<Object[]>();
        List<String> subManifests = new ArrayList<String>();

        public Manifest(String filename) {
            Throwable throwable;
            SailRepositoryConnection connection;
            SailRepository sailRepository = new SailRepository((Sail)new MemoryStore());
            try {
                connection = sailRepository.getConnection();
                throwable = null;
                try {
                    connection.add(new URL(filename), filename, RDFFormat.TURTLE, new Resource[0]);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (connection != null) {
                        if (throwable != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            connection.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            connection = sailRepository.getConnection();
            throwable = null;
            try {
                String manifestQuery = " PREFIX qt: <http://www.w3.org/2001/sw/DataAccess/tests/test-query#> PREFIX mf: <http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#> SELECT DISTINCT ?manifestFile WHERE { [] mf:include [ rdf:rest*/rdf:first ?manifestFile ] . }   ";
                try (TupleQueryResult manifestResults = connection.prepareTupleQuery(QueryLanguage.SPARQL, manifestQuery, filename).evaluate();){
                    for (BindingSet bindingSet : manifestResults) {
                        String subManifestFile = bindingSet.getValue("manifestFile").stringValue();
                        if (!SPARQL11QueryComplianceTest.includeSubManifest(subManifestFile, excludedSubdirs)) continue;
                        this.subManifests.add(subManifestFile);
                    }
                }
                StringBuilder query = new StringBuilder(512);
                query.append(" PREFIX mf: <http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#> \n");
                query.append(" PREFIX dawgt: <http://www.w3.org/2001/sw/DataAccess/tests/test-dawg#> \n");
                query.append(" PREFIX qt: <http://www.w3.org/2001/sw/DataAccess/tests/test-query#> \n");
                query.append(" PREFIX sd: <http://www.w3.org/ns/sparql-service-description#> \n");
                query.append(" PREFIX ent: <http://www.w3.org/ns/entailment/> \n");
                query.append(" SELECT DISTINCT ?testURI ?testName ?resultFile ?action ?queryFile ?defaultGraph ?ordered \n");
                query.append(" WHERE { [] rdf:first ?testURI . \n");
                query.append(" ?testURI dawgt:approval dawgt:Approved . \n");
                query.append(" ?testURI mf:name ?testName; \n");
                query.append("          mf:result ?resultFile . \n");
                query.append(" OPTIONAL { ?testURI mf:checkOrder ?ordered } \n");
                query.append(" OPTIONAL { ?testURI  mf:requires ?requirement } \n");
                query.append(" ?testURI mf:action ?action. \n");
                query.append(" ?action qt:query ?queryFile . \n");
                query.append(" OPTIONAL { ?action qt:data ?defaultGraph } \n");
                query.append(" OPTIONAL { ?action sd:entailmentRegime ?regime } \n");
                query.append(" FILTER(!STRENDS(STR(?resultFile), \"csv\")) \n");
                query.append(" FILTER(!BOUND(?regime)) \n");
                query.append(" FILTER (!BOUND(?requirement) || (?requirement != mf:BasicFederation)) \n");
                query.append(" }\n");
                TupleQueryResult result = connection.prepareTupleQuery(query.toString()).evaluate();
                Object object = null;
                try {
                    query.setLength(0);
                    query.append(" PREFIX qt: <http://www.w3.org/2001/sw/DataAccess/tests/test-query#> \n");
                    query.append(" SELECT ?graph \n");
                    query.append(" WHERE { ?action qt:graphData ?graph } \n");
                    TupleQuery namedGraphsQuery = connection.prepareTupleQuery(query.toString());
                    for (BindingSet bs : result) {
                        String testName = bs.getValue("testName").stringValue();
                        String displayName = filename.substring(filename.lastIndexOf("testcases-sparql-1.1-w3c/") + "testcases-sparql-1.1-w3c/".length(), filename.lastIndexOf("/")) + ": " + testName;
                        IRI defaultGraphURI = (IRI)bs.getValue("defaultGraph");
                        Value action = bs.getValue("action");
                        Value ordered = bs.getValue("ordered");
                        SimpleDataset dataset = null;
                        namedGraphsQuery.setBinding("action", action);
                        try (TupleQueryResult namedGraphs = namedGraphsQuery.evaluate();){
                            if (defaultGraphURI != null || namedGraphs.hasNext()) {
                                dataset = new SimpleDataset();
                                if (defaultGraphURI != null) {
                                    dataset.addDefaultGraph(defaultGraphURI);
                                }
                                while (namedGraphs.hasNext()) {
                                    BindingSet graphBindings = (BindingSet)namedGraphs.next();
                                    IRI namedGraphURI = (IRI)graphBindings.getValue("graph");
                                    dataset.addNamedGraph(namedGraphURI);
                                }
                            }
                        }
                        this.tests.add(new Object[]{displayName, bs.getValue("testURI").stringValue(), testName, bs.getValue("queryFile").stringValue(), bs.getValue("resultFile").stringValue(), dataset, Literals.getBooleanValue((Value)ordered, (boolean)false)});
                    }
                }
                catch (Throwable throwable4) {
                    object = throwable4;
                    throw throwable4;
                }
                finally {
                    if (result != null) {
                        if (object != null) {
                            try {
                                result.close();
                            }
                            catch (Throwable throwable5) {
                                ((Throwable)object).addSuppressed(throwable5);
                            }
                        } else {
                            result.close();
                        }
                    }
                }
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (connection != null) {
                    if (throwable != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                    } else {
                        connection.close();
                    }
                }
            }
        }
    }
}

