/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.parser.sparql.manifest;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.rdf4j.common.io.IOUtil;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.common.text.StringUtil;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.BooleanQuery;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.QueryResultHandler;
import org.eclipse.rdf4j.query.QueryResults;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.dawg.DAWGTestResultSetUtil;
import org.eclipse.rdf4j.query.impl.MutableTupleQueryResult;
import org.eclipse.rdf4j.query.impl.SimpleDataset;
import org.eclipse.rdf4j.query.impl.TupleQueryResultBuilder;
import org.eclipse.rdf4j.query.parser.sparql.manifest.SPARQL11ManifestTest;
import org.eclipse.rdf4j.query.resultio.BooleanQueryResultParserRegistry;
import org.eclipse.rdf4j.query.resultio.QueryResultFormat;
import org.eclipse.rdf4j.query.resultio.QueryResultIO;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultParser;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.repository.util.RDFInserter;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SPARQLQueryTest
extends TestCase {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final Logger LOGGER = LoggerFactory.getLogger(SPARQLQueryTest.class);
    protected final String testURI;
    protected final String queryFileURL;
    protected final String resultFileURL;
    protected final Dataset dataset;
    protected final boolean laxCardinality;
    protected final boolean checkOrder;
    protected final String[] ignoredTests;
    protected Repository dataRep;

    public SPARQLQueryTest(String testURI, String name, String queryFileURL, String resultFileURL, Dataset dataSet, boolean laxCardinality, String ... ignoredTests) {
        this(testURI, name, queryFileURL, resultFileURL, dataSet, laxCardinality, false, new String[0]);
    }

    public SPARQLQueryTest(String testURI, String name, String queryFileURL, String resultFileURL, Dataset dataSet, boolean laxCardinality, boolean checkOrder, String ... ignoredTests) {
        super(name.replaceAll("\\(", " ").replaceAll("\\)", " "));
        this.testURI = testURI;
        this.queryFileURL = queryFileURL;
        this.resultFileURL = resultFileURL;
        this.dataset = dataSet;
        this.laxCardinality = laxCardinality;
        this.checkOrder = checkOrder;
        this.ignoredTests = ignoredTests;
    }

    protected void setUp() throws Exception {
        this.dataRep = this.createRepository();
        if (this.dataset != null) {
            try {
                this.uploadDataset(this.dataset);
            }
            catch (Exception exc) {
                try {
                    this.dataRep.shutDown();
                    this.dataRep = null;
                }
                catch (Exception e2) {
                    this.logger.error(e2.toString(), (Throwable)e2);
                }
                throw exc;
            }
        }
    }

    protected final Repository createRepository() throws Exception {
        Repository repo = this.newRepository();
        repo.initialize();
        try (RepositoryConnection con = repo.getConnection();){
            con.clear(new Resource[0]);
            con.clearNamespaces();
        }
        return repo;
    }

    protected abstract Repository newRepository() throws Exception;

    protected void tearDown() throws Exception {
        if (this.dataRep != null) {
            this.dataRep.shutDown();
            this.dataRep = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runTest() throws Exception {
        block9: {
            if (Arrays.asList(this.ignoredTests).contains(this.getName())) {
                this.logger.warn("Query test ignored: " + this.getName());
                return;
            }
            RepositoryConnection con = this.dataRep.getConnection();
            con.getParserConfig().set(BasicParserSettings.VERIFY_DATATYPE_VALUES, (Object)Boolean.FALSE);
            con.getParserConfig().set(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES, (Object)Boolean.FALSE);
            try {
                String name;
                String queryString = this.readQueryString();
                Query query = con.prepareQuery(QueryLanguage.SPARQL, queryString, this.queryFileURL);
                if (this.dataset != null) {
                    query.setDataset(this.dataset);
                }
                if ((name = this.getName()).contains("pp34")) {
                    System.out.println(name);
                }
                if (query instanceof TupleQuery) {
                    TupleQueryResult queryResult = ((TupleQuery)query).evaluate();
                    TupleQueryResult expectedResult = this.readExpectedTupleQueryResult();
                    this.compareTupleQueryResults(queryResult, expectedResult);
                    break block9;
                }
                if (query instanceof GraphQuery) {
                    GraphQueryResult gqr = ((GraphQuery)query).evaluate();
                    Set queryResult = Iterations.asSet((Iteration)gqr);
                    Set<Statement> expectedResult = this.readExpectedGraphQueryResult();
                    this.compareGraphs(queryResult, expectedResult);
                    break block9;
                }
                if (query instanceof BooleanQuery) {
                    boolean queryResult = ((BooleanQuery)query).evaluate();
                    boolean expectedResult = this.readExpectedBooleanQueryResult();
                    SPARQLQueryTest.assertEquals((boolean)expectedResult, (boolean)queryResult);
                    break block9;
                }
                throw new RuntimeException("Unexpected query type: " + query.getClass());
            }
            finally {
                con.close();
            }
        }
    }

    protected final void compareTupleQueryResults(TupleQueryResult queryResult, TupleQueryResult expectedResult) throws Exception {
        boolean resultsEqual;
        MutableTupleQueryResult queryResultTable = new MutableTupleQueryResult(queryResult);
        MutableTupleQueryResult expectedResultTable = new MutableTupleQueryResult(expectedResult);
        if (this.laxCardinality) {
            resultsEqual = QueryResults.isSubset((TupleQueryResult)queryResultTable, (TupleQueryResult)expectedResultTable);
        } else {
            resultsEqual = QueryResults.equals((TupleQueryResult)queryResultTable, (TupleQueryResult)expectedResultTable);
            if (this.checkOrder) {
                queryResultTable.beforeFirst();
                expectedResultTable.beforeFirst();
                while (queryResultTable.hasNext()) {
                    BindingSet expectedBs;
                    BindingSet bs = queryResultTable.next();
                    if (bs.equals((Object)(expectedBs = expectedResultTable.next()))) continue;
                    resultsEqual = false;
                    break;
                }
            }
        }
        if (!resultsEqual) {
            queryResultTable.beforeFirst();
            expectedResultTable.beforeFirst();
            List queryBindings = Iterations.asList((Iteration)queryResultTable);
            List expectedBindings = Iterations.asList((Iteration)expectedResultTable);
            ArrayList missingBindings = new ArrayList(expectedBindings);
            missingBindings.removeAll(queryBindings);
            ArrayList unexpectedBindings = new ArrayList(queryBindings);
            unexpectedBindings.removeAll(expectedBindings);
            StringBuilder message = new StringBuilder(128);
            message.append("\n============ ");
            message.append(this.getName());
            message.append(" =======================\n");
            if (!missingBindings.isEmpty()) {
                message.append("Missing bindings: \n");
                for (BindingSet bs : missingBindings) {
                    this.printBindingSet(bs, message);
                }
                message.append("=============");
                StringUtil.appendN((char)'=', (int)this.getName().length(), (StringBuilder)message);
                message.append("========================\n");
            }
            if (!unexpectedBindings.isEmpty()) {
                message.append("Unexpected bindings: \n");
                for (BindingSet bs : unexpectedBindings) {
                    this.printBindingSet(bs, message);
                }
                message.append("=============");
                StringUtil.appendN((char)'=', (int)this.getName().length(), (StringBuilder)message);
                message.append("========================\n");
            }
            if (this.checkOrder && missingBindings.isEmpty() && unexpectedBindings.isEmpty()) {
                message.append("Results are not in expected order.\n");
                message.append(" =======================\n");
                message.append("query result: \n");
                for (BindingSet bs : queryBindings) {
                    this.printBindingSet(bs, message);
                }
                message.append(" =======================\n");
                message.append("expected result: \n");
                for (BindingSet bs : expectedBindings) {
                    this.printBindingSet(bs, message);
                }
                message.append(" =======================\n");
                System.out.print(message.toString());
            } else if (missingBindings.isEmpty() && unexpectedBindings.isEmpty()) {
                message.append("unexpected duplicate in result.\n");
                message.append(" =======================\n");
                message.append("query result: \n");
                for (BindingSet bs : queryBindings) {
                    this.printBindingSet(bs, message);
                }
                message.append(" =======================\n");
                message.append("expected result: \n");
                for (BindingSet bs : expectedBindings) {
                    this.printBindingSet(bs, message);
                }
                message.append(" =======================\n");
                System.out.print(message.toString());
            }
            this.logger.error(message.toString());
            SPARQLQueryTest.fail((String)message.toString());
        }
    }

    protected final void printBindingSet(BindingSet bs, StringBuilder appendable) {
        ArrayList names = new ArrayList(bs.getBindingNames());
        Collections.sort(names);
        for (String name : names) {
            if (!bs.hasBinding(name)) continue;
            appendable.append(bs.getBinding(name));
            appendable.append(' ');
        }
        appendable.append("\n");
    }

    protected final void compareGraphs(Set<Statement> queryResult, Set<Statement> expectedResult) throws Exception {
        if (!Models.isomorphic(expectedResult, queryResult)) {
            StringBuilder message = new StringBuilder(128);
            message.append("\n============ ");
            message.append(this.getName());
            message.append(" =======================\n");
            message.append("Expected result: \n");
            for (Statement st : expectedResult) {
                message.append(st.toString());
                message.append("\n");
            }
            message.append("=============");
            StringUtil.appendN((char)'=', (int)this.getName().length(), (StringBuilder)message);
            message.append("========================\n");
            message.append("Query result: \n");
            for (Statement st : queryResult) {
                message.append(st.toString());
                message.append("\n");
            }
            message.append("=============");
            StringUtil.appendN((char)'=', (int)this.getName().length(), (StringBuilder)message);
            message.append("========================\n");
            this.logger.error(message.toString());
            SPARQLQueryTest.fail((String)message.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void uploadDataset(Dataset dataset) throws Exception {
        try (RepositoryConnection con = this.dataRep.getConnection();){
            HashSet graphURIs = new HashSet();
            graphURIs.addAll(dataset.getDefaultGraphs());
            graphURIs.addAll(dataset.getNamedGraphs());
            for (Resource graphURI : graphURIs) {
                this.upload((IRI)graphURI, graphURI);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upload(IRI graphURI, Resource context) throws Exception {
        try (RepositoryConnection con = this.dataRep.getConnection();){
            con.begin();
            RDFFormat rdfFormat = Rio.getParserFormatForFileName((String)graphURI.toString());
            if (rdfFormat == null) {
                rdfFormat = RDFFormat.TURTLE;
            }
            RDFParser rdfParser = Rio.createParser((RDFFormat)rdfFormat, (ValueFactory)this.dataRep.getValueFactory());
            rdfParser.setVerifyData(false);
            rdfParser.setDatatypeHandling(RDFParser.DatatypeHandling.IGNORE);
            RDFInserter rdfInserter = new RDFInserter(con);
            rdfInserter.enforceContext(new Resource[]{context});
            rdfParser.setRDFHandler((RDFHandler)rdfInserter);
            URL graphURL = new URL(graphURI.toString());
            try (InputStream in = graphURL.openStream();){
                rdfParser.parse(in, graphURI.toString());
            }
            con.commit();
        }
    }

    protected final String readQueryString() throws IOException {
        try (InputStream stream = new URL(this.queryFileURL).openStream();){
            String string = IOUtil.readString((Reader)new InputStreamReader(stream, "UTF-8"));
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final TupleQueryResult readExpectedTupleQueryResult() throws Exception {
        QueryResultFormat tqrFormat = QueryResultIO.getParserFormatForFileName((String)this.resultFileURL);
        if (tqrFormat != null) {
            try (InputStream in = new URL(this.resultFileURL).openStream();){
                TupleQueryResultParser parser = QueryResultIO.createTupleParser((QueryResultFormat)tqrFormat);
                parser.setValueFactory(this.dataRep.getValueFactory());
                TupleQueryResultBuilder qrBuilder = new TupleQueryResultBuilder();
                parser.setQueryResultHandler((QueryResultHandler)qrBuilder);
                parser.parseQueryResult(in);
                TupleQueryResult tupleQueryResult = qrBuilder.getQueryResult();
                return tupleQueryResult;
            }
        }
        Set<Statement> resultGraph = this.readExpectedGraphQueryResult();
        return DAWGTestResultSetUtil.toTupleQueryResult(resultGraph);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean readExpectedBooleanQueryResult() throws Exception {
        QueryResultFormat bqrFormat = (QueryResultFormat)BooleanQueryResultParserRegistry.getInstance().getFileFormatForFileName(this.resultFileURL);
        if (bqrFormat != null) {
            try (InputStream in = new URL(this.resultFileURL).openStream();){
                boolean bl = QueryResultIO.parseBoolean((InputStream)in, (QueryResultFormat)bqrFormat);
                return bl;
            }
        }
        Set<Statement> resultGraph = this.readExpectedGraphQueryResult();
        return DAWGTestResultSetUtil.toBooleanQueryResult(resultGraph);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Set<Statement> readExpectedGraphQueryResult() throws Exception {
        RDFFormat rdfFormat = Rio.getParserFormatForFileName((String)this.resultFileURL);
        if (rdfFormat == null) {
            throw Rio.unsupportedFormat((String)this.resultFileURL);
        }
        RDFParser parser = Rio.createParser((RDFFormat)rdfFormat);
        parser.setDatatypeHandling(RDFParser.DatatypeHandling.IGNORE);
        parser.setPreserveBNodeIDs(true);
        parser.setValueFactory(this.dataRep.getValueFactory());
        LinkedHashSet<Statement> result = new LinkedHashSet<Statement>();
        parser.setRDFHandler((RDFHandler)new StatementCollector(result));
        try (InputStream in = new URL(this.resultFileURL).openStream();){
            parser.parse(in, this.resultFileURL);
        }
        return result;
    }

    public static TestSuite suite(String manifestFileURL, Factory factory) throws Exception {
        return SPARQLQueryTest.suite(manifestFileURL, factory, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TestSuite suite(String manifestFileURL, Factory factory, boolean approvedOnly) throws Exception {
        LOGGER.info("Building test suite for {}", (Object)manifestFileURL);
        TestSuite suite = new TestSuite(factory.getClass().getName());
        SailRepository manifestRep = new SailRepository((Sail)new MemoryStore());
        manifestRep.initialize();
        RepositoryConnection con = manifestRep.getConnection();
        SPARQL11ManifestTest.addTurtle(con, new URL(manifestFileURL), manifestFileURL, new Resource[0]);
        suite.setName(SPARQLQueryTest.getManifestName((Repository)manifestRep, con, manifestFileURL));
        StringBuilder query = new StringBuilder(512);
        query.append(" SELECT DISTINCT testURI, testName, resultFile, action, queryFile, defaultGraph, ordered ");
        query.append(" FROM {} rdf:first {testURI} ");
        if (approvedOnly) {
            query.append("                          dawgt:approval {dawgt:Approved}; ");
        }
        query.append("                             mf:name {testName}; ");
        query.append("                             mf:result {resultFile}; ");
        query.append("                             [ mf:checkOrder {ordered} ]; ");
        query.append("                             [ mf:requires {Requirement} ];");
        query.append("                             mf:action {action} qt:query {queryFile}; ");
        query.append("                                               [qt:data {defaultGraph}]; ");
        query.append("                                               [sd:entailmentRegime {Regime} ]");
        query.append(" WHERE NOT resultFile LIKE \"*.csv\" ");
        query.append(" AND NOT resultFile LIKE \"*.srj\" ");
        query.append(" AND NOT BOUND(Regime) ");
        query.append(" AND (NOT BOUND(Requirement) OR (Requirement != mf:BasicFederation)) ");
        query.append(" USING NAMESPACE ");
        query.append("  mf = <http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#>, ");
        query.append("  dawgt = <http://www.w3.org/2001/sw/DataAccess/tests/test-dawg#>, ");
        query.append("  qt = <http://www.w3.org/2001/sw/DataAccess/tests/test-query#>, ");
        query.append("  sd = <http://www.w3.org/ns/sparql-service-description#>, ");
        query.append("  ent = <http://www.w3.org/ns/entailment/> ");
        TupleQuery testCaseQuery = con.prepareTupleQuery(QueryLanguage.SERQL, query.toString());
        query.setLength(0);
        query.append(" SELECT graph ");
        query.append(" FROM {action} qt:graphData {graph} ");
        query.append(" USING NAMESPACE ");
        query.append(" qt = <http://www.w3.org/2001/sw/DataAccess/tests/test-query#>");
        TupleQuery namedGraphsQuery = con.prepareTupleQuery(QueryLanguage.SERQL, query.toString());
        query.setLength(0);
        query.append("SELECT 1 ");
        query.append(" FROM {testURI} mf:resultCardinality {mf:LaxCardinality}");
        query.append(" USING NAMESPACE mf = <http://www.w3.org/2001/sw/DataAccess/tests/test-manifest#>");
        TupleQuery laxCardinalityQuery = con.prepareTupleQuery(QueryLanguage.SERQL, query.toString());
        LOGGER.debug("evaluating query..");
        TupleQueryResult testCases = testCaseQuery.evaluate();
        while (testCases.hasNext()) {
            SPARQLQueryTest test;
            BindingSet bindingSet = (BindingSet)testCases.next();
            IRI testURI = (IRI)bindingSet.getValue("testURI");
            String testName = bindingSet.getValue("testName").stringValue();
            String resultFile = bindingSet.getValue("resultFile").stringValue();
            String queryFile = bindingSet.getValue("queryFile").stringValue();
            IRI defaultGraphURI = (IRI)bindingSet.getValue("defaultGraph");
            Value action = bindingSet.getValue("action");
            Value ordered = bindingSet.getValue("ordered");
            LOGGER.debug("found test case : {}", (Object)testName);
            namedGraphsQuery.setBinding("action", action);
            TupleQueryResult namedGraphs = namedGraphsQuery.evaluate();
            SimpleDataset dataset = null;
            if (defaultGraphURI != null || namedGraphs.hasNext()) {
                dataset = new SimpleDataset();
                if (defaultGraphURI != null) {
                    dataset.addDefaultGraph(defaultGraphURI);
                }
                while (namedGraphs.hasNext()) {
                    BindingSet graphBindings = (BindingSet)namedGraphs.next();
                    IRI namedGraphURI = (IRI)graphBindings.getValue("graph");
                    LOGGER.debug(" adding named graph : {}", (Object)namedGraphURI);
                    dataset.addNamedGraph(namedGraphURI);
                }
            }
            boolean laxCardinality = false;
            laxCardinalityQuery.setBinding("testURI", (Value)testURI);
            try (TupleQueryResult laxCardinalityResult = laxCardinalityQuery.evaluate();){
                laxCardinality = laxCardinalityResult.hasNext();
            }
            if (!laxCardinality && (testURI.stringValue().contains("distinct/manifest#distinct-2") || testURI.stringValue().contains("distinct/manifest#distinct-9"))) {
                laxCardinality = true;
            }
            LOGGER.debug("testURI={} name={} queryFile={}", new Object[]{testURI.stringValue(), testName, queryFile});
            boolean checkOrder = false;
            if (ordered != null) {
                checkOrder = Boolean.parseBoolean(ordered.stringValue());
            }
            if ((test = factory.createSPARQLQueryTest(testURI.stringValue(), testName, queryFile, resultFile, (Dataset)dataset, laxCardinality, checkOrder)) == null) continue;
            suite.addTest((Test)test);
        }
        testCases.close();
        con.close();
        manifestRep.shutDown();
        LOGGER.info("Created test suite with " + suite.countTestCases() + " test cases.");
        return suite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getManifestName(Repository manifestRep, RepositoryConnection con, String manifestFileURL) throws QueryEvaluationException, RepositoryException, MalformedQueryException {
        TupleQuery manifestNameQuery = con.prepareTupleQuery(QueryLanguage.SERQL, "SELECT ManifestName FROM {ManifestURL} rdfs:label {ManifestName}");
        manifestNameQuery.setBinding("ManifestURL", (Value)manifestRep.getValueFactory().createIRI(manifestFileURL));
        try (TupleQueryResult manifestNames = manifestNameQuery.evaluate();){
            if (manifestNames.hasNext()) {
                String string = ((BindingSet)manifestNames.next()).getValue("ManifestName").stringValue();
                return string;
            }
        }
        int lastSlashIdx = manifestFileURL.lastIndexOf(47);
        int secLastSlashIdx = manifestFileURL.lastIndexOf(47, lastSlashIdx - 1);
        return manifestFileURL.substring(secLastSlashIdx + 1, lastSlashIdx);
    }

    public static interface Factory {
        public SPARQLQueryTest createSPARQLQueryTest(String var1, String var2, String var3, String var4, Dataset var5, boolean var6);

        public SPARQLQueryTest createSPARQLQueryTest(String var1, String var2, String var3, String var4, Dataset var5, boolean var6, boolean var7);
    }
}

