/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.wrapper.shape;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.transaction.IsolationLevel;
import org.eclipse.rdf4j.common.transaction.IsolationLevels;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDF4J;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.sail.NotifyingSail;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.inferencer.fc.SchemaCachingRDFSInferencer;
import org.eclipse.rdf4j.sail.inferencer.fc.SchemaCachingRDFSInferencerConnection;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.eclipse.rdf4j.sail.shacl.wrapper.shape.ShapeSource;
import org.eclipse.rdf4j.sail.shacl.wrapper.shape.ShapeSourceHelper;

public class Rdf4jShaclShapeGraphShapeSource
implements ShapeSource {
    private static final IRI shaclVocabularyGraph = Values.iri((String)"http://rdf4j.org/schema/rdf4j#", (String)"shaclVocabularyGraph");
    private static final SchemaCachingRDFSInferencer shaclVocabulary = Rdf4jShaclShapeGraphShapeSource.createShaclVocabulary();
    private final RepositoryConnection connection;
    private final Resource[] context;
    private final Repository repository;

    public Rdf4jShaclShapeGraphShapeSource(RepositoryConnection connection) {
        this.context = null;
        assert (connection.isActive());
        this.repository = this.forwardChain(connection);
        this.connection = this.repository.getConnection();
        this.connection.begin((IsolationLevel)IsolationLevels.NONE);
    }

    public Rdf4jShaclShapeGraphShapeSource(SailConnection connection) {
        this.context = null;
        assert (connection.isActive());
        this.repository = this.forwardChain(connection);
        this.connection = this.repository.getConnection();
        this.connection.begin((IsolationLevel)IsolationLevels.NONE);
    }

    private Rdf4jShaclShapeGraphShapeSource(Repository repository, RepositoryConnection connection, Resource[] context) {
        this.connection = connection;
        this.context = context;
        this.repository = repository;
    }

    private SailRepository forwardChain(RepositoryConnection shapesRepoConnection) {
        try (RepositoryResult statements = shapesRepoConnection.getStatements(null, null, null, false, new Resource[]{RDF4J.SHACL_SHAPE_GRAPH});){
            if (!statements.hasNext()) {
                SailRepository sailRepository = new SailRepository((Sail)new MemoryStore());
                return sailRepository;
            }
            SailRepository shapesRepoWithReasoning = new SailRepository((Sail)SchemaCachingRDFSInferencer.fastInstantiateFrom((SchemaCachingRDFSInferencer)shaclVocabulary, (NotifyingSail)new MemoryStore(), (boolean)false));
            try (SailRepositoryConnection shapesRepoWithReasoningConnection = shapesRepoWithReasoning.getConnection();){
                shapesRepoWithReasoningConnection.begin((IsolationLevel)IsolationLevels.NONE);
                shapesRepoWithReasoningConnection.add(statements, new Resource[0]);
                this.enrichShapes((RepositoryConnection)shapesRepoWithReasoningConnection);
                shapesRepoWithReasoningConnection.commit();
            }
            SailRepository sailRepository = shapesRepoWithReasoning;
            return sailRepository;
        }
    }

    private SailRepository forwardChain(SailConnection shapesSailConnection) {
        try (CloseableIteration statements = shapesSailConnection.getStatements(null, null, null, false, new Resource[]{RDF4J.SHACL_SHAPE_GRAPH});){
            if (!statements.hasNext()) {
                SailRepository sailRepository = new SailRepository((Sail)new MemoryStore());
                return sailRepository;
            }
            SailRepository shapesRepoWithReasoning = new SailRepository((Sail)SchemaCachingRDFSInferencer.fastInstantiateFrom((SchemaCachingRDFSInferencer)shaclVocabulary, (NotifyingSail)new MemoryStore(), (boolean)false));
            try (SailRepositoryConnection shapesRepoWithReasoningConnection = shapesRepoWithReasoning.getConnection();){
                shapesRepoWithReasoningConnection.begin((IsolationLevel)IsolationLevels.NONE);
                shapesRepoWithReasoningConnection.add(statements, new Resource[0]);
                this.enrichShapes((RepositoryConnection)shapesRepoWithReasoningConnection);
                shapesRepoWithReasoningConnection.commit();
            }
            SailRepository sailRepository = shapesRepoWithReasoning;
            return sailRepository;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SchemaCachingRDFSInferencer createShaclVocabulary() {
        SchemaCachingRDFSInferencer schemaCachingRDFSInferencer;
        block25: {
            InputStream in = Rdf4jShaclShapeGraphShapeSource.getResourceAsStream("shacl-sparql-inference/shaclVocabulary.ttl");
            try {
                SchemaCachingRDFSInferencer schemaCachingRDFSInferencer2 = new SchemaCachingRDFSInferencer((NotifyingSail)new MemoryStore());
                try (SchemaCachingRDFSInferencerConnection connection = schemaCachingRDFSInferencer2.getConnection();){
                    connection.begin((IsolationLevel)IsolationLevels.NONE);
                    Model model = Rio.parse((InputStream)in, (String)"", (RDFFormat)RDFFormat.TURTLE, (Resource[])new Resource[0]);
                    model.forEach(s -> connection.addStatement(s.getSubject(), s.getPredicate(), s.getObject(), new Resource[]{shaclVocabularyGraph}));
                    connection.commit();
                }
                SchemaCachingRDFSInferencer fastInstantiated = SchemaCachingRDFSInferencer.fastInstantiateFrom((SchemaCachingRDFSInferencer)schemaCachingRDFSInferencer2, (NotifyingSail)new MemoryStore());
                try (SchemaCachingRDFSInferencerConnection connection = fastInstantiated.getConnection();){
                    connection.begin((IsolationLevel)IsolationLevels.NONE);
                    connection.commit();
                }
                finally {
                    fastInstantiated.shutDown();
                }
                schemaCachingRDFSInferencer = schemaCachingRDFSInferencer2;
                if (in == null) break block25;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Resource could not be read: shacl-sparql-inference/shaclVocabulary.ttl", e);
                }
            }
            in.close();
        }
        return schemaCachingRDFSInferencer;
    }

    private static InputStream getResourceAsStream(String filename) {
        InputStream resourceAsStream = Rdf4jShaclShapeGraphShapeSource.class.getClassLoader().getResourceAsStream(filename);
        if (resourceAsStream == null) {
            throw new IllegalStateException("Resource could not be found: " + filename);
        }
        return new BufferedInputStream(resourceAsStream);
    }

    private void enrichShapes(RepositoryConnection shaclSailConnection) {
        if (shaclSailConnection.isEmpty()) {
            return;
        }
        shaclSailConnection.add((Iterable)DASH_CONSTANTS, new Resource[]{RDF4J.SHACL_SHAPE_GRAPH});
        shaclSailConnection.add((Iterable)DASH_CONSTANTS, new Resource[0]);
        shaclSailConnection.add((Iterable)DASH_CONSTANTS, new Resource[]{null});
        try (Stream stream = shaclSailConnection.getStatements(null, SHACL.SHAPES_GRAPH, null, false, new Resource[0]).stream();){
            stream.forEach(s -> shaclSailConnection.add((Iterable)DASH_CONSTANTS, new Resource[]{(IRI)s.getObject()}));
        }
        this.implicitTargetClass(shaclSailConnection);
    }

    private void implicitTargetClass(RepositoryConnection shaclSailConnection) {
        try (Stream stream = shaclSailConnection.getStatements(null, RDF.TYPE, (Value)RDFS.CLASS, false, new Resource[0]).stream();){
            stream.map(Statement::getSubject).filter(s -> shaclSailConnection.hasStatement(s, RDF.TYPE, (Value)SHACL.NODE_SHAPE, true, new Resource[0]) || shaclSailConnection.hasStatement(s, RDF.TYPE, (Value)SHACL.PROPERTY_SHAPE, true, new Resource[0])).forEach(s -> shaclSailConnection.add(s, SHACL.TARGET_CLASS, (Value)s, new Resource[]{RDF4J.SHACL_SHAPE_GRAPH}));
        }
    }

    @Override
    public Rdf4jShaclShapeGraphShapeSource withContext(Resource[] context) {
        return new Rdf4jShaclShapeGraphShapeSource(this.repository, this.connection, context);
    }

    @Override
    public Resource[] getActiveContexts() {
        return this.context;
    }

    @Override
    public Stream<ShapeSource.ShapesGraph> getAllShapeContexts() {
        assert (this.context != null);
        try (Stream stream = this.connection.getStatements(null, SHACL.SHAPES_GRAPH, null, false, this.context).stream();){
            List collect = stream.collect(Collectors.toList());
            Stream<ShapeSource.ShapesGraph> stream2 = Stream.concat(Stream.of(new ShapeSource.ShapesGraph(RDF4J.SHACL_SHAPE_GRAPH)), collect.stream().collect(Collectors.groupingBy(Statement::getSubject)).entrySet().stream().map(entry -> new ShapeSource.ShapesGraph((Resource)entry.getKey(), (List)entry.getValue())));
            return stream2;
        }
    }

    @Override
    public Stream<Resource> getTargetableShape() {
        assert (this.context != null);
        return Stream.of(this.getSubjects(ShapeSource.Predicates.TARGET_NODE), this.getSubjects(ShapeSource.Predicates.TARGET_CLASS), this.getSubjects(ShapeSource.Predicates.TARGET_SUBJECTS_OF), this.getSubjects(ShapeSource.Predicates.TARGET_OBJECTS_OF), this.getSubjects(ShapeSource.Predicates.TARGET_PROP), this.getSubjects(ShapeSource.Predicates.RSX_targetShape)).reduce(Stream::concat).get().distinct();
    }

    @Override
    public boolean isType(Resource subject, IRI type) {
        assert (this.context != null);
        if (this.connection.hasStatement(subject, RDF.TYPE, (Value)type, true, this.context)) {
            return true;
        }
        if (type.equals((Object)SHACL.NODE_SHAPE)) {
            if (this.connection.hasStatement(subject, RDF.TYPE, (Value)SHACL.SHAPE, true, this.context)) {
                return true;
            }
            try (Stream stream = this.connection.getStatements(subject, null, null, true, this.context).stream();){
                boolean bl = stream.map(Statement::getPredicate).map(Value::stringValue).anyMatch(predicate -> predicate.startsWith("http://www.w3.org/ns/shacl#") || predicate.startsWith("http://datashapes.org/dash#"));
                return bl;
            }
        }
        return false;
    }

    @Override
    public Stream<Resource> getSubjects(ShapeSource.Predicates predicate) {
        assert (this.context != null);
        return this.connection.getStatements(null, predicate.getIRI(), null, true, this.context).stream().map(Statement::getSubject).distinct();
    }

    @Override
    public Stream<Value> getObjects(Resource subject, ShapeSource.Predicates predicate) {
        assert (this.context != null);
        return this.connection.getStatements(subject, predicate.getIRI(), null, true, this.context).stream().map(Statement::getObject).distinct();
    }

    @Override
    public Stream<Statement> getAllStatements(Resource id) {
        assert (this.context != null);
        return this.connection.getStatements(id, null, null, true, this.context).stream();
    }

    @Override
    public Value getRdfFirst(Resource subject) {
        return ShapeSourceHelper.getFirst(this.connection, subject, this.context);
    }

    @Override
    public Resource getRdfRest(Resource subject) {
        return ShapeSourceHelper.getRdfRest(this.connection, subject, this.context);
    }

    @Override
    public void close() {
        this.connection.commit();
        this.connection.close();
        this.repository.shutDown();
    }
}

