/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.common.concurrent.locks.Lock;
import org.eclipse.rdf4j.common.concurrent.locks.StampedLockManager;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.transaction.IsolationLevel;
import org.eclipse.rdf4j.common.transaction.IsolationLevels;
import org.eclipse.rdf4j.common.transaction.TransactionSetting;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF4J;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailConnectionListener;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.UpdateContext;
import org.eclipse.rdf4j.sail.helpers.NotifyingSailConnectionWrapper;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.eclipse.rdf4j.sail.shacl.ConnectionHelper;
import org.eclipse.rdf4j.sail.shacl.ShaclSail;
import org.eclipse.rdf4j.sail.shacl.ShaclSailValidationException;
import org.eclipse.rdf4j.sail.shacl.Stats;
import org.eclipse.rdf4j.sail.shacl.ValidationSettings;
import org.eclipse.rdf4j.sail.shacl.ast.ContextWithShapes;
import org.eclipse.rdf4j.sail.shacl.ast.Shape;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.SingleCloseablePlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.eclipse.rdf4j.sail.shacl.results.ValidationReport;
import org.eclipse.rdf4j.sail.shacl.results.lazy.LazyValidationReport;
import org.eclipse.rdf4j.sail.shacl.results.lazy.ValidationResultIterator;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.RdfsSubClassOfReasoner;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.VerySimpleRdfsBackwardsChainingConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShaclSailConnection
extends NotifyingSailConnectionWrapper
implements SailConnectionListener {
    private static final Logger logger = LoggerFactory.getLogger(ShaclSailConnection.class);
    private final SailConnection previousStateConnection;
    private final SailConnection serializableConnection;
    private final boolean useDefaultShapesGraph;
    private IRI[] shapesGraphs;
    Sail addedStatements;
    Sail removedStatements;
    private final HashSet<Statement> addedStatementsSet = new HashSet();
    private final HashSet<Statement> removedStatementsSet = new HashSet();
    private boolean shapeRefreshNeeded = false;
    private boolean shapesModifiedInCurrentTransaction = false;
    public final ShaclSail sail;
    private Stats stats;
    RdfsSubClassOfReasoner rdfsSubClassOfReasoner;
    private boolean prepareHasBeenCalled = false;
    private Lock exclusiveSerializableValidationLock;
    private Lock nonExclusiveSerializableValidationLock;
    private StampedLockManager.Cache.WritableState writableShapesCache;
    private StampedLockManager.Cache.ReadableState readableShapesCache;
    private final SailRepositoryConnection shapesRepoConnection;
    private boolean connectionListenerActive = false;
    private IsolationLevel currentIsolationLevel = null;
    private Settings transactionSettings;
    private TransactionSetting[] transactionSettingsRaw = new TransactionSetting[0];
    private volatile boolean closed;

    ShaclSailConnection(ShaclSail sail, NotifyingSailConnection connection, SailConnection previousStateConnection, SailRepositoryConnection shapesRepoConnection, SailConnection serializableConnection) {
        super(connection);
        this.previousStateConnection = previousStateConnection;
        this.shapesRepoConnection = shapesRepoConnection;
        this.serializableConnection = serializableConnection;
        this.sail = sail;
        this.transactionSettings = this.getDefaultSettings(sail);
        this.useDefaultShapesGraph = sail.getShapesGraphs().contains(RDF4J.SHACL_SHAPE_GRAPH);
    }

    ShaclSailConnection(ShaclSail sail, NotifyingSailConnection connection, SailConnection previousStateConnection, SailRepositoryConnection shapesRepoConnection) {
        super(connection);
        this.previousStateConnection = previousStateConnection;
        this.shapesRepoConnection = shapesRepoConnection;
        this.serializableConnection = null;
        this.sail = sail;
        this.transactionSettings = this.getDefaultSettings(sail);
        this.useDefaultShapesGraph = sail.getShapesGraphs().contains(RDF4J.SHACL_SHAPE_GRAPH);
    }

    ShaclSailConnection(ShaclSail sail, NotifyingSailConnection connection, SailRepositoryConnection shapesRepoConnection, SailConnection serializableConnection) {
        super(connection);
        this.previousStateConnection = null;
        this.shapesRepoConnection = shapesRepoConnection;
        this.serializableConnection = serializableConnection;
        this.sail = sail;
        this.transactionSettings = this.getDefaultSettings(sail);
        this.useDefaultShapesGraph = sail.getShapesGraphs().contains(RDF4J.SHACL_SHAPE_GRAPH);
    }

    ShaclSailConnection(ShaclSail sail, NotifyingSailConnection connection, SailRepositoryConnection shapesRepoConnection) {
        super(connection);
        this.previousStateConnection = null;
        this.serializableConnection = null;
        this.shapesRepoConnection = shapesRepoConnection;
        this.sail = sail;
        this.transactionSettings = this.getDefaultSettings(sail);
        this.useDefaultShapesGraph = sail.getShapesGraphs().contains(RDF4J.SHACL_SHAPE_GRAPH);
    }

    private Settings getDefaultSettings(ShaclSail sail) {
        return new Settings(sail.isCacheSelectNodes(), sail.isValidationEnabled(), sail.isParallelValidation(), this.currentIsolationLevel);
    }

    public void setTransactionSettings(TransactionSetting ... settings) {
        super.setTransactionSettings(settings);
        this.transactionSettingsRaw = settings;
    }

    public void begin() throws SailException {
        this.begin(this.sail.getDefaultIsolationLevel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void begin(IsolationLevel level) throws SailException {
        if (this.closed) {
            throw new SailException("Connection is closed");
        }
        this.currentIsolationLevel = level;
        assert (this.addedStatements == null);
        assert (this.removedStatements == null);
        assert (this.readableShapesCache == null);
        assert (this.writableShapesCache == null);
        assert (this.nonExclusiveSerializableValidationLock == null);
        assert (this.exclusiveSerializableValidationLock == null);
        assert (this.shapesGraphs == null);
        this.shapesGraphs = (IRI[])this.sail.getShapesGraphs().stream().map(g -> {
            if (g.equals((Object)RDF4J.NIL)) {
                return null;
            }
            return g;
        }).toArray(IRI[]::new);
        this.stats = new Stats();
        ShaclSail shaclSail = this.sail;
        synchronized (shaclSail) {
            super.begin(level);
            this.hasStatement(null, null, null, false, new Resource[0]);
            this.shapesRepoConnection.begin(this.currentIsolationLevel);
            if (this.previousStateConnection != null) {
                this.previousStateConnection.begin(this.currentIsolationLevel);
                this.previousStateConnection.hasStatement(null, null, null, false, new Resource[0]);
            }
        }
        this.stats.setEmptyBeforeTransaction(ConnectionHelper.isEmpty((SailConnection)this));
        this.transactionSettings = this.getDefaultSettings(this.sail);
        if (this.stats.wasEmptyBeforeTransaction() && !this.shouldUseSerializableValidation()) {
            this.transactionSettings.switchToBulkValidation();
        }
        this.transactionSettings.applyTransactionSettings(this.getLocalTransactionSettings());
        assert (this.transactionSettings.parallelValidation != null);
        assert (this.transactionSettings.cacheSelectedNodes != null);
        assert (this.transactionSettings.validationApproach != null);
        if (this.isBulkValidation() || !this.isValidationEnabled()) {
            this.removeConnectionListener(this);
        } else {
            this.addConnectionListener(this);
        }
    }

    private Settings getLocalTransactionSettings() {
        return new Settings(this);
    }

    public void addConnectionListener(SailConnectionListener listener) {
        if (!this.connectionListenerActive && this.isValidationEnabled()) {
            super.addConnectionListener((SailConnectionListener)this);
            this.connectionListenerActive = true;
        }
    }

    boolean isValidationEnabled() {
        return this.transactionSettings.getValidationApproach() != ShaclSail.TransactionSettings.ValidationApproach.Disabled;
    }

    public void removeConnectionListener(SailConnectionListener listener) {
        super.removeConnectionListener(listener);
        this.connectionListenerActive = false;
    }

    private Sail getNewMemorySail() {
        MemoryStore sail = new MemoryStore();
        sail.setDefaultIsolationLevel((IsolationLevel)IsolationLevels.NONE);
        sail.init();
        return sail;
    }

    public void commit() throws SailException {
        if (this.closed) {
            throw new SailException("Connection is closed");
        }
        if (!this.prepareHasBeenCalled) {
            this.prepare();
        }
        try {
            long before = this.getTimeStamp();
            if (this.previousStateConnection != null) {
                this.previousStateConnection.commit();
            }
            super.commit();
            this.shapesRepoConnection.commit();
            if (this.sail.isPerformanceLogging()) {
                logger.info("commit() excluding validation and cleanup took {} ms", (Object)(this.getTimeStamp() - before));
            }
        }
        finally {
            this.cleanup();
        }
    }

    public void addStatement(UpdateContext modify, Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        if (this.useDefaultShapesGraph && contexts.length == 1 && RDF4J.SHACL_SHAPE_GRAPH.equals((Object)contexts[0])) {
            this.shapesRepoConnection.add(subj, pred, obj, contexts);
            this.shapeRefreshNeeded = true;
        } else {
            super.addStatement(modify, subj, pred, obj, contexts);
        }
    }

    public void removeStatement(UpdateContext modify, Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        if (this.useDefaultShapesGraph && contexts.length == 1 && RDF4J.SHACL_SHAPE_GRAPH.equals((Object)contexts[0])) {
            this.shapesRepoConnection.remove(subj, pred, obj, contexts);
            this.shapeRefreshNeeded = true;
        } else {
            super.removeStatement(modify, subj, pred, obj, contexts);
        }
    }

    public void addStatement(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        if (this.useDefaultShapesGraph && contexts.length == 1 && RDF4J.SHACL_SHAPE_GRAPH.equals((Object)contexts[0])) {
            this.shapesRepoConnection.add(subj, pred, obj, contexts);
            this.shapeRefreshNeeded = true;
        } else {
            super.addStatement(subj, pred, obj, contexts);
        }
    }

    public void removeStatements(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        if (this.useDefaultShapesGraph && contexts.length == 1 && RDF4J.SHACL_SHAPE_GRAPH.equals((Object)contexts[0])) {
            this.shapesRepoConnection.remove(subj, pred, obj, contexts);
            this.shapeRefreshNeeded = true;
        } else {
            super.removeStatements(subj, pred, obj, contexts);
        }
    }

    public void clear(Resource ... contexts) throws SailException {
        if (Arrays.asList(contexts).contains(RDF4J.SHACL_SHAPE_GRAPH)) {
            this.shapesRepoConnection.clear(new Resource[0]);
            this.shapeRefreshNeeded = true;
        }
        super.clear(contexts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws SailException {
        if (this.closed) {
            throw new SailException("Connection is closed");
        }
        try {
            if (this.readableShapesCache != null) {
                this.readableShapesCache.close();
                this.readableShapesCache = null;
            }
            if (this.writableShapesCache != null) {
                this.writableShapesCache.purge();
                this.writableShapesCache.close();
                this.writableShapesCache = null;
            }
            if (this.previousStateConnection != null && this.previousStateConnection.isActive()) {
                this.previousStateConnection.rollback();
            }
        }
        finally {
            try {
                if (this.shapesRepoConnection.isActive()) {
                    this.shapesRepoConnection.rollback();
                }
            }
            finally {
                try {
                    if (this.isActive()) {
                        super.rollback();
                    }
                }
                finally {
                    this.cleanup();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        long before = 0L;
        try {
            if (this.sail.isPerformanceLogging()) {
                before = System.currentTimeMillis();
            }
            logger.debug("Cleanup");
            if (this.addedStatements != null) {
                if (this.addedStatements != this.sail.getBaseSail()) {
                    this.addedStatements.shutDown();
                }
                this.addedStatements = null;
            }
            if (this.removedStatements != null) {
                this.removedStatements.shutDown();
                this.removedStatements = null;
            }
            this.addedStatementsSet.clear();
            this.removedStatementsSet.clear();
            this.stats = null;
            this.prepareHasBeenCalled = false;
            this.shapeRefreshNeeded = false;
            this.shapesModifiedInCurrentTransaction = false;
            this.currentIsolationLevel = null;
            this.shapesGraphs = null;
        }
        finally {
            try {
                this.cleanupShapesReadWriteLock();
            }
            finally {
                this.cleanupReadWriteLock();
            }
            if (this.sail.isPerformanceLogging()) {
                logger.info("cleanup() took {} ms", (Object)(System.currentTimeMillis() - before));
            }
        }
    }

    private void cleanupShapesReadWriteLock() {
        block7: {
            try {
                if (this.writableShapesCache == null) break block7;
                try {
                    this.writableShapesCache.purge();
                }
                finally {
                    this.writableShapesCache.close();
                }
            }
            finally {
                if (this.readableShapesCache != null) {
                    this.readableShapesCache.close();
                }
            }
        }
        this.writableShapesCache = null;
        this.readableShapesCache = null;
    }

    private void cleanupReadWriteLock() {
        try {
            if (this.exclusiveSerializableValidationLock != null) {
                this.exclusiveSerializableValidationLock.release();
            }
        }
        finally {
            if (this.nonExclusiveSerializableValidationLock != null) {
                this.nonExclusiveSerializableValidationLock.release();
            }
        }
        this.exclusiveSerializableValidationLock = null;
        this.nonExclusiveSerializableValidationLock = null;
    }

    private ValidationReport validate(List<ContextWithShapes> shapes, boolean validateEntireBaseSail) throws InterruptedException {
        assert (this.isValidationEnabled());
        try {
            ConnectionsGroup connectionsGroup = this.getConnectionsGroup();
            try {
                ValidationReport validationReport = this.performValidation(shapes, validateEntireBaseSail, connectionsGroup);
                if (connectionsGroup != null) {
                    connectionsGroup.close();
                }
                return validationReport;
            }
            catch (Throwable throwable) {
                if (connectionsGroup != null) {
                    try {
                        connectionsGroup.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            this.rdfsSubClassOfReasoner = null;
        }
    }

    void prepareValidation(ValidationSettings validationSettings) throws InterruptedException {
        assert (this.isValidationEnabled());
        if (this.sail.isRdfsSubClassReasoning()) {
            this.rdfsSubClassOfReasoner = RdfsSubClassOfReasoner.createReasoner((SailConnection)this, validationSettings);
        }
        if (!this.isBulkValidation()) {
            this.fillAddedAndRemovedStatementRepositories();
        }
    }

    ConnectionsGroup getConnectionsGroup() {
        return new ConnectionsGroup((SailConnection)new VerySimpleRdfsBackwardsChainingConnection((SailConnection)this, this.rdfsSubClassOfReasoner), this.previousStateConnection, this.addedStatements, this.removedStatements, this.stats, this::getRdfsSubClassOfReasoner, this.transactionSettings, this.sail.sparqlValidation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValidationReport performValidation(List<ContextWithShapes> shapes, boolean validateEntireBaseSail, ConnectionsGroup connectionsGroup) throws InterruptedException {
        long beforeValidation = 0L;
        if (this.sail.isPerformanceLogging()) {
            beforeValidation = System.currentTimeMillis();
        }
        try {
            int numberOfShapes = shapes.stream().map(ContextWithShapes::getShapes).map(List::size).mapToInt(i -> i).sum();
            Stream<Callable> callableStream = shapes.stream().flatMap(contextWithShapes -> contextWithShapes.getShapes().stream().map(shape -> new ValidationContainer((Shape)shape, shape.generatePlans(connectionsGroup, new ValidationSettings(contextWithShapes.getDataGraph(), this.sail.isLogValidationPlans(), validateEntireBaseSail, this.sail.isPerformanceLogging()))))).filter(ValidationContainer::hasPlanNode).map(validationContainer -> validationContainer::performValidation);
            ArrayList<ValidationResultIterator> validationResultIterators = new ArrayList<ValidationResultIterator>(numberOfShapes);
            List<Future<Object>> futures = Collections.emptyList();
            boolean parallelValidation = numberOfShapes > 1 && this.isParallelValidation();
            try {
                futures = callableStream.map(callable -> {
                    if (Thread.currentThread().isInterrupted()) {
                        return null;
                    }
                    if (parallelValidation) {
                        return this.sail.submitToExecutorService(callable);
                    }
                    FutureTask futureTask = new FutureTask(callable);
                    futureTask.run();
                    return futureTask;
                }).collect(Collectors.toList());
                for (Future<Object> future : futures) {
                    assert (future != null);
                    try {
                        if (Thread.currentThread().isInterrupted()) continue;
                        validationResultIterators.add((ValidationResultIterator)future.get());
                    }
                    catch (ExecutionException e) {
                        Throwable cause = e.getCause();
                        if (cause instanceof InterruptedException) {
                            throw new InterruptedException();
                        }
                        if (cause instanceof RuntimeException) {
                            throw (RuntimeException)cause;
                        }
                        if (cause instanceof Error) {
                            throw (Error)cause;
                        }
                        assert (false);
                        throw new IllegalStateException(cause);
                    }
                }
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
            }
            finally {
                for (Future<Object> future : futures) {
                    future.cancel(true);
                }
            }
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            LazyValidationReport lazyValidationReport = new LazyValidationReport(validationResultIterators, this.sail.getValidationResultsLimitTotal());
            return lazyValidationReport;
        }
        finally {
            if (this.sail.isPerformanceLogging()) {
                logger.info("Actual validation and generating plans took {} ms", (Object)(System.currentTimeMillis() - beforeValidation));
            }
        }
    }

    private boolean isParallelValidation() {
        assert (!this.transactionSettings.isParallelValidation() || this.supportsConcurrentReads());
        assert (this.getIsolationLevel() != IsolationLevels.SERIALIZABLE || !this.transactionSettings.isParallelValidation()) : "Concurrent reads is buggy for SERIALIZABLE transactions.";
        return this.transactionSettings.isParallelValidation();
    }

    /*
     * Exception decompiling
     */
    void fillAddedAndRemovedStatementRepositories() throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private IsolationLevel getIsolationLevel() {
        return this.currentIsolationLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws SailException {
        if (this.closed) {
            return;
        }
        try {
            if (this.isActive()) {
                this.rollback();
            }
        }
        finally {
            try {
                this.shapesRepoConnection.close();
            }
            finally {
                try {
                    if (this.previousStateConnection != null) {
                        this.previousStateConnection.close();
                    }
                }
                finally {
                    try {
                        if (this.serializableConnection != null) {
                            this.serializableConnection.close();
                        }
                    }
                    finally {
                        try {
                            super.close();
                        }
                        finally {
                            try {
                                this.sail.closeConnection();
                            }
                            finally {
                                try {
                                    this.cleanupShapesReadWriteLock();
                                }
                                finally {
                                    try {
                                        this.cleanupReadWriteLock();
                                    }
                                    finally {
                                        this.closed = true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare() throws SailException {
        if (this.closed) {
            throw new SailException("Connection is closed");
        }
        this.prepareHasBeenCalled = true;
        long before = 0L;
        this.flush();
        try {
            boolean valid;
            boolean useSerializableValidation;
            if (this.sail.isPerformanceLogging()) {
                before = System.currentTimeMillis();
            }
            boolean bl = useSerializableValidation = this.shouldUseSerializableValidation() && !this.isBulkValidation();
            if (this.sail.isSerializableValidation()) {
                if (useSerializableValidation) {
                    this.exclusiveSerializableValidationLock = this.sail.serializableValidationLock.getWriteLock();
                } else {
                    this.nonExclusiveSerializableValidationLock = this.sail.serializableValidationLock.getReadLock();
                }
            } else assert (!useSerializableValidation) : "ShaclSail does not have serializable validation enabled but ShaclSailConnection still attempted to use serializable validation!";
            if (!this.isValidationEnabled()) {
                logger.debug("Validation skipped because validation was disabled");
                if (this.shapeRefreshNeeded || !this.connectionListenerActive) {
                    this.writableShapesCache = this.sail.getCachedShapesForWriting();
                }
                return;
            }
            assert (!this.shapeRefreshNeeded || !this.shapesModifiedInCurrentTransaction) : "isShapeRefreshNeeded should trigger shapesModifiedInCurrentTransaction once we have loaded the modified shapes, but shapesModifiedInCurrentTransaction should be null until then";
            if (!this.shapeRefreshNeeded && !this.isBulkValidation() && this.addedStatementsSet.isEmpty() && this.removedStatementsSet.isEmpty()) {
                logger.debug("Nothing has changed, nothing to validate.");
                return;
            }
            List currentShapes = null;
            List shapesAfterRefresh = null;
            if (this.shapeRefreshNeeded || !this.connectionListenerActive || this.isBulkValidation()) {
                if (this.writableShapesCache == null) {
                    this.writableShapesCache = this.sail.getCachedShapesForWriting();
                }
                this.shapesModifiedInCurrentTransaction = this.shapeRefreshNeeded;
                this.shapeRefreshNeeded = false;
                shapesAfterRefresh = this.sail.getShapes((RepositoryConnection)this.shapesRepoConnection, (SailConnection)this, this.shapesGraphs);
            } else if (this.readableShapesCache == null) {
                this.readableShapesCache = this.sail.getCachedShapes();
            }
            if (this.readableShapesCache != null) {
                currentShapes = (List)this.readableShapesCache.getData();
            }
            assert (currentShapes != null || shapesAfterRefresh != null);
            assert (currentShapes == null || shapesAfterRefresh == null);
            if (this.isEmpty(currentShapes) && this.isEmpty(shapesAfterRefresh)) {
                logger.debug("Validation skipped because there are no shapes to validate");
                return;
            }
            this.stats.setEmptyIncludingCurrentTransaction(ConnectionHelper.isEmpty((SailConnection)this));
            this.prepareValidation(new ValidationSettings(null, this.sail.isLogValidationPlans(), false, this.sail.isPerformanceLogging()));
            ValidationReport invalidTuples = null;
            if (useSerializableValidation) {
                Object object = this.sail.singleConnectionMonitor;
                synchronized (object) {
                    if (!this.sail.usesSingleConnection()) {
                        invalidTuples = this.serializableValidation(shapesAfterRefresh != null ? shapesAfterRefresh : currentShapes);
                    }
                }
            }
            if (invalidTuples == null) {
                invalidTuples = this.validate(shapesAfterRefresh != null ? shapesAfterRefresh : currentShapes, this.shapesModifiedInCurrentTransaction || this.isBulkValidation());
            }
            if (!(valid = invalidTuples.conforms())) {
                throw new ShaclSailValidationException(invalidTuples);
            }
        }
        catch (InterruptedException e) {
            throw ShaclSail.convertToSailException(e);
        }
        finally {
            if (this.sail.isPerformanceLogging()) {
                logger.info("prepare() including validation (excluding flushing and super.prepare()) took {} ms", (Object)(System.currentTimeMillis() - before));
            }
            if (!Thread.currentThread().isInterrupted()) {
                this.shapesRepoConnection.prepare();
                if (this.previousStateConnection != null) {
                    this.previousStateConnection.prepare();
                }
                super.prepare();
            }
        }
    }

    private boolean isEmpty(List<ContextWithShapes> shapesList) {
        if (shapesList == null) {
            return true;
        }
        for (ContextWithShapes shapesWithContext : shapesList) {
            if (shapesWithContext.getShapes().isEmpty()) continue;
            return false;
        }
        return true;
    }

    private boolean shouldUseSerializableValidation() {
        return this.serializableConnection != null && this.sail.isSerializableValidation() && this.currentIsolationLevel == IsolationLevels.SNAPSHOT;
    }

    private boolean isBulkValidation() {
        return this.transactionSettings.getValidationApproach() == ShaclSail.TransactionSettings.ValidationApproach.Bulk;
    }

    /*
     * Exception decompiling
     */
    private ValidationReport serializableValidation(List<ContextWithShapes> shapesAfterRefresh) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void statementAdded(Statement statement) {
        if (this.prepareHasBeenCalled) {
            throw new IllegalStateException("Detected changes after prepare() has been called.");
        }
        this.checkIfShapesRefreshIsNeeded(statement);
        boolean add = this.addedStatementsSet.add(statement);
        if (!add) {
            this.removedStatementsSet.remove(statement);
        }
        this.checkTransactionalValidationLimit();
    }

    public void statementRemoved(Statement statement) {
        if (this.prepareHasBeenCalled) {
            throw new IllegalStateException("Detected changes after prepare() has been called.");
        }
        this.checkIfShapesRefreshIsNeeded(statement);
        boolean add = this.removedStatementsSet.add(statement);
        if (!add) {
            this.addedStatementsSet.remove(statement);
        }
        this.checkTransactionalValidationLimit();
    }

    private void checkIfShapesRefreshIsNeeded(Statement statement) {
        if (!this.shapeRefreshNeeded) {
            for (IRI shapesGraph : this.shapesGraphs) {
                if (!Objects.equals(statement.getContext(), shapesGraph)) continue;
                this.shapeRefreshNeeded = true;
                break;
            }
        }
    }

    private void checkTransactionalValidationLimit() {
        if ((long)(this.addedStatementsSet.size() + this.removedStatementsSet.size()) > this.sail.getTransactionalValidationLimit()) {
            if (this.shouldUseSerializableValidation()) {
                logger.debug("Transaction size limit exceeded, could not switch to bulk validation because serializable validation is enabled.");
            } else {
                logger.debug("Transaction size limit exceeded, reverting to bulk validation.");
                this.removeConnectionListener(this);
                Settings bulkValidation = this.getLocalTransactionSettings();
                bulkValidation.setValidationApproach(ShaclSail.TransactionSettings.ValidationApproach.Bulk);
                this.getTransactionSettings().applyTransactionSettings(bulkValidation);
                this.removedStatementsSet.clear();
                this.addedStatementsSet.clear();
            }
        }
    }

    public RdfsSubClassOfReasoner getRdfsSubClassOfReasoner() {
        return this.rdfsSubClassOfReasoner;
    }

    public CloseableIteration<? extends Statement, SailException> getStatements(Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws SailException {
        if (this.useDefaultShapesGraph && contexts.length == 1 && RDF4J.SHACL_SHAPE_GRAPH.equals((Object)contexts[0])) {
            return ConnectionHelper.getCloseableIteration((RepositoryResult<Statement>)this.shapesRepoConnection.getStatements(subj, pred, obj, includeInferred, new Resource[0]));
        }
        return super.getStatements(subj, pred, obj, includeInferred, contexts);
    }

    public boolean hasStatement(Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws SailException {
        if (this.useDefaultShapesGraph && contexts.length == 1 && RDF4J.SHACL_SHAPE_GRAPH.equals((Object)contexts[0])) {
            return this.shapesRepoConnection.hasStatement(subj, pred, obj, includeInferred, new Resource[0]);
        }
        return super.hasStatement(subj, pred, obj, includeInferred, contexts);
    }

    public ValidationReport revalidate() {
        if (!this.isActive()) {
            throw new IllegalStateException("No active transaction!");
        }
        try {
            return this.validate(this.sail.getShapes((RepositoryConnection)this.shapesRepoConnection, (SailConnection)this, this.shapesGraphs), true);
        }
        catch (InterruptedException e) {
            throw ShaclSail.convertToSailException(e);
        }
    }

    Settings getTransactionSettings() {
        return this.transactionSettings;
    }

    private long getTimeStamp() {
        if (this.sail.isPerformanceLogging()) {
            return System.currentTimeMillis();
        }
        return 0L;
    }

    private static /* synthetic */ void lambda$serializableValidation$14(SailConnection rec$, Resource x$0, IRI x$1, Value x$2, Resource xva$3) {
        rec$.removeStatements(x$0, x$1, x$2, new Resource[]{xva$3});
    }

    private static /* synthetic */ void lambda$serializableValidation$13(SailConnection rec$, Resource x$0, IRI x$1, Value x$2, Resource xva$3) {
        rec$.addStatement(x$0, x$1, x$2, new Resource[]{xva$3});
    }

    private /* synthetic */ Future lambda$fillAddedAndRemovedStatementRepositories$12(boolean parallelValidation, Callable callable) {
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        if (parallelValidation) {
            return this.sail.submitToExecutorService(callable);
        }
        FutureTask objectFutureTask = new FutureTask(callable);
        objectFutureTask.run();
        return objectFutureTask;
    }

    private /* synthetic */ Callable lambda$fillAddedAndRemovedStatementRepositories$11(HashSet set) {
        return () -> {
            Sail repository;
            HashSet<Statement> otherSet;
            if (set == this.addedStatementsSet) {
                otherSet = this.removedStatementsSet;
                if (this.addedStatements != null && this.addedStatements != this.sail.getBaseSail()) {
                    this.addedStatements.shutDown();
                }
                repository = this.addedStatements = this.getNewMemorySail();
                set.forEach(this.stats::added);
            } else {
                otherSet = this.addedStatementsSet;
                if (this.removedStatements != null) {
                    this.removedStatements.shutDown();
                    this.removedStatements = null;
                }
                repository = this.removedStatements = this.getNewMemorySail();
                set.forEach(this.stats::removed);
            }
            try (SailConnection connection = repository.getConnection();){
                connection.begin((IsolationLevel)IsolationLevels.NONE);
                set.stream().filter(statement -> !otherSet.contains(statement)).flatMap(statement -> this.rdfsSubClassOfReasoner == null ? Stream.of(statement) : this.rdfsSubClassOfReasoner.forwardChain((Statement)statement)).forEach(statement -> {
                    if (!Thread.currentThread().isInterrupted()) {
                        connection.addStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[]{statement.getContext()});
                    }
                });
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                connection.commit();
            }
            return null;
        };
    }

    public static class Settings {
        private ShaclSail.TransactionSettings.ValidationApproach validationApproach;
        private Boolean cacheSelectedNodes;
        private Boolean parallelValidation;
        private IsolationLevel isolationLevel;
        private transient Settings previous = null;

        @Deprecated(since="4.0.0", forRemoval=true)
        public Settings() {
        }

        public Settings(boolean cacheSelectNodes, boolean validationEnabled, boolean parallelValidation, IsolationLevel isolationLevel) {
            this.cacheSelectedNodes = cacheSelectNodes;
            this.validationApproach = !validationEnabled ? ShaclSail.TransactionSettings.ValidationApproach.Disabled : ShaclSail.TransactionSettings.ValidationApproach.Auto;
            this.parallelValidation = parallelValidation;
            this.isolationLevel = isolationLevel;
        }

        public Settings(ShaclSailConnection connection) {
            TransactionSetting[] transactionSettingsRaw = connection.transactionSettingsRaw;
            assert (transactionSettingsRaw != null);
            ShaclSail.TransactionSettings.ValidationApproach validationApproach = null;
            Boolean cacheSelectedNodes = null;
            Boolean parallelValidation = null;
            block6: for (TransactionSetting transactionSetting : transactionSettingsRaw) {
                if (transactionSetting instanceof ShaclSail.TransactionSettings.ValidationApproach) {
                    validationApproach = (ShaclSail.TransactionSettings.ValidationApproach)transactionSetting;
                    continue;
                }
                if (!(transactionSetting instanceof ShaclSail.TransactionSettings.PerformanceHint)) continue;
                switch ((ShaclSail.TransactionSettings.PerformanceHint)transactionSetting) {
                    case ParallelValidation: {
                        parallelValidation = true;
                        continue block6;
                    }
                    case SerialValidation: {
                        parallelValidation = false;
                        continue block6;
                    }
                    case CacheDisabled: {
                        cacheSelectedNodes = false;
                        continue block6;
                    }
                    case CacheEnabled: {
                        cacheSelectedNodes = true;
                    }
                }
            }
            this.validationApproach = validationApproach;
            this.cacheSelectedNodes = cacheSelectedNodes;
            this.parallelValidation = !connection.supportsConcurrentReads() ? Boolean.valueOf(false) : parallelValidation;
        }

        private Settings(Settings settings) {
            this.validationApproach = settings.validationApproach;
            this.cacheSelectedNodes = settings.cacheSelectedNodes;
            this.parallelValidation = settings.parallelValidation;
            this.isolationLevel = settings.isolationLevel;
            this.previous = settings.previous;
        }

        public ShaclSail.TransactionSettings.ValidationApproach getValidationApproach() {
            return this.validationApproach;
        }

        public boolean isCacheSelectNodes() {
            return this.cacheSelectedNodes;
        }

        public boolean isParallelValidation() {
            return this.parallelValidation;
        }

        public IsolationLevel getIsolationLevel() {
            return this.isolationLevel;
        }

        static ShaclSail.TransactionSettings.ValidationApproach getMostSignificantValidationApproach(ShaclSail.TransactionSettings.ValidationApproach base, ShaclSail.TransactionSettings.ValidationApproach overriding) {
            if (base == null && overriding == null) {
                return ShaclSail.TransactionSettings.ValidationApproach.Auto;
            }
            return ShaclSail.TransactionSettings.ValidationApproach.getHighestPriority(base, overriding);
        }

        void applyTransactionSettings(Settings transactionSettingsLocal) {
            this.previous = new Settings(this);
            this.validationApproach = Settings.getMostSignificantValidationApproach(this.validationApproach, transactionSettingsLocal.validationApproach);
            if (this.validationApproach == ShaclSail.TransactionSettings.ValidationApproach.Bulk) {
                this.cacheSelectedNodes = false;
                this.parallelValidation = false;
            }
            if (transactionSettingsLocal.parallelValidation != null) {
                this.parallelValidation = transactionSettingsLocal.parallelValidation;
            }
            if (transactionSettingsLocal.cacheSelectedNodes != null) {
                this.cacheSelectedNodes = transactionSettingsLocal.cacheSelectedNodes;
            }
            assert (transactionSettingsLocal.isolationLevel == null);
        }

        public String toString() {
            return "Settings{validationApproach=" + this.validationApproach + ", cacheSelectedNodes=" + this.cacheSelectedNodes + ", parallelValidation=" + this.parallelValidation + ", isolationLevel=" + this.isolationLevel + "}";
        }

        public void switchToBulkValidation() {
            ShaclSail.TransactionSettings.ValidationApproach newValidationApproach = Settings.getMostSignificantValidationApproach(this.validationApproach, ShaclSail.TransactionSettings.ValidationApproach.Bulk);
            if (newValidationApproach != this.validationApproach) {
                this.validationApproach = newValidationApproach;
                this.parallelValidation = false;
                this.cacheSelectedNodes = false;
            }
        }

        private void setValidationApproach(ShaclSail.TransactionSettings.ValidationApproach validationApproach) {
            this.validationApproach = validationApproach;
        }

        private void setCacheSelectedNodes(Boolean cacheSelectedNodes) {
            this.cacheSelectedNodes = cacheSelectedNodes;
        }

        private void setParallelValidation(Boolean parallelValidation) {
            this.parallelValidation = parallelValidation;
        }

        private void setIsolationLevel(IsolationLevel isolationLevel) {
            this.isolationLevel = isolationLevel;
        }
    }

    public class ValidationContainer {
        private final Shape shape;
        private final PlanNode planNode;
        private final ValidationExecutionLogger validationExecutionLogger;

        public ValidationContainer(Shape shape, PlanNode planNode) {
            this.shape = shape;
            this.validationExecutionLogger = ValidationExecutionLogger.getInstance(ShaclSailConnection.this.sail.isGlobalLogValidationExecution());
            if (!planNode.isGuaranteedEmpty()) {
                assert (planNode instanceof SingleCloseablePlanNode);
                planNode.receiveLogger(this.validationExecutionLogger);
                this.planNode = planNode;
            } else {
                this.planNode = planNode;
            }
        }

        public Shape getShape() {
            return this.shape;
        }

        public boolean hasPlanNode() {
            return !this.planNode.isGuaranteedEmpty();
        }

        public ValidationResultIterator performValidation() {
            ValidationResultIterator validationResultIterator;
            ValidationResultIterator validationResults;
            long before;
            block8: {
                before = ShaclSailConnection.this.getTimeStamp();
                this.handlePreLogging();
                validationResults = null;
                CloseableIteration<? extends ValidationTuple, SailException> iterator = this.planNode.iterator();
                try {
                    validationResultIterator = validationResults = new ValidationResultIterator(iterator, ShaclSailConnection.this.sail.getEffectiveValidationResultsLimitPerConstraint(), this.shape.getSeverity());
                    if (iterator == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (iterator != null) {
                            try {
                                iterator.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable throwable3) {
                        this.handlePostLogging(before, validationResults);
                        throw throwable3;
                    }
                }
                iterator.close();
            }
            this.handlePostLogging(before, validationResults);
            return validationResultIterator;
        }

        private void handlePreLogging() {
            if (this.validationExecutionLogger.isEnabled()) {
                logger.info("Start execution of plan:\n{}\n", (Object)this.getShape().toString());
            }
        }

        private void handlePostLogging(long before, ValidationResultIterator validationResults) {
            if (this.validationExecutionLogger.isEnabled()) {
                this.validationExecutionLogger.flush();
            }
            if (validationResults != null) {
                if (ShaclSailConnection.this.sail.isPerformanceLogging()) {
                    long after = System.currentTimeMillis();
                    logger.info("Execution of plan took {} ms for:\n{}\n", (Object)(after - before), (Object)this.getShape().toString());
                }
                if (this.validationExecutionLogger.isEnabled()) {
                    logger.info("Finished execution of plan:\n{}\n", (Object)this.getShape().toString());
                }
                if (ShaclSailConnection.this.sail.isLogValidationViolations() && !validationResults.conforms()) {
                    List<ValidationTuple> tuples = validationResults.getTuples();
                    logger.info("SHACL not valid. The following experimental debug results were produced:\n\t\t{}\n\n{}\n", (Object)tuples.stream().map(ValidationTuple::toString).collect(Collectors.joining("\n\t\t")), (Object)this.getShape().toString());
                }
            }
        }
    }
}

