/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.sail.shacl.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.RdfsSubClassOfReasoner;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.ValidationApproach;
import org.eclipse.rdf4j.sail.shacl.ast.ValidationQuery;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.AbstractConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.paths.Path;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.BulkedExternalInnerJoin;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.EmptyNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ExternalPredicateObjectFilter;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeProvider;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ShiftToPropertyShape;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.TrimToTarget;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnionNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Unique;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnorderedSelect;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.eclipse.rdf4j.sail.shacl.ast.targets.EffectiveTarget;

public class ClassConstraintComponent
extends AbstractConstraintComponent {
    IRI clazz;

    public ClassConstraintComponent(IRI clazz) {
        this.clazz = clazz;
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection) {
        model.add(subject, SHACL.CLASS, (Value)this.clazz, new Resource[0]);
    }

    @Override
    public SourceConstraintComponent getConstraintComponent() {
        return SourceConstraintComponent.ClassConstraintComponent;
    }

    @Override
    public ConstraintComponent deepClone() {
        return new ClassConstraintComponent(this.clazz);
    }

    @Override
    public PlanNode generateTransactionalValidationPlan(ConnectionsGroup connectionsGroup, boolean logValidationPlans, PlanNodeProvider overrideTargetNode, ConstraintComponent.Scope scope) {
        StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider = new StatementMatcher.StableRandomVariableProvider();
        EffectiveTarget target = this.getTargetChain().getEffectiveTarget("_target", scope, connectionsGroup.getRdfsSubClassOfReasoner());
        if (scope == ConstraintComponent.Scope.propertyShape) {
            PlanNode addedTargets;
            Path path = this.getTargetChain().getPath().get();
            if (overrideTargetNode != null) {
                addedTargets = overrideTargetNode.getPlanNode();
                addedTargets = target.extend(addedTargets, connectionsGroup, scope, EffectiveTarget.Extend.right, false, null);
            } else {
                addedTargets = target.getPlanNode(connectionsGroup, scope, false, null);
                PlanNode addedByPath = path.getAdded(connectionsGroup, null);
                addedByPath = target.getTargetFilter(connectionsGroup, Unique.getInstance(new TrimToTarget(addedByPath), false));
                addedByPath = target.extend(addedByPath, connectionsGroup, scope, EffectiveTarget.Extend.left, false, null);
                if (connectionsGroup.getStats().hasRemoved()) {
                    PlanNode deletedTypes = new UnorderedSelect(connectionsGroup.getRemovedStatements(), null, RDF.TYPE, (Value)this.clazz, UnorderedSelect.Mapper.SubjectScopedMapper.getFunction(ConstraintComponent.Scope.nodeShape));
                    deletedTypes = this.getTargetChain().getEffectiveTarget("target_", ConstraintComponent.Scope.nodeShape, connectionsGroup.getRdfsSubClassOfReasoner()).extend(deletedTypes, connectionsGroup, ConstraintComponent.Scope.nodeShape, EffectiveTarget.Extend.left, false, null);
                    deletedTypes = this.getTargetChain().getEffectiveTarget("target_", ConstraintComponent.Scope.nodeShape, connectionsGroup.getRdfsSubClassOfReasoner()).getTargetFilter(connectionsGroup, deletedTypes);
                    addedTargets = UnionNode.getInstance(addedTargets, new TrimToTarget(new ShiftToPropertyShape(deletedTypes)));
                }
                addedTargets = UnionNode.getInstance(addedByPath, addedTargets);
                addedTargets = Unique.getInstance(addedTargets, false);
            }
            BulkedExternalInnerJoin joined = new BulkedExternalInnerJoin(addedTargets, connectionsGroup.getBaseConnection(), path.getTargetQueryFragment(new StatementMatcher.Variable("a"), new StatementMatcher.Variable("c"), connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider), false, null, b -> new ValidationTuple(b.getValue("a"), b.getValue("c"), scope, true));
            ExternalPredicateObjectFilter falseNode = new ExternalPredicateObjectFilter(connectionsGroup.getBaseConnection(), RDF.TYPE, Collections.singleton(this.clazz), joined, false, ExternalPredicateObjectFilter.FilterOn.value);
            return falseNode;
        }
        if (scope == ConstraintComponent.Scope.nodeShape) {
            PlanNode addedTargets;
            if (overrideTargetNode != null) {
                addedTargets = overrideTargetNode.getPlanNode();
                addedTargets = target.extend(addedTargets, connectionsGroup, scope, EffectiveTarget.Extend.right, false, null);
            } else {
                addedTargets = target.getPlanNode(connectionsGroup, scope, false, null);
                if (connectionsGroup.getStats().hasRemoved()) {
                    PlanNode deletedTypes = new UnorderedSelect(connectionsGroup.getRemovedStatements(), null, RDF.TYPE, (Value)this.clazz, UnorderedSelect.Mapper.SubjectScopedMapper.getFunction(scope));
                    deletedTypes = this.getTargetChain().getEffectiveTarget("target_", scope, connectionsGroup.getRdfsSubClassOfReasoner()).getTargetFilter(connectionsGroup, deletedTypes);
                    deletedTypes = this.getTargetChain().getEffectiveTarget("target_", scope, connectionsGroup.getRdfsSubClassOfReasoner()).extend(deletedTypes, connectionsGroup, scope, EffectiveTarget.Extend.left, false, null);
                    addedTargets = UnionNode.getInstance(addedTargets, new TrimToTarget(deletedTypes));
                }
            }
            ExternalPredicateObjectFilter falseNode = new ExternalPredicateObjectFilter(connectionsGroup.getBaseConnection(), RDF.TYPE, Collections.singleton(this.clazz), addedTargets, false, ExternalPredicateObjectFilter.FilterOn.value);
            return falseNode;
        }
        throw new UnsupportedOperationException("Unknown scope: " + (Object)((Object)scope));
    }

    @Override
    public PlanNode getAllTargetsPlan(ConnectionsGroup connectionsGroup, ConstraintComponent.Scope scope) {
        if (scope == ConstraintComponent.Scope.propertyShape) {
            PlanNode allTargetsPlan = this.getTargetChain().getEffectiveTarget("target_", ConstraintComponent.Scope.nodeShape, connectionsGroup.getRdfsSubClassOfReasoner()).getPlanNode(connectionsGroup, ConstraintComponent.Scope.nodeShape, true, null);
            if (connectionsGroup.getStats().hasRemoved()) {
                PlanNode deletedTypes = new UnorderedSelect(connectionsGroup.getRemovedStatements(), null, RDF.TYPE, (Value)this.clazz, UnorderedSelect.Mapper.SubjectScopedMapper.getFunction(ConstraintComponent.Scope.nodeShape));
                deletedTypes = this.getTargetChain().getEffectiveTarget("target_", ConstraintComponent.Scope.nodeShape, connectionsGroup.getRdfsSubClassOfReasoner()).getTargetFilter(connectionsGroup, deletedTypes);
                deletedTypes = this.getTargetChain().getEffectiveTarget("target_", ConstraintComponent.Scope.nodeShape, connectionsGroup.getRdfsSubClassOfReasoner()).extend(deletedTypes, connectionsGroup, ConstraintComponent.Scope.nodeShape, EffectiveTarget.Extend.left, false, null);
                allTargetsPlan = UnionNode.getInstanceDedupe(allTargetsPlan, deletedTypes);
            }
            if (connectionsGroup.getStats().hasAdded()) {
                PlanNode addedTypes = new UnorderedSelect(connectionsGroup.getAddedStatements(), null, RDF.TYPE, (Value)this.clazz, UnorderedSelect.Mapper.SubjectScopedMapper.getFunction(ConstraintComponent.Scope.nodeShape));
                addedTypes = this.getTargetChain().getEffectiveTarget("target_", ConstraintComponent.Scope.nodeShape, connectionsGroup.getRdfsSubClassOfReasoner()).getTargetFilter(connectionsGroup, addedTypes);
                addedTypes = this.getTargetChain().getEffectiveTarget("target_", ConstraintComponent.Scope.nodeShape, connectionsGroup.getRdfsSubClassOfReasoner()).extend(addedTypes, connectionsGroup, ConstraintComponent.Scope.nodeShape, EffectiveTarget.Extend.left, false, null);
                allTargetsPlan = UnionNode.getInstanceDedupe(allTargetsPlan, addedTypes);
            }
            return Unique.getInstance(new TrimToTarget(new ShiftToPropertyShape(allTargetsPlan)), false);
        }
        PlanNode allTargetsPlan = EmptyNode.getInstance();
        if (connectionsGroup.getStats().hasRemoved()) {
            PlanNode deletedTypes = new UnorderedSelect(connectionsGroup.getRemovedStatements(), null, RDF.TYPE, (Value)this.clazz, UnorderedSelect.Mapper.SubjectScopedMapper.getFunction(ConstraintComponent.Scope.nodeShape));
            deletedTypes = this.getTargetChain().getEffectiveTarget("target_", ConstraintComponent.Scope.nodeShape, connectionsGroup.getRdfsSubClassOfReasoner()).getTargetFilter(connectionsGroup, deletedTypes);
            deletedTypes = this.getTargetChain().getEffectiveTarget("target_", ConstraintComponent.Scope.nodeShape, connectionsGroup.getRdfsSubClassOfReasoner()).extend(deletedTypes, connectionsGroup, ConstraintComponent.Scope.nodeShape, EffectiveTarget.Extend.left, false, null);
            allTargetsPlan = UnionNode.getInstanceDedupe(allTargetsPlan, deletedTypes);
        }
        if (connectionsGroup.getStats().hasAdded()) {
            PlanNode addedTypes = new UnorderedSelect(connectionsGroup.getAddedStatements(), null, RDF.TYPE, (Value)this.clazz, UnorderedSelect.Mapper.SubjectScopedMapper.getFunction(ConstraintComponent.Scope.nodeShape));
            addedTypes = this.getTargetChain().getEffectiveTarget("target_", ConstraintComponent.Scope.nodeShape, connectionsGroup.getRdfsSubClassOfReasoner()).getTargetFilter(connectionsGroup, addedTypes);
            addedTypes = this.getTargetChain().getEffectiveTarget("target_", ConstraintComponent.Scope.nodeShape, connectionsGroup.getRdfsSubClassOfReasoner()).extend(addedTypes, connectionsGroup, ConstraintComponent.Scope.nodeShape, EffectiveTarget.Extend.left, false, null);
            allTargetsPlan = UnionNode.getInstanceDedupe(allTargetsPlan, addedTypes);
        }
        return Unique.getInstance(allTargetsPlan, false);
    }

    @Override
    public boolean requiresEvaluation(ConnectionsGroup connectionsGroup, ConstraintComponent.Scope scope) {
        return super.requiresEvaluation(connectionsGroup, scope) || connectionsGroup.getRemovedStatements().hasStatement(null, RDF.TYPE, (Value)this.clazz, true, new Resource[0]) || connectionsGroup.getAddedStatements().hasStatement(null, RDF.TYPE, (Value)this.clazz, true, new Resource[0]);
    }

    @Override
    public ValidationQuery generateSparqlValidationQuery(ConnectionsGroup connectionsGroup, boolean logValidationPlans, boolean negatePlan, boolean negateChildren, ConstraintComponent.Scope scope) {
        StatementMatcher.Variable value;
        String targetVarPrefix = "target_";
        StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider = new StatementMatcher.StableRandomVariableProvider();
        EffectiveTarget effectiveTarget = this.getTargetChain().getEffectiveTarget(targetVarPrefix, scope, connectionsGroup.getRdfsSubClassOfReasoner());
        String query = effectiveTarget.getQuery(false);
        if (scope == ConstraintComponent.Scope.nodeShape) {
            value = null;
            StatementMatcher.Variable target = effectiveTarget.getTargetVar();
            query = query + this.getFilter(connectionsGroup, target);
        } else {
            value = new StatementMatcher.Variable("value");
            String pathQuery = this.getTargetChain().getPath().map(p -> p.getTargetQueryFragment(effectiveTarget.getTargetVar(), value, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider)).orElseThrow(IllegalStateException::new);
            query = query + pathQuery;
            query = query + this.getFilter(connectionsGroup, value);
        }
        List<StatementMatcher.Variable> allTargetVariables = effectiveTarget.getAllTargetVariables();
        return new ValidationQuery(query, allTargetVariables, value, scope, this.getConstraintComponent(), null, null);
    }

    private String getFilter(ConnectionsGroup connectionsGroup, StatementMatcher.Variable target) {
        RdfsSubClassOfReasoner rdfsSubClassOfReasoner = connectionsGroup.getRdfsSubClassOfReasoner();
        Set<Object> allClasses = rdfsSubClassOfReasoner != null ? rdfsSubClassOfReasoner.backwardsChain((Resource)this.clazz) : Collections.singleton(this.clazz);
        String condition = allClasses.stream().map(c -> "EXISTS{?" + target.getName() + " a <" + c.stringValue() + ">}").reduce((a, b) -> a + " || " + b).orElseThrow(IllegalStateException::new);
        return "\n FILTER(!(" + condition + "))";
    }

    @Override
    public ValidationApproach getOptimalBulkValidationApproach() {
        return ValidationApproach.SPARQL;
    }
}

