/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeHelper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;

public class TargetChainPopper
implements PlanNode {
    private final PlanNode parent;
    private StackTraceElement[] stackTrace;
    private boolean printed = false;
    private ValidationExecutionLogger validationExecutionLogger;

    public TargetChainPopper(PlanNode parent) {
        this.parent = parent = PlanNodeHelper.handleSorting(this, parent);
    }

    @Override
    public CloseableIteration<? extends ValidationTuple, SailException> iterator() {
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            private final CloseableIteration<? extends ValidationTuple, SailException> iterator;
            {
                this.iterator = TargetChainPopper.this.parent.iterator();
            }

            public void close() throws SailException {
                this.iterator.close();
            }

            @Override
            boolean localHasNext() throws SailException {
                return this.iterator.hasNext();
            }

            @Override
            ValidationTuple loggingNext() throws SailException {
                ValidationTuple next = (ValidationTuple)this.iterator.next();
                next = new ValidationTuple(next);
                next.pop();
                return next;
            }

            public void remove() throws SailException {
                this.iterator.remove();
            }
        };
    }

    @Override
    public int depth() {
        return this.parent.depth() + 1;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        stringBuilder.append(this.parent.getId() + " -> " + this.getId()).append("\n");
        this.parent.getPlanAsGraphvizDot(stringBuilder);
    }

    public String toString() {
        return "TargetChainPopper";
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "";
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
        this.parent.receiveLogger(validationExecutionLogger);
    }

    @Override
    public boolean producesSorted() {
        return false;
    }

    @Override
    public boolean requiresSorted() {
        return false;
    }
}

