/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.AST;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.algebra.evaluation.util.ValueComparator;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShaclProperties {
    private static final Logger logger = LoggerFactory.getLogger(ShaclProperties.class);
    private final List<Resource> clazz = new ArrayList<Resource>();
    private final List<Resource> or = new ArrayList<Resource>();
    private final List<Resource> and = new ArrayList<Resource>();
    private final List<Resource> not = new ArrayList<Resource>();
    private Long minCount;
    private Long maxCount;
    private Resource datatype;
    private Resource in;
    private Value hasValue;
    private Resource hasValueIn;
    private Long minLength;
    private Long maxLength;
    private Resource languageIn;
    private Resource nodeKind;
    private Resource path;
    private Literal minExclusive;
    private Literal maxExclusive;
    private Literal minInclusive;
    private Literal maxInclusive;
    private final List<String> pattern = new ArrayList<String>();
    private String flags = "";
    private final Set<Resource> targetClass = new HashSet<Resource>();
    private final TreeSet<Value> targetNode = new TreeSet(new ValueComparator());
    private final Set<IRI> targetSubjectsOf = new HashSet<IRI>();
    private final Set<IRI> targetObjectsOf = new HashSet<IRI>();
    private final List<Resource> targetShape = new ArrayList<Resource>();
    private final List<Resource> target = new ArrayList<Resource>();
    private boolean deactivated = false;
    private boolean uniqueLang = false;

    public ShaclProperties() {
    }

    public ShaclProperties(Resource propertyShapeId, SailRepositoryConnection connection) {
        try (Stream stream = connection.getStatements(propertyShapeId, null, null, new Resource[0]).stream();){
            stream.forEach(statement -> {
                String predicate = statement.getPredicate().toString();
                Value object = statement.getObject();
                switch (predicate) {
                    case "http://www.w3.org/ns/shacl#or": {
                        this.or.add((Resource)object);
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#and": {
                        this.and.add((Resource)object);
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#not": {
                        this.not.add((Resource)object);
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#languageIn": {
                        if (this.languageIn != null) {
                            throw new IllegalStateException(predicate + " already populated");
                        }
                        this.languageIn = (Resource)object;
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#nodeKind": {
                        if (this.nodeKind != null) {
                            throw new IllegalStateException(predicate + " already populated");
                        }
                        this.nodeKind = (Resource)object;
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#datatype": {
                        if (this.datatype != null) {
                            throw new IllegalStateException(predicate + " already populated");
                        }
                        this.datatype = (Resource)object;
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#minCount": {
                        if (this.minCount != null) {
                            throw new IllegalStateException(predicate + " already populated");
                        }
                        this.minCount = ((Literal)object).longValue();
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#maxCount": {
                        if (this.maxCount != null) {
                            throw new IllegalStateException(predicate + " already populated");
                        }
                        this.maxCount = ((Literal)object).longValue();
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#minLength": {
                        if (this.minLength != null) {
                            throw new IllegalStateException(predicate + " already populated");
                        }
                        this.minLength = ((Literal)object).longValue();
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#maxLength": {
                        if (this.maxLength != null) {
                            throw new IllegalStateException(predicate + " already populated");
                        }
                        this.maxLength = ((Literal)object).longValue();
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#minExclusive": {
                        if (this.minExclusive != null) {
                            throw new IllegalStateException(predicate + " already populated");
                        }
                        this.minExclusive = (Literal)object;
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#maxExclusive": {
                        if (this.maxExclusive != null) {
                            throw new IllegalStateException(predicate + " already populated");
                        }
                        this.maxExclusive = (Literal)object;
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#minInclusive": {
                        if (this.minInclusive != null) {
                            throw new IllegalStateException(predicate + " already populated");
                        }
                        this.minInclusive = (Literal)object;
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#maxInclusive": {
                        if (this.maxInclusive != null) {
                            throw new IllegalStateException(predicate + " already populated");
                        }
                        this.maxInclusive = (Literal)object;
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#pattern": {
                        this.pattern.add(object.stringValue());
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#class": {
                        this.clazz.add((Resource)object);
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#targetNode": {
                        this.targetNode.add(object);
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#targetClass": {
                        this.targetClass.add((Resource)object);
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#targetSubjectsOf": {
                        this.targetSubjectsOf.add((IRI)object);
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#targetObjectsOf": {
                        this.targetObjectsOf.add((IRI)object);
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#deactivated": {
                        this.deactivated = ((Literal)object).booleanValue();
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#uniqueLang": {
                        this.uniqueLang = ((Literal)object).booleanValue();
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#flags": {
                        this.flags = this.flags + object.stringValue();
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#path": {
                        if (this.path != null) {
                            throw new IllegalStateException(predicate + " already populated");
                        }
                        this.path = (Resource)object;
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#in": {
                        if (this.in != null) {
                            throw new IllegalStateException(predicate + " already populated");
                        }
                        this.in = (Resource)object;
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#property": {
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#target": {
                        this.target.add((Resource)object);
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#hasValue": {
                        if (this.hasValue != null) {
                            throw new IllegalStateException(predicate + " already populated");
                        }
                        this.hasValue = object;
                        break;
                    }
                    case "http://datashapes.org/dash#hasValueIn": {
                        if (this.hasValueIn != null) {
                            throw new IllegalStateException(predicate + " already populated");
                        }
                        this.hasValueIn = (Resource)object;
                        break;
                    }
                    case "http://www.w3.org/ns/shacl#targetShape": {
                        this.targetShape.add((Resource)object);
                        break;
                    }
                    default: {
                        if (!predicate.startsWith("http://www.w3.org/ns/shacl#")) break;
                        logger.warn("Unsupported SHACL feature detected {} in statement {}", (Object)predicate.replace("http://www.w3.org/ns/shacl#", "sh:"), statement);
                    }
                }
            });
        }
    }

    public List<Resource> getClazz() {
        return this.clazz;
    }

    public List<Resource> getOr() {
        return this.or;
    }

    public List<Resource> getAnd() {
        return this.and;
    }

    public List<Resource> getNot() {
        return this.not;
    }

    public Long getMinCount() {
        return this.minCount;
    }

    public Long getMaxCount() {
        return this.maxCount;
    }

    public Resource getDatatype() {
        return this.datatype;
    }

    public Resource getIn() {
        return this.in;
    }

    public Long getMinLength() {
        return this.minLength;
    }

    public Long getMaxLength() {
        return this.maxLength;
    }

    public Resource getLanguageIn() {
        return this.languageIn;
    }

    public Resource getNodeKind() {
        return this.nodeKind;
    }

    public Resource getPath() {
        return this.path;
    }

    public Literal getMinExclusive() {
        return this.minExclusive;
    }

    public Literal getMaxExclusive() {
        return this.maxExclusive;
    }

    public Literal getMinInclusive() {
        return this.minInclusive;
    }

    public Literal getMaxInclusive() {
        return this.maxInclusive;
    }

    public List<String> getPattern() {
        return this.pattern;
    }

    public String getFlags() {
        return this.flags;
    }

    public Set<Resource> getTargetClass() {
        return this.targetClass;
    }

    public TreeSet<Value> getTargetNode() {
        return this.targetNode;
    }

    public Set<IRI> getTargetSubjectsOf() {
        return this.targetSubjectsOf;
    }

    public Set<IRI> getTargetObjectsOf() {
        return this.targetObjectsOf;
    }

    public boolean isDeactivated() {
        return this.deactivated;
    }

    public boolean isUniqueLang() {
        return this.uniqueLang;
    }

    public Value getHasValue() {
        return this.hasValue;
    }

    public List<Resource> getTarget() {
        return this.target;
    }

    public List<Resource> getTargetShape() {
        return this.targetShape;
    }

    public Resource getHasValueIn() {
        return this.hasValueIn;
    }
}

