/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl;

import java.util.ArrayDeque;
import java.util.List;
import org.eclipse.rdf4j.exceptions.ValidationException;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.AST.PropertyShape;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;
import org.eclipse.rdf4j.sail.shacl.results.ValidationReport;
import org.eclipse.rdf4j.sail.shacl.results.ValidationResult;

public class ShaclSailValidationException
extends SailException
implements ValidationException {
    private List<Tuple> invalidTuples;

    ShaclSailValidationException(List<Tuple> invalidTuples) {
        super("Failed SHACL validation");
        this.invalidTuples = invalidTuples;
    }

    public Model validationReportAsModel() {
        ValidationReport validationReport = this.getValidationReport();
        Model model = validationReport.asModel();
        model.setNamespace("sh", "http://www.w3.org/ns/shacl#");
        return model;
    }

    @Deprecated
    public ValidationReport getValidationReport() {
        ValidationReport validationReport = new ValidationReport(this.invalidTuples.isEmpty());
        for (Tuple invalidTuple : this.invalidTuples) {
            ValidationResult parent = null;
            ArrayDeque<PropertyShape> propertyShapes = new ArrayDeque<PropertyShape>(invalidTuple.getCausedByPropertyShapes());
            while (!propertyShapes.isEmpty()) {
                ValidationResult validationResult = new ValidationResult(propertyShapes.pop(), invalidTuple.getLine().get(0));
                if (parent == null) {
                    validationReport.addValidationResult(validationResult);
                } else {
                    parent.setDetail(validationResult);
                }
                parent = validationResult;
            }
        }
        return validationReport;
    }
}

