/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.AST;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.shacl.AST.NodeShape;
import org.eclipse.rdf4j.sail.shacl.AST.Path;
import org.eclipse.rdf4j.sail.shacl.AST.PlaneNodeWrapper;
import org.eclipse.rdf4j.sail.shacl.AST.PropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.SimplePath;
import org.eclipse.rdf4j.sail.shacl.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.ShaclSailConnection;
import org.eclipse.rdf4j.sail.shacl.Stats;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNodeProvider;
import org.eclipse.rdf4j.sail.shacl.planNodes.Select;
import org.eclipse.rdf4j.sail.shacl.planNodes.Sort;
import org.eclipse.rdf4j.sail.shacl.planNodes.Unique;
import org.eclipse.rdf4j.sail.shacl.planNodes.UnorderedSelect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PathPropertyShape
extends PropertyShape {
    private Path path;
    private static final Logger logger = LoggerFactory.getLogger(ShaclSailConnection.class);
    private static final Set<IRI> complexPathPredicates = new HashSet<IRI>(Arrays.asList(RDF.FIRST, RDF.REST, SHACL.ALTERNATIVE_PATH, SHACL.INVERSE_PATH, SHACL.ZERO_OR_MORE_PATH, SHACL.ONE_OR_MORE_PATH, SHACL.ZERO_OR_ONE_PATH));

    PathPropertyShape(Resource id, SailRepositoryConnection connection, NodeShape nodeShape, boolean deactivated, PathPropertyShape parent, Resource path) {
        super(id, nodeShape, deactivated ? deactivated : !PathPropertyShape.validPath(path, connection), parent);
        if (path != null) {
            if (PathPropertyShape.validPath(path, connection)) {
                this.path = new SimplePath((IRI)path);
            } else {
                logger.warn("Unsupported SHACL feature with complex path. Only single predicate paths are supported. <{}> shape has been deactivated! \n{}", (Object)id, (Object)this.describe(connection, path));
            }
        }
    }

    private static boolean validPath(Resource path, SailRepositoryConnection connection) {
        if (path != null) {
            if (!(path instanceof IRI)) {
                return false;
            }
            try (Stream stream = connection.getStatements(path, null, null, new Resource[0]).stream();){
                boolean complexPath = stream.map(Statement::getPredicate).anyMatch(complexPathPredicates::contains);
                if (complexPath) {
                    boolean bl = false;
                    return bl;
                }
            }
        }
        return true;
    }

    PathPropertyShape(Resource id, NodeShape nodeShape, boolean deactivated, PathPropertyShape parent, Path path) {
        super(id, nodeShape, deactivated, parent);
        this.path = path;
    }

    @Override
    public PlanNode getPlan(ConnectionsGroup connectionsGroup, boolean printPlans, PlanNodeProvider overrideTargetNode, boolean negateThisPlan, boolean negateSubPlans) {
        return connectionsGroup.getCachedNodeFor(new Sort(new UnorderedSelect(connectionsGroup.getBaseConnection(), null, (IRI)this.getPath().getId(), null, UnorderedSelect.OutputPattern.SubjectObject)));
    }

    @Override
    public PlanNode getPlanAddedStatements(ConnectionsGroup connectionsGroup, PlaneNodeWrapper planeNodeWrapper) {
        PlanNode unorderedSelect = new UnorderedSelect(connectionsGroup.getAddedStatements(), null, (IRI)this.getPath().getId(), null, UnorderedSelect.OutputPattern.SubjectObject);
        if (planeNodeWrapper != null) {
            unorderedSelect = planeNodeWrapper.wrap(unorderedSelect);
        }
        return connectionsGroup.getCachedNodeFor(new Sort(unorderedSelect));
    }

    @Override
    public PlanNode getPlanRemovedStatements(ConnectionsGroup connectionsGroup, PlaneNodeWrapper planeNodeWrapper) {
        PlanNode unorderedSelect = new UnorderedSelect(connectionsGroup.getRemovedStatements(), null, (IRI)this.getPath().getId(), null, UnorderedSelect.OutputPattern.SubjectObject);
        if (planeNodeWrapper != null) {
            unorderedSelect = planeNodeWrapper.wrap(unorderedSelect);
        }
        return connectionsGroup.getCachedNodeFor(new Sort(unorderedSelect));
    }

    @Override
    public List<Path> getPaths() {
        return Collections.singletonList(this.getPath());
    }

    public boolean hasOwnPath() {
        return this.path != null;
    }

    @Override
    public boolean requiresEvaluation(SailConnection addedStatements, SailConnection removedStatements, Stats stats) {
        if (this.deactivated) {
            return false;
        }
        if (this.path == null) {
            return super.requiresEvaluation(addedStatements, removedStatements, stats);
        }
        return super.requiresEvaluation(addedStatements, removedStatements, stats) || this.path.requiresEvaluation(addedStatements, removedStatements, stats);
    }

    public Path getPath() {
        if (this.path == null && this.parent != null) {
            return this.parent.getPath();
        }
        return this.path;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PathPropertyShape that = (PathPropertyShape)o;
        return Objects.equals(this.path, that.path);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.path);
    }

    @Override
    public PlanNode getAllTargetsPlan(ConnectionsGroup connectionsGroup, boolean negated) {
        Select select = new Select(connectionsGroup.getBaseConnection(), "?a ?b ?c", "?a");
        Unique unique = new Unique(select);
        return this.nodeShape.getTargetFilter(connectionsGroup.getBaseConnection(), unique);
    }
}

