/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.algebra.evaluation.util.ValueComparator;
import org.eclipse.rdf4j.sail.shacl.AST.PropertyShape;

public class Tuple
implements Comparable<Tuple> {
    private Deque<PropertyShape> causedByPropertyShapes = new ArrayDeque<PropertyShape>(1);
    private List<Tuple> history = new ArrayList<Tuple>(1);
    public List<Value> line = new ArrayList<Value>(3);
    private static final ValueComparator valueComparator = new ValueComparator();

    public Tuple(List<Value> list) {
        this.line = list;
    }

    public Tuple(Value ... list) {
        this.line = new ArrayList<Value>(Arrays.asList(list));
    }

    public Tuple(List<Value> list, Tuple historyTuple) {
        this.line = list;
        this.addHistory(historyTuple);
    }

    public Tuple() {
    }

    public Tuple(BindingSet bindingset, String[] bindingnames) {
        for (String bindingname : bindingnames) {
            Value value = bindingset.getValue(bindingname.replace("?", ""));
            if (value == null) continue;
            this.line.add(value);
        }
    }

    public Tuple(Tuple tuple) {
        this.line = new ArrayList<Value>(tuple.line);
        this.history = new ArrayList<Tuple>(tuple.history);
        this.causedByPropertyShapes = new ArrayDeque<PropertyShape>(this.causedByPropertyShapes);
    }

    public List<Value> getlist() {
        return this.line;
    }

    public String toString() {
        String propertyShapeDescrption = "";
        if (this.causedByPropertyShapes != null) {
            String join = String.join((CharSequence)" , ", this.causedByPropertyShapes.stream().map(p -> p.getClass().getSimpleName() + " <" + p.getId() + ">").collect(Collectors.toList()));
            propertyShapeDescrption = ", propertyShapes= " + join;
        }
        return "Tuple{line=" + Arrays.toString(this.line.toArray()) + propertyShapeDescrption + "}";
    }

    public void addCausedByPropertyShape(PropertyShape propertyShape) {
        if (this.causedByPropertyShapes == null) {
            this.causedByPropertyShapes = new ArrayDeque<PropertyShape>();
        }
        this.causedByPropertyShapes.addFirst(propertyShape);
    }

    public Deque<PropertyShape> getCausedByPropertyShapes() {
        return this.causedByPropertyShapes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tuple tuple = (Tuple)o;
        if (tuple.line.size() != this.line.size()) {
            return false;
        }
        for (int i = 0; i < this.line.size(); ++i) {
            if (this.line.get(i) == tuple.line.get(i) || this.line.get(i).equals(tuple.line.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.line);
    }

    @Override
    public int compareTo(Tuple o) {
        for (int i = 0; i < Math.min(o.line.size(), this.line.size()); ++i) {
            int compareTo = valueComparator.compare(this.line.get(i), o.line.get(i));
            if (compareTo == 0) continue;
            return compareTo;
        }
        return 0;
    }

    public String getCause() {
        return " [ " + String.join((CharSequence)" , ", this.history.stream().distinct().map(Object::toString).collect(Collectors.toList())) + " ]";
    }

    public void addHistory(Tuple tuple) {
        this.history.addAll(tuple.history);
        this.history.add(tuple);
    }

    public void addAllCausedByPropertyShape(Deque<PropertyShape> causedByPropertyShapes) {
        if (causedByPropertyShapes != null) {
            this.causedByPropertyShapes.addAll(causedByPropertyShapes);
        }
    }
}

