/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.AST;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.shacl.AST.NodeShape;
import org.eclipse.rdf4j.sail.shacl.AST.OrPropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.PathPropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.PropertyShape;
import org.eclipse.rdf4j.sail.shacl.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.planNodes.BufferedPlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.EnrichWithShape;
import org.eclipse.rdf4j.sail.shacl.planNodes.InnerJoin;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNodeProvider;
import org.eclipse.rdf4j.sail.shacl.planNodes.TrimTuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.UnionNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Unique;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotPropertyShape
extends PathPropertyShape {
    private final PropertyShape orPropertyShape;
    private static final Logger logger = LoggerFactory.getLogger(NotPropertyShape.class);

    NotPropertyShape(Resource id, SailRepositoryConnection connection, NodeShape nodeShape, boolean deactivated, PathPropertyShape parent, Resource path, Resource not) {
        super(id, connection, nodeShape, deactivated, parent, path);
        List<List<PathPropertyShape>> collect = PropertyShape.Factory.getPropertyShapesInner(connection, nodeShape, not, this).stream().map(Collections::singletonList).collect(Collectors.toList());
        this.orPropertyShape = new OrPropertyShape(id, connection, nodeShape, deactivated, (PathPropertyShape)this, null, collect);
    }

    @Override
    public PlanNode getPlan(ConnectionsGroup connectionsGroup, boolean printPlans, PlanNodeProvider overrideTargetNode, boolean negateThisPlan, boolean negateSubPlans) {
        if (this.deactivated) {
            return null;
        }
        if (this.getPath() != null) {
            EnrichWithShape plan = (EnrichWithShape)this.orPropertyShape.getPlan(connectionsGroup, printPlans, overrideTargetNode, false, !negateThisPlan);
            PlanNode parent = plan.getParent();
            return new EnrichWithShape(parent, this);
        }
        EnrichWithShape plan = (EnrichWithShape)this.orPropertyShape.getPlan(connectionsGroup, printPlans, () -> this.getTargetsPlan(connectionsGroup, overrideTargetNode, !negateThisPlan), false, false);
        PlanNode parent = plan.getParent();
        if (this.childrenHasOwnPath()) {
            parent = new Unique(new TrimTuple(parent, 0, 1));
        }
        PlanNode targetsPlan = this.getTargetsPlan(connectionsGroup, overrideTargetNode, !negateThisPlan);
        parent = new InnerJoin(targetsPlan, parent).getDiscardedLeft(BufferedPlanNode.class);
        return new EnrichWithShape(parent, this);
    }

    @Override
    public PlanNode getAllTargetsPlan(ConnectionsGroup connectionsGroup, boolean negated) {
        return this.orPropertyShape.getAllTargetsPlan(connectionsGroup, !negated);
    }

    public PlanNode getTargetsPlan(ConnectionsGroup connectionsGroup, PlanNodeProvider overrideTargetNode, boolean negated) {
        PlanNode targetsPlan = this.orPropertyShape.getAllTargetsPlan(connectionsGroup, negated);
        if (overrideTargetNode != null) {
            targetsPlan = new Unique(new UnionNode(targetsPlan, overrideTargetNode.getPlanNode()));
        }
        return targetsPlan;
    }

    private static PlanNode unionAll(List<PlanNode> planNodes) {
        return new Unique(new UnionNode(planNodes.toArray(new PlanNode[0])));
    }

    @Override
    public boolean requiresEvaluation(SailConnection addedStatements, SailConnection removedStatements) {
        return !this.deactivated;
    }

    @Override
    public SourceConstraintComponent getSourceConstraintComponent() {
        return SourceConstraintComponent.NotConstraintComponent;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NotPropertyShape that = (NotPropertyShape)o;
        return this.orPropertyShape.equals(that.orPropertyShape);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.orPropertyShape);
    }

    public String toString() {
        return "NotPropertyShape{orPropertyShape=" + this.orPropertyShape + ", id=" + this.id + '}';
    }

    public boolean childrenHasOwnPath() {
        return ((OrPropertyShape)this.orPropertyShape).childrenHasOwnPath();
    }
}

