/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.planNodes.BufferedPlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.IteratorData;
import org.eclipse.rdf4j.sail.shacl.planNodes.MultiStreamPlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PushablePlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.TupleHelper;
import org.eclipse.rdf4j.sail.shacl.planNodes.UnBufferedPlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.ValidationExecutionLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InnerJoin
implements MultiStreamPlanNode,
PlanNode {
    private static final Logger logger = LoggerFactory.getLogger(InnerJoin.class);
    private boolean printed = false;
    private PlanNode left;
    private PlanNode right;
    private CloseableIteration<Tuple, SailException> iterator;
    private PushablePlanNode joined;
    private PushablePlanNode discardedLeft;
    private PushablePlanNode discardedRight;
    private ValidationExecutionLogger validationExecutionLogger;

    public InnerJoin(PlanNode left, PlanNode right) {
        this.left = left;
        this.right = right;
    }

    public List<PlanNode> parent() {
        return Arrays.asList(this.left, this.right);
    }

    public PlanNode getJoined(Class<? extends PushablePlanNode> type) {
        if (this.joined != null) {
            throw new IllegalStateException();
        }
        this.joined = type == BufferedPlanNode.class ? new BufferedPlanNode<InnerJoin>(this, "Joined") : new UnBufferedPlanNode<InnerJoin>(this, "Joined");
        return this.joined;
    }

    public PlanNode getDiscardedLeft(Class<? extends PushablePlanNode> type) {
        if (this.discardedLeft != null) {
            throw new IllegalStateException();
        }
        this.discardedLeft = type == BufferedPlanNode.class ? new BufferedPlanNode<InnerJoin>(this, "DiscardedLeft") : new UnBufferedPlanNode<InnerJoin>(this, "DiscaredLeft");
        return this.discardedLeft;
    }

    public PlanNode getDiscardedRight(Class<? extends PushablePlanNode> type) {
        if (this.discardedRight != null) {
            throw new IllegalStateException();
        }
        this.discardedRight = type == BufferedPlanNode.class ? new BufferedPlanNode<InnerJoin>(this, "DiscardedRight") : new UnBufferedPlanNode<InnerJoin>(this, "DiscardedRight");
        return this.discardedRight;
    }

    @Override
    public CloseableIteration<Tuple, SailException> iterator() {
        throw new IllegalStateException();
    }

    public CloseableIteration<Tuple, SailException> internalIterator() {
        InnerJoin that = this;
        return new CloseableIteration<Tuple, SailException>(){
            CloseableIteration<Tuple, SailException> leftIterator;
            CloseableIteration<Tuple, SailException> rightIterator;
            Tuple next;
            Tuple nextLeft;
            Tuple nextRight;
            Tuple joinedLeft;
            {
                this.leftIterator = InnerJoin.this.left.iterator();
                this.rightIterator = InnerJoin.this.right.iterator();
            }

            void calculateNext() {
                if (this.next != null) {
                    return;
                }
                Tuple prevLeft = this.nextLeft;
                if (this.nextLeft == null && this.leftIterator.hasNext()) {
                    this.nextLeft = (Tuple)this.leftIterator.next();
                }
                if (this.nextRight == null && this.rightIterator.hasNext()) {
                    this.nextRight = (Tuple)this.rightIterator.next();
                }
                if (this.nextRight == null && prevLeft == null && this.nextLeft != null) {
                    if (InnerJoin.this.discardedLeft != null) {
                        InnerJoin.this.discardedLeft.push(this.nextLeft);
                    }
                    return;
                }
                if (this.nextLeft == null) {
                    if (InnerJoin.this.discardedRight != null) {
                        while (this.nextRight != null) {
                            InnerJoin.this.discardedRight.push(this.nextRight);
                            if (this.rightIterator.hasNext()) {
                                this.nextRight = (Tuple)this.rightIterator.next();
                                continue;
                            }
                            this.nextRight = null;
                        }
                    }
                    return;
                }
                while (this.next == null) {
                    if (this.nextRight != null) {
                        if (this.nextLeft.line.get(0) == this.nextRight.line.get(0) || this.nextLeft.line.get(0).equals(this.nextRight.line.get(0))) {
                            this.next = TupleHelper.join(this.nextLeft, this.nextRight);
                            this.joinedLeft = this.nextLeft;
                            this.nextRight = null;
                            continue;
                        }
                        int compareTo = this.nextLeft.compareTo(this.nextRight);
                        if (compareTo < 0) {
                            if (this.joinedLeft != this.nextLeft && InnerJoin.this.discardedLeft != null) {
                                InnerJoin.this.discardedLeft.push(this.nextLeft);
                            }
                            if (this.leftIterator.hasNext()) {
                                this.nextLeft = (Tuple)this.leftIterator.next();
                                continue;
                            }
                            this.nextLeft = null;
                            break;
                        }
                        if (InnerJoin.this.discardedRight != null) {
                            InnerJoin.this.discardedRight.push(this.nextRight);
                        }
                        if (this.rightIterator.hasNext()) {
                            this.nextRight = (Tuple)this.rightIterator.next();
                            continue;
                        }
                        this.nextRight = null;
                        break;
                    }
                    if (InnerJoin.this.discardedLeft != null) {
                        while (this.leftIterator.hasNext()) {
                            InnerJoin.this.discardedLeft.push((Tuple)this.leftIterator.next());
                        }
                    }
                    return;
                }
            }

            public void close() throws SailException {
                this.leftIterator.close();
                this.rightIterator.close();
            }

            public boolean hasNext() throws SailException {
                this.calculateNext();
                return this.next != null;
            }

            public Tuple next() throws SailException {
                this.calculateNext();
                Tuple temp = this.next;
                this.next = null;
                return temp;
            }

            public void remove() throws SailException {
            }
        };
    }

    @Override
    public int depth() {
        return Math.max(this.left.depth(), this.right.depth());
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        this.left.getPlanAsGraphvizDot(stringBuilder);
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        stringBuilder.append(this.left.getId() + " -> " + this.getId() + " [label=\"left\"];").append("\n");
        stringBuilder.append(this.right.getId() + " -> " + this.getId() + " [label=\"right\"];").append("\n");
        this.right.getPlanAsGraphvizDot(stringBuilder);
        if (this.discardedRight != null) {
            stringBuilder.append(this.getId() + " -> " + this.discardedRight.getId() + " [label=\"discardedRight\"];").append("\n");
        }
        if (this.discardedLeft != null) {
            stringBuilder.append(this.getId() + " -> " + this.discardedLeft.getId() + " [label=\"discardedLeft\"];").append("\n");
        }
        if (this.joined != null) {
            stringBuilder.append(this.getId() + " -> " + this.joined.getId() + " [label=\"joined\"];").append("\n");
        }
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "";
    }

    @Override
    public IteratorData getIteratorDataType() {
        if (this.left.getIteratorDataType() == this.right.getIteratorDataType()) {
            return this.left.getIteratorDataType();
        }
        throw new IllegalStateException("Not implemented support for when left and right have different types of data");
    }

    public String toString() {
        return "InnerJoin";
    }

    private String leadingSpace() {
        return StringUtils.leftPad((String)"", (int)this.depth(), (String)"    ");
    }

    @Override
    public void init() {
        if (this.iterator == null) {
            this.iterator = this.internalIterator();
        }
    }

    @Override
    public void close() {
        if (!(this.discardedLeft != null && !this.discardedLeft.isClosed() || this.discardedRight != null && !this.discardedRight.isClosed() || this.joined != null && !this.joined.isClosed())) {
            this.iterator.close();
            this.iterator = null;
        }
    }

    @Override
    public boolean incrementIterator() {
        if (this.iterator.hasNext()) {
            Tuple next = (Tuple)this.iterator.next();
            if (this.joined != null) {
                this.joined.push(next);
            }
            return true;
        }
        return false;
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        PlanNode[] planNodes;
        this.validationExecutionLogger = validationExecutionLogger;
        for (PlanNode planNode : planNodes = new PlanNode[]{this.joined, this.discardedLeft, this.discardedRight, this.left, this.right}) {
            if (planNode == null) continue;
            planNode.receiveLogger(validationExecutionLogger);
        }
    }
}

