/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import java.util.Arrays;
import java.util.Set;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.memory.MemoryStoreConnection;
import org.eclipse.rdf4j.sail.shacl.GlobalValidationExecutionLogging;
import org.eclipse.rdf4j.sail.shacl.planNodes.Formatter;
import org.eclipse.rdf4j.sail.shacl.planNodes.IteratorData;
import org.eclipse.rdf4j.sail.shacl.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;
import org.eclipse.rdf4j.sail.shacl.planNodes.ValidationExecutionLogger;

public class ExternalTypeFilterNode
implements PlanNode {
    private SailConnection connection;
    private Set<Resource> filterOnType;
    PlanNode parent;
    int index = 0;
    private final boolean returnMatching;
    private boolean printed = false;
    private ValidationExecutionLogger validationExecutionLogger;

    public ExternalTypeFilterNode(SailConnection connection, Set<Resource> filterOnType, PlanNode parent, int index, boolean returnMatching) {
        this.connection = connection;
        this.filterOnType = filterOnType;
        this.parent = parent;
        this.index = index;
        this.returnMatching = returnMatching;
    }

    @Override
    public CloseableIteration<Tuple, SailException> iterator() {
        final ExternalTypeFilterNode that = this;
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            Tuple next;
            CloseableIteration<Tuple, SailException> parentIterator;
            {
                super(planNode, validationExecutionLogger);
                this.next = null;
                this.parentIterator = ExternalTypeFilterNode.this.parent.iterator();
            }

            void calculateNext() {
                while (this.next == null && this.parentIterator.hasNext()) {
                    Tuple temp = (Tuple)this.parentIterator.next();
                    Value subject = temp.line.get(ExternalTypeFilterNode.this.index);
                    Resource matchedType = this.isType(subject);
                    if (ExternalTypeFilterNode.this.returnMatching) {
                        if (matchedType != null) {
                            this.next = temp;
                            this.next.addHistory(new Tuple(Arrays.asList(subject, RDF.TYPE, matchedType)));
                            continue;
                        }
                        if (!GlobalValidationExecutionLogging.loggingEnabled) continue;
                        ExternalTypeFilterNode.this.validationExecutionLogger.log(ExternalTypeFilterNode.this.depth(), that.getClass().getSimpleName() + ":IgnoredAsTypeMismatch", temp, that, ExternalTypeFilterNode.this.getId());
                        continue;
                    }
                    if (matchedType == null) {
                        this.next = temp;
                        this.next.addHistory(new Tuple(Arrays.asList(subject)));
                        continue;
                    }
                    if (!GlobalValidationExecutionLogging.loggingEnabled) continue;
                    ExternalTypeFilterNode.this.validationExecutionLogger.log(ExternalTypeFilterNode.this.depth(), that.getClass().getSimpleName() + ":IgnoredAsTypeMismatch", temp, that, ExternalTypeFilterNode.this.getId());
                }
            }

            private Resource isType(Value subject) {
                if (subject instanceof Resource) {
                    return ExternalTypeFilterNode.this.filterOnType.stream().filter(type -> ExternalTypeFilterNode.this.connection.hasStatement((Resource)subject, RDF.TYPE, (Value)type, true, new Resource[0])).findFirst().orElse(null);
                }
                return null;
            }

            public void close() throws SailException {
                this.parentIterator.close();
            }

            @Override
            boolean localHasNext() throws SailException {
                this.calculateNext();
                return this.next != null;
            }

            @Override
            Tuple loggingNext() throws SailException {
                this.calculateNext();
                Tuple temp = this.next;
                this.next = null;
                return temp;
            }

            public void remove() throws SailException {
            }
        };
    }

    @Override
    public int depth() {
        return this.parent.depth() + 1;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        stringBuilder.append(this.parent.getId() + " -> " + this.getId()).append("\n");
        if (this.connection instanceof MemoryStoreConnection) {
            stringBuilder.append(System.identityHashCode(((MemoryStoreConnection)this.connection).getSail()) + " -> " + this.getId() + " [label=\"filter source\"]").append("\n");
        } else {
            stringBuilder.append(System.identityHashCode(this.connection) + " -> " + this.getId() + " [label=\"filter source\"]").append("\n");
        }
        this.parent.getPlanAsGraphvizDot(stringBuilder);
    }

    public String toString() {
        return "ExternalTypeFilterNode{filterOnType=" + Arrays.toString(this.filterOnType.stream().map(Formatter::prefix).toArray()) + '}';
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "";
    }

    @Override
    public IteratorData getIteratorDataType() {
        return this.parent.getIteratorDataType();
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
        this.parent.receiveLogger(validationExecutionLogger);
    }
}

