/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.AST;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.WriterConfig;
import org.eclipse.rdf4j.rio.helpers.BasicWriterSettings;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.eclipse.rdf4j.sail.memory.MemoryStoreConnection;
import org.eclipse.rdf4j.sail.shacl.AST.AndPropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.ClassPropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.DatatypePropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.InPropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.LanguageInPropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.MaxCountPropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.MaxExclusivePropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.MaxInclusivePropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.MaxLengthPropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.MinCountPropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.MinExclusivePropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.MinInclusivePropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.MinLengthPropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.NodeKindPropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.NodeShape;
import org.eclipse.rdf4j.sail.shacl.AST.NotPropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.OrPropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.Path;
import org.eclipse.rdf4j.sail.shacl.AST.PathPropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.PatternPropertyShape;
import org.eclipse.rdf4j.sail.shacl.AST.PlanGenerator;
import org.eclipse.rdf4j.sail.shacl.AST.PlaneNodeWrapper;
import org.eclipse.rdf4j.sail.shacl.AST.RequiresEvalutation;
import org.eclipse.rdf4j.sail.shacl.AST.ShaclProperties;
import org.eclipse.rdf4j.sail.shacl.AST.UniqueLangPropertyShape;
import org.eclipse.rdf4j.sail.shacl.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.SourceConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNodeProvider;

public abstract class PropertyShape
implements PlanGenerator,
RequiresEvalutation {
    final boolean deactivated;
    final Resource id;
    NodeShape nodeShape;
    PathPropertyShape parent;

    PropertyShape(Resource id, NodeShape nodeShape, boolean deactivated, PathPropertyShape parent) {
        this.id = id;
        this.nodeShape = nodeShape;
        this.deactivated = deactivated;
        this.parent = parent;
    }

    @Override
    public PlanNode getPlan(ConnectionsGroup connectionsGroup, boolean printPlans, PlanNodeProvider overrideTargetNode, boolean negateThisPlan, boolean negateSubPlans) {
        throw new IllegalStateException("Should never get here!!!");
    }

    @Override
    public PlanNode getPlanAddedStatements(ConnectionsGroup connectionsGroup, PlaneNodeWrapper planeNodeWrapper) {
        throw new IllegalStateException("Should never get here!!!");
    }

    @Override
    public PlanNode getPlanRemovedStatements(ConnectionsGroup connectionsGroup, PlaneNodeWrapper planeNodeWrapper) {
        throw new IllegalStateException("Should never get here!!!");
    }

    @Override
    public List<Path> getPaths() {
        throw new IllegalStateException();
    }

    @Override
    public boolean requiresEvaluation(SailConnection addedStatements, SailConnection removedStatements) {
        if (this.deactivated) {
            return false;
        }
        return this.nodeShape.requiresEvaluation(addedStatements, removedStatements);
    }

    public String getPlanAsGraphvizDot(PlanNode planNode, ConnectionsGroup connectionsGroup) {
        StringBuilder stringBuilder = new StringBuilder("Graphviz DOT output:\n\n");
        stringBuilder.append("digraph  {").append("\n");
        stringBuilder.append("labelloc=t;\nfontsize=30;\nlabel=\"" + this.getClass().getSimpleName() + "\";").append("\n");
        stringBuilder.append(System.identityHashCode(connectionsGroup.getBaseConnection()) + " [label=\"Base sail\" nodeShape=pentagon fillcolor=lightblue style=filled];").append("\n");
        stringBuilder.append(System.identityHashCode(connectionsGroup.getPreviousStateConnection()) + " [label=\"Previous state connection\" nodeShape=pentagon fillcolor=lightblue style=filled];").append("\n");
        MemoryStore addedStatements = ((MemoryStoreConnection)connectionsGroup.getAddedStatements()).getSail();
        MemoryStore removedStatements = ((MemoryStoreConnection)connectionsGroup.getRemovedStatements()).getSail();
        stringBuilder.append(System.identityHashCode(addedStatements) + " [label=\"Added statements\" nodeShape=pentagon fillcolor=lightblue style=filled];").append("\n");
        stringBuilder.append(System.identityHashCode(removedStatements) + " [label=\"Removed statements\" nodeShape=pentagon fillcolor=lightblue style=filled];").append("\n");
        planNode.getPlanAsGraphvizDot(stringBuilder);
        stringBuilder.append("}").append("\n");
        return stringBuilder.append("\n\n").toString();
    }

    static List<Value> toList(SailRepositoryConnection connection, Resource orList) {
        ArrayList<Value> ret = new ArrayList<Value>();
        while (!orList.equals(RDF.NIL)) {
            try (Stream stream = connection.getStatements(orList, RDF.FIRST, null, new Resource[0]).stream();){
                Value value = stream.map(Statement::getObject).findAny().get();
                ret.add(value);
            }
            stream = connection.getStatements(orList, RDF.REST, null, new Resource[0]).stream();
            var4_4 = null;
            try {
                orList = stream.map(Statement::getObject).map(v -> (Resource)v).findAny().get();
            }
            catch (Throwable throwable) {
                var4_4 = throwable;
                throw throwable;
            }
            finally {
                if (stream == null) continue;
                if (var4_4 != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                    continue;
                }
                stream.close();
            }
        }
        return ret;
    }

    public Resource getId() {
        return this.id;
    }

    public NodeShape getNodeShape() {
        return this.nodeShape;
    }

    public SourceConstraintComponent getSourceConstraintComponent() {
        throw new IllegalStateException("Missing implementetion in extending class!");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyShape that = (PropertyShape)o;
        return this.deactivated == that.deactivated && this.id.equals(that.id);
    }

    public int hashCode() {
        return Objects.hash(this.deactivated, this.id);
    }

    protected static String toString(List<List<PathPropertyShape>> propertyShapes) {
        List collect = propertyShapes.stream().map(l -> Arrays.toString(l.toArray())).collect(Collectors.toList());
        return Arrays.toString(collect.toArray());
    }

    String describe(SailRepositoryConnection connection, Resource resource) {
        GraphQuery graphQuery = connection.prepareGraphQuery("describe ?a where {BIND(?resource as ?a)}");
        graphQuery.setBinding("resource", (Value)resource);
        try (Stream stream = graphQuery.evaluate().stream();){
            LinkedHashModel statements = stream.collect(Collectors.toCollection(LinkedHashModel::new));
            statements.setNamespace("sh", "http://www.w3.org/ns/shacl#");
            WriterConfig config = new WriterConfig();
            config.set(BasicWriterSettings.PRETTY_PRINT, (Object)true);
            config.set(BasicWriterSettings.INLINE_BLANK_NODES, (Object)true);
            StringWriter stringWriter = new StringWriter();
            Rio.write((Iterable)statements, (Writer)stringWriter, (RDFFormat)RDFFormat.TURTLE, (WriterConfig)config);
            String string = stringWriter.toString();
            return string;
        }
    }

    static class Factory {
        Factory() {
        }

        static List<PathPropertyShape> getPropertyShapes(Resource ShapeId, SailRepositoryConnection connection, NodeShape nodeShape) {
            try (Stream stream = connection.getStatements(ShapeId, SHACL.PROPERTY, null, new Resource[0]).stream();){
                List<PathPropertyShape> list = stream.map(Statement::getObject).map(v -> (Resource)v).flatMap(propertyShapeId -> {
                    List<PathPropertyShape> propertyShapes = Factory.getPropertyShapesInner(connection, nodeShape, propertyShapeId, null);
                    return propertyShapes.stream();
                }).collect(Collectors.toList());
                return list;
            }
        }

        static List<PathPropertyShape> getPropertyShapesInner(SailRepositoryConnection connection, NodeShape nodeShape, Resource propertyShapeId, PathPropertyShape parent) {
            ArrayList<PathPropertyShape> propertyShapes = new ArrayList<PathPropertyShape>(2);
            ShaclProperties shaclProperties = new ShaclProperties(propertyShapeId, connection);
            if (shaclProperties.minCount != null) {
                propertyShapes.add(new MinCountPropertyShape(propertyShapeId, connection, nodeShape, shaclProperties.deactivated, parent, shaclProperties.path, shaclProperties.minCount));
            }
            if (shaclProperties.maxCount != null) {
                propertyShapes.add(new MaxCountPropertyShape(propertyShapeId, connection, nodeShape, shaclProperties.deactivated, parent, shaclProperties.path, shaclProperties.maxCount));
            }
            if (shaclProperties.datatype != null) {
                propertyShapes.add(new DatatypePropertyShape(propertyShapeId, connection, nodeShape, shaclProperties.deactivated, parent, shaclProperties.path, shaclProperties.datatype));
            }
            if (!shaclProperties.or.isEmpty()) {
                shaclProperties.or.forEach(or -> propertyShapes.add(new OrPropertyShape(propertyShapeId, connection, nodeShape, shaclProperties.deactivated, parent, shaclProperties.path, (Resource)or)));
            }
            if (shaclProperties.minLength != null) {
                propertyShapes.add(new MinLengthPropertyShape(propertyShapeId, connection, nodeShape, shaclProperties.deactivated, parent, shaclProperties.path, shaclProperties.minLength));
            }
            if (shaclProperties.maxLength != null) {
                propertyShapes.add(new MaxLengthPropertyShape(propertyShapeId, connection, nodeShape, shaclProperties.deactivated, parent, shaclProperties.path, shaclProperties.maxLength));
            }
            if (!shaclProperties.pattern.isEmpty()) {
                shaclProperties.pattern.forEach(pattern -> propertyShapes.add(new PatternPropertyShape(propertyShapeId, connection, nodeShape, shaclProperties.deactivated, parent, shaclProperties.path, (String)pattern, shaclProperties.flags)));
            }
            if (shaclProperties.languageIn != null) {
                propertyShapes.add(new LanguageInPropertyShape(propertyShapeId, connection, nodeShape, shaclProperties.deactivated, parent, shaclProperties.path, shaclProperties.languageIn));
            }
            if (shaclProperties.nodeKind != null) {
                propertyShapes.add(new NodeKindPropertyShape(propertyShapeId, connection, nodeShape, shaclProperties.deactivated, parent, shaclProperties.path, shaclProperties.nodeKind));
            }
            if (shaclProperties.minExclusive != null) {
                propertyShapes.add(new MinExclusivePropertyShape(propertyShapeId, connection, nodeShape, shaclProperties.deactivated, parent, shaclProperties.path, shaclProperties.minExclusive));
            }
            if (shaclProperties.maxExclusive != null) {
                propertyShapes.add(new MaxExclusivePropertyShape(propertyShapeId, connection, nodeShape, shaclProperties.deactivated, parent, shaclProperties.path, shaclProperties.maxExclusive));
            }
            if (shaclProperties.maxInclusive != null) {
                propertyShapes.add(new MaxInclusivePropertyShape(propertyShapeId, connection, nodeShape, shaclProperties.deactivated, parent, shaclProperties.path, shaclProperties.maxInclusive));
            }
            if (shaclProperties.minInclusive != null) {
                propertyShapes.add(new MinInclusivePropertyShape(propertyShapeId, connection, nodeShape, shaclProperties.deactivated, parent, shaclProperties.path, shaclProperties.minInclusive));
            }
            if (!shaclProperties.clazz.isEmpty()) {
                shaclProperties.clazz.forEach(clazz -> propertyShapes.add(new ClassPropertyShape(propertyShapeId, connection, nodeShape, shaclProperties.deactivated, parent, shaclProperties.path, (Resource)clazz)));
            }
            if (!shaclProperties.and.isEmpty()) {
                shaclProperties.and.forEach(and -> propertyShapes.add(new AndPropertyShape(propertyShapeId, connection, nodeShape, shaclProperties.deactivated, parent, shaclProperties.path, (Resource)and)));
            }
            if (!shaclProperties.not.isEmpty()) {
                shaclProperties.not.forEach(not -> propertyShapes.add(new NotPropertyShape(propertyShapeId, connection, nodeShape, shaclProperties.deactivated, parent, shaclProperties.path, (Resource)not)));
            }
            if (shaclProperties.in != null) {
                propertyShapes.add(new InPropertyShape(propertyShapeId, connection, nodeShape, shaclProperties.deactivated, parent, shaclProperties.path, shaclProperties.in));
            }
            if (shaclProperties.uniqueLang) {
                propertyShapes.add(new UniqueLangPropertyShape(propertyShapeId, connection, nodeShape, shaclProperties.deactivated, parent, shaclProperties.path, shaclProperties.uniqueLang));
            }
            return propertyShapes;
        }
    }
}

